/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBTokenType;
import org.jetbrains.annotations.NotNull;

public class GDBParser
implements PsiParser {
    private static final String[] GDB_EXPRESSION_COMMANDS = new String[]{"print", "p", "print-object", "po", "call"};

    @NotNull
    public ASTNode parse(@NotNull IElementType root, PsiBuilder builder) {
        if (root == null) {
            GDBParser.$$$reportNull$$$0(0);
        }
        PsiBuilder.Marker mark = builder.mark();
        GDBParser.parseGDBCommand(builder);
        mark.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            GDBParser.$$$reportNull$$$0(1);
        }
        return aSTNode;
    }

    private static void parseGDBCommand(PsiBuilder builder) {
        PsiBuilder.Marker command = builder.mark();
        if (builder.getTokenType() == GDBTokenType.IDENTIFIER) {
            String commandName = builder.getTokenText();
            PsiBuilder.Marker commandNameMarker = builder.mark();
            builder.advanceLexer();
            commandNameMarker.done((IElementType)GDBTokenType.COMMAND_NAME);
            if (GDBParser.isExpressionCommand(commandName)) {
                GDBParser.parseExpression(builder);
            } else {
                GDBParser.parseCommandArguments(builder);
            }
        } else {
            GDBParser.eatEverything(builder);
        }
        command.done((IElementType)GDBTokenType.DBG_COMMAND);
    }

    private static boolean isExpressionCommand(String commandName) {
        return ArrayUtil.contains((String)commandName, (String[])GDB_EXPRESSION_COMMANDS);
    }

    private static void eatEverything(PsiBuilder builder) {
        while (!builder.eof()) {
            builder.advanceLexer();
        }
    }

    private static void parseExpression(PsiBuilder builder) {
        PsiBuilder.Marker body = builder.mark();
        GDBParser.eatEverything(builder);
        body.done((IElementType)GDBTokenType.EXPRESSION_PLACEHOLDER);
    }

    private static void parseCommandArguments(PsiBuilder builder) {
        PsiBuilder.Marker body = builder.mark();
        while (!builder.eof()) {
            if (builder.getTokenType() == GDBTokenType.IDENTIFIER) {
                PsiBuilder.Marker subCommand = builder.mark();
                builder.advanceLexer();
                subCommand.done((IElementType)GDBTokenType.COMMAND_ARGUMENTS);
                continue;
            }
            if (builder.getTokenType() == GDBTokenType.DASH && builder.rawLookup(1) == GDBTokenType.IDENTIFIER) {
                PsiBuilder.Marker option = builder.mark();
                builder.advanceLexer();
                builder.advanceLexer();
                option.done((IElementType)GDBTokenType.COMMAND_ARGUMENTS);
                continue;
            }
            if (builder.getTokenType() == GDBTokenType.DASHDASH) {
                PsiBuilder.Marker dashDash = builder.mark();
                builder.advanceLexer();
                dashDash.done((IElementType)GDBTokenType.COMMAND_ARGS_END);
                GDBParser.eatEverything(builder);
                continue;
            }
            builder.advanceLexer();
        }
        body.done((IElementType)GDBTokenType.COMMAND_ARGUMENTS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/lang/GDBParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/lang/GDBParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

