/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrErrorValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrLocalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrValue
extends XNamedValue
implements UserDataHolderEx {
    public static final Key<Boolean> DO_NOT_SHOW_ADDRESSES = Key.create((String)"DO_NOT_SHOW_ADDRESSES");
    public static final Key<Boolean> THREAT_VALUE_AS_RICH_TEXT = Key.create((String)"THREAT_VALUE_AS_RICH_TEXT");
    private static final Logger LOG = Logger.getInstance(CidrValue.class);
    @NotNull
    private final UserDataHolderBase myUserDataHolder;
    @NotNull
    private final CidrDebugProcess myProcess;
    @Nullable
    private final XSourcePosition myPosition;
    @NotNull
    private final CidrStackFrame myFrame;
    @NotNull
    private final List<String> myPresentationErrors;

    public CidrValue(@NotNull String displayName, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        if (displayName == null) {
            CidrValue.$$$reportNull$$$0(0);
        }
        if (process == null) {
            CidrValue.$$$reportNull$$$0(1);
        }
        if (frame == null) {
            CidrValue.$$$reportNull$$$0(2);
        }
        super(displayName);
        this.myUserDataHolder = new UserDataHolderBase();
        this.myPresentationErrors = Collections.synchronizedList(new ArrayList());
        this.myProcess = process;
        this.myPosition = position;
        this.myFrame = frame;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            CidrValue.$$$reportNull$$$0(3);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            CidrValue.$$$reportNull$$$0(4);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            CidrValue.$$$reportNull$$$0(5);
        }
        if (value == null) {
            CidrValue.$$$reportNull$$$0(6);
        }
        Object object = this.myUserDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            CidrValue.$$$reportNull$$$0(7);
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            CidrValue.$$$reportNull$$$0(8);
        }
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrStackFrame getFrame() {
        CidrStackFrame cidrStackFrame = this.myFrame;
        if (cidrStackFrame == null) {
            CidrValue.$$$reportNull$$$0(9);
        }
        return cidrStackFrame;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myPosition;
    }

    @NotNull
    public String getEvaluationExpression() {
        String string = this.getEvaluationExpression(false);
        if (string == null) {
            CidrValue.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        String string = this.getName();
        if (string == null) {
            CidrValue.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        if (cidrDebugProcess == null) {
            CidrValue.$$$reportNull$$$0(12);
        }
        return cidrDebugProcess;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            CidrValue.$$$reportNull$$$0(13);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            XSourcePosition computedPosition;
            XSourcePosition position = this.getSourcePosition();
            if (position == null) {
                navigatable.setSourcePosition(null);
                return;
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator == null) {
                LOG.warn("computeSourcePosition finished with error: ProgressIndicator is null");
                return;
            }
            try {
                computedPosition = this.doComputePositionAsync(position, indicator).get();
            }
            catch (ProcessCanceledException | InterruptedException | CancellationException | ExecutionException e) {
                LOG.info("computeSourcePosition finished with error: " + e.getMessage());
                return;
            }
            ReadAction.run(() -> navigatable.setSourcePosition(computedPosition));
        }, CidrDebuggerBundle.message("debug.computing.source.position", new Object[0]), true, this.myProcess.getProject());
    }

    @NotNull
    protected abstract CompletableFuture<XSourcePosition> doComputePositionAsync(@NotNull XSourcePosition var1, @NotNull ProgressIndicator var2);

    @NotNull
    protected CompletableFuture<XSourcePosition> doComputeNearestUsagePositionAsync(@NotNull XSourcePosition position, @NotNull ProgressIndicator indicator) {
        if (position == null) {
            CidrValue.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            CidrValue.$$$reportNull$$$0(15);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            CidrValue.$$$reportNull$$$0(16);
        }
        return completableFuture;
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        if (callback == null) {
            CidrValue.$$$reportNull$$$0(17);
        }
        this.doComputeInlineDebuggerDataAsync(arg_0 -> ((XInlineDebuggerDataCallback)callback).computed(arg_0));
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            CidrValue.$$$reportNull$$$0(18);
        }
        return threeState;
    }

    protected void doComputeInlineDebuggerDataAsync(XNavigatable navigatable) {
        XSourcePosition position = this.getSourcePosition();
        if (position == null) {
            navigatable.setSourcePosition(null);
            return;
        }
        XDebugSession session = this.myProcess.getSession();
        Function<Function, CompletableFuture> execWithEmptyProgressIndicator = f -> {
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            XDebugSessionListener listener = new XDebugSessionListener((ProgressIndicator)indicator){
                final /* synthetic */ ProgressIndicator val$indicator;
                {
                    this.val$indicator = progressIndicator;
                }

                public void sessionResumed() {
                    this.val$indicator.cancel();
                }

                public void sessionStopped() {
                    this.val$indicator.cancel();
                }
            };
            session.addSessionListener(listener);
            return ((CompletableFuture)f.apply(indicator)).whenComplete((v, t) -> session.removeSessionListener(listener));
        };
        execWithEmptyProgressIndicator.apply(i -> this.doComputePositionAsync(position, (ProgressIndicator)i).thenAccept(p -> ReadAction.run(() -> navigatable.setSourcePosition(p)))).whenComplete((v, t) -> execWithEmptyProgressIndicator.apply(ii -> this.doComputeNearestUsagePositionAsync(position, (ProgressIndicator)ii).thenAccept(pp -> ReadAction.run(() -> navigatable.setSourcePosition(pp)))));
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            CidrValue.$$$reportNull$$$0(19);
        }
        if (place == null) {
            CidrValue.$$$reportNull$$$0(20);
        }
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node)) {
            return;
        }
        this.myProcess.postCommand(driver -> {
            if (node.isObsolete()) {
                return;
            }
            boolean hasChildren = false;
            try {
                XFullValueEvaluator evaluator;
                XValuePresentation presentation;
                Icon icon;
                EvaluationContext context2 = this.createEvaluationContext(driver, new XValueNodeExpirable((Obsolescent)node));
                try {
                    hasChildren = this.doComputeMayHaveChildren(context2);
                    icon = this.doComputeIcon(context2, hasChildren);
                }
                catch (DebuggerCommandException e) {
                    icon = XDebuggerUIConstants.ERROR_MESSAGE_ICON;
                    this.myPresentationErrors.add(e.getMessage());
                    hasChildren = true;
                }
                try {
                    Pair<XValuePresentation, XFullValueEvaluator> presentationAndEvaluator = this.doComputePresentationAndEvaluator(context2);
                    presentation = (XValuePresentation)presentationAndEvaluator.first;
                    evaluator = (XFullValueEvaluator)presentationAndEvaluator.second;
                }
                catch (DebuggerCommandException e) {
                    CidrErrorValue.doComputePresentation(node, e.getMessage(), hasChildren);
                    return;
                }
                if (evaluator != null) {
                    node.setFullValueEvaluator(evaluator);
                }
                node.setPresentation(icon, presentation, hasChildren);
            }
            catch (com.intellij.execution.ExecutionException e) {
                CidrErrorValue.doComputePresentation(node, CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)), hasChildren);
                throw e;
            }
        });
    }

    protected abstract boolean doComputeMayHaveChildren(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @Nullable
    protected abstract Icon doComputeIcon(@NotNull EvaluationContext var1, boolean var2) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @Nullable
    protected abstract String doComputeType(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @NotNull
    protected abstract Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @NotNull
    protected Pair<XValuePresentation, XFullValueEvaluator> doComputePresentationAndEvaluator(@NotNull EvaluationContext context2) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            CidrValue.$$$reportNull$$$0(21);
        }
        String type = this.doComputeType(context2);
        Pair<String, XFullValueEvaluator> valueAndEvaluator = this.doComputeValueAndEvaluator(context2);
        Pair pair = Pair.create((Object)this.createValuePresentation(context2, (String)valueAndEvaluator.first, type), (Object)((XFullValueEvaluator)valueAndEvaluator.second));
        if (pair == null) {
            CidrValue.$$$reportNull$$$0(22);
        }
        return pair;
    }

    @NotNull
    protected XValuePresentation createValuePresentation(@NotNull EvaluationContext context2, @NotNull String value, @Nullable String type) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (context2 == null) {
            CidrValue.$$$reportNull$$$0(23);
        }
        if (value == null) {
            CidrValue.$$$reportNull$$$0(24);
        }
        return new XRegularValuePresentation(value, type);
    }

    public final void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            CidrValue.$$$reportNull$$$0(25);
        }
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node)) {
            return;
        }
        if (!this.myPresentationErrors.isEmpty()) {
            node.addChildren(CidrValue.createErrorChildren(this.myPresentationErrors), false);
        }
        this.computeValueChildren(node);
    }

    @NotNull
    protected static XValueChildrenList createErrorChildren(@NotNull List<String> errors) {
        if (errors == null) {
            CidrValue.$$$reportNull$$$0(26);
        }
        XValueChildrenList errorNodesList = new XValueChildrenList();
        for (String each : errors) {
            errorNodesList.add((XNamedValue)new CidrErrorValue(each));
        }
        XValueChildrenList xValueChildrenList = errorNodesList;
        if (xValueChildrenList == null) {
            CidrValue.$$$reportNull$$$0(27);
        }
        return xValueChildrenList;
    }

    protected abstract void computeValueChildren(@NotNull XCompositeNode var1);

    public static void addLocalValues(@NotNull Collection<LLValue> vars, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame, @NotNull XCompositeNode toNode) {
        if (vars == null) {
            CidrValue.$$$reportNull$$$0(28);
        }
        if (process == null) {
            CidrValue.$$$reportNull$$$0(29);
        }
        if (frame == null) {
            CidrValue.$$$reportNull$$$0(30);
        }
        if (toNode == null) {
            CidrValue.$$$reportNull$$$0(31);
        }
        if (toNode.isObsolete()) {
            return;
        }
        SmartList values = new SmartList();
        for (LLValue each : vars) {
            values.add(new CidrLocalValue(each, process, position, frame));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, toNode);
    }

    public static void addAllTo(@NotNull Collection<CidrValue> values, @NotNull XCompositeNode toNode) {
        if (values == null) {
            CidrValue.$$$reportNull$$$0(32);
        }
        if (toNode == null) {
            CidrValue.$$$reportNull$$$0(33);
        }
        if (toNode.isObsolete()) {
            return;
        }
        XValueChildrenList list = values.isEmpty() ? XValueChildrenList.EMPTY : new XValueChildrenList(values.size());
        for (CidrValue each : values) {
            list.add((XNamedValue)each);
        }
        toNode.addChildren(list, true);
    }

    @NotNull
    public abstract String getConsoleDescription(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable) {
        if (driver == null) {
            CidrValue.$$$reportNull$$$0(34);
        }
        return this.getProcess().createEvaluationContext(driver, expirable, this.myFrame);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 22: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 22: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNode";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrame";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeNearestUsagePositionAsync";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInlineDebuggerData";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputePresentationAndEvaluator";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 22: 
            case 27: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePosition";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doComputeNearestUsagePositionAsync";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeInlineDebuggerData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doComputePresentationAndEvaluator";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createValuePresentation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createErrorChildren";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addLocalValues";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addAllTo";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluationContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 22: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

