/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001%B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0002J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eH\u0096\u0002J\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000 2\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0002J\b\u0010#\u001a\u00020$H\u0016R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "Lkotlin/ranges/ClosedRange;", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "", "start", "endInclusive", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lcom/jetbrains/cidr/execution/debugger/memory/Address;)V", "getEndInclusive", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "size", "", "getSize", "()J", "getStart", "component1", "component2", "contains", "", "range", "copy", "equals", "other", "", "hashCode", "", "headUntil", "endExclusive", "intersectWith", "intersects", "iterator", "", "splitBy", "Lkotlin/Pair;", "tailAfter", "startExclusive", "toString", "", "Companion", "intellij.cidr.debugger.backend"})
public final class AddressRange
implements ClosedRange<Address>,
Iterable<Address>,
KMappedMarker {
    @NotNull
    private final Address start;
    @NotNull
    private final Address endInclusive;
    @JvmField
    @NotNull
    public static final AddressRange EMPTY;
    @JvmField
    @NotNull
    public static final AddressRange WHOLE;
    private static final Pair<AddressRange, AddressRange> EMPTY_PAIR;
    @NotNull
    public static final Companion Companion;

    public final long getSize() {
        return this.getEndInclusive().minus(this.getStart()) + 1L;
    }

    public final boolean contains(@NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return !range.isEmpty() && this.contains((Comparable)range.getStart()) && this.contains((Comparable)range.getEndInclusive());
    }

    public final boolean intersects(@NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return !range.isEmpty() && (this.contains((Comparable)range.getStart()) || this.contains((Comparable)range.getEndInclusive())) || !this.isEmpty() && (range.contains((Comparable)this.getStart()) || range.contains((Comparable)this.getEndInclusive()));
    }

    @NotNull
    public final AddressRange intersectWith(@NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return !this.intersects(range) ? EMPTY : AddressUtil.addressRangeInclusive((Address)RangesKt.coerceIn((Comparable)this.getStart(), (ClosedRange)range), (Address)RangesKt.coerceIn((Comparable)this.getEndInclusive(), (ClosedRange)range));
    }

    @NotNull
    public final Pair<AddressRange, AddressRange> splitBy(@NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return range.contains(this) ? EMPTY_PAIR : TuplesKt.to((Object)this.headUntil(range.getStart()), (Object)this.tailAfter(range.getEndInclusive()));
    }

    @NotNull
    public final AddressRange headUntil(@NotNull Address endExclusive) {
        Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
        return this.isEmpty() || endExclusive.compareTo(this.getStart()) <= 0 ? EMPTY : AddressUtil.addressRangeInclusive(this.getStart(), (Address)RangesKt.coerceIn((Comparable)endExclusive.minus(1), (ClosedRange)this));
    }

    @NotNull
    public final AddressRange tailAfter(@NotNull Address startExclusive) {
        Intrinsics.checkNotNullParameter((Object)startExclusive, (String)"startExclusive");
        return this.isEmpty() || startExclusive.compareTo(this.getEndInclusive()) >= 0 ? EMPTY : AddressUtil.addressRangeInclusive((Address)RangesKt.coerceIn((Comparable)startExclusive.plus(1), (ClosedRange)this), this.getEndInclusive());
    }

    @Override
    @NotNull
    public Iterator<Address> iterator() {
        Address address = this.getStart();
        boolean bl = false;
        boolean bl2 = false;
        Address it = address;
        boolean bl3 = false;
        return SequencesKt.generateSequence((Object)(it.compareTo(this.getEndInclusive()) <= 0 ? address : null), (Function1)((Function1)new Function1<Address, Address>(this){
            final /* synthetic */ AddressRange this$0;

            @Nullable
            public final Address invoke(@NotNull Address it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.compareTo(this.this$0.getEndInclusive()) < 0 ? it.plus(1) : null;
            }
            {
                this.this$0 = addressRange;
                super(1);
            }
        })).iterator();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof AddressRange && (this.isEmpty() && ((AddressRange)other).isEmpty() || Intrinsics.areEqual((Object)this.getStart(), (Object)((AddressRange)other).getStart()) && Intrinsics.areEqual((Object)this.getEndInclusive(), (Object)((AddressRange)other).getEndInclusive()));
    }

    public int hashCode() {
        return this.isEmpty() ? -1 : this.getStart().hashCode() ^ this.getEndInclusive().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getStart() + ".." + this.getEndInclusive();
    }

    @NotNull
    public Address getStart() {
        return this.start;
    }

    @NotNull
    public Address getEndInclusive() {
        return this.endInclusive;
    }

    public AddressRange(@NotNull Address start, @NotNull Address endInclusive) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        this.start = start;
        this.endInclusive = endInclusive;
    }

    static {
        Companion = new Companion(null);
        EMPTY = new AddressRange(Address.MIN_VALUE.plus(1), Address.MIN_VALUE);
        WHOLE = new AddressRange(Address.MIN_VALUE, Address.MAX_VALUE);
        EMPTY_PAIR = TuplesKt.to((Object)EMPTY, (Object)EMPTY);
    }

    public boolean contains(@NotNull Address value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return ClosedRange.DefaultImpls.contains((ClosedRange)this, (Comparable)value);
    }

    public boolean isEmpty() {
        return ClosedRange.DefaultImpls.isEmpty((ClosedRange)this);
    }

    @NotNull
    public final Address component1() {
        return this.getStart();
    }

    @NotNull
    public final Address component2() {
        return this.getEndInclusive();
    }

    @NotNull
    public final AddressRange copy(@NotNull Address start, @NotNull Address endInclusive) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        return new AddressRange(start, endInclusive);
    }

    public static /* synthetic */ AddressRange copy$default(AddressRange addressRange, Address address, Address address2, int n, Object object) {
        if ((n & 1) != 0) {
            address = addressRange.getStart();
        }
        if ((n & 2) != 0) {
            address2 = addressRange.getEndInclusive();
        }
        return addressRange.copy(address, address2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange$Companion;", "", "()V", "EMPTY", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "EMPTY_PAIR", "Lkotlin/Pair;", "WHOLE", "intellij.cidr.debugger.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

