/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.disasm;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.BaseDocRegion;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.ErrorDocRegion;
import com.jetbrains.cidr.execution.debugger.memory.disasm.AbstractDisasmDataProvider;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0014J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0012H\u0014J$\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u001cH\u0014J\u0014\u0010\u001d\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0014J\u0014\u0010\u001e\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0014R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/CidrDisasmRegion;", "Lcom/jetbrains/cidr/execution/debugger/memory/BaseDocRegion;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/util/TextRange;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;)V", "nrHeaderLines", "", "getNrHeaderLines", "()I", "getAddressForLineNumberInsideRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "lineNumber", "getLineNumberInsideRegion", "address", "renderEntry", "", "buffer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "dataEntry", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "renderFooter", "renderHeader", "Companion", "intellij.cidr.debugger"})
public final class CidrDisasmRegion
extends BaseDocRegion<LLInstruction> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final int getNrHeaderLines() {
        return CidrDisasmRegion.Companion.getFunctionOffset(this.getData()) != null ? 2 : (this.getData() instanceof CidrMemoryData.DataPlaceholder ? 1 : 0);
    }

    @Override
    protected void renderHeader(@NotNull Appendable buffer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            LLSymbolOffset lLSymbolOffset = CidrDisasmRegion.Companion.getFunctionOffset(this.getData());
            if (lLSymbolOffset == null) break block0;
            LLSymbolOffset lLSymbolOffset2 = lLSymbolOffset;
            boolean bl = false;
            boolean bl2 = false;
            LLSymbolOffset functionOffset = lLSymbolOffset2;
            boolean bl3 = false;
            buffer.append('\n');
            buffer.append(functionOffset + ":\n");
        }
    }

    @Override
    protected void renderFooter(@NotNull Appendable buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.append('\n');
    }

    @Override
    protected void renderEntry(@NotNull Appendable buffer, @NotNull CidrMemoryData.DataEntry<LLInstruction> dataEntry) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(dataEntry, (String)"dataEntry");
        StringBuilder stringBuilder = new StringBuilder().append('\t');
        LLInstruction lLInstruction = dataEntry.getValue();
        String string = lLInstruction != null ? lLInstruction.getDisassembly() : null;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        buffer.append(stringBuilder.append(StringsKt.replace$default((String)string2, (String)"\n", (String)"", (boolean)false, (int)4, null)).append('\n').toString());
    }

    @Override
    @Nullable
    protected Address getAddressForLineNumberInsideRegion(int lineNumber) {
        if (this.getNrHeaderLines() > 0 && lineNumber == 0 || !(this.getData() instanceof AbstractDisasmDataProvider.DisasmBlock)) {
            return null;
        }
        int idx = RangesKt.coerceAtLeast((int)(lineNumber - this.getNrHeaderLines()), (int)0);
        if (idx >= ((AbstractDisasmDataProvider.DisasmBlock)this.getData()).getEntries().size()) {
            return null;
        }
        return ((AbstractDisasmDataProvider.DisasmBlock)this.getData()).getEntries().get(idx).getAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getLineNumberInsideRegion(@NotNull Address address) {
        int n;
        void $this$count$iv;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Iterable iterable = this.getData().getEntries();
        int n2 = this.getNrHeaderLines();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CidrMemoryData.DataEntry it = (CidrMemoryData.DataEntry)element$iv;
                boolean bl = false;
                if (!(it.getAddress().compareTo(address) < 0)) continue;
                int n3 = ++count$iv;
                boolean bl2 = false;
                if (n3 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n4 = n;
        return n2 + n4;
    }

    public CidrDisasmRegion(@NotNull Document document2, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion<LLInstruction> dataRegion, @NotNull AddressSpace<DocRegion<LLInstruction>> reallocatedSpace) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter(dataRegion, (String)"dataRegion");
        Intrinsics.checkNotNullParameter(reallocatedSpace, (String)"reallocatedSpace");
        super(document2, textRange, dataRegion, reallocatedSpace);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J@\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u0012H\u0016R\"\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/CidrDisasmRegion$Companion;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc$DocRegionFactory;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "()V", "functionOffset", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "getFunctionOffset", "(Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;)Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "createDocRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "intellij.cidr.debugger"})
    public static final class Companion
    implements CidrMemoryDoc.DocRegionFactory<LLInstruction> {
        @Override
        @NotNull
        public DocRegion<LLInstruction> createDocRegion(@NotNull Document document2, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion<LLInstruction> dataRegion, @NotNull AddressSpace<DocRegion<LLInstruction>> reallocatedSpace) {
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            Intrinsics.checkNotNullParameter(dataRegion, (String)"dataRegion");
            Intrinsics.checkNotNullParameter(reallocatedSpace, (String)"reallocatedSpace");
            return dataRegion instanceof CidrMemoryData.DataRegion.Completed.LoadError ? (DocRegion)new ErrorDocRegion(document2, textRange, (CidrMemoryData.DataRegion.Completed.LoadError)dataRegion) : (DocRegion)new CidrDisasmRegion(document2, textRange, dataRegion, reallocatedSpace);
        }

        private final LLSymbolOffset getFunctionOffset(CidrMemoryData.Data<LLInstruction> $this$functionOffset) {
            CidrMemoryData.Data<LLInstruction> data = $this$functionOffset;
            if (!(data instanceof AbstractDisasmDataProvider.DisasmBlock)) {
                data = null;
            }
            AbstractDisasmDataProvider.DisasmBlock disasmBlock = (AbstractDisasmDataProvider.DisasmBlock)data;
            return disasmBlock != null ? disasmBlock.getFunctionOffset() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

