/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.disasm;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import com.jetbrains.cidr.execution.debugger.memory.disasm.DisasmFileType;
import java.awt.Component;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/ForceMappingEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "getKey", "Lcom/intellij/openapi/util/Key;", "Companion", "intellij.cidr.debugger"})
public final class ForceMappingEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        VirtualFile frameFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)DisasmFileType.INSTANCE)) ^ true) {
            return null;
        }
        if (!(file instanceof MemoryViewFile)) {
            return null;
        }
        CidrDebugProcess cidrDebugProcess = (CidrDebugProcess)file.getUserData(CidrDebugProcess.DEBUG_PROCESS_KEY);
        if (cidrDebugProcess == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"file.getUserData(CidrDeb\u2026OCESS_KEY) ?: return null");
        CidrDebugProcess process = cidrDebugProcess;
        XDebugSession xDebugSession = process.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"process.session");
        XStackFrame xStackFrame = xDebugSession.getCurrentStackFrame();
        if (!(xStackFrame instanceof CidrStackFrame)) {
            xStackFrame = null;
        }
        CidrStackFrame cidrStackFrame = (CidrStackFrame)xStackFrame;
        if (cidrStackFrame == null) {
            return null;
        }
        CidrStackFrame frame = cidrStackFrame;
        LLFrame lLFrame = frame.getFrame();
        Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"frame.frame");
        CharSequence charSequence = lLFrame.getFile();
        boolean bl = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            charSequence2 = "";
        }
        String sourcePath = charSequence2;
        charSequence = sourcePath;
        bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        boolean bl2 = false;
        if (bl2) return null;
        if (frame.hasSourceFile()) {
            return null;
        }
        VirtualFile virtualFile = frameFile = VfsUtil.findFile((Path)Paths.get(sourcePath, new String[0]), (boolean)true);
        boolean frameFileExists = virtualFile != null && virtualFile.exists() && !frameFile.isDirectory();
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor);
        if (frameFileExists) {
            panel2.setText(CidrDebuggerBundle.message("debug.editor.notification.force.mapping.exists", PathUtil.getFileName((String)sourcePath)));
        } else {
            panel2.setText(CidrDebuggerBundle.message("debug.editor.notification.force.mapping", PathUtil.getFileName((String)sourcePath)));
        }
        LLFrame lLFrame2 = frame.getFrame();
        Intrinsics.checkNotNullExpressionValue((Object)lLFrame2, (String)"frame.frame");
        DebuggerSourceFileHash sourceHash = lLFrame2.getHash();
        if (frameFile != null && frameFileExists) {
            panel2.createActionLabel(CidrDebuggerBundle.message("debug.editor.notification.force.mapping.use.it.anyway", new Object[0]), new Runnable(process, sourcePath, sourceHash, frameFile){
                final /* synthetic */ CidrDebugProcess $process;
                final /* synthetic */ String $sourcePath;
                final /* synthetic */ DebuggerSourceFileHash $sourceHash;
                final /* synthetic */ VirtualFile $frameFile;

                public final void run() {
                    this.$process.getSourceFileLocator().forceFileMapping(this.$sourcePath, this.$sourceHash, this.$frameFile, false);
                }
                {
                    this.$process = cidrDebugProcess;
                    this.$sourcePath = string;
                    this.$sourceHash = debuggerSourceFileHash;
                    this.$frameFile = virtualFile;
                }
            });
        }
        panel2.createActionLabel(CidrDebuggerBundle.message("debug.editor.notification.force.mapping.select.file", new Object[0]), new Runnable(project, fileEditor, process, sourcePath, sourceHash){
            final /* synthetic */ Project $project;
            final /* synthetic */ FileEditor $fileEditor;
            final /* synthetic */ CidrDebugProcess $process;
            final /* synthetic */ String $sourcePath;
            final /* synthetic */ DebuggerSourceFileHash $sourceHash;

            public final void run() {
                FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser(fileChooserDescriptor, this.$project, (Component)this.$fileEditor.getComponent());
                Intrinsics.checkNotNullExpressionValue((Object)fileChooserDialog, (String)"FileChooserFactory.getIn\u2026ct, fileEditor.component)");
                FileChooserDialog fileChooser = fileChooserDialog;
                Object[] objectArray = fileChooser.choose(this.$project, new VirtualFile[]{ProjectUtil.guessProjectDir((Project)this.$project)});
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"fileChooser.choose(proje\u2026roject.guessProjectDir())");
                VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])objectArray);
                if (virtualFile == null) {
                    return;
                }
                VirtualFile chosenFile = virtualFile;
                this.$process.getSourceFileLocator().forceFileMapping(this.$sourcePath, this.$sourceHash, chosenFile, true);
            }
            {
                this.$project = project;
                this.$fileEditor = fileEditor;
                this.$process = cidrDebugProcess;
                this.$sourcePath = string;
                this.$sourceHash = debuggerSourceFileHash;
            }
        });
        return panel2;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"cidr.debugger.disasm.force.mapping");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"cidr.debugger.disasm.force.mapping\")");
        KEY = key;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/ForceMappingEditorNotificationProvider$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ui/EditorNotificationPanel;", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

