/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.nativeplatform.project;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.Task;
import org.gradle.tooling.model.cpp.CppBinary;
import org.gradle.tooling.model.cpp.CppComponent;
import org.gradle.tooling.model.cpp.CppStaticLibrary;
import org.gradle.tooling.model.cpp.CppTestSuite;
import org.gradle.tooling.model.cpp.LinkageDetails;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.builder.CppModelBuilder;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CompilationDetails;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppExecutable;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppProject;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppSharedLibrary;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.MacroDirective;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.SourceFile;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CompilationDetailsImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppBinaryImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppComponentImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppExecutableImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppProjectImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppSharedLibraryImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppStaticLibraryImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppTestSuiteImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.LinkageDetailsImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.MacroDirectiveImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.SourceFileImpl;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public final class GradleNativeProjectResolver
extends AbstractProjectResolverExtension {
    @NotNull
    public static final Key<CppProject> CPP_PROJECT = Key.create(CppProject.class, (int)(ProjectKeys.MODULE.getProcessingWeight() + 1));

    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        CppProjectImpl cppProject;
        if (gradleModule == null) {
            GradleNativeProjectResolver.$$$reportNull$$$0(0);
        }
        if (ideModule == null) {
            GradleNativeProjectResolver.$$$reportNull$$$0(1);
        }
        if ((cppProject = this.appendCppProject(gradleModule, ideModule)) != null) {
            ContentRootData ideContentRoot;
            org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppComponent mainComponent = cppProject.getMainComponent();
            Set<Object> sourceFolders = mainComponent == null ? new HashSet() : GradleNativeProjectResolver.getSourceFolders(mainComponent);
            org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppTestSuite testComponent = cppProject.getTestComponent();
            Set<Object> testSourceFolders = testComponent == null ? new HashSet() : GradleNativeProjectResolver.getSourceFolders(testComponent);
            testSourceFolders.removeAll(sourceFolders);
            for (File file : sourceFolders) {
                ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, file.getAbsolutePath());
                ideContentRoot.storePath(ExternalSystemSourceType.SOURCE, file.getAbsolutePath());
                ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
            }
            for (File file : testSourceFolders) {
                ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, file.getAbsolutePath());
                ideContentRoot.storePath(ExternalSystemSourceType.TEST, file.getAbsolutePath());
                ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
            }
        }
        this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        Set set = ContainerUtil.set((Object[])new Class[]{org.gradle.tooling.model.cpp.CppProject.class, CppProject.class});
        if (set == null) {
            GradleNativeProjectResolver.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<Class<?>> getToolingExtensionsClasses() {
        Set set = ContainerUtil.set((Object[])new Class[]{CppModelBuilder.class});
        if (set == null) {
            GradleNativeProjectResolver.$$$reportNull$$$0(3);
        }
        return set;
    }

    public Set<Class<?>> getTargetTypes() {
        return ContainerUtil.set((Object[])new Class[]{CppExecutable.class, CppSharedLibrary.class, org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppStaticLibrary.class});
    }

    @Nullable
    private CppProjectImpl appendCppProject(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            GradleNativeProjectResolver.$$$reportNull$$$0(4);
        }
        if (ideModule == null) {
            GradleNativeProjectResolver.$$$reportNull$$$0(5);
        }
        CppProjectImpl cppProject = null;
        org.gradle.tooling.model.cpp.CppProject gradleCppProject = (org.gradle.tooling.model.cpp.CppProject)this.resolverCtx.getExtraProject(gradleModule, org.gradle.tooling.model.cpp.CppProject.class);
        if (gradleCppProject != null) {
            cppProject = GradleNativeProjectResolver.convert(gradleCppProject);
        } else {
            CppProject customGradleCppProject = (CppProject)this.resolverCtx.getExtraProject(gradleModule, CppProject.class);
            if (customGradleCppProject != null) {
                cppProject = new CppProjectImpl(customGradleCppProject);
            }
        }
        if (cppProject != null) {
            ideModule.createChild(CPP_PROJECT, (Object)cppProject);
        }
        return cppProject;
    }

    private static CppProjectImpl convert(@NotNull org.gradle.tooling.model.cpp.CppProject gradleCppProject) {
        if (gradleCppProject == null) {
            GradleNativeProjectResolver.$$$reportNull$$$0(6);
        }
        CppProjectImpl cppProject = new CppProjectImpl();
        cppProject.setMainComponent(GradleNativeProjectResolver.convert(gradleCppProject.getMainComponent()));
        cppProject.setTestComponent((org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppTestSuite)GradleNativeProjectResolver.convert((CppComponent)gradleCppProject.getTestComponent()));
        return cppProject;
    }

    private static org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppComponent convert(@Nullable CppComponent component) {
        if (component == null) {
            return null;
        }
        CppComponentImpl cppComponent = component instanceof CppTestSuite ? new CppTestSuiteImpl(component.getName(), component.getBaseName()) : new CppComponentImpl(component.getName(), component.getBaseName());
        for (CppBinary binary : component.getBinaries()) {
            cppComponent.addBinary(GradleNativeProjectResolver.convert(binary));
        }
        return cppComponent;
    }

    @Nullable
    private static CppBinaryImpl convert(@Nullable CppBinary binary) {
        CppBinaryImpl cppBinary;
        if (binary instanceof org.gradle.tooling.model.cpp.CppExecutable) {
            cppBinary = new CppExecutableImpl(binary.getName(), binary.getBaseName(), binary.getVariantName());
        } else if (binary instanceof org.gradle.tooling.model.cpp.CppSharedLibrary) {
            cppBinary = new CppSharedLibraryImpl(binary.getName(), binary.getBaseName(), binary.getVariantName());
        } else if (binary instanceof CppStaticLibrary) {
            cppBinary = new CppStaticLibraryImpl(binary.getName(), binary.getBaseName(), binary.getVariantName());
        } else {
            return null;
        }
        cppBinary.setCompilationDetails(GradleNativeProjectResolver.convert(binary.getCompilationDetails()));
        cppBinary.setLinkageDetails(GradleNativeProjectResolver.convert(binary.getLinkageDetails()));
        return cppBinary;
    }

    private static LinkageDetailsImpl convert(LinkageDetails details) {
        LinkageDetailsImpl linkageDetails = new LinkageDetailsImpl();
        linkageDetails.setAdditionalArgs(new ArrayList<String>(details.getAdditionalArgs()));
        linkageDetails.setLinkTask(GradleNativeProjectResolver.convert(details.getLinkTask()));
        linkageDetails.setOutputLocation(details.getOutputLocation());
        return linkageDetails;
    }

    private static ExternalTask convert(Task task) {
        if (task == null) {
            return null;
        }
        DefaultExternalTask externalTask = new DefaultExternalTask();
        externalTask.setDescription(task.getDescription());
        externalTask.setGroup(task.getGroup());
        externalTask.setName(task.getName());
        externalTask.setQName(task.getPath());
        return externalTask;
    }

    private static CompilationDetailsImpl convert(org.gradle.tooling.model.cpp.CompilationDetails details) {
        CompilationDetailsImpl compilationDetails = new CompilationDetailsImpl();
        compilationDetails.setCompileTask(GradleNativeProjectResolver.convert(details.getCompileTask()));
        compilationDetails.setAdditionalArgs(new ArrayList<String>(details.getAdditionalArgs()));
        compilationDetails.setCompilerExecutable(details.getCompilerExecutable());
        compilationDetails.setCompileWorkingDir(details.getCompileWorkingDir());
        compilationDetails.setFrameworkSearchPaths(new ArrayList<File>(details.getFrameworkSearchPaths()));
        compilationDetails.setHeaderDirs(new LinkedHashSet<File>(details.getHeaderDirs()));
        compilationDetails.setMacroDefines(GradleNativeProjectResolver.convert((DomainObjectSet<? extends org.gradle.tooling.model.cpp.MacroDirective>)details.getMacroDefines()));
        compilationDetails.setMacroUndefines(new LinkedHashSet<String>(details.getMacroUndefines()));
        compilationDetails.setSources(GradleNativeProjectResolver.convertSources((DomainObjectSet<? extends org.gradle.tooling.model.cpp.SourceFile>)details.getSources()));
        compilationDetails.setSystemHeaderSearchPaths(new ArrayList<File>(details.getSystemHeaderSearchPaths()));
        compilationDetails.setUserHeaderSearchPaths(new ArrayList<File>(details.getUserHeaderSearchPaths()));
        return compilationDetails;
    }

    private static Set<SourceFile> convertSources(DomainObjectSet<? extends org.gradle.tooling.model.cpp.SourceFile> sources) {
        LinkedHashSet<SourceFile> sourceFiles = new LinkedHashSet<SourceFile>(sources.size());
        for (org.gradle.tooling.model.cpp.SourceFile sourceFile : sources) {
            sourceFiles.add(GradleNativeProjectResolver.convert(sourceFile));
        }
        return sourceFiles;
    }

    private static SourceFile convert(org.gradle.tooling.model.cpp.SourceFile sourceFile) {
        return new SourceFileImpl(sourceFile.getSourceFile(), sourceFile.getObjectFile());
    }

    private static Set<MacroDirective> convert(DomainObjectSet<? extends org.gradle.tooling.model.cpp.MacroDirective> directives) {
        LinkedHashSet<MacroDirective> macroDirectives = new LinkedHashSet<MacroDirective>(directives.size());
        for (org.gradle.tooling.model.cpp.MacroDirective directive : directives) {
            macroDirectives.add(GradleNativeProjectResolver.convert(directive));
        }
        return macroDirectives;
    }

    private static MacroDirective convert(org.gradle.tooling.model.cpp.MacroDirective directive) {
        return new MacroDirectiveImpl(directive.getName(), directive.getValue());
    }

    private static Set<File> getSourceFolders(org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppComponent component) {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        for (org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppBinary cppBinary : component.getBinaries()) {
            CompilationDetails compilationDetails = cppBinary.getCompilationDetails();
            result.addAll(compilationDetails.getHeaderDirs());
            compilationDetails.getSources().forEach(sourceFile -> result.add(sourceFile.getSourceFile().getParentFile()));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/nativeplatform/project/GradleNativeProjectResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleCppProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/nativeplatform/project/GradleNativeProjectResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolingExtensionsClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleContentRoots";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendCppProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

