/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.makefile.execution.build.runners;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.jetbrains.cidr.cpp.makefile.MakefileLog;
import com.jetbrains.cidr.cpp.makefile.MakefileUtil;
import com.jetbrains.cidr.cpp.makefile.MakefileWorkspace;
import com.jetbrains.cidr.cpp.makefile.execution.build.MakefileBuildConfiguration;
import com.jetbrains.cidr.cpp.makefile.execution.build.runners.CleanTaskRunner;
import com.jetbrains.cidr.cpp.makefile.execution.build.runners.MkCompileTaskRunner;
import com.jetbrains.cidr.cpp.makefile.execution.build.runners.ModuleBuildRunner;
import com.jetbrains.cidr.cpp.makefile.execution.build.runners.ProjectModelBuildTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.execution.build.tasks.CidrCleanTask;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/execution/build/runners/MakefileProjectTaskRunner;", "Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;", "()V", "buildSystemId", "", "getBuildSystemId", "()Ljava/lang/String;", "canRun", "", "project", "Lcom/intellij/openapi/project/Project;", "projectTask", "Lcom/intellij/task/ProjectTask;", "task", "runnerForTask", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "intellij.clion.makefile"})
public final class MakefileProjectTaskRunner
extends CidrProjectTaskRunner {
    @NotNull
    private final String buildSystemId;

    @NotNull
    public String getBuildSystemId() {
        return this.buildSystemId;
    }

    public boolean canRun(@NotNull Project project2, @NotNull ProjectTask projectTask) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectTask, (String)"projectTask");
        MakefileWorkspace workspace = MakefileWorkspace.Companion.getInstance(project2);
        return workspace.isInitialized() && this.canRun(projectTask) && (projectTask instanceof ModuleBuildTask ? Intrinsics.areEqual((Object)((ModuleBuildTask)projectTask).getModule(), (Object)workspace.getModule()) : true);
    }

    public boolean canRun(@NotNull ProjectTask task) {
        boolean bl;
        block7: {
            ProjectTask projectTask;
            block9: {
                block11: {
                    block10: {
                        boolean bl2;
                        block5: {
                            block8: {
                                block6: {
                                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                                    projectTask = task;
                                    if (!(projectTask instanceof ProjectModelBuildTask)) break block6;
                                    bl = ((ProjectModelBuildTask)task).getBuildableElement() instanceof MakefileBuildConfiguration;
                                    break block7;
                                }
                                if (!(projectTask instanceof CidrCleanTask)) break block8;
                                bl = ((CidrCleanTask)task).getBuildConfiguration() instanceof MakefileBuildConfiguration;
                                break block7;
                            }
                            if (!(projectTask instanceof ModuleFilesBuildTask)) break block9;
                            VirtualFile[] virtualFileArray = ((ModuleFilesBuildTask)task).getFiles();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"task.files");
                            VirtualFile[] virtualFileArray2 = virtualFileArray;
                            boolean bl3 = false;
                            if (virtualFileArray2.length == 0) break block10;
                            VirtualFile[] virtualFileArray3 = ((ModuleFilesBuildTask)task).getFiles();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray3, (String)"task.files");
                            VirtualFile[] $this$any$iv = virtualFileArray3;
                            boolean $i$f$any = false;
                            VirtualFile[] virtualFileArray4 = $this$any$iv;
                            int n = virtualFileArray4.length;
                            for (int i = 0; i < n; ++i) {
                                VirtualFile element$iv;
                                VirtualFile it = element$iv = virtualFileArray4[i];
                                boolean bl4 = false;
                                VirtualFile virtualFile = it;
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                                if (!(virtualFile.isDirectory() || !OCFileTypeHelpers.isSourceFile((String)it.getName()) && !OCFileTypeHelpers.isHeaderFile((String)it.getName()))) continue;
                                bl2 = true;
                                break block5;
                            }
                            bl2 = false;
                        }
                        if (!bl2) break block11;
                    }
                    return false;
                }
                Module module = ((ModuleFilesBuildTask)task).getModule();
                Intrinsics.checkNotNullExpressionValue((Object)module, (String)"task.module");
                Project project2 = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"task.module.project");
                MakefileWorkspace workspace = MakefileWorkspace.Companion.getInstance(project2);
                return workspace.isInitialized() && Intrinsics.areEqual((Object)((ModuleFilesBuildTask)task).getModule(), (Object)workspace.getModule());
            }
            if (projectTask instanceof ModuleBuildTask) {
                Module module = ((ModuleBuildTask)task).getModule();
                Intrinsics.checkNotNullExpressionValue((Object)module, (String)"task.module");
                Project project3 = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"task.module.project");
                MakefileWorkspace workspace = MakefileWorkspace.Companion.getInstance(project3);
                return workspace.isInitialized() && Intrinsics.areEqual((Object)((ModuleBuildTask)task).getModule(), (Object)workspace.getModule());
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public CidrTaskRunner runnerForTask(@NotNull ProjectTask task, @NotNull Project project2) {
        CidrTaskRunner cidrTaskRunner;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ProjectTask projectTask = task;
        if (projectTask instanceof ProjectModelBuildTask) {
            cidrTaskRunner = new ProjectModelBuildTaskRunner();
        } else if (projectTask instanceof CidrCleanTask) {
            cidrTaskRunner = new CleanTaskRunner(project2);
        } else if (projectTask instanceof ModuleFilesBuildTask) {
            cidrTaskRunner = (CidrTaskRunner)new MkCompileTaskRunner();
        } else if (projectTask instanceof ModuleBuildTask) {
            cidrTaskRunner = new ModuleBuildRunner(project2);
        } else {
            MakefileLog.LOG.error("Unexpected project task type: " + task.getPresentableName());
            cidrTaskRunner = null;
        }
        return cidrTaskRunner;
    }

    public MakefileProjectTaskRunner() {
        String string = MakefileUtil.ID.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ID.id");
        this.buildSystemId = string;
    }
}

