/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class Untar
extends Expand {
    private UntarCompressionMethod compression = new UntarCompressionMethod();

    public void setCompression(UntarCompressionMethod method) {
        this.compression = method;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void expandFile(FileUtils fileUtils, File srcF, File dir) {
        TarInputStream tis = null;
        try {
            try {
                this.log("Expanding: " + srcF + " into " + dir, 2);
                tis = new TarInputStream(this.compression.decompress(srcF, new BufferedInputStream(new FileInputStream(srcF))));
                TarEntry te = null;
                while ((te = tis.getNextEntry()) != null) {
                    this.extractFile(fileUtils, srcF, dir, tis, te.getName(), te.getModTime(), te.isDirectory());
                }
                this.log("expand complete", 3);
            }
            catch (IOException ioe) {
                throw new BuildException("Error while expanding " + srcF.getPath(), ioe, this.location);
            }
            Object var7_7 = null;
            if (tis == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (tis == null) throw throwable;
            try {
                tis.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        tis.close();
        return;
    }

    public static final class UntarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public UntarCompressionMethod() {
            this.setValue(NONE);
        }

        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        private InputStream decompress(File file, InputStream istream) throws IOException, BuildException {
            String value = this.getValue();
            if (GZIP.equals(value)) {
                return new GZIPInputStream(istream);
            }
            if (BZIP2.equals(value)) {
                char[] magic = new char[]{'B', 'Z'};
                for (int i = 0; i < magic.length; ++i) {
                    if (istream.read() == magic[i]) continue;
                    throw new BuildException("Invalid bz2 file." + file.toString());
                }
                return new CBZip2InputStream(istream);
            }
            return istream;
        }
    }
}

