/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;

public class AboutBox
extends JDialog {
    public static final String MODULE = "About";
    public static int TOP = 5;
    public static int BOTTOM = 105;

    public AboutBox() {
        this.init();
    }

    public AboutBox(Frame owner) {
        super(owner);
        this.init();
    }

    private void init() {
        this.setModal(true);
        this.getContentPane().add((Component)new AboutPanel(), "Center");
        this.setTitle(GRI18n.getString((String)MODULE, (String)"title"));
        this.pack();
        DialogUtil.center((Window)this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                AboutBox.this.thisWindowClosing();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(MouseEvent e) {
                AboutBox.this.thisWindowClosing();
            }
        });
    }

    void thisWindowClosing() {
        this.setVisible(false);
        this.dispose();
    }

    public class AboutPanel
    extends JComponent {
        ImageIcon image;
        ArrayList text;
        int scrollPosition;
        AnimationThread thread;
        int maxWidth;
        FontMetrics fm;
        int initialPosition;

        public AboutPanel() {
            this.setFont(UIManager.getFont("Label.font"));
            this.fm = this.getFontMetrics(this.getFont());
            URL imu = this.getClass().getResource("/rar_about_gr1.png");
            Log.log((int)3, (String)AboutBox.MODULE, (String)("Looking for splash screen in " + imu.toString()));
            this.image = new ImageIcon(imu);
            this.setBorder(new MatteBorder(1, 1, 1, 1, Color.gray));
            this.text = new ArrayList();
            StringTokenizer st = new StringTokenizer(GalleryRemote._().properties.getProperty("aboutText"), "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                this.text.add(line);
                this.maxWidth = Math.max(this.maxWidth, this.fm.stringWidth(line) + 10);
            }
            this.scrollPosition = this.initialPosition = this.getHeight() - BOTTOM - TOP - TOP;
            this.thread = new AnimationThread();
        }

        public Dimension getPreferredSize() {
            return new Dimension(1 + this.image.getIconWidth(), 1 + this.image.getIconHeight());
        }

        public void paintComponent(Graphics g) {
            this.image.paintIcon(this, g, 1, 1);
            FontMetrics fm = g.getFontMetrics();
            String version = GalleryRemote._().properties.getProperty("version");
            g.drawString(version, (this.getWidth() - fm.stringWidth(version)) / 2, this.getHeight() - 5);
            g = g.create((this.getWidth() - this.maxWidth) / 2, TOP, this.maxWidth, this.getHeight() - TOP - BOTTOM);
            int height = fm.getHeight();
            int firstLine = this.scrollPosition / height;
            int firstLineOffset = height - this.scrollPosition % height;
            int lines = (this.getHeight() - TOP - BOTTOM) / height;
            int y = firstLineOffset;
            g.setColor(new Color(255, 255, 255));
            for (int i = 0; i <= lines; ++i) {
                if (i + firstLine >= 0 && i + firstLine < this.text.size()) {
                    String line = (String)this.text.get(i + firstLine);
                    g.drawString(line, (this.maxWidth - fm.stringWidth(line)) / 2, y);
                }
                y += fm.getHeight();
            }
        }

        public void addNotify() {
            super.addNotify();
            this.thread.start();
        }

        public void removeNotify() {
            super.removeNotify();
            this.thread.kill();
        }

        class AnimationThread
        extends Thread {
            private boolean running = true;

            AnimationThread() {
                super(GRI18n.getString((String)AboutBox.MODULE, (String)"aboutAnim"));
                this.setPriority(1);
            }

            public void kill() {
                this.running = false;
            }

            public void run() {
                FontMetrics fm = AboutPanel.this.getFontMetrics(AboutPanel.this.getFont());
                int max = AboutPanel.this.text.size() * fm.getHeight();
                while (this.running) {
                    long start = System.currentTimeMillis();
                    AboutPanel.this.scrollPosition += 2;
                    if (AboutPanel.this.scrollPosition > max) {
                        AboutPanel.this.scrollPosition = AboutPanel.this.initialPosition;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    AboutPanel.this.repaint(AboutPanel.this.getWidth() / 2 - AboutPanel.this.maxWidth, TOP, AboutPanel.this.maxWidth * 2, AboutPanel.this.getHeight() - TOP - BOTTOM);
                }
            }
        }
    }
}

