/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.structure;

import br.arca.morcego.Config;
import br.arca.morcego.Morcego;
import br.arca.morcego.physics.Spring;
import br.arca.morcego.physics.Vector3D;
import br.arca.morcego.structure.GraphElement;
import br.arca.morcego.structure.Node;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.util.Hashtable;

public abstract class Link
extends GraphElement {
    private Spring spring;
    protected Node node1;
    protected Node node2;
    protected Color color = Config.getColor("morcego.linkColor");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public Link() {
    }

    public Link(Node n1, Node n2) {
        this.setup(n1, n2);
    }

    public void setup(Node n1, Node n2) {
        this.spring = new Spring(n1.getBody(), n2.getBody());
        this.node1 = n1;
        this.node2 = n2;
        this.node1.addLink(this.node2, this);
        this.node2.addLink(this.node1, this);
        n1.getGraph().addLink(this);
    }

    public Hashtable availableProperties() {
        Hashtable prop = super.availableProperties();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        prop.put("color", clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        prop.put("description", clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        prop.put("springsize", clazz3);
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        prop.put("springelasticconstant", clazz4);
        return prop;
    }

    public boolean hasNode(Node node) {
        return this.node1 == node || this.node2 == node;
    }

    public float getDepth() {
        return this.node1.getDepth() + this.node2.getDepth() / 2.0f;
    }

    public boolean contains(MouseEvent e) {
        Vector3D start = new Vector3D(this.node1.body.projection.x, this.node1.body.projection.y, 0.0f);
        Vector3D axis = new Vector3D(this.node2.body.projection.x, this.node2.body.projection.y, 0.0f).getVectorFrom(start);
        Vector3D ortog = new Vector3D(-1.0f * axis.y, axis.x, 0.0f);
        ortog.resize(2.0f / ortog.module());
        Polygon p = new Polygon();
        p.addPoint((int)(start.x + ortog.x), (int)(start.y + ortog.y));
        p.addPoint((int)(start.x - ortog.x), (int)(start.y - ortog.y));
        p.addPoint((int)(start.x - ortog.x + axis.x), (int)(start.y - ortog.y + axis.y));
        p.addPoint((int)(start.x + ortog.x + axis.x), (int)(start.y + ortog.y + axis.y));
        return p.contains(e.getX(), e.getY());
    }

    public void paint(Graphics g) {
    }

    public void mouseClicked(MouseEvent e) {
        this.callJsEvent("onclick");
    }

    public void mouseEntered(MouseEvent e) {
        Morcego.setHandCursor();
        this.showDescription();
        e.consume();
        this.callJsEvent("onmouseover");
    }

    private void showDescription() {
        if (this.description != null) {
            int x = (this.node1.getBody().projection.x + this.node2.getBody().projection.x) / 2;
            int y = (this.node1.getBody().projection.y + this.node2.getBody().projection.y) / 2;
            this.description.setPosition(x, y);
            Morcego application = Morcego.getApplication();
            application.add(this.description);
            this.description.setVisible(true);
            Morcego.notifyRenderer();
        }
    }

    public void mouseExited(MouseEvent e) {
        Morcego.setDefaultCursor();
        this.hideDescription();
        this.callJsEvent("onmouseout");
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public Spring getSpring() {
        return this.spring;
    }

    public void setProperty(String name, Object value) {
        if (name.equals("springSize")) {
            this.spring.setSize(((Float)value).floatValue());
        }
        if (name.equals("springElasticConstant")) {
            this.spring.setElasticConstant(((Float)value).floatValue());
        }
        if (name.equals("color")) {
            this.color = (Color)value;
        }
        super.setProperty(name, value);
    }

    public Node getNode1() {
        return this.node1;
    }

    public Node getNode2() {
        return this.node2;
    }

    public Node getOther(Node node) {
        if (this.node1 == node) {
            return this.node2;
        }
        if (this.node2 == node) {
            return this.node1;
        }
        return null;
    }

    public boolean visible() {
        return this.getNode1().visible() && this.getNode2().visible();
    }
}

