# Generated by Django 4.2.13 on 2024-06-08 09:10

import uuid

from django.db import migrations, models

import django_tasks.backends.database.models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="DBTaskResult",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("NEW", "New"),
                            ("RUNNING", "Running"),
                            ("FAILED", "Failed"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="NEW",
                        max_length=8,
                    ),
                ),
                ("args_kwargs", models.JSONField()),
                ("priority", models.PositiveSmallIntegerField(default=0)),
                ("task_path", models.TextField()),
                ("queue_name", models.TextField(default="default")),
                ("backend_name", models.TextField()),
                ("run_after", models.DateTimeField(null=True)),
                ("result", models.JSONField(default=None, null=True)),
            ],
            options={
                "ordering": [
                    models.OrderBy(models.F("priority"), descending=True),
                    models.OrderBy(
                        models.F("run_after"), descending=True, nulls_last=True
                    ),
                ],
            },
            bases=(django_tasks.backends.database.models.GenericBase, models.Model),
        ),
    ]
