/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.transport.Reader;
import com.glavsoft.transport.Writer;

public class PixelFormat {
    public byte bitsPerPixel;
    public byte depth;
    public byte bigEndianFlag;
    public byte trueColourFlag;
    public short redMax;
    public short greenMax;
    public short blueMax;
    public byte redShift;
    public byte greenShift;
    public byte blueShift;

    public void fill(Reader reader) throws TransportException {
        this.bitsPerPixel = reader.readByte();
        this.depth = reader.readByte();
        this.bigEndianFlag = reader.readByte();
        this.trueColourFlag = reader.readByte();
        this.redMax = reader.readInt16();
        this.greenMax = reader.readInt16();
        this.blueMax = reader.readInt16();
        this.redShift = reader.readByte();
        this.greenShift = reader.readByte();
        this.blueShift = reader.readByte();
        reader.readBytes(3);
    }

    public void send(Writer writer) throws TransportException {
        writer.write(this.bitsPerPixel);
        writer.write(this.depth);
        writer.write(this.bigEndianFlag);
        writer.write(this.trueColourFlag);
        writer.write(this.redMax);
        writer.write(this.greenMax);
        writer.write(this.blueMax);
        writer.write(this.redShift);
        writer.write(this.greenShift);
        writer.write(this.blueShift);
        writer.writeInt16(0);
        writer.writeByte(0);
    }

    public static PixelFormat create24bitColorDepthPixelFormat(int bigEndianFlag) {
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.bigEndianFlag = (byte)bigEndianFlag;
        pixelFormat.bitsPerPixel = (byte)32;
        pixelFormat.blueMax = (short)255;
        pixelFormat.blueShift = 0;
        pixelFormat.greenMax = (short)255;
        pixelFormat.greenShift = (byte)8;
        pixelFormat.redMax = (short)255;
        pixelFormat.redShift = (byte)16;
        pixelFormat.depth = (byte)24;
        pixelFormat.trueColourFlag = 1;
        return pixelFormat;
    }

    public static PixelFormat create16bitColorDepthPixelFormat(int bigEndianFlag) {
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.bigEndianFlag = (byte)bigEndianFlag;
        pixelFormat.bitsPerPixel = (byte)16;
        pixelFormat.blueMax = (short)31;
        pixelFormat.blueShift = 0;
        pixelFormat.greenMax = (short)63;
        pixelFormat.greenShift = (byte)5;
        pixelFormat.redMax = (short)31;
        pixelFormat.redShift = (byte)11;
        pixelFormat.depth = (byte)16;
        pixelFormat.trueColourFlag = 1;
        return pixelFormat;
    }

    public static PixelFormat create8bitColorDepthBGRPixelFormat(int bigEndianFlag) {
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.bigEndianFlag = (byte)bigEndianFlag;
        pixelFormat.bitsPerPixel = (byte)8;
        pixelFormat.redMax = (short)7;
        pixelFormat.redShift = 0;
        pixelFormat.greenMax = (short)7;
        pixelFormat.greenShift = (byte)3;
        pixelFormat.blueMax = (short)3;
        pixelFormat.blueShift = (byte)6;
        pixelFormat.depth = (byte)8;
        pixelFormat.trueColourFlag = 1;
        return pixelFormat;
    }

    public static PixelFormat create6bitColorDepthPixelFormat(int bigEndianFlag) {
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.bigEndianFlag = (byte)bigEndianFlag;
        pixelFormat.bitsPerPixel = (byte)8;
        pixelFormat.blueMax = (short)3;
        pixelFormat.blueShift = 0;
        pixelFormat.greenMax = (short)3;
        pixelFormat.greenShift = (byte)2;
        pixelFormat.redMax = (short)3;
        pixelFormat.redShift = (byte)4;
        pixelFormat.depth = (byte)6;
        pixelFormat.trueColourFlag = 1;
        return pixelFormat;
    }

    public static PixelFormat create3bppPixelFormat(int bigEndianFlag) {
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.bigEndianFlag = (byte)bigEndianFlag;
        pixelFormat.bitsPerPixel = (byte)8;
        pixelFormat.blueMax = 1;
        pixelFormat.blueShift = 0;
        pixelFormat.greenMax = 1;
        pixelFormat.greenShift = 1;
        pixelFormat.redMax = 1;
        pixelFormat.redShift = (byte)2;
        pixelFormat.depth = (byte)3;
        pixelFormat.trueColourFlag = 1;
        return pixelFormat;
    }

    public String toString() {
        return "PixelFormat: [bits-per-pixel: " + String.valueOf(0xFF & this.bitsPerPixel) + ", depth: " + String.valueOf(0xFF & this.depth) + ", big-endian-flag: " + String.valueOf(0xFF & this.bigEndianFlag) + ", true-color-flag: " + String.valueOf(0xFF & this.trueColourFlag) + ", red-max: " + String.valueOf(0xFFFF & this.redMax) + ", green-max: " + String.valueOf(0xFFFF & this.greenMax) + ", blue-max: " + String.valueOf(0xFFFF & this.blueMax) + ", red-shift: " + String.valueOf(0xFF & this.redShift) + ", green-shift: " + String.valueOf(0xFF & this.greenShift) + ", blue-shift: " + String.valueOf(0xFF & this.blueShift) + "]";
    }
}

