/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Path
extends DataType
implements Cloneable {
    private Vector elements;
    public static Path systemClasspath = new Path(null, System.getProperty("java.class.path"));

    public Path(Project p, String path) {
        this(p);
        this.createPathElement().setPath(path);
    }

    public Path(Project project) {
        this.setProject(project);
        this.elements = new Vector();
    }

    public void setLocation(File location) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createPathElement().setLocation(location);
    }

    public void setPath(String path) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createPathElement().setPath(path);
    }

    public void setRefid(Reference r) throws BuildException {
        if (!this.elements.isEmpty()) {
            throw this.tooManyAttributes();
        }
        this.elements.addElement(r);
        super.setRefid(r);
    }

    public PathElement createPathElement() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PathElement pe = new PathElement();
        this.elements.addElement(pe);
        return pe;
    }

    public void addFileset(FileSet fs) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(fs);
        this.checked = false;
    }

    public void addFilelist(FileList fl) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(fl);
        this.checked = false;
    }

    public void addDirset(DirSet dset) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(dset);
        this.checked = false;
    }

    public Path createPath() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Path p = new Path(this.getProject());
        this.elements.addElement(p);
        this.checked = false;
        return p;
    }

    public void append(Path other) {
        if (other == null) {
            return;
        }
        String[] l = other.list();
        for (int i = 0; i < l.length; ++i) {
            if (this.elements.indexOf(l[i]) != -1) continue;
            this.elements.addElement(l[i]);
        }
    }

    public void addExisting(Path source) {
        String[] list = source.list();
        for (int i = 0; i < list.length; ++i) {
            File f = null;
            f = this.getProject() != null ? this.getProject().resolveFile(list[i]) : new File(list[i]);
            if (f.exists()) {
                this.setLocation(f);
                continue;
            }
            this.log("dropping " + f + " from path as it doesn't exist", 3);
        }
    }

    public String[] list() {
        if (!this.checked) {
            Stack<Path> stk = new Stack<Path>();
            stk.push(this);
            this.dieOnCircularReference(stk, this.getProject());
        }
        Vector result = new Vector(2 * this.elements.size());
        for (int i = 0; i < this.elements.size(); ++i) {
            File dir;
            Reference r;
            Object o = this.elements.elementAt(i);
            if (o instanceof Reference && !((o = (r = (Reference)o).getReferencedObject(this.getProject())) instanceof Path)) {
                String msg = r.getRefId() + " doesn't denote a path";
                throw new BuildException(msg);
            }
            if (o instanceof String) {
                Path.addUnlessPresent(result, (String)o);
                continue;
            }
            if (o instanceof PathElement) {
                String[] parts = ((PathElement)o).getParts();
                if (parts == null) {
                    throw new BuildException("You must either set location or path on <pathelement>");
                }
                for (int j = 0; j < parts.length; ++j) {
                    Path.addUnlessPresent(result, parts[j]);
                }
                continue;
            }
            if (o instanceof Path) {
                Path p = (Path)o;
                if (p.getProject() == null) {
                    p.setProject(this.getProject());
                }
                String[] parts = p.list();
                for (int j = 0; j < parts.length; ++j) {
                    Path.addUnlessPresent(result, parts[j]);
                }
                continue;
            }
            if (o instanceof DirSet) {
                DirSet dset = (DirSet)o;
                DirectoryScanner ds = dset.getDirectoryScanner(this.getProject());
                String[] s = ds.getIncludedDirectories();
                dir = dset.getDir(this.getProject());
                Path.addUnlessPresent(result, dir, s);
                continue;
            }
            if (o instanceof FileSet) {
                FileSet fs = (FileSet)o;
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] s = ds.getIncludedFiles();
                dir = fs.getDir(this.getProject());
                Path.addUnlessPresent(result, dir, s);
                continue;
            }
            if (!(o instanceof FileList)) continue;
            FileList fl = (FileList)o;
            String[] s = fl.getFiles(this.getProject());
            File dir2 = fl.getDir(this.getProject());
            Path.addUnlessPresent(result, dir2, s);
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public String toString() {
        String[] list = this.list();
        if (list.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(list[0].toString());
        for (int i = 1; i < list.length; ++i) {
            result.append(File.pathSeparatorChar);
            result.append(list[i]);
        }
        return result.toString();
    }

    public static String[] translatePath(Project project, String source) {
        Vector<String> result = new Vector<String>();
        if (source == null) {
            return new String[0];
        }
        PathTokenizer tok = new PathTokenizer(source);
        StringBuffer element = new StringBuffer();
        while (tok.hasMoreTokens()) {
            element.setLength(0);
            String pathElement = tok.nextToken();
            try {
                element.append(Path.resolveFile(project, pathElement));
            }
            catch (BuildException e) {
                project.log("Dropping path element " + pathElement + " as it is not valid relative to the project", 3);
            }
            for (int i = 0; i < element.length(); ++i) {
                Path.translateFileSep(element, i);
            }
            result.addElement(element.toString());
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public static String translateFile(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(source);
        for (int i = 0; i < result.length(); ++i) {
            Path.translateFileSep(result, i);
        }
        return result.toString();
    }

    protected static boolean translateFileSep(StringBuffer buffer, int pos) {
        if (buffer.charAt(pos) == '/' || buffer.charAt(pos) == '\\') {
            buffer.setCharAt(pos, File.separatorChar);
            return true;
        }
        return false;
    }

    public int size() {
        return this.list().length;
    }

    public Object clone() {
        Path p = new Path(this.getProject());
        p.append(this);
        return p;
    }

    protected void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.checked) {
            return;
        }
        Enumeration enumeration = this.elements.elements();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (o instanceof Reference) {
                o = ((Reference)o).getReferencedObject(p);
            }
            if (!(o instanceof DataType)) continue;
            if (stk.contains(o)) {
                throw this.circularReference();
            }
            stk.push(o);
            ((DataType)o).dieOnCircularReference(stk, p);
            stk.pop();
        }
        this.checked = true;
    }

    private static String resolveFile(Project project, String relativeName) {
        if (project != null) {
            File f = project.resolveFile(relativeName);
            return f.getAbsolutePath();
        }
        return relativeName;
    }

    private static void addUnlessPresent(Vector v, String s) {
        if (v.indexOf(s) == -1) {
            v.addElement(s);
        }
    }

    private static void addUnlessPresent(Vector v, File dir, String[] s) {
        for (int j = 0; j < s.length; ++j) {
            File d = new File(dir, s[j]);
            String absolutePath = d.getAbsolutePath();
            Path.addUnlessPresent(v, Path.translateFile(absolutePath));
        }
    }

    public Path concatSystemClasspath() {
        return this.concatSystemClasspath("last");
    }

    public Path concatSystemClasspath(String defValue) {
        String o;
        Path result = new Path(this.getProject());
        String order = defValue;
        if (this.getProject() != null && (o = this.getProject().getProperty("build.sysclasspath")) != null) {
            order = o;
        }
        if (order.equals("only")) {
            result.addExisting(systemClasspath);
        } else if (order.equals("first")) {
            result.addExisting(systemClasspath);
            result.addExisting(this);
        } else if (order.equals("ignore")) {
            result.addExisting(this);
        } else {
            if (!order.equals("last")) {
                this.log("invalid value for build.sysclasspath: " + order, 1);
            }
            result.addExisting(this);
            result.addExisting(systemClasspath);
        }
        return result;
    }

    public void addJavaRuntime() {
        if (System.getProperty("java.vendor").toLowerCase(Locale.US).indexOf("microsoft") >= 0) {
            FileSet msZipFiles = new FileSet();
            msZipFiles.setDir(new File(System.getProperty("java.home") + File.separator + "Packages"));
            msZipFiles.setIncludes("*.ZIP");
            this.addFileset(msZipFiles);
        } else if ("Kaffe".equals(System.getProperty("java.vm.name"))) {
            FileSet kaffeJarFiles = new FileSet();
            kaffeJarFiles.setDir(new File(System.getProperty("java.home") + File.separator + "share" + File.separator + "kaffe"));
            kaffeJarFiles.setIncludes("*.jar");
            this.addFileset(kaffeJarFiles);
        } else if (JavaEnvUtils.isJavaVersion("1.1")) {
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "classes.zip"));
        } else {
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
            String[] secJars = new String[]{"jce", "jsse"};
            for (int i = 0; i < secJars.length; ++i) {
                this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + secJars[i] + ".jar"));
            }
            String[] ibmJars = new String[]{"core", "graphics", "security", "server", "xml"};
            for (int i = 0; i < ibmJars.length; ++i) {
                this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + ibmJars[i] + ".jar"));
            }
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + "classes.jar"));
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + "ui.jar"));
        }
    }

    public void addExtdirs(Path extdirs) {
        if (extdirs == null) {
            String extProp = System.getProperty("java.ext.dirs");
            if (extProp != null) {
                extdirs = new Path(this.getProject(), extProp);
            } else {
                return;
            }
        }
        String[] dirs = extdirs.list();
        for (int i = 0; i < dirs.length; ++i) {
            File dir = this.getProject().resolveFile(dirs[i]);
            if (!dir.exists() || !dir.isDirectory()) continue;
            FileSet fs = new FileSet();
            fs.setDir(dir);
            fs.setIncludes("*");
            this.addFileset(fs);
        }
    }

    public class PathElement {
        private String[] parts;

        public void setLocation(File loc) {
            this.parts = new String[]{Path.translateFile(loc.getAbsolutePath())};
        }

        public void setPath(String path) {
            this.parts = Path.translatePath(Path.this.getProject(), path);
        }

        public String[] getParts() {
            return this.parts;
        }
    }
}

