/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpstatistics;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtils;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtpstatistics.FileCheck;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.utils.ErrorMessage;
import net.sf.gogui.utils.Platform;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.utils.Table;

public class GtpStatistics {
    private final boolean m_allowSetup;
    private final boolean m_backward;
    private boolean m_result;
    private int m_max;
    private int m_min;
    private int m_numberGames;
    private final int m_size;
    private double m_lastCpuTime;
    private GtpClient m_gtp;
    private final NumberFormat m_format1;
    private final NumberFormat m_format2;
    private Table m_table;
    private ArrayList m_commands;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GtpStatistics(String string, ArrayList arrayList, File file, int n, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, boolean bl, boolean bl2, boolean bl3, int n2, int n3, boolean bl4) throws Exception {
        block7: {
            this.m_lastCpuTime = 0.0;
            this.m_format1 = StringUtils.getNumberFormat(1);
            this.m_format2 = StringUtils.getNumberFormat(2);
            if (file.exists() && !bl2) {
                throw new ErrorMessage("File " + file + " already exists");
            }
            new FileCheck(arrayList, n, bl3);
            this.m_size = n;
            this.m_result = false;
            this.m_allowSetup = bl3;
            this.m_min = n2;
            this.m_max = n3;
            this.m_backward = bl4;
            this.initCommands(arrayList2, arrayList3, arrayList4);
            ArrayList<String> arrayList5 = new ArrayList<String>();
            arrayList5.add("File");
            arrayList5.add("Move");
            for (int i = 0; i < this.m_commands.size(); ++i) {
                arrayList5.add(this.getCommand((int)i).m_columnTitle);
            }
            this.m_table = new Table(arrayList5);
            this.m_table.setProperty("Size", Integer.toString(n));
            this.m_gtp = new GtpClient(string, bl, null);
            this.m_gtp.queryProtocolVersion();
            this.m_table.setProperty("Program", string);
            try {
                this.m_table.setProperty("Name", this.m_gtp.send("name"));
            }
            catch (GtpError gtpError) {
                this.m_table.setProperty("Name", "");
                if (!this.m_gtp.isProgramDead()) break block7;
                throw gtpError;
            }
        }
        try {
            this.m_table.setProperty("Version", this.m_gtp.send("version"));
        }
        catch (GtpError gtpError) {
            this.m_table.setProperty("Version", "");
        }
        String string2 = Platform.getHostInfo();
        this.m_table.setProperty("Host", string2);
        this.m_table.setProperty("Date", StringUtils.getDate());
        for (int i = 0; i < arrayList.size(); ++i) {
            this.handleFile((String)arrayList.get(i));
        }
        this.m_table.setProperty("Games", Integer.toString(this.m_numberGames));
        this.m_table.setProperty("Backward", bl4 ? "yes" : "no");
        FileWriter fileWriter = new FileWriter(file);
        this.m_table.save(fileWriter);
        fileWriter.close();
    }

    public boolean getResult() {
        return this.m_result;
    }

    private void addCommand(String string, boolean bl, boolean bl2) throws ErrorMessage {
        if ((string = string.trim()).equals("")) {
            throw new ErrorMessage("Empty command not allowed");
        }
        Command command = new Command();
        command.m_command = string;
        command.m_begin = bl;
        command.m_final = bl2;
        int n = 0;
        Command command2 = null;
        for (int i = 0; i < this.m_commands.size(); ++i) {
            if (!this.getCommand((int)i).m_command.equals(string)) continue;
            command2 = this.getCommand(i);
            ++n;
        }
        if (n == 0) {
            command.m_columnTitle = string;
        } else {
            if (n == 1) {
                command2.m_columnTitle = command2.m_columnTitle + " (1)";
            }
            command.m_columnTitle = string + " (" + (n + 1) + ")";
        }
        this.m_commands.add(command);
    }

    private void addCommands(ArrayList arrayList, boolean bl, boolean bl2) throws ErrorMessage {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.addCommand((String)arrayList.get(i), bl, bl2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkGame(GameTree gameTree, String string) throws ErrorMessage {
        GameInformation gameInformation = gameTree.getGameInformation();
        int n = gameInformation.m_boardSize;
        if (n != this.m_size) {
            throw new ErrorMessage(string + " has not size " + this.m_size);
        }
        Node node = gameTree.getRoot();
        GoColor goColor = GoColor.BLACK;
        for (Node node2 = node; node2 != null; node2 = node2.getChild()) {
            Move move;
            if (node2.getNumberAddWhite() + node2.getNumberAddBlack() > 0) {
                if (!this.m_allowSetup) throw new ErrorMessage(string + " contains setup stones");
                if (node2 != node) throw new ErrorMessage(string + " contains setup stones" + " in non-root position");
                goColor = GoColor.EMPTY;
            }
            if ((move = node2.getMove()) == null) continue;
            if (goColor == GoColor.EMPTY) {
                goColor = move.getColor();
            }
            if (move.getColor() != goColor) {
                throw new ErrorMessage(string + "has non-alternating moves");
            }
            goColor = goColor.otherColor();
        }
    }

    private String convertCommand(String string, GoColor goColor) {
        if (string.equals("reg_genmove")) {
            return string + ' ' + goColor;
        }
        return string;
    }

    private String convertResponse(String string, String string2, GoColor goColor, Move move) throws GtpError {
        if (string.equals("cputime")) {
            try {
                double d = Double.parseDouble(string2);
                double d2 = d - this.m_lastCpuTime;
                this.m_lastCpuTime = d;
                return this.m_format2.format(d2);
            }
            catch (NumberFormatException numberFormatException) {
                return string2;
            }
        }
        if (string.equals("estimate_score")) {
            String[] stringArray = StringUtils.splitArguments(string2);
            if (stringArray.length == 0) {
                return string2;
            }
            return this.convertScore(stringArray[0]);
        }
        if (string.equals("final_score")) {
            return this.convertScore(string2);
        }
        if (string.equals("reg_genmove")) {
            if (move == null) {
                return "";
            }
            try {
                GoPoint goPoint = GoPoint.parsePoint(string2, this.m_size);
                return Move.get(goPoint, goColor) == move ? "1" : "0";
            }
            catch (GoPoint.InvalidPoint invalidPoint) {
                throw new GtpError("Program sent invalid move: " + string2);
            }
        }
        return string2;
    }

    private String convertScore(String string) {
        String string2 = string.trim();
        double d = 1.0;
        if (string2.startsWith("W+")) {
            string2 = string2.substring(2);
            d = -1.0;
        } else if (string2.startsWith("B+")) {
            string2 = string2.substring(2);
        }
        try {
            return this.m_format1.format(d * Double.parseDouble(string2));
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    private void initCommands(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) throws ErrorMessage {
        this.m_commands = new ArrayList();
        if (arrayList2 != null) {
            this.addCommands(arrayList2, true, false);
        }
        if (arrayList != null) {
            this.addCommands(arrayList, false, false);
        }
        if (arrayList3 != null) {
            this.addCommands(arrayList3, false, true);
        }
        if (this.m_commands.size() == 0) {
            throw new ErrorMessage("No commands defined");
        }
    }

    private Command getCommand(int n) {
        return (Command)this.m_commands.get(n);
    }

    private void handleFile(String string) throws ErrorMessage, FileNotFoundException, GtpError, SgfReader.SgfError {
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        SgfReader sgfReader = new SgfReader(fileInputStream, string, null, 0L);
        ++this.m_numberGames;
        GameTree gameTree = sgfReader.getGameTree();
        this.checkGame(gameTree, string);
        GameInformation gameInformation = gameTree.getGameInformation();
        int n = gameInformation.m_boardSize;
        this.m_gtp.sendBoardsize(n);
        this.m_gtp.sendClearBoard(n);
        Node node = gameTree.getRoot();
        if (this.m_backward) {
            this.iteratePositionsBackward(node, string);
        } else {
            this.iteratePositions(node, string);
        }
    }

    private void handlePosition(String string, GoColor goColor, Move move, int n, boolean bl, boolean bl2, boolean bl3) throws GtpError {
        String string2;
        Command command;
        int n2;
        System.err.println(string + ":" + n);
        this.m_table.startRow();
        this.m_table.set("File", string);
        this.m_table.set("Move", n);
        for (n2 = 0; n2 < this.m_commands.size(); ++n2) {
            command = this.getCommand(n2);
            if (!command.m_begin || !bl) continue;
            string2 = this.send(command.m_command, goColor, move);
            this.m_table.set(command.m_columnTitle, string2);
        }
        for (n2 = 0; n2 < this.m_commands.size(); ++n2) {
            command = this.getCommand(n2);
            if (command.m_begin || command.m_final || !bl2) continue;
            string2 = this.send(command.m_command, goColor, move);
            this.m_table.set(command.m_columnTitle, string2);
        }
        for (n2 = 0; n2 < this.m_commands.size(); ++n2) {
            command = this.getCommand(n2);
            if (!command.m_final || !bl3) continue;
            string2 = this.send(command.m_command, goColor, move);
            this.m_table.set(command.m_columnTitle, string2);
        }
    }

    private void iteratePositions(Node node, String string) throws GtpError {
        int n = 0;
        GoColor goColor = GoColor.BLACK;
        for (Node node2 = node; node2 != null; node2 = node2.getChild()) {
            boolean bl;
            Move move;
            if (node2.getNumberAddWhite() + node2.getNumberAddBlack() > 0) {
                if (!($assertionsDisabled || this.m_allowSetup && node2 != node)) {
                    throw new AssertionError();
                }
                goColor = this.sendSetup(node2);
            }
            if ((move = node2.getMove()) == null) continue;
            boolean bl2 = ++n == 1;
            boolean bl3 = bl = n >= this.m_min && n <= this.m_max;
            if (bl2 || bl) {
                this.handlePosition(string, goColor, move, n, bl2, bl, false);
            }
            this.m_gtp.sendPlay(move);
            goColor = goColor.otherColor();
        }
        boolean bl = ++n == 1;
        boolean bl4 = n >= this.m_min && n <= this.m_max;
        this.handlePosition(string, goColor, null, n, bl, bl4, true);
    }

    private void iteratePositionsBackward(Node node, String string) throws GtpError {
        Node node2 = node;
        GoColor goColor = GoColor.BLACK;
        while (true) {
            Node node3;
            Move move;
            if (node2.getNumberAddWhite() + node2.getNumberAddBlack() > 0) {
                if (!($assertionsDisabled || this.m_allowSetup && node2 == node)) {
                    throw new AssertionError();
                }
                goColor = this.sendSetup(node2);
            }
            if ((move = node2.getMove()) != null) {
                this.m_gtp.sendPlay(move);
                goColor = goColor.otherColor();
            }
            if ((node3 = node2.getChild()) == null) break;
            node2 = node3;
        }
        int n = 1;
        boolean bl = node2 == node;
        boolean bl2 = n >= this.m_min && n <= this.m_max;
        this.handlePosition(string, goColor, null, n, true, bl2, bl);
        while (node2 != node) {
            if (!$assertionsDisabled && node2.getNumberAddWhite() + node2.getNumberAddBlack() != 0) {
                throw new AssertionError();
            }
            Move move = node2.getMove();
            if (move != null) {
                this.m_gtp.send("undo");
                bl = node2.getFather() == node;
                boolean bl3 = bl2 = ++n >= this.m_min && n <= this.m_max;
                if (bl || bl2) {
                    this.handlePosition(string, goColor, move, n, false, bl2, bl);
                }
                goColor = goColor.otherColor();
            }
            node2 = node2.getFather();
        }
    }

    private String send(String string, GoColor goColor, Move move) throws GtpError {
        String string2 = this.convertCommand(string, goColor);
        String string3 = this.m_gtp.send(string2);
        return this.convertResponse(string, string3, goColor, move);
    }

    private GoColor sendSetup(Node node) throws GtpError {
        ArrayList arrayList = NodeUtils.getAllAsMoves(node);
        if (!$assertionsDisabled && arrayList.size() <= 0) {
            throw new AssertionError();
        }
        GoColor goColor = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            Move move = (Move)arrayList.get(i);
            this.m_gtp.sendPlay(move);
            goColor = move.getColor().otherColor();
        }
        return goColor;
    }

    static {
        $assertionsDisabled = !GtpStatistics.class.desiredAssertionStatus();
    }

    private static class Command {
        public boolean m_begin;
        public boolean m_final;
        public String m_command;
        public String m_columnTitle;

        private Command() {
        }
    }
}

