/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.core.client.impl.AsyncFragmentLoader;
import com.google.gwt.core.client.impl.LoadingStrategyBase;

public class ScriptTagLoadingStrategy
extends LoadingStrategyBase {
    private static void asyncCallback(LoadingStrategyBase.RequestData request, String code) {
        boolean firstTimeCalled = ScriptTagLoadingStrategy.clearAsyncCallback(request.getFragment());
        if (firstTimeCalled) {
            request.tryInstall(code);
        }
    }

    private static void cleanup(LoadingStrategyBase.RequestData request) {
        boolean neverCalled = ScriptTagLoadingStrategy.clearAsyncCallback(request.getFragment());
        if (neverCalled) {
            request.onLoadError(new AsyncFragmentLoader.HttpDownloadFailure(request.getUrl(), 404, "Script Tag Failure - no status available"), true);
        }
    }

    private static native boolean clearAsyncCallback(int var0);

    private static native void setAsyncCallback(int var0, LoadingStrategyBase.RequestData var1);

    public ScriptTagLoadingStrategy() {
        super(new ScriptTagDownloadStrategy());
    }

    public static class ScriptTagDownloadStrategy
    implements LoadingStrategyBase.DownloadStrategy {
        @Override
        public void tryDownload(final LoadingStrategyBase.RequestData request) {
            ScriptTagLoadingStrategy.setAsyncCallback(request.getFragment(), request);
            ScriptInjector.fromUrl(request.getUrl()).setRemoveTag(true).setCallback(new Callback<Void, Exception>(){

                @Override
                public void onFailure(Exception reason) {
                    ScriptTagLoadingStrategy.cleanup(request);
                }

                @Override
                public void onSuccess(Void result) {
                    ScriptTagLoadingStrategy.cleanup(request);
                }
            }).inject();
        }
    }
}

