/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.OptionPaneUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicOptionPaneUI
extends OptionPaneUI {
    public static final int MinimumWidth = 262;
    public static final int MinimumHeight = 90;
    private static final int iconSize = 36;
    private static final String OK_STRING = "OK";
    private static final String YES_STRING = "Yes";
    private static final String NO_STRING = "No";
    private static final String CANCEL_STRING = "Cancel";
    private static MessageIcon errorIcon = new MessageIcon(){

        public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int[] nArray = new int[8];
            nArray[2] = 9;
            nArray[3] = 27;
            nArray[4] = 36;
            nArray[5] = 36;
            nArray[6] = 27;
            nArray[7] = 9;
            int[] nArray2 = new int[8];
            nArray2[0] = 9;
            nArray2[1] = 27;
            nArray2[2] = 36;
            nArray2[3] = 36;
            nArray2[4] = 27;
            nArray2[5] = 9;
            Polygon polygon = new Polygon(nArray, nArray2, 8);
            graphics.translate(n, n2);
            Color color = graphics.getColor();
            graphics.setColor(Color.RED);
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(13, 16, 10, 4);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }
    };
    private static MessageIcon infoIcon = new MessageIcon(){

        public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            Color color = graphics.getColor();
            graphics.setColor(Color.RED);
            graphics.fillOval(0, 0, 36, 36);
            graphics.setColor(Color.BLACK);
            graphics.drawOval(16, 6, 4, 4);
            Polygon polygon = new Polygon(new int[]{15, 15, 13, 13, 23, 23, 21, 21}, new int[]{12, 28, 28, 30, 30, 28, 28, 12}, 8);
            graphics.drawPolygon(polygon);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }
    };
    private static MessageIcon warningIcon = new MessageIcon(){

        public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            Color color = graphics.getColor();
            graphics.setColor(Color.YELLOW);
            int[] nArray = new int[3];
            nArray[1] = 18;
            nArray[2] = 36;
            int[] nArray2 = new int[3];
            nArray2[0] = 36;
            nArray2[2] = 36;
            Polygon polygon = new Polygon(nArray, nArray2, 3);
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.BLACK);
            Polygon polygon2 = new Polygon(new int[]{15, 16, 20, 21}, new int[]{8, 26, 26, 8}, 4);
            graphics.drawPolygon(polygon2);
            graphics.drawOval(16, 30, 4, 4);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }
    };
    private static MessageIcon questionIcon = new MessageIcon(){

        public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            Color color = graphics.getColor();
            graphics.setColor(Color.GREEN);
            graphics.fillRect(0, 0, 36, 36);
            graphics.setColor(Color.BLACK);
            graphics.drawOval(11, 2, 16, 16);
            graphics.drawOval(14, 5, 10, 10);
            graphics.setColor(Color.GREEN);
            graphics.fillRect(0, 10, 36, 26);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(11, 10, 14, 10);
            graphics.drawLine(24, 10, 17, 22);
            graphics.drawLine(27, 10, 20, 22);
            graphics.drawLine(17, 22, 20, 22);
            graphics.drawOval(17, 25, 3, 3);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }
    };
    protected boolean hasCustomComponents;
    protected Component initialFocusComponent;
    protected JComponent inputComponent;
    protected Dimension minimumSize;
    protected PropertyChangeListener propertyChangeListener;
    protected JOptionPane optionPane;
    private transient Color messageForeground;
    private transient Border messageBorder;
    private transient Border buttonBorder;
    transient Container messageAreaContainer;
    transient Container buttonContainer;
    static /* synthetic */ Class class$javax$swing$JInternalFrame;

    protected void addButtonComponents(Container container, Object[] objectArray, int n) {
        if (objectArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] != null) {
                Component component;
                if (objectArray[n2] instanceof Component) {
                    component = (Component)objectArray[n2];
                } else {
                    component = objectArray[n2] instanceof Icon ? new JButton((Icon)objectArray[n2]) : new JButton(objectArray[n2].toString());
                    this.hasCustomComponents = true;
                }
                if (component instanceof JButton) {
                    ((JButton)component).addActionListener(this.createButtonActionListener(n2));
                }
                if (n2 == n) {
                    this.initialFocusComponent = component;
                }
                container.add(component);
            }
            ++n2;
        }
        this.selectInitialValue(this.optionPane);
    }

    protected void addIcon(Container container) {
        JLabel jLabel = null;
        Icon icon = this.getIcon();
        if (icon != null) {
            jLabel = new JLabel(icon);
            container.add((Component)jLabel, "West");
        }
    }

    private static final GridBagConstraints createConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        return gridBagConstraints;
    }

    protected void addMessageComponents(Container container, GridBagConstraints gridBagConstraints, Object object, int n, boolean bl) {
        if (object == null) {
            return;
        }
        this.hasCustomComponents = bl;
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.addMessageComponents(container, gridBagConstraints, objectArray[n2], n, bl);
                ++n2;
            }
            return;
        }
        if (object instanceof Component) {
            container.add((Component)object, gridBagConstraints);
            ++gridBagConstraints.gridy;
        } else if (object instanceof Icon) {
            container.add((Component)new JLabel((Icon)object), gridBagConstraints);
            ++gridBagConstraints.gridy;
        } else if (object.toString().length() > n || object.toString().contains("\n")) {
            Box box = new Box(1);
            this.burstStringInto(box, object.toString(), n);
            this.addMessageComponents(container, gridBagConstraints, box, n, true);
        } else {
            this.addMessageComponents(container, gridBagConstraints, new JLabel(object.toString()), n, true);
        }
    }

    protected void burstStringInto(Container container, String string, int n) {
        String string2;
        String string3;
        if (string == null || container == null) {
            return;
        }
        int n2 = string.indexOf(10);
        if (n2 >= 0 && n2 < n) {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
        }
        JLabel jLabel = new JLabel(string3);
        container.add(jLabel);
        if (string2.length() == 0) {
            return;
        }
        if (string2.length() > n || string2.contains("\n")) {
            this.burstStringInto(container, string2, n);
        } else {
            container.add(new JLabel(string2));
        }
    }

    public boolean containsCustomComponents(JOptionPane jOptionPane) {
        return this.hasCustomComponents;
    }

    protected ActionListener createButtonActionListener(int n) {
        return new ButtonActionListener(n);
    }

    protected Container createButtonArea() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.createLayoutManager());
        this.addButtonComponents(jPanel, this.getButtons(), this.getInitialValueIndex());
        return jPanel;
    }

    protected LayoutManager createLayoutManager() {
        return new ButtonAreaLayout(this.getSizeButtonsToSameWidth(), 6);
    }

    protected Container createMessageArea() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.addIcon(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = BasicOptionPaneUI.createConstraints();
        this.addMessageComponents(jPanel2, gridBagConstraints, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        if (this.optionPane.getWantsInput()) {
            Object[] objectArray = this.optionPane.getSelectionValues();
            this.inputComponent = objectArray == null ? new JTextField(15) : (objectArray.length < 20 ? new JComboBox(objectArray) : new JList(objectArray));
            if (this.inputComponent != null) {
                this.addMessageComponents(jPanel2, gridBagConstraints, this.inputComponent, this.getMaxCharactersPerLineCount(), false);
                this.resetSelectedValue();
                this.selectInitialValue(this.optionPane);
            }
        }
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected Container createSeparator() {
        return null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicOptionPaneUI();
    }

    protected Object[] getButtons() {
        if (this.optionPane.getOptions() != null) {
            return this.optionPane.getOptions();
        }
        switch (this.optionPane.getOptionType()) {
            case 0: {
                return new Object[]{YES_STRING, NO_STRING};
            }
            case 1: {
                return new Object[]{YES_STRING, NO_STRING, CANCEL_STRING};
            }
            case 2: {
                return new Object[]{OK_STRING, CANCEL_STRING};
            }
            case -1: {
                Object[] objectArray;
                if (this.optionPane.getWantsInput()) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = OK_STRING;
                    objectArray = objectArray2;
                    objectArray2[1] = CANCEL_STRING;
                } else if (this.optionPane.getMessageType() == 3) {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = YES_STRING;
                    objectArray3[1] = NO_STRING;
                    objectArray = objectArray3;
                    objectArray3[2] = CANCEL_STRING;
                } else {
                    Object[] objectArray4 = new Object[1];
                    objectArray = objectArray4;
                    objectArray4[0] = OK_STRING;
                }
                return objectArray;
            }
        }
        return null;
    }

    protected Icon getIcon() {
        if (this.optionPane.getIcon() != null) {
            return this.optionPane.getIcon();
        }
        return this.getIconForType(this.optionPane.getMessageType());
    }

    protected Icon getIconForType(int n) {
        MessageIcon messageIcon = null;
        switch (n) {
            case 0: {
                messageIcon = errorIcon;
                break;
            }
            case 1: {
                messageIcon = infoIcon;
                break;
            }
            case 2: {
                messageIcon = warningIcon;
                break;
            }
            case 3: {
                messageIcon = questionIcon;
                break;
            }
        }
        return messageIcon;
    }

    protected int getInitialValueIndex() {
        Object[] objectArray = this.getButtons();
        if (objectArray == null) {
            return -1;
        }
        Object object = this.optionPane.getInitialValue();
        int n = 0;
        while (n < objectArray.length) {
            if (object == objectArray[n]) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected Object getMessage() {
        return this.optionPane.getMessage();
    }

    public Dimension getMinimumOptionPaneSize() {
        return this.minimumSize;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.optionPane.getLayout().preferredLayoutSize(this.optionPane);
        Dimension dimension2 = this.getMinimumOptionPaneSize();
        int n = Math.max(dimension.width, dimension2.width);
        int n2 = Math.max(dimension.height, dimension2.height);
        return new Dimension(n, n2);
    }

    protected boolean getSizeButtonsToSameWidth() {
        return true;
    }

    protected void installComponents() {
        Container container;
        Container container2;
        this.hasCustomComponents = false;
        Container container3 = this.createMessageArea();
        if (container3 != null) {
            ((JComponent)container3).setBorder(this.messageBorder);
            container3.setForeground(this.messageForeground);
            this.messageAreaContainer = container3;
            this.optionPane.add(container3);
        }
        if ((container2 = this.createSeparator()) != null) {
            this.optionPane.add(container2);
        }
        if ((container = this.createButtonArea()) != null) {
            ((JComponent)container).setBorder(this.buttonBorder);
            this.buttonContainer = container;
            this.optionPane.add(container);
        }
        this.optionPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.optionPane.invalidate();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.optionPane, "OptionPane.background", "OptionPane.foreground", "OptionPane.font");
        LookAndFeel.installBorder(this.optionPane, "OptionPane.border");
        this.optionPane.setOpaque(true);
        this.messageBorder = UIManager.getBorder("OptionPane.messageAreaBorder");
        this.messageForeground = UIManager.getColor("OptionPane.messageForeground");
        this.buttonBorder = UIManager.getBorder("OptionPane.buttonAreaBorder");
        this.minimumSize = UIManager.getDimension("OptionPane.minimumSize");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.optionPane.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JOptionPane) {
            this.optionPane = (JOptionPane)jComponent;
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    protected void resetInputValue() {
        if (this.optionPane.getWantsInput() && this.inputComponent != null) {
            Object object = null;
            if (this.inputComponent instanceof JTextField) {
                object = ((JTextField)this.inputComponent).getText();
            } else if (this.inputComponent instanceof JComboBox) {
                object = ((JComboBox)this.inputComponent).getSelectedItem();
            } else if (this.inputComponent instanceof JList) {
                object = ((JList)this.inputComponent).getSelectedValue();
            }
            if (object != null) {
                this.optionPane.setInputValue(object);
            }
        }
    }

    public void selectInitialValue(JOptionPane jOptionPane) {
        if (this.inputComponent != null) {
            this.inputComponent.requestFocus();
            return;
        }
        if (this.initialFocusComponent != null) {
            this.initialFocusComponent.requestFocus();
        }
    }

    void resetSelectedValue() {
        block1: {
            Object object;
            block2: {
                if (this.inputComponent == null) break block1;
                object = this.optionPane.getInitialSelectionValue();
                if (object == null) {
                    return;
                }
                if (!(this.inputComponent instanceof JTextField)) break block2;
                ((JTextField)this.inputComponent).setText((String)object);
                break block1;
            }
            if (!(this.inputComponent instanceof JComboBox)) break block1;
            ((JComboBox)this.inputComponent).setSelectedItem(object);
        }
    }

    protected void uninstallComponents() {
        this.optionPane.removeAll();
        this.buttonContainer = null;
        this.messageAreaContainer = null;
    }

    protected void uninstallDefaults() {
        this.optionPane.setFont(null);
        this.optionPane.setForeground(null);
        this.optionPane.setBackground(null);
        this.minimumSize = null;
        this.messageBorder = null;
        this.buttonBorder = null;
        this.messageForeground = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.optionPane.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.optionPane = null;
    }

    static /* synthetic */ int access$0() {
        return 36;
    }

    static /* synthetic */ String access$1() {
        return OK_STRING;
    }

    static /* synthetic */ String access$2() {
        return CANCEL_STRING;
    }

    static /* synthetic */ String access$3() {
        return YES_STRING;
    }

    static /* synthetic */ String access$4() {
        return NO_STRING;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.hasCustomComponents = false;
    }

    public BasicOptionPaneUI() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ButtonActionListener
    implements ActionListener {
        protected int buttonIndex;

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame;
            Class clazz;
            Object object;
            Integer n = new Integer(-1);
            Object[] objectArray = BasicOptionPaneUI.this.optionPane.getOptions();
            if (objectArray != null) {
                n = new Integer(this.buttonIndex);
            } else {
                object = ((JButton)actionEvent.getSource()).getText();
                if (((String)object).equals(BasicOptionPaneUI.OK_STRING)) {
                    n = new Integer(0);
                }
                if (((String)object).equals(BasicOptionPaneUI.CANCEL_STRING)) {
                    n = new Integer(2);
                }
                if (((String)object).equals(BasicOptionPaneUI.YES_STRING)) {
                    n = new Integer(0);
                }
                if (((String)object).equals(BasicOptionPaneUI.NO_STRING)) {
                    n = new Integer(1);
                }
            }
            BasicOptionPaneUI.this.optionPane.setValue(n);
            BasicOptionPaneUI.this.resetInputValue();
            object = SwingUtilities.windowForComponent(BasicOptionPaneUI.this.optionPane);
            if (object instanceof JDialog) {
                ((JDialog)object).dispose();
            }
            if ((clazz = class$javax$swing$JInternalFrame) == null) {
                clazz = class$javax$swing$JInternalFrame = BasicOptionPaneUI.class("[Ljavax.swing.JInternalFrame;", false);
            }
            if ((jInternalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(clazz, BasicOptionPaneUI.this.optionPane)) != null) {
                try {
                    jInternalFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public ButtonActionListener(int n) {
            this.buttonIndex = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ButtonAreaLayout
    implements LayoutManager {
        protected boolean centersChildren;
        protected int padding;
        protected boolean syncAllWidths;
        private transient int widthOfWidestButton;
        private transient int tallestButton;

        public void addLayoutComponent(String string, Component component) {
        }

        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        public int getPadding() {
            return this.padding;
        }

        public boolean getSyncAllWidths() {
            return this.syncAllWidths;
        }

        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            int n = container.getInsets().left;
            if (this.getCentersChildren()) {
                n += (int)((double)container.getSize().width / (double)2 - (double)this.buttonRowLength(container) / (double)2);
            }
            int n2 = 0;
            while (n2 < componentArray.length) {
                Dimension dimension = componentArray[n2].getPreferredSize();
                if (this.syncAllWidths) {
                    componentArray[n2].setBounds(n, 0, this.widthOfWidestButton, dimension.height);
                    n += this.widthOfWidestButton + this.getPadding();
                } else {
                    componentArray[n2].setBounds(n, 0, dimension.width, dimension.height);
                    n += dimension.width + this.getPadding();
                }
                ++n2;
            }
        }

        private final int buttonRowLength(Container container) {
            Cloneable cloneable;
            Component[] componentArray = container.getComponents();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < componentArray.length) {
                cloneable = componentArray[n4].getPreferredSize();
                n += cloneable.width + this.getPadding();
                n2 = Math.max(n2, cloneable.width);
                n3 = Math.max(n3, cloneable.height);
                ++n4;
            }
            this.widthOfWidestButton = n2;
            this.tallestButton = n3;
            n4 = this.getSyncAllWidths() ? n2 * componentArray.length + this.getPadding() * (componentArray.length - 1) : n;
            cloneable = container.getInsets();
            return n4 += ((Insets)cloneable).left + ((Insets)cloneable).right;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = this.buttonRowLength(container);
            return new Dimension(n, this.tallestButton);
        }

        public void removeLayoutComponent(Component component) {
        }

        public void setCentersChildren(boolean bl) {
            this.centersChildren = bl;
        }

        public void setPadding(int n) {
            this.padding = n;
        }

        public void setSyncAllWidths(boolean bl) {
            this.syncAllWidths = bl;
        }

        private final /* synthetic */ void this() {
            this.centersChildren = true;
        }

        public ButtonAreaLayout(boolean bl, int n) {
            this.this();
            this.syncAllWidths = bl;
            this.padding = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("icon") || propertyChangeEvent.getPropertyName().equals("messageType")) {
                BasicOptionPaneUI.this.addIcon(BasicOptionPaneUI.this.messageAreaContainer);
            } else if (propertyChangeEvent.getPropertyName().equals("initialSelectionValue")) {
                BasicOptionPaneUI.this.resetSelectedValue();
            } else if (propertyChangeEvent.getPropertyName().equals("initialValue") || propertyChangeEvent.getPropertyName().equals("options") || propertyChangeEvent.getPropertyName().equals("optionType")) {
                Container container = BasicOptionPaneUI.this.createButtonArea();
                BasicOptionPaneUI.this.optionPane.remove(BasicOptionPaneUI.this.buttonContainer);
                BasicOptionPaneUI.this.optionPane.add(container);
                BasicOptionPaneUI.this.buttonContainer = container;
            } else if (propertyChangeEvent.getPropertyName().equals("message") || propertyChangeEvent.getPropertyName().equals("wantsInput") || propertyChangeEvent.getPropertyName().equals("selectionValues")) {
                BasicOptionPaneUI.this.optionPane.remove(BasicOptionPaneUI.this.messageAreaContainer);
                BasicOptionPaneUI.this.messageAreaContainer = BasicOptionPaneUI.this.createMessageArea();
                BasicOptionPaneUI.this.optionPane.add(BasicOptionPaneUI.this.messageAreaContainer);
                Container container = BasicOptionPaneUI.this.createButtonArea();
                BasicOptionPaneUI.this.optionPane.remove(BasicOptionPaneUI.this.buttonContainer);
                BasicOptionPaneUI.this.optionPane.add(container);
                BasicOptionPaneUI.this.buttonContainer = container;
                BasicOptionPaneUI.this.optionPane.add(BasicOptionPaneUI.this.buttonContainer);
            }
            BasicOptionPaneUI.this.optionPane.invalidate();
            BasicOptionPaneUI.this.optionPane.repaint();
        }
    }

    private static class MessageIcon
    implements Icon {
        public int getIconWidth() {
            return 36;
        }

        public int getIconHeight() {
            return 36;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        private MessageIcon() {
        }
    }
}

