/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class AiffAudioFileReader
extends TAudioFileReader {
    private static final int READ_LIMIT = 1000;

    private final void skipChunk(DataInputStream dataInputStream, int n, int n2) throws IOException {
        if ((n -= n2) > 0) {
            dataInputStream.skip(n + n % 2);
        }
    }

    private final AudioFormat readCommChunk(DataInputStream dataInputStream, int n) throws IOException, UnsupportedAudioFileException {
        int n2;
        short s = dataInputStream.readShort();
        if (s <= 0) {
            throw new UnsupportedAudioFileException("not an AIFF file: number of channels must be positive");
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("Found " + s + " channels.");
        }
        dataInputStream.readInt();
        int n3 = dataInputStream.readShort();
        float f = (float)AiffAudioFileReader.readIeeeExtended(dataInputStream);
        if ((double)f <= 0.0) {
            throw new UnsupportedAudioFileException("not an AIFF file: sample rate must be positive");
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("Found framerate " + f);
        }
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        int n4 = 18;
        if (n > n4) {
            n2 = dataInputStream.readInt();
            n4 += 4;
            if (n2 != 1313820229) {
                if (n2 == 1970037111) {
                    encoding = AudioFormat.Encoding.ULAW;
                    n3 = 8;
                } else if (n2 == 1768775988) {
                    encoding = Encodings.getEncoding("IMA_ADPCM");
                    n3 = 4;
                } else {
                    throw new UnsupportedAudioFileException("Encoding 0x" + Integer.toHexString(n2) + " of AIFF file not supported");
                }
            }
        }
        int n5 = n2 = n3 == 4 ? -1 : AiffAudioFileReader.calculateFrameSize(n3, s);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("calculated frame size: " + n2);
        }
        this.skipChunk(dataInputStream, n, n4);
        AudioFormat audioFormat = new AudioFormat(encoding, f, n3, s, n2, f, true);
        return audioFormat;
    }

    private final void readVerChunk(DataInputStream dataInputStream, int n) throws IOException, UnsupportedAudioFileException {
        if (n < 4) {
            throw new UnsupportedAudioFileException("Corrput AIFF file: FVER chunk too small.");
        }
        int n2 = dataInputStream.readInt();
        if (n2 != -1568648896) {
            throw new UnsupportedAudioFileException("Unsupported AIFF file: version not known.");
        }
        this.skipChunk(dataInputStream, n, 4);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long l) throws UnsupportedAudioFileException, IOException {
        boolean bl;
        DataInputStream dataInputStream;
        int n;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AiffAudioFileReader.getAudioFileFormat(InputStream, long): begin");
        }
        if ((n = (dataInputStream = new DataInputStream(inputStream)).readInt()) != 1179603533) {
            throw new UnsupportedAudioFileException("not an AIFF file: header magic is not FORM");
        }
        int n2 = dataInputStream.readInt();
        n = dataInputStream.readInt();
        if (n == 1095321158) {
            bl = false;
        } else if (n == 1095321155) {
            bl = true;
        } else {
            throw new UnsupportedAudioFileException("unsupported IFF file: header magic neither AIFF nor AIFC");
        }
        boolean bl2 = bl ^ true;
        boolean bl3 = false;
        boolean bl4 = false;
        AudioFormat audioFormat = null;
        int n3 = 0;
        block5: while (!(bl2 && bl3 && bl4)) {
            n = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            switch (n) {
                case 1129270605: {
                    audioFormat = this.readCommChunk(dataInputStream, n4);
                    if (TDebug.TraceAudioFileReader) {
                        TDebug.out("Read COMM chunk with length " + n4);
                    }
                    bl3 = true;
                    break;
                }
                case 1180058962: {
                    if (!bl2) {
                        this.readVerChunk(dataInputStream, n4);
                        if (TDebug.TraceAudioFileReader) {
                            TDebug.out("Read FVER chunk with length " + n4);
                        }
                        bl2 = true;
                        break;
                    }
                    this.skipChunk(dataInputStream, n4, 0);
                    break;
                }
                case 1397968452: {
                    if (!bl3 || !bl2) {
                        throw new UnsupportedAudioFileException("cannot handle AIFF file: SSND not last chunk");
                    }
                    bl4 = true;
                    n3 = n4 - 8;
                    dataInputStream.skip(8L);
                    if (!TDebug.TraceAudioFileReader) continue block5;
                    TDebug.out("Found SSND chunk with length " + n4);
                    break;
                }
                default: {
                    if (TDebug.TraceAudioFileReader) {
                        TDebug.out("Skipping unknown chunk: " + Integer.toHexString(n));
                    }
                    this.skipChunk(dataInputStream, n4, 0);
                }
            }
        }
        TAudioFileFormat tAudioFileFormat = new TAudioFileFormat(bl ? AudioFileFormat.Type.AIFC : AudioFileFormat.Type.AIFF, audioFormat, n3 / audioFormat.getFrameSize(), n2 + 8);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AiffAudioFileReader.getAudioFileFormat(InputStream, long): end");
        }
        return tAudioFileFormat;
    }

    public AiffAudioFileReader() {
        super(1000);
    }
}

