/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.lens;

import com.xerox.VTM.glyphs.Translucent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Timer;
import java.util.TimerTask;
import net.claribole.zvtm.engine.LowPassFilter;
import net.claribole.zvtm.glyphs.Translucency;
import net.claribole.zvtm.lens.TLens;
import net.claribole.zvtm.lens.TTrailingTimer;
import net.claribole.zvtm.lens.TemporalLens;

public class TFadingLens
extends TLens
implements TemporalLens {
    double frequency = -1.0;
    long mLastSampleTime = -1L;
    int xOffset = -10;
    int yOffset = 10;
    double maxDist = 2 * Math.abs(this.xOffset);
    LowPassFilter filter = new LowPassFilter();
    Point2D currentPos = new Point2D.Double(0.0, 0.0);
    Point2D parentPos = new Point2D.Double(0.0, 0.0);
    Point2D targetPos = new Point2D.Double(0.0, 0.0);
    Timer timer;
    TTrailingTimer mouseStillUpdater;
    double cutoffParamA = 0.2;
    double cutoffParamB = 0.2;
    Color bColor = Color.BLACK;
    Color rColor = Color.BLACK;
    float a = 1.0f;
    float b = 0.0f;

    public TFadingLens() {
        this.MM = 2.0f;
        this.updateMagBufferWorkingDimensions();
        this.computeOpacityFactors(0.0f, 1.0f);
        this.initTimer();
    }

    public TFadingLens(float mm) {
        this.MM = mm;
        this.updateMagBufferWorkingDimensions();
        this.computeOpacityFactors(0.0f, 1.0f);
        this.initTimer();
    }

    public TFadingLens(float mm, float minT, float maxT, int innerRadius) {
        this.MM = mm;
        this.LR2 = innerRadius;
        this.MMTf = maxT;
        this.updateMagBufferWorkingDimensions();
        this.computeOpacityFactors(minT, maxT);
        this.initTimer();
    }

    public TFadingLens(float mm, float minT, float maxT, int innerRadius, int x, int y) {
        this.MM = mm;
        this.LR2 = innerRadius;
        this.MMTf = maxT;
        this.updateMagBufferWorkingDimensions();
        this.computeOpacityFactors(minT, maxT);
        this.lx = x;
        this.ly = y;
        this.initTimer();
    }

    void computeOpacityFactors(float minT, float maxT) {
        this.a = maxT - minT;
        this.b = minT;
    }

    void initTimer() {
        this.timer = new Timer();
        this.mouseStillUpdater = new TTrailingTimer(this);
        this.timer.scheduleAtFixedRate((TimerTask)this.mouseStillUpdater, 40L, 20L);
    }

    public void setInnerRadius(int r) {
        super.setInnerRadius(r);
    }

    public void setRadii(int outerRadius, int innerRadius) {
        this.setRadii(outerRadius, innerRadius, true);
    }

    public void setRadii(int outerRadius, int innerRadius, boolean forceRaster) {
        super.setRadii(outerRadius, innerRadius, forceRaster);
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius) {
        this.setMMandRadii(mm, outerRadius, innerRadius, true);
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius, boolean forceRaster) {
        super.setMMandRadii(mm, outerRadius, innerRadius, forceRaster);
    }

    public void setMaximumMagnification(float mm) {
        this.setMaximumMagnification(mm, true);
    }

    public void setMaximumMagnification(float mm, boolean forceRaster) {
        super.setMaximumMagnification(mm, forceRaster);
    }

    public void gfT(float x, float y, float[] g) {
        this.d = Math.sqrt(Math.pow(x - (float)this.sw - (float)this.lx, 2.0) + Math.pow(y - (float)this.sh - (float)this.ly, 2.0));
        g[0] = this.d <= (double)this.LR2 ? this.MMTf : 0.0f;
    }

    public void updateFrequency() {
        this.updateFrequency(System.currentTimeMillis());
    }

    public void updateFrequency(long currentTime) {
        if (this.frequency == -1.0) {
            this.frequency = 1.0;
        } else if (currentTime != this.mLastSampleTime) {
            this.frequency = 1000.0 / (double)(currentTime - this.mLastSampleTime);
        }
        this.mLastSampleTime = currentTime;
    }

    public void updateTimeBasedParams(int cx, int cy) {
        this.parentPos.setLocation(cx, cy);
        this.updateTimeBasedParams();
    }

    public void updateTimeBasedParams() {
        this.targetPos.setLocation(this.parentPos.getX() + (double)this.xOffset, this.parentPos.getY() + (double)this.yOffset);
        double distAway = this.targetPos.distance(this.currentPos);
        double opacity = 1.0 - Math.min(1.0, distAway / this.maxDist);
        this.filter.setCutOffFrequency((1.0 - opacity) * this.cutoffParamA + this.cutoffParamB);
        this.currentPos = this.filter.apply(this.targetPos, this.frequency);
        int tx = (int)Math.round(this.currentPos.getX());
        int ty = (int)Math.round(this.currentPos.getY());
        tx = Math.max(tx, this.w / 2);
        ty = Math.min(ty, this.owningView.parent.getPanelSize().height - this.h / 2);
        float nMMTf = (float)opacity * this.a + this.b;
        if (Math.abs(this.MMTf - nMMTf) > 0.01f) {
            this.MMTf = nMMTf;
            this.owningView.parent.repaintNow();
        }
    }

    public void setCutoffFrequencyParameters(double a, double b) {
        this.cutoffParamA = a;
        this.cutoffParamB = b;
    }

    public void setNoUpdateWhenMouseStill(boolean b) {
        this.mouseStillUpdater.setEnabled(!b);
    }

    public void dispose() {
        super.dispose();
        this.timer.cancel();
    }

    public synchronized void setAbsolutePosition(int ax, int ay, long absTime) {
        super.setAbsolutePosition(ax, ay);
        this.updateFrequency(absTime);
        this.updateTimeBasedParams(ax, ay);
    }

    public int getRadius() {
        return this.LR2;
    }

    public void setBoundaryColor(Color bc) {
        this.bColor = bc;
    }

    public void setObservedRegionColor(Color bc) {
        this.rColor = bc;
    }

    public void drawBoundary(Graphics2D g2d) {
        if (this.bColor != null) {
            g2d.setColor(this.bColor);
            g2d.drawOval(this.lx + this.w / 2 - this.lensWidth / 2, this.ly + this.h / 2 - this.lensHeight / 2, this.lensWidth, this.lensHeight);
        }
        if (this.rColor != null) {
            this.lensProjectedWidth = Math.round((float)this.lensWidth / this.MM);
            this.lensProjectedHeight = Math.round((float)this.lensHeight / this.MM);
            g2d.setColor(this.rColor);
            g2d.setComposite(Translucency.acs[Math.round((1.0f - this.MMTf) * 20.0f) - 1]);
            g2d.drawOval(this.lx + this.w / 2 - this.lensProjectedWidth / 2, this.ly + this.h / 2 - this.lensProjectedHeight / 2, this.lensProjectedWidth, this.lensProjectedHeight);
            g2d.setComposite(Translucent.acO);
        }
    }
}

