/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
var __decorate=function(e,t,o,r){var i,n=arguments.length,s=n<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,o):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,o,r);else for(var a=e.length-1;a>=0;a--)(i=e[a])&&(s=(n<3?i(s):n>3?i(t,o,s):i(t,o))||s);return n>3&&s&&Object.defineProperty(t,o,s),s};import{html,LitElement}from"lit";import{customElement,query}from"lit/decorators.js";import"@typo3/backend/element/icon-element.js";import{SeverityEnum}from"@typo3/backend/enum/severity.js";import"@typo3/backend/tree/tree-toolbar.js";import{TreeNodePositionEnum}from"@typo3/backend/tree/tree-node.js";import{FileStorageTree}from"@typo3/backend/tree/file-storage-tree.js";import ContextMenu from"@typo3/backend/context-menu.js";import Notification from"@typo3/backend/notification.js";import{ModuleStateStorage}from"@typo3/backend/storage/module-state-storage.js";import{ModuleUtility}from"@typo3/backend/module.js";import{FileListDragDropEvent}from"@typo3/filelist/file-list-dragdrop.js";import{Resource}from"@typo3/backend/resource/resource.js";import{DataTransferTypes}from"@typo3/backend/enum/data-transfer-types.js";export const navigationComponentName="typo3-backend-navigation-component-filestoragetree";let EditableFileStorageTree=class extends FileStorageTree{constructor(){super(...arguments),this.allowNodeDrag=!0}handleNodeMove(e,t,o){if(!this.isDropAllowed(t,e))return;const r=this.getDropCommandDetails(t,e,o);if(null===r)return;const i=FileOperationCollection.fromNodePositionOptions(r),n=i.getConflictingOperationsForTreeNode(r.target);n.length>0?n.forEach((e=>{Notification.showMessage(TYPO3.lang["drop.conflict"],TYPO3.lang["mess.drop.conflict"].replace("%s",e.resource.name).replace("%s",decodeURIComponent(r.target.identifier)),SeverityEnum.error)})):this.initiateDropAction(i)}createDataTransferItemsFromNode(e){return[{type:DataTransferTypes.treenode,data:this.getNodeTreeIdentifier(e)},{type:DataTransferTypes.falResources,data:JSON.stringify([FileResource.fromTreeNode(e)])}]}handleNodeDragOver(e){if(super.handleNodeDragOver(e))return!0;if(e.dataTransfer.types.includes(DataTransferTypes.falResources)){const t=this.getNodeFromDragEvent(e);if(null===t)return!1;this.cleanDrag();return this.getElementFromNode(t).classList.add("node-hover"),t.hasChildren&&!t.__expanded?this.openNodeTimeout.targetNode!=t&&(this.openNodeTimeout.targetNode=t,clearTimeout(this.openNodeTimeout.timeout),this.openNodeTimeout.timeout=setTimeout((()=>{this.showChildren(this.openNodeTimeout.targetNode),this.openNodeTimeout.targetNode=null,this.openNodeTimeout.timeout=null}),1e3)):(clearTimeout(this.openNodeTimeout.timeout),this.openNodeTimeout.targetNode=null,this.openNodeTimeout.timeout=null),e.preventDefault(),!0}return!1}getTooltipDescription(e){return decodeURIComponent(e.identifier)}handleNodeDrop(e){if(super.handleNodeDrop(e))return!0;if(e.dataTransfer.types.includes(DataTransferTypes.falResources)){const t=this.getNodeFromDragEvent(e);if(null===t)return!1;if(t){const o=FileResource.fromTreeNode(t),r=FileOperationCollection.fromDataTransfer(e.dataTransfer,o),i=r.getConflictingOperationsForTreeNode(t);return i.length>0?(i.forEach((e=>{Notification.showMessage(TYPO3.lang["drop.conflict"],TYPO3.lang["mess.drop.conflict"].replace("%s",e.resource.name).replace("%s",decodeURIComponent(t.identifier)),SeverityEnum.error)})),!1):(e.preventDefault(),this.initiateDropAction(r),!0)}}return!1}getDropCommandDetails(e,t,o){const r=this.nodes,i=t.identifier;let n=e;if(i===n.identifier)return null;if(o===TreeNodePositionEnum.BEFORE){const t=r.indexOf(e),i=this.setNodePositionAndTarget(t);if(null===i)return null;o=i.position,n=i.target}return{node:t,identifier:i,target:n,position:o}}setNodePositionAndTarget(e){const t=this.nodes,o=t[e].depth;e>0&&e--;const r=t[e].depth,i=this.nodes[e];if(r===o)return{position:TreeNodePositionEnum.AFTER,target:i};if(r<o)return{position:TreeNodePositionEnum.INSIDE,target:i};for(let r=e;r>=0;r--){if(t[r].depth===o)return{position:TreeNodePositionEnum.AFTER,target:this.nodes[r]};if(t[r].depth<o)return{position:TreeNodePositionEnum.AFTER,target:t[r]}}return null}isDropAllowed(e,t){return e!==t&&!!this.isOverRoot}initiateDropAction(e){const t={action:"transfer",resources:e.getResources(),target:e.target};top.document.dispatchEvent(new CustomEvent(FileListDragDropEvent.transfer,{detail:t}))}};EditableFileStorageTree=__decorate([customElement("typo3-backend-navigation-component-filestorage-tree")],EditableFileStorageTree);export{EditableFileStorageTree};let FileStorageTreeNavigationComponent=class extends LitElement{constructor(){super(...arguments),this.refresh=()=>{this.tree.refreshOrFilterTree()},this.selectFirstNode=()=>{const e=this.tree.nodes[0];e&&this.tree.selectNode(e,!0)},this.treeUpdateRequested=e=>{const t=encodeURIComponent(e.detail.payload.identifier),o=this.tree.nodes.filter((e=>e.identifier===t))[0];o&&0===this.tree.getSelectedNodes().filter((e=>e.identifier===o.identifier)).length&&this.tree.selectNode(o,!1)},this.loadContent=e=>{const t=e.detail.node;if(!t?.checked)return;if(ModuleStateStorage.update("media",t.identifier,!0),!1===e.detail.propagate)return;const o=top.TYPO3.ModuleMenu.App;let r=ModuleUtility.getFromName(o.getCurrentModule()).link;r+=r.includes("?")?"&":"?",top.TYPO3.Backend.ContentContainer.setUrl(r+"id="+t.identifier)},this.showContextMenu=e=>{const t=e.detail.node;t&&ContextMenu.show(t.recordType,decodeURIComponent(t.identifier),"tree","","",this.tree.getElementFromNode(t),e.detail.originalEvent)},this.selectActiveNode=e=>{const t=ModuleStateStorage.current("file").selection,o=e.detail.nodes;e.detail.nodes=o.map((e=>(e.identifier===t&&(e.checked=!0),e)))}}connectedCallback(){super.connectedCallback(),document.addEventListener("typo3:filestoragetree:refresh",this.refresh),document.addEventListener("typo3:filestoragetree:selectFirstNode",this.selectFirstNode),document.addEventListener("typo3:filelist:treeUpdateRequested",this.treeUpdateRequested)}disconnectedCallback(){document.removeEventListener("typo3:filestoragetree:refresh",this.refresh),document.removeEventListener("typo3:filestoragetree:selectFirstNode",this.selectFirstNode),document.removeEventListener("typo3:filelist:treeUpdateRequested",this.treeUpdateRequested),super.disconnectedCallback()}createRenderRoot(){return this}render(){const e={dataUrl:top.TYPO3.settings.ajaxUrls.filestorage_tree_data,filterUrl:top.TYPO3.settings.ajaxUrls.filestorage_tree_filter,showIcons:!0};return html`
      <div id="typo3-filestoragetree" class="tree">
        <typo3-backend-tree-toolbar .tree="${this.tree}" id="filestoragetree-toolbar"></typo3-backend-tree-toolbar>
        <div class="navigation-tree-container">
          <typo3-backend-navigation-component-filestorage-tree id="typo3-filestoragetree-tree" class="tree-wrapper" .setup=${e}></typo3-backend-navigation-component-filestorage-tree>
        </div>
      </div>
    `}firstUpdated(){this.toolbar.tree=this.tree,this.tree.addEventListener("typo3:tree:node-selected",this.loadContent),this.tree.addEventListener("typo3:tree:node-context",this.showContextMenu),this.tree.addEventListener("typo3:tree:nodes-prepared",this.selectActiveNode)}};__decorate([query(".tree-wrapper")],FileStorageTreeNavigationComponent.prototype,"tree",void 0),__decorate([query("typo3-backend-tree-toolbar")],FileStorageTreeNavigationComponent.prototype,"toolbar",void 0),FileStorageTreeNavigationComponent=__decorate([customElement("typo3-backend-navigation-component-filestoragetree")],FileStorageTreeNavigationComponent);export{FileStorageTreeNavigationComponent};class FileOperation{constructor(e,t=TreeNodePositionEnum.INSIDE){this.resource=e,this.position=t}hasConflictWithTreeNode(e){return"folder"===this.resource.type&&(e.identifier===this.resource.identifier||e.__parents[0]==this.resource.identifier||e.__parents.includes(this.resource.identifier))}}class FileResource extends Resource{static fromTreeNode(e){return new FileResource(decodeURIComponent(e.resourceType),decodeURIComponent(e.identifier),decodeURIComponent(e.name))}}class FileOperationCollection{constructor(e,t){this.operations=e,this.target=t}static fromDataTransfer(e,t){return FileOperationCollection.fromArray(JSON.parse(e.getData(DataTransferTypes.falResources)),t)}static fromArray(e,t){const o=[];for(const t of e)o.push(new FileOperation(t,TreeNodePositionEnum.INSIDE));return new FileOperationCollection(o,t)}static fromNodePositionOptions(e){const t=FileResource.fromTreeNode(e.node),o=FileResource.fromTreeNode(e.target),r=[new FileOperation(t,e.position)];return new FileOperationCollection(r,o)}getConflictingOperationsForTreeNode(e){return this.operations.filter((t=>t.hasConflictWithTreeNode(e)))}getResources(){const e=[];return this.operations.forEach((t=>{e.push(t.resource)})),e}}