/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.io.Serializable;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TreePath
implements Serializable {
    static final long serialVersionUID = 4380036194768077479L;
    private Object[] path;

    public int hashCode() {
        return this.getLastPathComponent().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof TreePath) {
            Object[] treepath = ((TreePath)object).getPath();
            if (treepath.length != this.path.length) {
                return false;
            }
            int index = 0;
            while (index < this.path.length) {
                if (!treepath[index].equals(this.path[index])) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.path.length == 1) {
            return String.valueOf(this.path[0]);
        }
        return Arrays.asList(this.path).toString();
    }

    public Object[] getPath() {
        return (Object[])this.path.clone();
    }

    public Object getLastPathComponent() {
        return this.path[this.path.length - 1];
    }

    public int getPathCount() {
        return this.path.length;
    }

    public Object getPathComponent(int position) {
        if (position < 0 || position >= this.getPathCount()) {
            throw new IllegalArgumentException("Invalid position: " + position);
        }
        return this.path[position];
    }

    public boolean isDescendant(TreePath path) {
        if (path == null) {
            return false;
        }
        int count = this.getPathCount();
        if (path.getPathCount() < count) {
            return false;
        }
        int i = 0;
        while (i < count) {
            if (!this.path[i].equals(path.getPathComponent(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public TreePath pathByAddingChild(Object element) {
        return new TreePath(this, element);
    }

    public TreePath getParentPath() {
        if (this.path.length <= 1) {
            return null;
        }
        return new TreePath(this.getPath(), this.path.length - 1);
    }

    private final /* synthetic */ void this() {
        this.path = null;
    }

    public TreePath(Object[] path) {
        this.this();
        if (path == null) {
            throw new IllegalArgumentException("Null 'path' not permitted.");
        }
        this.path = new Object[path.length];
        System.arraycopy(path, 0, this.path, 0, path.length);
    }

    public TreePath(Object element) {
        this.this();
        this.path = new Object[1];
        this.path[0] = element;
    }

    protected TreePath(TreePath path, Object element) {
        this.this();
        if (element == null) {
            throw new NullPointerException("Null 'element' argument.");
        }
        Object[] treepath = path.getPath();
        this.path = new Object[treepath.length + 1];
        System.arraycopy(treepath, 0, this.path, 0, treepath.length);
        this.path[treepath.length] = element;
    }

    protected TreePath(Object[] path, int length) {
        this.this();
        this.path = new Object[length];
        System.arraycopy(path, 0, this.path, 0, length);
    }

    protected TreePath() {
        this.this();
        this.path = new Object[0];
    }
}

