/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEditSupport;
import net.bluecow.spectro.AudioFileUtils;
import net.bluecow.spectro.ClipDataChangeEvent;
import net.bluecow.spectro.ClipDataChangeListener;
import net.bluecow.spectro.ClipDataEdit;
import net.bluecow.spectro.Frame;
import net.bluecow.spectro.OverlapBuffer;
import net.bluecow.spectro.VorbisWindowFunction;

public class Clip {
    private static final Logger logger = Logger.getLogger(Clip.class.getName());
    private static final AudioFormat AUDIO_FORMAT = new AudioFormat(44100.0f, 16, 1, true, true);
    private final List<Frame> frames = new ArrayList<Frame>();
    private int frameSize = 1024;
    private int overlap = 2;
    private double spectralScale = 10000.0;
    private ClipDataEdit currentEdit;
    private final UndoableEditSupport undoEventSupport = new UndoableEditSupport();
    private final List<ClipDataChangeListener> clipDataChangeListeners = new ArrayList<ClipDataChangeListener>();

    public Clip(File file) throws UnsupportedAudioFileException, IOException {
        int n;
        VorbisWindowFunction windowFunc = new VorbisWindowFunction(this.frameSize);
        AudioFormat desiredFormat = AUDIO_FORMAT;
        BufferedInputStream in = new BufferedInputStream(AudioFileUtils.readAsMono(desiredFormat, file));
        byte[] buf = new byte[this.frameSize * 2];
        in.mark(buf.length * 2);
        while ((n = this.readFully(in, buf)) != -1) {
            logger.finest("Read " + n + " bytes");
            if (n != buf.length) {
                logger.warning("Only read " + n + " of " + buf.length + " bytes at frame " + this.frames.size());
                for (int i = n; i < buf.length; ++i) {
                    buf[i] = 0;
                }
            }
            double[] samples = new double[this.frameSize];
            for (int i = 0; i < this.frameSize; ++i) {
                byte hi = buf[2 * i];
                int low = buf[2 * i + 1] & 0xFF;
                int sampVal = hi << 8 | low;
                samples[i] = (double)sampVal / this.spectralScale;
            }
            this.frames.add(new Frame(samples, windowFunc));
            in.reset();
            long bytesToSkip = this.frameSize * 2 / this.overlap;
            long bytesSkipped = in.skip(bytesToSkip);
            if (bytesSkipped != bytesToSkip) {
                logger.info("Skipped " + bytesSkipped + " bytes, but wanted " + bytesToSkip + " at frame " + this.frames.size());
            }
            in.mark(buf.length * 2);
        }
        logger.info(String.format("Read %d frames from %s (%d bytes). frameSize=%d overlap=%d\n", this.frames.size(), file.getAbsolutePath(), this.frames.size() * buf.length, this.frameSize, this.overlap));
    }

    private int readFully(InputStream in, byte[] buf) throws IOException {
        int offset;
        int length = buf.length;
        int bytesRead = 0;
        for (offset = 0; offset < buf.length && (bytesRead = in.read(buf, offset, length)) != -1; offset += bytesRead) {
            logger.finest("read " + bytesRead + " bytes at offset " + offset);
            length -= bytesRead;
        }
        if (offset > 0) {
            logger.fine("Returning " + offset + " bytes read into buf");
            return offset;
        }
        logger.fine("Returning EOF");
        return -1;
    }

    public int getFrameTimeSamples() {
        return this.frameSize;
    }

    public int getFrameFreqSamples() {
        return this.frameSize;
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public Frame getFrame(int i) {
        return this.frames.get(i);
    }

    public AudioInputStream getAudio() {
        return this.getAudio(0);
    }

    public AudioInputStream getAudio(int sample) {
        final int initialFrame = sample / this.getFrameTimeSamples();
        InputStream audioData = new InputStream(){
            int nextFrame;
            OverlapBuffer overlapBuffer;
            int currentSample;
            boolean currentByteHigh;
            int emptyFrameCount;
            {
                this.nextFrame = initialFrame;
                this.overlapBuffer = new OverlapBuffer(Clip.this.frameSize, Clip.this.overlap);
                this.currentByteHigh = true;
                this.emptyFrameCount = 0;
            }

            public int available() throws IOException {
                return Integer.MAX_VALUE;
            }

            public int read() throws IOException {
                if (this.overlapBuffer.needsNewFrame()) {
                    if (this.nextFrame < Clip.this.frames.size()) {
                        Frame f = (Frame)Clip.this.frames.get(this.nextFrame++);
                        this.overlapBuffer.addFrame(f.asTimeData());
                    } else {
                        this.overlapBuffer.addEmptyFrame();
                        ++this.emptyFrameCount;
                    }
                }
                if (this.emptyFrameCount >= Clip.this.overlap) {
                    return -1;
                }
                if (this.currentByteHigh) {
                    this.currentSample = (int)(this.overlapBuffer.next() * Clip.this.spectralScale);
                    this.currentByteHigh = false;
                    return this.currentSample >> 8 & 0xFF;
                }
                this.currentByteHigh = true;
                return this.currentSample & 0xFF;
            }
        };
        int length = this.getFrameCount() * this.getFrameTimeSamples() * (AUDIO_FORMAT.getSampleSizeInBits() / 8) / this.overlap;
        return new AudioInputStream(audioData, AUDIO_FORMAT, length);
    }

    public void beginEdit(Rectangle region, String description) {
        if (this.currentEdit != null) {
            throw new IllegalStateException("Already in an edit: " + this.currentEdit);
        }
        this.currentEdit = new ClipDataEdit(this, region.x, region.y, region.width, region.height);
    }

    public void endEdit() {
        if (this.currentEdit == null) {
            throw new IllegalStateException("No edit is in progress");
        }
        this.currentEdit.captureNewData();
        this.undoEventSupport.postEdit(this.currentEdit);
        this.regionChanged(this.currentEdit.getRegion());
        this.currentEdit = null;
    }

    public void beginCompoundEdit(String presentationName) {
        this.undoEventSupport.beginUpdate();
    }

    public void endCompoundEdit() {
        this.undoEventSupport.endUpdate();
    }

    public void regionChanged(Rectangle region) {
        this.fireClipDataChangeEvent(region);
    }

    public void addClipDataChangeListener(ClipDataChangeListener l) {
        this.clipDataChangeListeners.add(l);
    }

    public void removeClipDataChangeListener(ClipDataChangeListener l) {
        this.clipDataChangeListeners.remove(l);
    }

    private void fireClipDataChangeEvent(Rectangle region) {
        ClipDataChangeEvent e = new ClipDataChangeEvent(this, region);
        for (int i = this.clipDataChangeListeners.size() - 1; i >= 0; --i) {
            this.clipDataChangeListeners.get(i).clipDataChanged(e);
        }
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this.undoEventSupport.addUndoableEditListener(l);
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        return this.undoEventSupport.getUndoableEditListeners();
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this.undoEventSupport.removeUndoableEditListener(l);
    }

    public double getSamplingRate() {
        return AUDIO_FORMAT.getSampleRate();
    }
}

