#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
author: Francisco Munoz (@fmunoz)
description:
  - Manage operation delete of the resource networks _wireless _air _marshal _rules
    _delete.
  - Delete an Air Marshal rule.
extends_documentation_fragment:
  - cisco.meraki.module
module: networks_wireless_air_marshal_rules_delete
notes:
  - SDK Method used are wireless.Wireless.delete_network_wireless_air_marshal_rule,
  - Paths used are delete /networks/{networkId}/wireless/airMarshal/rules/{ruleId},
options:
  networkId:
    description: NetworkId path parameter. Network ID.
    type: str
  ruleId:
    description: RuleId path parameter. Rule ID.
    type: str
requirements:
  - meraki >= 2.4.9
  - python >= 3.5
seealso:
  - description: Complete reference of the deleteNetworkWirelessAirMarshalRule API.
    link: https://developer.cisco.com/meraki/api-v1/#!delete-network-wireless-air-marshal-rule
    name: Cisco Meraki documentation for wireless deleteNetworkWirelessAirMarshalRule
short_description: Resource module for networks _wireless _air _marshal _rules _delete
version_added: 2.20.0
"""

EXAMPLES = r"""
- name: Delete by id
  cisco.meraki.networks_wireless_air_marshal_rules_delete:
    meraki_api_key: '{{ meraki_api_key }}'
    meraki_base_url: '{{ meraki_base_url }}'
    meraki_single_request_timeout: '{{ meraki_single_request_timeout }}'
    meraki_certificate_path: '{{ meraki_certificate_path }}'
    meraki_requests_proxy: '{{ meraki_requests_proxy }}'
    meraki_wait_on_rate_limit: '{{ meraki_wait_on_rate_limit }}'
    meraki_nginx_429_retry_wait_time: '{{ meraki_nginx_429_retry_wait_time }}'
    meraki_action_batch_retry_wait_time: '{{ meraki_action_batch_retry_wait_time }}'
    meraki_retry_4xx_error: '{{ meraki_retry_4xx_error }}'
    meraki_retry_4xx_error_wait_time: '{{ meraki_retry_4xx_error_wait_time }}'
    meraki_maximum_retries: '{{ meraki_maximum_retries }}'
    meraki_output_log: '{{ meraki_output_log }}'
    meraki_log_file_prefix: '{{ meraki_log_file_prefix }}'
    meraki_log_path: '{{ meraki_log_path }}'
    meraki_print_console: '{{ meraki_print_console }}'
    meraki_suppress_logging: '{{ meraki_suppress_logging }}'
    meraki_simulate: '{{ meraki_simulate }}'
    meraki_be_geo_id: '{{ meraki_be_geo_id }}'
    meraki_use_iterator_for_get_pages: '{{ meraki_use_iterator_for_get_pages }}'
    meraki_inherit_logging_config: '{{ meraki_inherit_logging_config }}'
    networkId: string
    ruleId: string
"""
RETURN = r"""
meraki_response:
  description: A dictionary or list with the response returned by the Cisco Meraki Python SDK
  returned: always
  type: dict
  sample: >
    {}
"""
