/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.gogui.gui.SimpleDialogs;
import net.sf.gogui.thumbnail.Thumbnail;

class SgfPreview
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 0L;
    private File m_file;
    private JButton m_preview;
    private JCheckBox m_auto;
    private JLabel m_description;
    private Image m_image;
    private ImagePanel m_imagePanel;
    private Thumbnail m_thumbnail = new Thumbnail(false);

    public SgfPreview() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalGlue());
        Dimension dimension = new Dimension(138, 234);
        jPanel.setPreferredSize(dimension);
        this.add(jPanel);
        this.m_imagePanel = new ImagePanel();
        jPanel.add(this.m_imagePanel);
        this.m_description = new JLabel(" ");
        this.m_description.setAlignmentX(0.5f);
        jPanel.add(this.m_description);
        jPanel.add(Box.createVerticalGlue());
        JPanel jPanel2 = new JPanel();
        this.add((Component)jPanel2, "South");
        this.m_auto = new JCheckBox("Automatic preview");
        jPanel2.add(this.m_auto);
        this.m_preview = new JButton("Preview");
        this.m_preview.setActionCommand("preview");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("preview")) {
                    SgfPreview.this.preview();
                }
            }
        };
        this.m_preview.addActionListener(actionListener);
        this.m_preview.setEnabled(false);
        jPanel2.add(this.m_preview);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("SelectedFileChangedProperty")) {
            String string2;
            this.m_file = null;
            this.m_preview.setEnabled(false);
            File file = (File)propertyChangeEvent.getNewValue();
            if (!(file == null || (string2 = file.getAbsolutePath()) != null && string2.toLowerCase().endsWith(".sgf"))) {
                file = null;
            }
            if (file != null) {
                this.m_file = file;
                this.m_preview.setEnabled(true);
                if (this.m_auto.isSelected()) {
                    this.preview();
                }
            }
        }
    }

    public void preview() {
        Object object;
        if (this.m_file == null) {
            return;
        }
        this.m_thumbnail.create(this.m_file);
        File file = this.m_thumbnail.getLastThumbnail();
        if (file != null) {
            object = new ImageIcon(file.toString());
            this.m_image = ((ImageIcon)object).getImage();
        } else {
            SimpleDialogs.showError(this, "Preview generation failed:\n" + this.m_thumbnail.getLastError());
            this.m_image = null;
        }
        object = this.m_thumbnail.getLastDescription();
        if (!((String)object).equals("")) {
            this.m_description.setText((String)object);
        } else {
            this.m_description.setText("");
        }
        this.m_imagePanel.repaint();
        this.m_preview.setEnabled(false);
    }

    private class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 0L;

        public ImagePanel() {
            Dimension dimension = new Dimension(138, 138);
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (SgfPreview.this.m_image != null) {
                int n = SgfPreview.this.m_image.getWidth(null);
                int n2 = SgfPreview.this.m_image.getHeight(null);
                int n3 = (this.getWidth() - n) / 2;
                int n4 = (this.getHeight() - n2) / 2;
                graphics.drawImage(SgfPreview.this.m_image, n3, n4, n, n2, null);
            }
        }
    }
}

