# Schema Generation

These files handle the generation of JSON schema's for inspec output as yielded by `inspec schema <schema-name>`.
This schema is in the JSON Schema 4th revision spec.

## Structure
Data/schema structures shared between all outputs are located in `primitives.rb`
The files `exec_json_min.rb`, `exec_json.rb`, and `profile_json.rb` contain JSON structures for their specific output types, respectively.
The output schema is "flat" in terms of schema structure, with each "type" defined in the JSONs `definitions` block and referred to via $ref.
The logic for this is handled via the `SchemaType` class in `primitives.rb`.
All relevant dependencies are included recursively via the `dependencies` property of that class, constructed using the `build_definitions` method in `output_schema.rb`.

## Reasoning and validation
In general the first iteration of this updated schema was made by examining the output of all of the profiles in the tests directory. 
All of the profiles generated by those tests successfully validate against this schema.
However, in light of potential missed properties that aren't covered by existing tests, the schema was left very non-strict.
More specifically, "additionalProperties" was left as True on all schema objects.
