require 'webunit/webunit'

class TestDigitView < WebUnit::TestCase

  def setup
    super
    @url = "webunit/sample/conv/digit-1.cgi"
  end

  def test_initial

    response = Response::get( @url )
    assert_title( 'Digit - WebUnit Sample -', response )

    assert_equals( 1, response.forms.size )
    assert_equals( 1, response.tables.size )

    form = response.form
    assert_urls( @url, form.action )
    assert_equals( 'post', form.method )

    parameters = form.parameters #=> array
    assert_equals( 6, parameters.size )
    i = -1

    assert_input( 'toct', 'text', '0', parameters[i+=1] )
    assert_input( 'tdec', 'text', '0', parameters[i+=1] )
    assert_input( 'thex', 'text', '0x0', parameters[i+=1] )
    assert_input( 'boct', 'submit', '8=&gt;', parameters[i+=1] )
    assert_input( 'bdec', 'submit', '10=&gt;', parameters[i+=1] )
    assert_input( 'bhex', 'submit', '16=&gt;', parameters[i+=1] )

    table = response.table
    params = form.params #=> hash
    c = 0

    assert_include( params['toct'], table.at(1,c+=1) )
    assert_include( params['boct'], table.at(2,c) )
    assert_equals( 'center', table.at(2,c).attrs['align'] )

    assert_include( params['tdec'], table.at(1,c+=1) )
    assert_include( params['bdec'], table.at(2,c) )
    assert_equals( 'center', table.at(2,c).attrs['align'] )

    assert_include( params['thex'], table.at(1,c+=1) )
    assert_include( params['bhex'], table.at(2,c) )
    assert_equals( 'center', table.at(2,c).attrs['align'] )

  end

  def test_8_to

    response = Response::get( @url )
    assert_title( 'Digit - WebUnit Sample -', response )

    form = response.form
    params = form.params

    params['toct'].value = '017'
    response = form.submit( 'boct' )

    params = response.form.params
    assert_equals( '15', params['tdec'].value )
    assert_equals( '0xF', params['thex'].value )

  end

  def test_10_to

    response = Response::get( @url )
    assert_title( 'Digit - WebUnit Sample -', response )

    form = response.form
    params = form.params

    params['tdec'].value = '10'
    response = form.submit( 'bdec' )

    params = response.form.params
    assert_equals( '012', params['toct'].value )
    assert_equals( '0xA', params['thex'].value )

  end

  def test_16_to

    response = Response::get( @url )
    assert_title( 'Digit - WebUnit Sample -', response )

    form = response.form
    params = form.params

    params['thex'].value = '0x1A'
    response = form.submit( 'bhex' )

    params = response.form.params
    assert_equals( '032', params['toct'].value )
    assert_equals( '26', params['tdec'].value )

  end

end
