/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DoubleDST_1D {
    private int n;
    private DoubleDCT_1D dct;

    public DoubleDST_1D(int n) {
        this.n = n;
        this.dct = new DoubleDCT_1D(n);
    }

    public DoubleDST_1D(int n, int[] nArray, double[] dArray) {
        this.n = n;
        this.dct = new DoubleDCT_1D(n, nArray, dArray);
    }

    public void forward(double[] dArray, boolean bl) {
        this.forward(dArray, 0, bl);
    }

    public void forward(final double[] dArray, final int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        if (this.n == 1) {
            return;
        }
        int n5 = ConcurrencyUtils.getNumberOfProcessors();
        if (n5 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n6;
            n4 = this.n / n5;
            Future[] futureArray = new Future[n5];
            for (n6 = 0; n6 < n5; ++n6) {
                n3 = n + n6 * n4 + 1;
                n2 = n6 == n5 - 1 ? this.n : n3 + n4;
                futureArray[n6] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                    public void run() {
                        if (DoubleDST_1D.this.n >= 4) {
                            for (int i = n3; i < n2; i += 4) {
                                dArray[i] = -dArray[i];
                                dArray[i + 2] = -dArray[i + 2];
                            }
                        } else {
                            for (int i = n3; i < n2; i += 2) {
                                dArray[i] = -dArray[i];
                            }
                        }
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    futureArray[n6].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = 1 + n;
            int n7 = n + this.n;
            if (this.n >= 4) {
                for (int i = n4; i < n7; i += 4) {
                    dArray[i] = -dArray[i];
                    dArray[i + 2] = -dArray[i + 2];
                }
            } else {
                for (int i = n4; i < n7; i += 2) {
                    dArray[i] = -dArray[i];
                }
            }
        }
        this.dct.forward(dArray, n, bl);
        if (n5 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n8;
            n4 = this.n / 2 / n5;
            Future[] futureArray = new Future[n5];
            for (n8 = 0; n8 < n5; ++n8) {
                n3 = n + n8 * n4;
                n2 = n8 == n5 - 1 ? this.n / 2 : n3 + n4;
                futureArray[n8] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                    public void run() {
                        int n4 = n + DoubleDST_1D.this.n - 1;
                        if (DoubleDST_1D.this.n / 2 >= 4) {
                            for (int i = n3; i < n2; i += 4) {
                                double d = dArray[i];
                                int n22 = n4 - i;
                                dArray[i] = dArray[n22];
                                dArray[n22] = d;
                                d = dArray[i + 1];
                                n22 = n4 - i - 1;
                                dArray[i + 1] = dArray[n22];
                                dArray[n22] = d;
                                d = dArray[i + 2];
                                n22 = n4 - i - 2;
                                dArray[i + 2] = dArray[n22];
                                dArray[n22] = d;
                                d = dArray[i + 3];
                                n22 = n4 - i - 3;
                                dArray[i + 3] = dArray[n22];
                                dArray[n22] = d;
                            }
                        } else {
                            for (int i = n3; i < n2; ++i) {
                                double d = dArray[i];
                                int n32 = n4 - i;
                                dArray[i] = dArray[n32];
                                dArray[n32] = d;
                            }
                        }
                    }
                });
            }
            try {
                for (n8 = 0; n8 < n5; ++n8) {
                    futureArray[n8].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = n + this.n - 1;
            if (this.n / 2 >= 4) {
                for (int i = 0; i < this.n / 2; i += 4) {
                    double d = dArray[n + i];
                    dArray[n + i] = dArray[n4 - i];
                    dArray[n4 - i] = d;
                    d = dArray[n + i + 1];
                    dArray[n + i + 1] = dArray[n4 - i - 1];
                    dArray[n4 - i - 1] = d;
                    d = dArray[n + i + 2];
                    dArray[n + i + 2] = dArray[n4 - i - 2];
                    dArray[n4 - i - 2] = d;
                    d = dArray[n + i + 3];
                    dArray[n + i + 3] = dArray[n4 - i - 3];
                    dArray[n4 - i - 3] = d;
                }
            } else {
                for (int i = 0; i < this.n / 2; ++i) {
                    double d = dArray[n + i];
                    dArray[n + i] = dArray[n4 - i];
                    dArray[n4 - i] = d;
                }
            }
        }
    }

    public void inverse(double[] dArray, boolean bl) {
        this.inverse(dArray, 0, bl);
    }

    public void inverse(final double[] dArray, final int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        if (this.n == 1) {
            return;
        }
        int n5 = ConcurrencyUtils.getNumberOfProcessors();
        if (n5 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n6;
            n4 = this.n / 2 / n5;
            Future[] futureArray = new Future[n5];
            for (n6 = 0; n6 < n5; ++n6) {
                n3 = n + n6 * n4;
                n2 = n6 == n5 - 1 ? this.n / 2 : n3 + n4;
                futureArray[n6] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                    public void run() {
                        int n4 = n + DoubleDST_1D.this.n - 1;
                        if (DoubleDST_1D.this.n / 2 >= 4) {
                            for (int i = n3; i < n2; i += 4) {
                                double d = dArray[i];
                                int n22 = n4 - i;
                                dArray[i] = dArray[n22];
                                dArray[n22] = d;
                                d = dArray[i + 1];
                                n22 = n4 - i - 1;
                                dArray[i + 1] = dArray[n22];
                                dArray[n22] = d;
                                d = dArray[i + 2];
                                n22 = n4 - i - 2;
                                dArray[i + 2] = dArray[n22];
                                dArray[n22] = d;
                                d = dArray[i + 3];
                                n22 = n4 - i - 3;
                                dArray[i + 3] = dArray[n22];
                                dArray[n22] = d;
                            }
                        } else {
                            for (int i = n3; i < n2; ++i) {
                                double d = dArray[i];
                                int n32 = n4 - i;
                                dArray[i] = dArray[n32];
                                dArray[n32] = d;
                            }
                        }
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    futureArray[n6].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            double d;
            n4 = n + this.n - 1;
            if (this.n / 2 >= 4) {
                for (int i = 0; i < this.n / 2; i += 4) {
                    d = dArray[n + i];
                    dArray[n + i] = dArray[n4 - i];
                    dArray[n4 - i] = d;
                    d = dArray[n + i + 1];
                    dArray[n + i + 1] = dArray[n4 - i - 1];
                    dArray[n4 - i - 1] = d;
                    d = dArray[n + i + 2];
                    dArray[n + i + 2] = dArray[n4 - i - 2];
                    dArray[n4 - i - 2] = d;
                    d = dArray[n + i + 3];
                    dArray[n + i + 3] = dArray[n4 - i - 3];
                    dArray[n4 - i - 3] = d;
                }
            } else {
                for (int i = 0; i < this.n / 2; ++i) {
                    d = dArray[n + i];
                    dArray[n + i] = dArray[n4 - i];
                    dArray[n4 - i] = d;
                }
            }
        }
        this.dct.inverse(dArray, n, bl);
        if (n5 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n7;
            n4 = this.n / n5;
            Future[] futureArray = new Future[n5];
            for (n7 = 0; n7 < n5; ++n7) {
                n3 = n + n7 * n4 + 1;
                n2 = n7 == n5 - 1 ? this.n : n3 + n4;
                futureArray[n7] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                    public void run() {
                        if (DoubleDST_1D.this.n >= 4) {
                            for (int i = n3; i < n2; i += 4) {
                                dArray[i] = -dArray[i];
                                dArray[i + 2] = -dArray[i + 2];
                            }
                        } else {
                            for (int i = n3; i < n2; i += 2) {
                                dArray[i] = -dArray[i];
                            }
                        }
                    }
                });
            }
            try {
                for (n7 = 0; n7 < n5; ++n7) {
                    futureArray[n7].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = 1 + n;
            int n8 = n + this.n;
            if (this.n >= 4) {
                for (int i = n4; i < n8; i += 4) {
                    dArray[i] = -dArray[i];
                    dArray[i + 2] = -dArray[i + 2];
                }
            } else {
                for (int i = n4; i < n8; i += 2) {
                    dArray[i] = -dArray[i];
                }
            }
        }
    }
}

