/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

public class ImageFileTypes {
    public static Type getImageFileType(String fileExtension) {
        String extension = fileExtension.toLowerCase();
        Type type = Type.NULL;
        if (".jpg".equalsIgnoreCase(fileExtension)) {
            type = Type.JPEG;
        }
        for (Type iterType : Type.values()) {
            if (type != Type.NULL) break;
            if (!iterType.getExtension().equalsIgnoreCase(extension)) continue;
            type = iterType;
        }
        return type;
    }

    public static enum Type {
        NULL("", ""),
        EPS(".eps", "Encapsulated Postscript Files (*.eps)"),
        PDF(".pdf", "Portable Document FormatFles (*.pdf)"),
        SVG(".svg", "Scalable Vector Graphics Files (*.svg)"),
        PNG(".png", "Portable Network Graphics Files (*.png)"),
        JPEG(".jpeg", "Joint Photographic Experts Group Files (*.jpeg)");

        private String fileExtension;
        private String fileDescription;

        private Type(String extension, String description) {
            this.fileExtension = extension;
            this.fileDescription = description;
        }

        public String getExtension() {
            return this.fileExtension;
        }

        public String getDescription() {
            return this.fileDescription;
        }
    }
}

