/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.util.XorShift128PlusRandomGenerator;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;

public final class Util {
    private static final NumberFormat FORMAT_DOUBLE = NumberFormat.getInstance(Locale.US);
    private static final NumberFormat FORMAT_LONG;
    private static final FieldPosition UNUSED_FIELD_POSITION;
    public static final Runtime RUNTIME;
    private static final XorShift128PlusRandomGenerator seedUniquifier;

    private Util() {
    }

    public static synchronized String format(double d) {
        return FORMAT_DOUBLE.format(d, new StringBuffer(), UNUSED_FIELD_POSITION).toString();
    }

    public static synchronized String format(long l) {
        return FORMAT_LONG.format(l, new StringBuffer(), UNUSED_FIELD_POSITION).toString();
    }

    public static String format(double d, NumberFormat format) {
        StringBuffer s = new StringBuffer();
        return format.format(d, s, UNUSED_FIELD_POSITION).toString();
    }

    public static String format(long l, NumberFormat format) {
        StringBuffer s = new StringBuffer();
        return format.format(l, s, UNUSED_FIELD_POSITION).toString();
    }

    public static String formatSize(long l) {
        if (l >= 1000000000000L) {
            return Util.format((double)l / 1.0E12) + "T";
        }
        if (l >= 1000000000L) {
            return Util.format((double)l / 1.0E9) + "G";
        }
        if (l >= 1000000L) {
            return Util.format((double)l / 1000000.0) + "M";
        }
        if (l >= 1000L) {
            return Util.format((double)l / 1000.0) + "K";
        }
        return Long.toString(l);
    }

    public static String formatBinarySize(long l) {
        if ((l & -l) != l) {
            throw new IllegalArgumentException("Not a power of 2: " + l);
        }
        if (l >= 0x10000000000L) {
            return Util.format(l >> 40) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format(l >> 30) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format(l >> 20) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format(l >> 10) + "Ki";
        }
        return Long.toString(l);
    }

    public static String formatSize2(long l) {
        if (l >= 0x10000000000L) {
            return Util.format((double)l / 1.099511627776E12) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format((double)l / 1.073741824E9) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format((double)l / 1048576.0) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format((double)l / 1024.0) + "Ki";
        }
        return Long.toString(l);
    }

    public static String formatSize(long l, NumberFormat format) {
        if (l >= 1000000000000L) {
            return Util.format((double)l / 1.0E12) + "T";
        }
        if (l >= 1000000000L) {
            return Util.format((double)l / 1.0E9) + "G";
        }
        if (l >= 1000000L) {
            return Util.format((double)l / 1000000.0) + "M";
        }
        if (l >= 1000L) {
            return Util.format((double)l / 1000.0) + "K";
        }
        return Long.toString(l);
    }

    public static String formatBinarySize(long l, NumberFormat format) {
        if ((l & -l) != l) {
            throw new IllegalArgumentException("Not a power of 2: " + l);
        }
        if (l >= 0x10000000000L) {
            return Util.format(l >> 40) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format(l >> 30) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format(l >> 20) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format(l >> 10) + "Ki";
        }
        return Long.toString(l);
    }

    public static String formatSize2(long l, NumberFormat format) {
        if (l >= 0x10000000000L) {
            return Util.format((double)l / 1.099511627776E12) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format((double)l / 1.073741824E9) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format((double)l / 1048576.0) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format((double)l / 1024.0) + "Ki";
        }
        return Long.toString(l);
    }

    public static boolean memoryIsLow() {
        return Util.availableMemory() * 100L < RUNTIME.totalMemory() * 5L;
    }

    public static long availableMemory() {
        return RUNTIME.freeMemory() + (RUNTIME.maxMemory() - RUNTIME.totalMemory());
    }

    public static int percAvailableMemory() {
        return (int)(Util.availableMemory() * 100L / Runtime.getRuntime().maxMemory());
    }

    public static void compactMemory() {
        try {
            byte[][] unused = new byte[128][];
            int i = unused.length;
            while (i-- != 0) {
                unused[i] = new byte[2000000000];
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long randomSeed() {
        long x;
        XorShift128PlusRandomGenerator xorShift128PlusRandomGenerator = seedUniquifier;
        synchronized (xorShift128PlusRandomGenerator) {
            x = seedUniquifier.nextLong();
        }
        return x ^ System.nanoTime();
    }

    public static byte[] randomSeedBytes() {
        long seed = Util.randomSeed();
        byte[] s = new byte[8];
        int i = 8;
        while (i-- != 0) {
            s[i] = (byte)(seed >>> i);
        }
        return s;
    }

    public static int[] invertPermutationInPlace(int[] perm) {
        int n = perm.length;
        block0: while (n-- != 0) {
            int i = perm[n];
            if (i < 0) {
                perm[n] = -i - 1;
                continue;
            }
            if (i == n) continue;
            int k = n;
            while (true) {
                int j = perm[i];
                perm[i] = -k - 1;
                if (j == n) {
                    perm[n] = i;
                    continue block0;
                }
                k = i;
                i = j;
            }
        }
        return perm;
    }

    public static int[] invertPermutation(int[] perm, int[] inv) {
        int i = perm.length;
        while (i-- != 0) {
            inv[perm[i]] = i;
        }
        return inv;
    }

    public static int[] invertPermutation(int[] perm) {
        return Util.invertPermutation(perm, new int[perm.length]);
    }

    public static int[] identity(int[] perm) {
        int i = perm.length;
        while (i-- != 0) {
            perm[i] = i;
        }
        return perm;
    }

    public static int[] identity(int n) {
        return Util.identity(new int[n]);
    }

    public static long[][] invertPermutationInPlace(long[][] perm) {
        long n = LongBigArrays.length((long[][])perm);
        block0: while (n-- != 0L) {
            long i = LongBigArrays.get((long[][])perm, (long)n);
            if (i < 0L) {
                LongBigArrays.set((long[][])perm, (long)n, (long)(-i - 1L));
                continue;
            }
            if (i == n) continue;
            long k = n;
            while (true) {
                long j = LongBigArrays.get((long[][])perm, (long)i);
                LongBigArrays.set((long[][])perm, (long)i, (long)(-k - 1L));
                if (j == n) {
                    LongBigArrays.set((long[][])perm, (long)n, (long)i);
                    continue block0;
                }
                k = i;
                i = j;
            }
        }
        return perm;
    }

    public static long[][] invertPermutation(long[][] perm, long[][] inv) {
        int i = perm.length;
        while (i-- != 0) {
            long[] t = perm[i];
            int d = t.length;
            while (d-- != 0) {
                LongBigArrays.set((long[][])inv, (long)t[d], (long)BigArrays.index((int)i, (int)d));
            }
        }
        return inv;
    }

    public static long[][] invertPermutation(long[][] perm) {
        return Util.invertPermutation(perm, LongBigArrays.newBigArray((long)LongBigArrays.length((long[][])perm)));
    }

    public static long[][] identity(long[][] perm) {
        int i = perm.length;
        while (i-- != 0) {
            long[] t = perm[i];
            int d = t.length;
            while (d-- != 0) {
                t[d] = BigArrays.index((int)i, (int)d);
            }
        }
        return perm;
    }

    public static long[][] identity(long n) {
        return Util.identity(LongBigArrays.newBigArray((long)n));
    }

    static {
        if (FORMAT_DOUBLE instanceof DecimalFormat) {
            ((DecimalFormat)FORMAT_DOUBLE).applyPattern("#,##0.00");
        }
        FORMAT_LONG = NumberFormat.getInstance(Locale.US);
        if (FORMAT_DOUBLE instanceof DecimalFormat) {
            ((DecimalFormat)FORMAT_LONG).applyPattern("#,###");
        }
        UNUSED_FIELD_POSITION = new FieldPosition(0);
        RUNTIME = Runtime.getRuntime();
        seedUniquifier = new XorShift128PlusRandomGenerator(System.nanoTime());
    }
}

