#!/usr/pkg/bin/perl
# mailbox managing
#
require './functions-lib.pl';

use CGI; $q=new CGI; 
iframe_header();

my $err="", $root="", $reload=0;
my $mbox=$q->param('mbox');
$mbox="user" if $q->param('user');
$cyrus = &cyrus_connect();

if ($mbox)
	{
	check_mailbox($mbox);
#	$entry=$list[0]; ($mbox, $attributes, $sep) = ($entry->[0],$entry->[1],$entry->[2]);
	($name, $supmbox, $partition) = mbox_info($mbox,1);
    $cyrus->setacl($mbox, $config{admin_user}=>"all");
	}

# create new mailbox or subfolder
if ($q->param('create'))
	{ 
    ($mbox, $domain) = split /@/, $mbox;
	$mbox = $mbox.$SEP.name_encode($q->param('folder'));
	$mbox .= '@'.$domain if $domain;
	$cyrus->create($mbox,$q->param('defaultpartition')); 
	$err=$cyrus->error."<BR>\n";
	if ($q->param('quota') && !$err) 
		{ $cyrus->setquota($mbox, 'STORAGE', $q->param('quota')); }
	$err=$cyrus->error;
	msglog("create mailbox ".name_decode($mbox)) unless $err;
	$reload=1;
	}
	
# delete mailbox 
if ($q->param('delete'))
	{ 
	$cyrus->delete($mbox); 
	$err=$cyrus->error;
	if (!$err)
		{
		msglog("delete mailbox ".name_decode($mbox));
        ($mbox, $domain) = split /@/, $mbox;
		$mbox=$supmbox;
	    $mbox .= '@'.$domain if $domain;		
		}
	$reload=1;
	}

# rebuild mailbox 
if ($q->param('rebuild'))
	{
    %acls=$cyrus->listacl($mbox); 
    $cyrus->setacl($mbox, $config{admin_user}=>"all") unless $acls{$config{admin_user}} eq "lrswipcda";    
	$rebuild=$config{lib_path}."/reconstruct";
	if (-f $rebuild)
		{
        system "su -c '$rebuild \"$mbox\"' cyrus"; 
        print "<br>";
        msglog("reconstruct mailbox ".name_decode($mbox));
        }
   	else 
        {
        print "<BR><BR>$rebuild ", $text{not_found}, "<BR>", $text{go_to_config};
        exit;
        }
	}
	
# update quota and/or partition
if ($q->param('update'))
	{ 
	($quota, $used)=getquota($mbox);
	if ($q->param('quota') != $quota*1024)
		{
        $quotacmd=$config{lib_path}."/quota";	
        unless (-f $quotacmd)
            {
			print "<BR><BR>$quotacmd ", $text{not_found}, "<BR>", $text{go_to_config};
			exit;
			}
		if ($q->param('quota')>0)
		    {
#	modify the quota in the root mailbox! (not in all subfolders!)
            $cyrus->setquota($mbox, 'STORAGE', $q->param('quota'));
            $err=$cyrus->error;
            msglog("set quota ".$q->param('quota')." on ".name_decode($mbox)) unless $err;
            }
		else
#	remove the quota in mailbox and all subfolders
            {
            my $findName=$mbox; $findName =~ s/^user.//; $findName =~ s/\./^/g;
            my @list=split /\n/,`find $config{imap_path}/quota -type f -name *$findName*`;
            foreach (@list) { unlink $_; }
            msglog("remove quota from ".name_decode($mbox));
            }
        print "<PRE>", `su -c '$quotacmd -f $mbox' cyrus 2>&1`, "</PRE><br>";
		}

	get_partitions() unless %imapPartitions;
	if ($imapPartitions{$q->param('defaultpartition')} ne $partition)
		{
#	move the mailbox to another partition
		$cyrus->rename($mbox,$mbox,$q->param('defaultpartition'));
		$err=$cyrus->error;
		msglog("move ".name_decode($mbox)." to ".$q->param('defaultpartition')." partition") unless $err;
		}
	}

iframe_footer($mbox, $err, $reload);