/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.AbstractNumberNode;
import gnu.xml.transform.ApplyTemplatesNode;
import gnu.xml.transform.AttributeNode;
import gnu.xml.transform.AttributeSet;
import gnu.xml.transform.Bindings;
import gnu.xml.transform.CallTemplateNode;
import gnu.xml.transform.CopyNode;
import gnu.xml.transform.CopyOfNode;
import gnu.xml.transform.CurrentFunction;
import gnu.xml.transform.DOMSourceLocator;
import gnu.xml.transform.DocumentFunction;
import gnu.xml.transform.ElementAvailableFunction;
import gnu.xml.transform.ElementNode;
import gnu.xml.transform.ForEachNode;
import gnu.xml.transform.FormatNumberFunction;
import gnu.xml.transform.FunctionAvailableFunction;
import gnu.xml.transform.GenerateIdFunction;
import gnu.xml.transform.IfNode;
import gnu.xml.transform.Key;
import gnu.xml.transform.KeyFunction;
import gnu.xml.transform.LiteralNode;
import gnu.xml.transform.MessageNode;
import gnu.xml.transform.NamespaceProxy;
import gnu.xml.transform.NodeNumberNode;
import gnu.xml.transform.NumberNode;
import gnu.xml.transform.ParameterNode;
import gnu.xml.transform.ProcessingInstructionNode;
import gnu.xml.transform.SortKey;
import gnu.xml.transform.StrippingInstruction;
import gnu.xml.transform.SystemPropertyFunction;
import gnu.xml.transform.Template;
import gnu.xml.transform.TemplateNode;
import gnu.xml.transform.TextNode;
import gnu.xml.transform.TransformerFactoryImpl;
import gnu.xml.transform.TransformerImpl;
import gnu.xml.transform.UnparsedEntityUriFunction;
import gnu.xml.transform.ValueOfNode;
import gnu.xml.transform.WhenNode;
import gnu.xml.transform.WithParam;
import gnu.xml.xpath.Expr;
import gnu.xml.xpath.NameTest;
import gnu.xml.xpath.NodeTypeTest;
import gnu.xml.xpath.Pattern;
import gnu.xml.xpath.Root;
import gnu.xml.xpath.Selector;
import gnu.xml.xpath.XPathImpl;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

class Stylesheet
implements NamespaceContext,
XPathFunctionResolver,
UserDataHandler,
Cloneable {
    static final String XSL_NS = "http://www.w3.org/1999/XSL/Transform";
    private static final NameTest STYLESHEET_PRESERVE_TEXT = new NameTest(new QName("http://www.w3.org/1999/XSL/Transform", "text"), false, false);
    static final int OUTPUT_XML = 0;
    static final int OUTPUT_HTML = 1;
    static final int OUTPUT_TEXT = 2;
    final TransformerFactoryImpl factory;
    TransformerImpl transformer;
    Stylesheet parent;
    final XPathImpl xpath;
    final String systemId;
    final int precedence;
    final boolean debug;
    String version;
    Collection extensionElementPrefixes;
    Collection excludeResultPrefixes;
    Set stripSpace;
    Set preserveSpace;
    Node output;
    int outputMethod;
    String outputVersion;
    String outputEncoding;
    boolean outputOmitXmlDeclaration;
    boolean outputStandalone;
    String outputPublicId;
    String outputSystemId;
    Collection outputCdataSectionElements;
    boolean outputIndent;
    String outputMediaType;
    Collection keys;
    Map decimalFormats;
    Map namespaceAliases;
    List attributeSets;
    List variables;
    Bindings bindings;
    LinkedList templates;
    TemplateNode builtInNodeTemplate;
    TemplateNode builtInTextTemplate;
    Node current;
    transient boolean terminated;
    transient Template currentTemplate;

    Stylesheet getRootStylesheet() {
        Stylesheet stylesheet = this;
        while (stylesheet.parent != null) {
            stylesheet = stylesheet.parent;
        }
        return stylesheet;
    }

    void initDefaultDecimalFormat() {
        DecimalFormat decimalFormat = new DecimalFormat();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setPercent('%');
        decimalFormatSymbols.setPerMill('\u2030');
        decimalFormatSymbols.setZeroDigit('0');
        decimalFormatSymbols.setDigit('#');
        decimalFormatSymbols.setPatternSeparator(';');
        decimalFormatSymbols.setInfinity("Infinity");
        decimalFormatSymbols.setNaN("NaN");
        decimalFormatSymbols.setMinusSign('-');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        this.decimalFormats.put(null, decimalFormat);
    }

    public Object clone() {
        try {
            Object object;
            Object object2;
            Object object3;
            Stylesheet stylesheet = (Stylesheet)super.clone();
            stylesheet.bindings = (Bindings)this.bindings.clone();
            LinkedList linkedList = new LinkedList();
            Object object4 = this.templates.iterator();
            while (object4.hasNext()) {
                object3 = (Template)object4.next();
                linkedList.add(((Template)object3).clone(stylesheet));
            }
            stylesheet.templates = linkedList;
            object4 = new LinkedList();
            object3 = this.attributeSets.iterator();
            while (object3.hasNext()) {
                object2 = (AttributeSet)object3.next();
                ((LinkedList)object4).add(((AttributeSet)object2).clone(stylesheet));
            }
            stylesheet.attributeSets = object4;
            object3 = new LinkedList();
            object2 = this.variables.iterator();
            while (object2.hasNext()) {
                object = (ParameterNode)object2.next();
                ((LinkedList)object3).add(((ParameterNode)object).clone(stylesheet));
            }
            stylesheet.variables = object3;
            object2 = new LinkedList();
            object = this.keys.iterator();
            while (object.hasNext()) {
                Key key = (Key)object.next();
                ((LinkedList)object2).add(key.clone(stylesheet));
            }
            stylesheet.keys = object2;
            return stylesheet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException.getMessage());
        }
    }

    void initTopLevelVariables(Node node2) throws TransformerException {
        this.current = node2;
        ArrayList arrayList = new ArrayList(this.variables);
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ParameterNode parameterNode = (ParameterNode)iterator.next();
            this.bindings.set(parameterNode.name, parameterNode.getValue(this, null, node2, 1, 1), parameterNode.type);
        }
        this.current = null;
    }

    public String getNamespaceURI(String string) {
        return this.current == null ? null : this.current.lookupNamespaceURI(string);
    }

    public String getPrefix(String string) {
        return this.current == null ? null : this.current.lookupPrefix(string);
    }

    public Iterator getPrefixes(String string) {
        return Collections.singleton(this.getPrefix(string)).iterator();
    }

    final QName getQName(String string) {
        String string2 = string;
        String string3 = null;
        String string4 = null;
        int n = string.indexOf(58);
        if (n != -1) {
            string4 = string.substring(0, n);
            string2 = string.substring(n + 1);
            string3 = this.getNamespaceURI(string4);
        }
        return new QName(string3, string2, string4);
    }

    TemplateNode getTemplate(QName qName, Node node2, boolean bl) throws TransformerException {
        if (this.debug) {
            System.err.println("getTemplate: mode=" + qName + " context=" + node2);
        }
        Template template = null;
        Iterator iterator = this.templates.iterator();
        while (iterator.hasNext()) {
            Template template2 = (Template)iterator.next();
            boolean bl2 = template2.matches(qName, node2);
            if (bl) {
                if (this.currentTemplate == null) {
                    String string = "current template may not be null during apply-imports";
                    throw new TransformerException(string);
                }
                if (!this.currentTemplate.imports(template2)) {
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            if (template == null) {
                template = template2;
                continue;
            }
            if (template2.precedence < template.precedence || template2.priority < template.priority) continue;
            template = template2;
        }
        if (template == null) {
            if (this.debug) {
                System.err.println("\tbuiltInTemplate context=" + node2);
            }
            switch (node2.getNodeType()) {
                case 1: 
                case 7: 
                case 8: 
                case 9: 
                case 11: {
                    return this.builtInNodeTemplate;
                }
                case 2: 
                case 3: 
                case 4: {
                    return this.builtInTextTemplate;
                }
            }
            return null;
        }
        this.currentTemplate = template;
        if (this.debug) {
            System.err.println("\ttemplate=" + this.currentTemplate + " context=" + node2);
        }
        return this.currentTemplate.node;
    }

    TemplateNode getTemplate(QName qName, QName qName2) throws TransformerException {
        Template template = null;
        Iterator iterator = this.templates.iterator();
        while (iterator.hasNext()) {
            Template template2 = (Template)iterator.next();
            boolean bl = template2.matches(qName2);
            if (!bl) continue;
            if (template == null) {
                template = template2;
                continue;
            }
            if (template2.precedence < template.precedence || template2.priority < template.priority) continue;
            template = template2;
        }
        if (template == null) {
            return null;
        }
        return template.node;
    }

    final Template parseTemplate(Node node2, NamedNodeMap namedNodeMap) throws TransformerConfigurationException, XPathExpressionException {
        String string = Stylesheet.getAttribute(namedNodeMap, "name");
        QName qName = string == null ? null : this.getQName(string);
        String string2 = Stylesheet.getAttribute(namedNodeMap, "match");
        Pattern pattern2 = null;
        if (string2 != null) {
            try {
                pattern2 = (Pattern)this.xpath.compile(string2);
            }
            catch (ClassCastException classCastException) {
                String string3 = "illegal pattern: " + string2;
                throw new TransformerConfigurationException(string3);
            }
        }
        String string4 = Stylesheet.getAttribute(namedNodeMap, "priority");
        String string5 = Stylesheet.getAttribute(namedNodeMap, "mode");
        QName qName2 = string5 == null ? null : this.getQName(string5);
        Node node3 = node2.getFirstChild();
        return new Template(this, qName, pattern2, this.parse(node3), this.precedence, string4, qName2);
    }

    final void parseOutput(Node node2, NamedNodeMap namedNodeMap) throws TransformerConfigurationException {
        String string;
        this.output = node2;
        String string2 = Stylesheet.getAttribute(namedNodeMap, "method");
        if ("xml".equals(string2) || string2 == null) {
            this.outputMethod = 0;
        } else if ("html".equals(string2)) {
            this.outputMethod = 1;
        } else if ("text".equals(string2)) {
            this.outputMethod = 2;
        } else {
            String string3 = "unsupported output method: " + string2;
            DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
            throw new TransformerConfigurationException(string3, dOMSourceLocator);
        }
        this.outputPublicId = Stylesheet.getAttribute(namedNodeMap, "doctype-public");
        this.outputSystemId = Stylesheet.getAttribute(namedNodeMap, "doctype-system");
        this.outputEncoding = Stylesheet.getAttribute(namedNodeMap, "encoding");
        String string4 = Stylesheet.getAttribute(namedNodeMap, "indent");
        if (string4 != null) {
            this.outputIndent = "yes".equals(string4);
        }
        this.outputVersion = Stylesheet.getAttribute(namedNodeMap, "version");
        String string5 = Stylesheet.getAttribute(namedNodeMap, "omit-xml-declaration");
        if (string5 != null) {
            this.outputOmitXmlDeclaration = "yes".equals(string5);
        }
        if ((string = Stylesheet.getAttribute(namedNodeMap, "standalone")) != null) {
            this.outputStandalone = "yes".equals(string);
        }
        this.outputMediaType = Stylesheet.getAttribute(namedNodeMap, "media-type");
        String string6 = Stylesheet.getAttribute(namedNodeMap, "cdata-section-elements");
        if (string6 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string6, " ");
            while (stringTokenizer.hasMoreTokens()) {
                this.outputCdataSectionElements.add(stringTokenizer.nextToken());
            }
        }
    }

    final void parseKey(Node node2, NamedNodeMap namedNodeMap) throws TransformerConfigurationException, XPathExpressionException {
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2);
        String string2 = Stylesheet.getRequiredAttribute(namedNodeMap, "match", node2);
        String string3 = Stylesheet.getRequiredAttribute(namedNodeMap, "use", node2);
        QName qName = this.getQName(string);
        Expr expr = (Expr)this.xpath.compile(string3);
        try {
            Pattern pattern2 = (Pattern)this.xpath.compile(string2);
            Key key = new Key(qName, pattern2, expr);
            this.keys.add(key);
        }
        catch (ClassCastException classCastException) {
            throw new TransformerConfigurationException("invalid pattern: " + string2);
        }
    }

    final void parseDecimalFormat(Node node2, NamedNodeMap namedNodeMap) throws TransformerConfigurationException {
        String string = Stylesheet.getAttribute(namedNodeMap, "name");
        DecimalFormat decimalFormat = new DecimalFormat();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator(this.parseDFChar(namedNodeMap, "decimal-separator", '.'));
        decimalFormatSymbols.setGroupingSeparator(this.parseDFChar(namedNodeMap, "grouping-separator", ','));
        decimalFormatSymbols.setInfinity(this.parseDFString(namedNodeMap, "infinity", "Infinity"));
        decimalFormatSymbols.setMinusSign(this.parseDFChar(namedNodeMap, "minus-sign", '-'));
        decimalFormatSymbols.setNaN(this.parseDFString(namedNodeMap, "NaN", "NaN"));
        decimalFormatSymbols.setPercent(this.parseDFChar(namedNodeMap, "percent", '%'));
        decimalFormatSymbols.setPerMill(this.parseDFChar(namedNodeMap, "per-mille", '\u2030'));
        decimalFormatSymbols.setZeroDigit(this.parseDFChar(namedNodeMap, "zero-digit", '0'));
        decimalFormatSymbols.setDigit(this.parseDFChar(namedNodeMap, "digit", '#'));
        decimalFormatSymbols.setPatternSeparator(this.parseDFChar(namedNodeMap, "pattern-separator", ';'));
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        this.decimalFormats.put(string, decimalFormat);
    }

    private final char parseDFChar(NamedNodeMap namedNodeMap, String string, char c) throws TransformerConfigurationException {
        Node node2 = namedNodeMap.getNamedItem(string);
        try {
            return node2 == null ? c : node2.getNodeValue().charAt(0);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new TransformerConfigurationException("empty attribute '" + string + "' in decimal-format", stringIndexOutOfBoundsException);
        }
    }

    private final String parseDFString(NamedNodeMap namedNodeMap, String string, String string2) {
        Node node2 = namedNodeMap.getNamedItem(string);
        return node2 == null ? string2 : node2.getNodeValue();
    }

    final void parseNamespaceAlias(Node node2, NamedNodeMap namedNodeMap) throws TransformerConfigurationException {
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "stylesheet-prefix", node2);
        String string2 = Stylesheet.getRequiredAttribute(namedNodeMap, "result-prefix", node2);
        this.namespaceAliases.put(string, string2);
    }

    final void parseAttributeSet(Node node2, NamedNodeMap namedNodeMap) throws TransformerConfigurationException, XPathExpressionException {
        TemplateNode templateNode = this.parse(node2.getFirstChild());
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2);
        String string2 = Stylesheet.getAttribute(namedNodeMap, "use-attribute-sets");
        this.attributeSets.add(new AttributeSet(templateNode, string, string2));
    }

    void parse(Node node2, boolean bl) throws TransformerConfigurationException {
        while (node2 != null) {
            this.current = node2;
            this.doParse(node2, bl);
            node2 = node2.getNextSibling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doParse(Node var1_1, boolean var2_2) throws TransformerConfigurationException {
        block24: {
            try {
                block25: {
                    block28: {
                        block27: {
                            block26: {
                                var3_3 = var1_1.getNamespaceURI();
                                if (!"http://www.w3.org/1999/XSL/Transform".equals(var3_3) || var1_1.getNodeType() != 1) break block25;
                                var4_7 = var1_1.getLocalName();
                                var5_12 = var1_1.getAttributes();
                                if (!"stylesheet".equals(var4_7)) break block26;
                                this.version = Stylesheet.getAttribute(var5_12, "version");
                                var6_15 = Stylesheet.getAttribute(var5_12, "extension-element-prefixes");
                                if (var6_15 == null) break block24;
                                var7_22 = new StringTokenizer(var6_15);
                                if (true) ** GOTO lbl103
                            }
                            if ("template".equals(var4_7)) {
                                this.templates.add(this.parseTemplate(var1_1, var5_12));
                                return;
                            }
                            if ("param".equals(var4_7) || "variable".equals(var4_7)) {
                                var6_16 = 1 - "variable".equals(var4_7);
                                var7_23 = this.parse(var1_1.getFirstChild());
                                var8_28 = this.getQName(Stylesheet.getRequiredAttribute(var5_12, "name", var1_1));
                                var9_32 = Stylesheet.getAttribute(var5_12, "select");
                                if (var9_32 != null && var9_32.length() > 0) {
                                    if (var7_23 != null) {
                                        var11_34 = "parameter '" + var8_28 + "' has both select and content";
                                        var12_36 = new DOMSourceLocator(var1_1);
                                        throw new TransformerConfigurationException(var11_34, var12_36);
                                    }
                                    var11_35 = (Expr)this.xpath.compile(var9_32);
                                    var10_37 = new ParameterNode(var8_28, var11_35, var6_16);
                                } else {
                                    var10_37 = new ParameterNode(var8_28, null, var6_16);
                                    var10_37.children = var7_23;
                                }
                                this.variables.add(var10_37);
                                return;
                            }
                            if ("include".equals(var4_7) || "import".equals(var4_7)) {
                                var6_17 = 0 - "import".equals(var4_7);
                                var7_24 = Stylesheet.getRequiredAttribute(var5_12, "href", var1_1);
                                var9_33 = this.factory.resolver;
                                synchronized (var9_33) {
                                    if (this.transformer != null) {
                                        this.factory.resolver.setUserResolver(this.transformer.getURIResolver());
                                        this.factory.resolver.setUserListener(this.transformer.getErrorListener());
                                    }
                                    var8_29 = this.factory.resolver.resolve(this.systemId, var7_24);
                                }
                                this.factory.newStylesheet(var8_29, this.precedence + var6_17, this);
                                return;
                            }
                            if ("output".equals(var4_7)) {
                                this.parseOutput(var1_1, var5_12);
                                return;
                            }
                            if (!"preserve-space".equals(var4_7)) break block27;
                            var6_18 = Stylesheet.getRequiredAttribute(var5_12, "elements", var1_1);
                            var7_25 = new StringTokenizer(var6_18, " \t\n\r");
                            if (true) ** GOTO lbl117
                        }
                        if (!"strip-space".equals(var4_7)) break block28;
                        var6_19 = Stylesheet.getRequiredAttribute(var5_12, "elements", var1_1);
                        var7_26 = new StringTokenizer(var6_19, " \t\n\r");
                        if (true) ** GOTO lbl123
                    }
                    if ("key".equals(var4_7)) {
                        this.parseKey(var1_1, var5_12);
                        return;
                    }
                    if ("decimal-format".equals(var4_7)) {
                        this.parseDecimalFormat(var1_1, var5_12);
                        return;
                    }
                    if ("namespace-alias".equals(var4_7)) {
                        this.parseNamespaceAlias(var1_1, var5_12);
                        return;
                    }
                    if ("attribute-set".equals(var4_7) == false) return;
                    this.parseAttributeSet(var1_1, var5_12);
                    return;
                }
                if (var2_2 == false) return;
                var4_8 = ((Element)var1_1).getAttributeNodeNS("http://www.w3.org/1999/XSL/Transform", "version");
                if (var4_8 == null) {
                    var5_13 = "no xsl:version attribute on literal result node";
                    var6_20 = new DOMSourceLocator(var1_1);
                    throw new TransformerConfigurationException(var5_13, var6_20);
                }
                this.version = var4_8.getValue();
                var5_14 = var1_1.cloneNode(true);
                var6_21 = var5_14.getAttributes();
                var6_21.removeNamedItemNS("http://www.w3.org/1999/XSL/Transform", "version");
                this.templates.add(new Template(this, null, new Root(), this.parse(var5_14), this.precedence, null, null));
                return;
            }
            catch (TransformerException var3_4) {
                var4_9 = new DOMSourceLocator(var1_1);
                throw new TransformerConfigurationException(var3_4.getMessage(), var4_9, var3_4);
            }
            catch (DOMException var3_5) {
                var4_10 = new DOMSourceLocator(var1_1);
                throw new TransformerConfigurationException(var3_5.getMessage(), var4_10, var3_5);
            }
            catch (XPathExpressionException var3_6) {
                var4_11 = new DOMSourceLocator(var1_1);
                throw new TransformerConfigurationException(var3_6.getMessage(), var4_11, var3_6);
            }
            do {
                this.extensionElementPrefixes.add(var7_22.nextToken());
lbl103:
                // 2 sources

            } while (var7_22.hasMoreTokens());
        }
        if ((var7_22 = Stylesheet.getAttribute(var5_12, "exclude-result-prefixes")) != null) {
            var8_27 = new StringTokenizer((String)var7_22);
            while (var8_27.hasMoreTokens()) {
                this.excludeResultPrefixes.add(var8_27.nextToken());
            }
        }
        this.parse(var1_1.getFirstChild(), false);
        return;
        do {
            var8_30 = this.parseNameTest(var7_25.nextToken());
            this.preserveSpace.add(new StrippingInstruction(var8_30, this.precedence));
lbl117:
            // 2 sources

        } while (var7_25.hasMoreTokens());
        return;
        do {
            var8_31 = this.parseNameTest(var7_26.nextToken());
            this.stripSpace.add(new StrippingInstruction(var8_31, this.precedence));
lbl123:
            // 2 sources

        } while (var7_26.hasMoreTokens());
    }

    final NameTest parseNameTest(String string) {
        if ("*".equals(string)) {
            return new NameTest(null, true, true);
        }
        if (string.endsWith(":*")) {
            QName qName = this.getQName(string);
            return new NameTest(qName, true, false);
        }
        QName qName = this.getQName(string);
        return new NameTest(qName, false, false);
    }

    final TemplateNode parseAttributeValueTemplate(String string, Node node2) throws TransformerConfigurationException, XPathExpressionException {
        this.current = node2;
        int n = string.length();
        int n2 = 0;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c = string.charAt(n4);
            if (c == '{') {
                if (n4 < n - 1 && string.charAt(n4 + 1) == '{') {
                    arrayList.add(string.substring(n2, n4 + 1));
                    arrayList2.add(Boolean.FALSE);
                    n2 = ++n4 + 1;
                } else {
                    if (n3 == 0) {
                        if (n4 - n2 > 0) {
                            arrayList.add(string.substring(n2, n4));
                            arrayList2.add(Boolean.FALSE);
                        }
                        n2 = n4 + 1;
                    }
                    ++n3;
                }
            } else if (c == '}') {
                if (n4 < n - 1 && string.charAt(n4 + 1) == '}') {
                    arrayList.add(string.substring(n2, n4 + 1));
                    arrayList2.add(Boolean.FALSE);
                    n2 = ++n4 + 1;
                } else {
                    if (n3 == 1) {
                        if (n4 - n2 <= 0) {
                            String string2 = "attribute value template must contain expression: " + string;
                            DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
                            throw new TransformerConfigurationException(string2, dOMSourceLocator);
                        }
                        arrayList.add(string.substring(n2, n4));
                        arrayList2.add(Boolean.TRUE);
                        n2 = n4 + 1;
                    }
                    --n3;
                }
            }
            ++n4;
        }
        if (n3 > 0) {
            String string3 = "invalid attribute value template: " + string;
            throw new TransformerConfigurationException(string3);
        }
        if (n - n2 > 0) {
            arrayList.add(string.substring(n2));
            arrayList2.add(Boolean.FALSE);
        }
        Object object = null;
        Document document = node2.getOwnerDocument();
        n = arrayList.size();
        int n5 = n - 1;
        while (n5 >= 0) {
            Object object2;
            String string4 = (String)arrayList.get(n5);
            Boolean bl = (Boolean)arrayList2.get(n5);
            if (bl == Boolean.TRUE) {
                object2 = (Expr)this.xpath.compile(string4);
                ValueOfNode valueOfNode = new ValueOfNode((Expr)object2, false);
                valueOfNode.next = object;
                object = valueOfNode;
            } else {
                object2 = new LiteralNode(document.createTextNode(string4));
                ((TemplateNode)object2).next = object;
                object = object2;
            }
            --n5;
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    boolean isPreserved(Text var1_1, boolean var2_2) throws TransformerConfigurationException {
        block17: {
            var3_3 = var1_1.getData();
            if (var3_3 != null) {
                var4_4 = var3_3.length();
                var5_6 = 0;
                while (var5_6 < var4_4) {
                    var6_8 = var3_3.charAt(var5_6);
                    if (var6_8 != ' ' && var6_8 != '\t' && var6_8 != '\n' && var6_8 != '\r') {
                        return true;
                    }
                    ++var5_6;
                }
            }
            var4_5 = var1_1.getParentNode();
            if (!var2_2) break block17;
            var5_6 = 1;
            var6_9 = 0.0f;
            var7_11 = 0.0f;
            if (!this.stripSpace.isEmpty()) {
                var8_13 = null;
                var9_14 = null;
                var10_15 = this.stripSpace.iterator();
                while (var10_15.hasNext()) {
                    var11_16 = (StrippingInstruction)var10_15.next();
                    if (!var11_16.element.matches(var4_5, 1, 1) || var8_13 != null && (var11_16.precedence < var8_13.precedence || (var12_17 = var11_16.getPriority()) < var7_11)) continue;
                    var8_13 = var11_16;
                }
                var10_15 = this.preserveSpace.iterator();
                while (var10_15.hasNext()) {
                    var11_16 = (StrippingInstruction)var10_15.next();
                    if (!var11_16.element.matches(var4_5, 1, 1) || var9_14 != null && (var11_16.precedence < var9_14.precedence || (var12_17 = var11_16.getPriority()) < var6_9)) continue;
                    var9_14 = var11_16;
                }
                if (var8_13 != null) {
                    if (var9_14 != null) {
                        if (var9_14.precedence < var8_13.precedence) {
                            var5_6 = 0;
                        } else if (var6_9 < var7_11) {
                            var5_6 = 0;
                        }
                    } else {
                        var5_6 = 0;
                    }
                }
            }
            if (var5_6 != 0) {
                return true;
            }
            ** GOTO lbl56
        }
        if (!Stylesheet.STYLESHEET_PRESERVE_TEXT.matches(var4_5, 1, 1)) ** GOTO lbl56
        return true;
lbl-1000:
        // 1 sources

        {
            if (var4_5.getNodeType() == 1) {
                var5_7 = (Element)var4_5;
                var6_10 = var5_7.getAttribute("xml:space");
                if ("default".equals(var6_10)) break;
                if ("preserve".equals(var6_10)) {
                    return true;
                }
                if (var6_10.length() > 0) {
                    var7_12 = "Illegal value for xml:space: " + var6_10;
                    throw new TransformerConfigurationException(var7_12);
                }
            }
            var4_5 = var4_5.getParentNode();
lbl56:
            // 3 sources

            ** while (var4_5 != null)
        }
lbl57:
        // 2 sources

        return false;
    }

    public XPathFunction resolveFunction(QName qName, int n) {
        String string = qName.getNamespaceURI();
        if (XSL_NS.equals(string) || string == null || string.length() == 0) {
            String string2 = qName.getLocalPart();
            if ("document".equals(string2) && (n == 1 || n == 2)) {
                if (this.current == null) {
                    throw new RuntimeException("current is null");
                }
                return new DocumentFunction(this.getRootStylesheet(), this.current);
            }
            if ("key".equals(string2) && n == 2) {
                return new KeyFunction(this.getRootStylesheet());
            }
            if ("format-number".equals(string2) && (n == 2 || n == 3)) {
                return new FormatNumberFunction(this.getRootStylesheet());
            }
            if ("current".equals(string2) && n == 0) {
                return new CurrentFunction(this.getRootStylesheet());
            }
            if ("unparsed-entity-uri".equals(string2) && n == 1) {
                return new UnparsedEntityUriFunction();
            }
            if ("generate-id".equals(string2) && (n == 1 || n == 0)) {
                return new GenerateIdFunction();
            }
            if ("system-property".equals(string2) && n == 1) {
                return new SystemPropertyFunction();
            }
            if ("element-available".equals(string2) && n == 1) {
                return new ElementAvailableFunction(new NamespaceProxy(this.current));
            }
            if ("function-available".equals(string2) && n == 1) {
                return new FunctionAvailableFunction(new NamespaceProxy(this.current));
            }
        }
        return null;
    }

    final TemplateNode parseApplyTemplates(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getAttribute(namedNodeMap, "mode");
        QName qName = string == null ? null : this.getQName(string);
        String string2 = Stylesheet.getAttribute(namedNodeMap, "select");
        if (string2 == null) {
            string2 = "child::node()";
        }
        Node node3 = node2.getFirstChild();
        List list2 = this.parseSortKeys(node3);
        List list3 = this.parseWithParams(node3);
        Expr expr = (Expr)this.xpath.compile(string2);
        return new ApplyTemplatesNode(expr, qName, list2, list3, false);
    }

    final TemplateNode parseCallTemplate(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2);
        QName qName = this.getQName(string);
        Node node3 = node2.getFirstChild();
        List list2 = this.parseWithParams(node3);
        return new CallTemplateNode(qName, list2);
    }

    final TemplateNode parseValueOf(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "select", node2);
        String string2 = Stylesheet.getAttribute(namedNodeMap, "disable-output-escaping");
        boolean bl = "yes".equals(string2);
        Expr expr = (Expr)this.xpath.compile(string);
        return new ValueOfNode(expr, bl);
    }

    final TemplateNode parseForEach(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "select", node2);
        Node node3 = node2.getFirstChild();
        List list2 = this.parseSortKeys(node3);
        Expr expr = (Expr)this.xpath.compile(string);
        ForEachNode forEachNode = new ForEachNode(expr, list2);
        forEachNode.children = this.parse(node3);
        return forEachNode;
    }

    final TemplateNode parseIf(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "test", node2);
        Expr expr = (Expr)this.xpath.compile(string);
        Node node3 = node2.getFirstChild();
        IfNode ifNode = new IfNode(expr);
        ifNode.children = this.parse(node3);
        return ifNode;
    }

    final TemplateNode parseWhen(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "test", node2);
        Expr expr = (Expr)this.xpath.compile(string);
        Node node3 = node2.getFirstChild();
        WhenNode whenNode = new WhenNode(expr);
        whenNode.children = this.parse(node3);
        return whenNode;
    }

    final TemplateNode parseElement(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2);
        String string2 = Stylesheet.getAttribute(namedNodeMap, "namespace");
        String string3 = Stylesheet.getAttribute(namedNodeMap, "use-attribute-sets");
        TemplateNode templateNode = this.parseAttributeValueTemplate(string, node2);
        TemplateNode templateNode2 = string2 == null ? null : this.parseAttributeValueTemplate(string2, node2);
        Node node3 = node2.getFirstChild();
        ElementNode elementNode = new ElementNode(templateNode, templateNode2, string3, node2);
        elementNode.children = this.parse(node3);
        return elementNode;
    }

    final TemplateNode parseAttribute(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2);
        String string2 = Stylesheet.getAttribute(namedNodeMap, "namespace");
        TemplateNode templateNode = this.parseAttributeValueTemplate(string, node2);
        TemplateNode templateNode2 = string2 == null ? null : this.parseAttributeValueTemplate(string2, node2);
        Node node3 = node2.getFirstChild();
        AttributeNode attributeNode = new AttributeNode(templateNode, templateNode2, node2);
        attributeNode.children = this.parse(node3);
        return attributeNode;
    }

    final TemplateNode parseText(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getAttribute(namedNodeMap, "disable-output-escaping");
        boolean bl = "yes".equals(string);
        Node node3 = node2.getFirstChild();
        TextNode textNode = new TextNode(bl);
        textNode.children = this.parse(node3);
        return textNode;
    }

    final TemplateNode parseCopy(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getAttribute(namedNodeMap, "use-attribute-sets");
        Node node3 = node2.getFirstChild();
        CopyNode copyNode = new CopyNode(string);
        copyNode.children = this.parse(node3);
        return copyNode;
    }

    final TemplateNode parseProcessingInstruction(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2);
        Node node3 = node2.getFirstChild();
        ProcessingInstructionNode processingInstructionNode = new ProcessingInstructionNode(string);
        processingInstructionNode.children = this.parse(node3);
        return processingInstructionNode;
    }

    final TemplateNode parseNumber(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        AbstractNumberNode abstractNumberNode;
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getAttribute(namedNodeMap, "value");
        String string2 = Stylesheet.getAttribute(namedNodeMap, "format");
        if (string2 == null) {
            string2 = "1";
        }
        TemplateNode templateNode = this.parseAttributeValueTemplate(string2, node2);
        String string3 = Stylesheet.getAttribute(namedNodeMap, "lang");
        String string4 = Stylesheet.getAttribute(namedNodeMap, "letter-value");
        int n = "traditional".equals(string4);
        String string5 = Stylesheet.getAttribute(namedNodeMap, "grouping-separator");
        String string6 = Stylesheet.getAttribute(namedNodeMap, "grouping-size");
        int n2 = 1;
        if (string6 != null && string6.length() > 0) {
            n2 = Integer.parseInt(string6);
        }
        int n3 = n2;
        Node node3 = node2.getFirstChild();
        if (string != null && string.length() > 0) {
            Expr expr = (Expr)this.xpath.compile(string);
            abstractNumberNode = new NumberNode(expr, templateNode, string3, n, string5, n3);
        } else {
            String string7 = Stylesheet.getAttribute(namedNodeMap, "level");
            int n4 = 1;
            if (!"multiple".equals(string7)) {
                n4 = "any".equals(string7) ? 2 : 0;
            }
            int n5 = n4;
            String string8 = Stylesheet.getAttribute(namedNodeMap, "count");
            String string9 = Stylesheet.getAttribute(namedNodeMap, "from");
            Pattern pattern2 = null;
            Pattern pattern3 = null;
            if (string8 != null) {
                try {
                    pattern2 = (Pattern)this.xpath.compile(string8);
                }
                catch (ClassCastException classCastException) {
                    String string10 = "invalid pattern: " + string8;
                    throw new TransformerConfigurationException(string10);
                }
            }
            if (string9 != null) {
                try {
                    pattern3 = (Pattern)this.xpath.compile(string9);
                }
                catch (ClassCastException classCastException) {
                    String string11 = "invalid pattern: " + string9;
                    throw new TransformerConfigurationException(string11);
                }
            }
            abstractNumberNode = new NodeNumberNode(n5, pattern2, pattern3, templateNode, string3, n, string5, n3);
        }
        abstractNumberNode.children = this.parse(node3);
        return abstractNumberNode;
    }

    final TemplateNode parseCopyOf(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getRequiredAttribute(namedNodeMap, "select", node2);
        Expr expr = (Expr)this.xpath.compile(string);
        Node node3 = node2.getFirstChild();
        CopyOfNode copyOfNode = new CopyOfNode(expr);
        copyOfNode.children = this.parse(node3);
        return copyOfNode;
    }

    final TemplateNode parseMessage(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = Stylesheet.getAttribute(namedNodeMap, "terminate");
        boolean bl = "yes".equals(string);
        Node node3 = node2.getFirstChild();
        MessageNode messageNode = new MessageNode(bl);
        messageNode.children = this.parse(node3);
        return messageNode;
    }

    final TemplateNode parse(Node node2) throws TransformerConfigurationException {
        TemplateNode templateNode = null;
        TemplateNode templateNode2 = null;
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            TemplateNode templateNode3 = this.doParse(node2);
            if (templateNode3 != null) {
                if (templateNode == null) {
                    templateNode = templateNode3;
                }
                if (templateNode2 != null) {
                    templateNode2.next = templateNode3;
                }
                templateNode2 = templateNode3;
            }
            node2 = node3;
        }
        return templateNode;
    }

    /*
     * Exception decompiling
     */
    private final TemplateNode doParse(Node var1_1) throws TransformerConfigurationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CASE]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final List parseSortKeys(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        LinkedList linkedList = new LinkedList();
        while (node2 != null) {
            String string = node2.getNamespaceURI();
            if (XSL_NS.equals(string) && 1 == node2.getNodeType() && "sort".equals(node2.getLocalName())) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                String string2 = Stylesheet.getAttribute(namedNodeMap, "select");
                if (string2 == null) {
                    string2 = ".";
                }
                Expr expr = (Expr)this.xpath.compile(string2);
                String string3 = Stylesheet.getAttribute(namedNodeMap, "lang");
                TemplateNode templateNode = string3 == null ? null : this.parseAttributeValueTemplate(string3, node2);
                String string4 = Stylesheet.getAttribute(namedNodeMap, "data-type");
                TemplateNode templateNode2 = string4 == null ? null : this.parseAttributeValueTemplate(string4, node2);
                String string5 = Stylesheet.getAttribute(namedNodeMap, "order");
                TemplateNode templateNode3 = string5 == null ? null : this.parseAttributeValueTemplate(string5, node2);
                String string6 = Stylesheet.getAttribute(namedNodeMap, "case-order");
                TemplateNode templateNode4 = string6 == null ? null : this.parseAttributeValueTemplate(string6, node2);
                linkedList.add(new SortKey(expr, templateNode, templateNode2, templateNode3, templateNode4));
            }
            node2 = node2.getNextSibling();
        }
        return linkedList.isEmpty() ? null : linkedList;
    }

    final List parseWithParams(Node node2) throws TransformerConfigurationException, XPathExpressionException {
        LinkedList linkedList = new LinkedList();
        while (node2 != null) {
            String string = node2.getNamespaceURI();
            if (XSL_NS.equals(string) && 1 == node2.getNodeType() && "with-param".equals(node2.getLocalName())) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                TemplateNode templateNode = this.parse(node2.getFirstChild());
                QName qName = this.getQName(Stylesheet.getRequiredAttribute(namedNodeMap, "name", node2));
                String string2 = Stylesheet.getAttribute(namedNodeMap, "select");
                if (string2 != null) {
                    Object object;
                    if (templateNode != null) {
                        object = "parameter '" + qName + "' has both select and content";
                        DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
                        throw new TransformerConfigurationException((String)object, dOMSourceLocator);
                    }
                    object = (Expr)this.xpath.compile(string2);
                    linkedList.add(new WithParam(qName, (Expr)object));
                } else {
                    linkedList.add(new WithParam(qName, templateNode));
                }
            }
            node2 = node2.getNextSibling();
        }
        return linkedList.isEmpty() ? null : linkedList;
    }

    final void addNamespaceNodes(Node node2, Node node3, Document document, Collection collection) {
        Node node4;
        NamedNodeMap namedNodeMap = node2.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node5 = namedNodeMap.item(n2);
                String string = node5.getNamespaceURI();
                if (string == "http://www.w3.org/2000/xmlns/") {
                    String string2;
                    String string3 = node5.getLocalName();
                    if ("xmlns".equals(string3)) {
                        string3 = "#default";
                    }
                    if (!(XSL_NS.equals(string2 = node5.getNodeValue()) || this.extensionElementPrefixes.contains(string3) || collection.contains(string3) || this.excludeResultPrefixes.contains(string3))) {
                        if (string3 == "#default") {
                            string3 = null;
                        }
                        if (node3.lookupNamespaceURI(string3) == null) {
                            node5 = node5.cloneNode(true);
                            node5 = document.adoptNode(node5);
                            node3.getAttributes().setNamedItemNS(node5);
                        }
                    }
                }
                ++n2;
            }
        }
        if ((node4 = node2.getParentNode()) != null) {
            this.addNamespaceNodes(node4, node3, document, collection);
        }
    }

    static final String getAttribute(NamedNodeMap namedNodeMap, String string) {
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        String string2 = node2.getNodeValue();
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    static final String getRequiredAttribute(NamedNodeMap namedNodeMap, String string, Node node2) throws TransformerConfigurationException {
        String string2 = Stylesheet.getAttribute(namedNodeMap, string);
        if (string2 == null || string2.length() == 0) {
            String string3 = string + " attribute is required on " + node2.getNodeName();
            DOMSourceLocator dOMSourceLocator = new DOMSourceLocator(node2);
            throw new TransformerConfigurationException(string3, dOMSourceLocator);
        }
        return string2;
    }

    public void handle(short s, String string, Object object, Node node2, Node node3) {
        node3.setUserData(string, object, this);
    }

    Stylesheet(TransformerFactoryImpl transformerFactoryImpl, Stylesheet stylesheet, Document document, String string, int n) throws TransformerConfigurationException {
        Object object;
        this.factory = transformerFactoryImpl;
        this.systemId = string;
        this.precedence = n;
        this.parent = stylesheet;
        this.extensionElementPrefixes = new HashSet();
        this.excludeResultPrefixes = new HashSet();
        this.stripSpace = new LinkedHashSet();
        this.preserveSpace = new LinkedHashSet();
        this.outputCdataSectionElements = new LinkedHashSet();
        this.xpath = (XPathImpl)transformerFactoryImpl.xpathFactory.newXPath();
        this.xpath.setNamespaceContext(this);
        if (stylesheet == null) {
            this.bindings = new Bindings(this);
            this.attributeSets = new LinkedList();
            this.variables = new LinkedList();
            this.namespaceAliases = new LinkedHashMap();
            this.templates = new LinkedList();
            this.keys = new LinkedList();
            this.decimalFormats = new LinkedHashMap();
            this.initDefaultDecimalFormat();
            this.xpath.setXPathFunctionResolver(this);
        } else {
            object = this;
            while (((Stylesheet)object).parent != null) {
                if (string != null && string.equals(((Stylesheet)object).parent.systemId)) {
                    String string2 = "circularity importing " + string;
                    throw new TransformerConfigurationException(string2);
                }
                object = ((Stylesheet)object).parent;
            }
            object = this.getRootStylesheet();
            this.bindings = ((Stylesheet)object).bindings;
            this.attributeSets = ((Stylesheet)object).attributeSets;
            this.variables = ((Stylesheet)object).variables;
            this.namespaceAliases = ((Stylesheet)object).namespaceAliases;
            this.templates = ((Stylesheet)object).templates;
            this.keys = ((Stylesheet)object).keys;
            this.decimalFormats = ((Stylesheet)object).decimalFormats;
            this.xpath.setXPathFunctionResolver((XPathFunctionResolver)object);
        }
        this.xpath.setXPathVariableResolver(this.bindings);
        object = new NodeTypeTest(0);
        List list2 = Collections.singletonList(object);
        this.builtInNodeTemplate = new ApplyTemplatesNode(new Selector(3, list2), null, null, null, true);
        this.builtInTextTemplate = new ValueOfNode(new Selector(12, list2), false);
        this.parse(document.getDocumentElement(), true);
        this.current = document;
        this.debug = "yes".equals(System.getProperty("xsl.debug"));
        if (this.debug) {
            System.err.println("Stylesheet: " + document.getDocumentURI());
            Iterator iterator = this.templates.iterator();
            while (iterator.hasNext()) {
                Template template = (Template)iterator.next();
                template.list(System.err);
                System.err.println("--------------------");
            }
        }
    }
}

