/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class DateType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            block13: {
                char c = string.charAt(n4);
                if (c == '-' && n4 == 0) {
                    ++n3;
                } else if (c < '0' || c > '9') {
                    switch (n2) {
                        case 0: {
                            if (c != '-') break;
                            String string2 = string.substring(n3, n4);
                            if ("0000".equals(string2) || string2.length() < 4) {
                                throw new DatatypeException(n4, "invalid date value");
                            }
                            n2 = 1;
                            n3 = n4 + 1;
                            break block13;
                        }
                        case 1: {
                            if (c != '-') break;
                            if (n4 - n3 != 2) {
                                throw new DatatypeException(n4, "invalid date value");
                            }
                            n2 = 2;
                            n3 = n4 + 1;
                            break block13;
                        }
                    }
                    throw new DatatypeException(n4, "invalid date value");
                }
            }
            ++n4;
        }
        switch (n2) {
            case 2: {
                if (n - n3 == 2) break;
                throw new DatatypeException("invalid date value");
            }
            default: {
                throw new DatatypeException("invalid date value");
            }
        }
    }

    public final Object createValue(String string, ValidationContext validationContext) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(10, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        try {
            int n4;
            int n5 = 0;
            while (n5 < n) {
                n4 = string.charAt(n5);
                if (n4 == 45 && n5 == 0) {
                    ++n3;
                } else if (n4 < 48 || n4 > 57) {
                    switch (n2) {
                        case 0: {
                            if (n4 != 45) break;
                            gregorianCalendar.set(1, Integer.parseInt(string.substring(0, n5)));
                            n2 = 1;
                            n3 = n5 + 1;
                            break;
                        }
                        case 1: {
                            if (n4 != 45) break;
                            gregorianCalendar.set(2, Integer.parseInt(string.substring(n3, n5)));
                            n2 = 2;
                            n3 = n5 + 1;
                            break;
                        }
                        case 2: {
                            if (n4 != 84) break;
                            gregorianCalendar.set(5, Integer.parseInt(string.substring(n3, n5)));
                            n2 = 7;
                            n3 = n5 + 1;
                            break;
                        }
                    }
                }
                ++n5;
            }
            if (n - n3 > 0 && n2 == 7) {
                String string2 = string.substring(n - n3);
                n4 = string2.indexOf(58);
                if (n4 == -1) {
                    TimeZone timeZone;
                    if ("Z".equals(string2)) {
                        string2 = "UTC";
                    }
                    if ((timeZone = TimeZone.getTimeZone(string2)) == null) {
                        return null;
                    }
                    gregorianCalendar.set(15, timeZone.getRawOffset());
                } else {
                    String string3 = string2.substring(0, n4);
                    String string4 = string2.substring(n4 + 1);
                    int n6 = Integer.parseInt(string3) * 360000;
                    n6 = n6 < 0 ? (n6 -= Integer.parseInt(string4) * 60000) : (n6 += Integer.parseInt(string4) * 60000);
                    gregorianCalendar.set(15, n6);
                }
            }
            return gregorianCalendar.getTime();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    DateType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "date"), TypeLibrary.ANY_SIMPLE_TYPE);
    }
}

