/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public final class BandedSampleModel
extends ComponentSampleModel {
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] sampleSize;
    private int dataBitOffset;
    private int elemBits;
    private int numberOfBits;
    private int numElems;

    private static final int[] createBankArray(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return nArray;
    }

    public final SampleModel createCompatibleSampleModel(int n, int n2) {
        int n3;
        int n4;
        int[] nArray = new int[this.bandOffsets.length];
        int[] nArray2 = new int[this.bandOffsets.length];
        int n5 = 0;
        while (n5 < this.bandOffsets.length) {
            nArray2[n5] = n5;
            ++n5;
        }
        n5 = 0;
        while (n5 < this.bandOffsets.length) {
            n4 = n5 + 1;
            while (n4 < this.bandOffsets.length) {
                if (this.bankIndices[nArray2[n5]] > this.bankIndices[nArray2[n4]] || this.bankIndices[nArray2[n5]] == this.bankIndices[nArray2[n4]] && this.bandOffsets[nArray2[n5]] > this.bandOffsets[nArray2[n4]]) {
                    n3 = nArray2[n5];
                    nArray2[n5] = nArray2[n4];
                    nArray2[n4] = n3;
                }
                ++n5;
            }
            ++n5;
        }
        n5 = 0;
        n4 = 0;
        n3 = 0;
        while (n3 < this.bandOffsets.length) {
            if (this.bankIndices[nArray2[n3]] != n5) {
                n5 = this.bankIndices[nArray2[n3]];
                n4 = 0;
            }
            nArray[nArray2[n3]] = n4;
            n4 += n * this.scanlineStride;
            ++n3;
        }
        return new BandedSampleModel(this.dataType, n, n2, this.scanlineStride, this.bankIndices, nArray);
    }

    public final SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.bankIndices.length) {
            throw new RasterFormatException("BandedSampleModel createSubsetSampleModel too many bands");
        }
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            nArray2[n] = this.bandOffsets[n2];
            nArray3[n] = this.bankIndices[n2];
            ++n;
        }
        return new BandedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray3, nArray2);
    }

    public final Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getSample(n, n2, 0, dataBuffer);
        switch (this.getTransferType()) {
            case 0: {
                byte[] byArray = (byte[])object;
                if (byArray == null) {
                    byArray = new byte[this.numBands];
                }
                int n4 = 0;
                while (n4 < this.numBands) {
                    byArray[n4] = (byte)this.getSample(n, n2, n4, dataBuffer);
                    ++n4;
                }
                return byArray;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                if (sArray == null) {
                    sArray = new short[this.numBands];
                }
                int n5 = 0;
                while (n5 < this.numBands) {
                    sArray[n5] = (short)this.getSample(n, n2, n5, dataBuffer);
                    ++n5;
                }
                return sArray;
            }
            case 3: {
                int[] nArray = (int[])object;
                if (nArray == null) {
                    nArray = new int[this.numBands];
                }
                int n6 = 0;
                while (n6 < this.numBands) {
                    nArray[n6] = this.getSample(n, n2, n6, dataBuffer);
                    ++n6;
                }
                return nArray;
            }
            case 4: {
                float[] fArray = (float[])object;
                if (fArray == null) {
                    fArray = new float[this.numBands];
                }
                int n7 = 0;
                while (n7 < this.numBands) {
                    fArray[n7] = this.getSampleFloat(n, n2, n7, dataBuffer);
                    ++n7;
                }
                return fArray;
            }
            case 5: {
                double[] dArray = (double[])object;
                if (dArray == null) {
                    dArray = new double[this.numBands];
                }
                int n8 = 0;
                while (n8 < this.numBands) {
                    dArray[n8] = this.getSample(n, n2, n8, dataBuffer);
                    ++n8;
                }
                return dArray;
            }
        }
        throw new ClassCastException();
    }

    public final int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        int n3 = 0;
        while (n3 < this.numBands) {
            nArray[n3] = this.getSample(n, n2, n3, dataBuffer);
            ++n3;
        }
        return nArray;
    }

    public final int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        if (nArray == null) {
            nArray = new int[n3 * n4 * this.numBands];
        }
        int n5 = 0;
        int n6 = n + n3;
        int n7 = n2 + n4;
        int n8 = n;
        while (n8 < n7) {
            int n9 = n;
            while (n9 < n6) {
                int n10 = 0;
                while (n10 < this.numBands) {
                    int n11 = this.bandOffsets[n10] + n8 * this.scanlineStride + n9;
                    nArray[n5++] = dataBuffer.getElem(this.bankIndices[n10], n11);
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
        return nArray;
    }

    public final int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = this.bandOffsets[n3] + n2 * this.scanlineStride + n;
        return dataBuffer.getElem(this.bankIndices[n3], n4);
    }

    public final float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = this.bandOffsets[n3] + n2 * this.scanlineStride + n;
        return dataBuffer.getElemFloat(this.bankIndices[n3], n4);
    }

    public final double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = this.bandOffsets[n3] + n2 * this.scanlineStride + n;
        return dataBuffer.getElemDouble(this.bankIndices[n3], n4);
    }

    public final int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (nArray == null) {
            nArray = new int[n3 * n4];
        }
        int n6 = 0;
        int n7 = n + n3;
        int n8 = n2 + n4;
        int n9 = n2;
        while (n9 < n8) {
            int n10 = n;
            while (n10 < n7) {
                int n11 = this.bandOffsets[n5] + n9 * this.scanlineStride + n10;
                nArray[n6++] = dataBuffer.getElem(this.bankIndices[n5], n11);
                ++n10;
            }
            ++n9;
        }
        return nArray;
    }

    public final void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        if (this.getTransferType() != dataBuffer.getDataType()) {
            throw new IllegalArgumentException("transfer type (" + this.getTransferType() + "), does not match data buffer type (" + dataBuffer.getDataType() + ").");
        }
        int n4 = n2 * this.scanlineStride + n;
        try {
            switch (n3) {
                case 0: {
                    DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                    byte[] byArray = (byte[])object;
                    int n5 = 0;
                    while (n5 < this.numBands) {
                        dataBufferByte.getData((int)this.bankIndices[n5])[n4 + this.bandOffsets[n5]] = byArray[n5];
                        ++n5;
                    }
                    return;
                }
                case 2: {
                    DataBufferShort dataBufferShort = (DataBufferShort)dataBuffer;
                    short[] sArray = (short[])object;
                    int n6 = 0;
                    while (n6 < this.numBands) {
                        dataBufferShort.getData((int)this.bankIndices[n6])[n4 + this.bandOffsets[n6]] = sArray[n6];
                        ++n6;
                    }
                    return;
                }
                case 1: {
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
                    short[] sArray = (short[])object;
                    int n7 = 0;
                    while (n7 < this.numBands) {
                        dataBufferUShort.getData((int)this.bankIndices[n7])[n4 + this.bandOffsets[n7]] = sArray[n7];
                        ++n7;
                    }
                    return;
                }
                case 3: {
                    DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                    int[] nArray = (int[])object;
                    int n8 = 0;
                    while (n8 < this.numBands) {
                        dataBufferInt.getData((int)this.bankIndices[n8])[n4 + this.bandOffsets[n8]] = nArray[n8];
                        ++n8;
                    }
                    return;
                }
                case 4: {
                    DataBufferFloat dataBufferFloat = (DataBufferFloat)dataBuffer;
                    float[] fArray = (float[])object;
                    int n9 = 0;
                    while (n9 < this.numBands) {
                        dataBufferFloat.getData((int)this.bankIndices[n9])[n4 + this.bandOffsets[n9]] = fArray[n9];
                        ++n9;
                    }
                    return;
                }
                case 5: {
                    DataBufferDouble dataBufferDouble = (DataBufferDouble)dataBuffer;
                    double[] dArray = (double[])object;
                    int n10 = 0;
                    while (n10 < this.numBands) {
                        dataBufferDouble.getData((int)this.bankIndices[n10])[n4 + this.bandOffsets[n10]] = dArray[n10];
                        ++n10;
                    }
                    return;
                }
            }
            throw new ClassCastException("Unsupported data type");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = "While writing data elements, x=" + n + ", y=" + n2 + ", width=" + this.width + ", height=" + this.height + ", scanlineStride=" + this.scanlineStride + ", offset=" + n4 + ", data.getSize()=" + dataBuffer.getSize() + ", data.getOffset()=" + dataBuffer.getOffset() + ": " + arrayIndexOutOfBoundsException;
            throw new ArrayIndexOutOfBoundsException(string);
        }
    }

    public final void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = 0;
        while (n3 < this.numBands) {
            dataBuffer.setElem(this.bankIndices[n3], this.bandOffsets[n3] + n2 * this.scanlineStride + n, nArray[n3]);
            ++n3;
        }
    }

    public final void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < n3) {
                int n8 = n2 * this.scanlineStride + (n + n7);
                int n9 = 0;
                while (n9 < this.numBands) {
                    dataBuffer.setElem(this.bankIndices[n9], this.bandOffsets[n9] + n8, nArray[n5++]);
                    ++n9;
                }
                ++n7;
            }
            ++n2;
            ++n6;
        }
    }

    public final void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        dataBuffer.setElem(this.bankIndices[n3], this.bandOffsets[n3] + n2 * this.scanlineStride + n, n4);
    }

    public final void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
        dataBuffer.setElemFloat(this.bankIndices[n3], this.bandOffsets[n3] + n2 * this.scanlineStride + n, f);
    }

    public final void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
        dataBuffer.setElemDouble(this.bankIndices[n3], this.bandOffsets[n3] + n2 * this.scanlineStride + n, d);
    }

    public final void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = 0;
        switch (this.getTransferType()) {
            case 0: {
                DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                byte[] byArray = dataBufferByte.getData(this.bankIndices[n5]);
                int n7 = 0;
                while (n7 < n4) {
                    int n8 = 0;
                    while (n8 < n3) {
                        int n9 = this.bandOffsets[n5] + n2 * this.scanlineStride + (n + n8);
                        byArray[n9] = (byte)nArray[n6++];
                        ++n8;
                    }
                    ++n2;
                    ++n7;
                }
                return;
            }
            case 2: {
                DataBufferShort dataBufferShort = (DataBufferShort)dataBuffer;
                short[] sArray = dataBufferShort.getData(this.bankIndices[n5]);
                int n10 = 0;
                while (n10 < n4) {
                    int n11 = 0;
                    while (n11 < n3) {
                        int n12 = this.bandOffsets[n5] + n2 * this.scanlineStride + (n + n11);
                        sArray[n12] = (short)nArray[n6++];
                        ++n11;
                    }
                    ++n2;
                    ++n10;
                }
                return;
            }
            case 1: {
                DataBufferShort dataBufferShort = (DataBufferShort)dataBuffer;
                short[] sArray = dataBufferShort.getData(this.bankIndices[n5]);
                int n13 = 0;
                while (n13 < n4) {
                    int n14 = 0;
                    while (n14 < n3) {
                        int n15 = this.bandOffsets[n5] + n2 * this.scanlineStride + (n + n14);
                        sArray[n15] = (short)nArray[n6++];
                        ++n14;
                    }
                    ++n2;
                    ++n13;
                }
                return;
            }
            case 3: {
                DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                int[] nArray2 = dataBufferInt.getData(this.bankIndices[n5]);
                int n16 = 0;
                while (n16 < n4) {
                    int n17 = 0;
                    while (n17 < n3) {
                        int n18 = this.bandOffsets[n5] + n2 * this.scanlineStride + (n + n17);
                        nArray2[n18] = nArray[n6++];
                        ++n17;
                    }
                    ++n2;
                    ++n16;
                }
                return;
            }
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new ClassCastException("Unsupported data type");
            }
        }
        int n19 = 0;
        while (n19 < n4) {
            int n20 = 0;
            while (n20 < n3) {
                int n21 = this.bandOffsets[n5] + n2 * this.scanlineStride + (n + n20);
                dataBuffer.setElem(this.bankIndices[n5], n21, nArray[n6++]);
                ++n20;
            }
            ++n2;
            ++n19;
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[");
        stringBuffer.append("scanlineStride=").append(this.scanlineStride);
        int n = 0;
        while (n < this.bitMasks.length) {
            stringBuffer.append(", mask[").append(n).append("]=0x").append(Integer.toHexString(this.bitMasks[n]));
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public BandedSampleModel(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n2, BandedSampleModel.createBankArray(n4), new int[n4]);
    }

    public BandedSampleModel(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        super(n, n2, n3, 1, n4, nArray, nArray2);
    }
}

