/* $MirOS: src/include/sfv.h,v 1.2 2013/10/31 20:06:08 tg Exp $ */

#ifndef _SFV_H
#define _SFV_H

#define SFV_DIGEST_LENGTH		4
#define SFV_DIGEST_STRING_LENGTH	(SFV_DIGEST_LENGTH * 2 + 1)

typedef struct {
	uint64_t len;
	uint32_t crc;
} SFV_CTX;

#define SFV_DIGEST_UPPERCASE

#include <sys/cdefs.h>

__BEGIN_DECLS
void SFVInit(SFV_CTX *);
void SFVPad(SFV_CTX *);
void SFVUpdate(SFV_CTX *, const uint8_t *, size_t)
	;
void SFVFinal(uint8_t *, SFV_CTX *)
	;
char *SFVEnd(SFV_CTX *, char *)
	;
char *SFVFile(const char *, char *)
	;
char *SFVFileChunk(const char *, char *, off_t, off_t)
	;
char *SFVData(const uint8_t *, size_t, char *)
	
	;
__END_DECLS

#endif
