/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openide.util.Parameters;

public final class Enumerations {
    private Enumerations() {
    }

    public static final <T> Enumeration<T> empty() {
        List emptyL = Collections.emptyList();
        return Collections.enumeration(emptyL);
    }

    public static <T> Enumeration<T> singleton(T obj) {
        return Collections.enumeration(Collections.singleton(obj));
    }

    public static <T> Enumeration<T> concat(Enumeration<? extends T> en1, Enumeration<? extends T> en2) {
        ArrayList<Enumeration<? extends T>> two = new ArrayList<Enumeration<? extends T>>();
        two.add(en1);
        two.add(en2);
        return new SeqEn(Collections.enumeration(two));
    }

    public static <T> Enumeration<T> concat(Enumeration<? extends Enumeration<? extends T>> enumOfEnums) {
        return new SeqEn(enumOfEnums);
    }

    public static <T> Enumeration<T> removeDuplicates(Enumeration<T> en) {
        class RDupls
        implements Processor<T, T> {
            private Set<T> set = new HashSet();

            RDupls() {
            }

            @Override
            public T process(T o, Collection<T> nothing) {
                return this.set.add(o) ? o : null;
            }
        }
        return Enumerations.filter(en, new RDupls());
    }

    public static <T> Enumeration<T> array(T ... arr) {
        return Collections.enumeration(Arrays.asList(arr));
    }

    public static <T> Enumeration<T> removeNulls(Enumeration<T> en) {
        return Enumerations.filter(en, new RNulls());
    }

    public static <T, R> Enumeration<R> convert(Enumeration<? extends T> en, Processor<T, R> processor) {
        return new AltEn<T, R>(en, processor);
    }

    public static <T, R> Enumeration<R> filter(Enumeration<? extends T> en, Processor<T, R> filter) {
        Parameters.notNull("en", en);
        Parameters.notNull("filter", filter);
        return new FilEn<T, R>(en, filter);
    }

    public static <T, R> Enumeration<R> queue(Enumeration<? extends T> en, Processor<T, R> filter) {
        QEn<T, R> q = new QEn<T, R>(filter);
        while (en.hasMoreElements()) {
            q.put(en.nextElement());
        }
        return q;
    }

    private static final class AltEn<T, R>
    implements Enumeration<R> {
        private Enumeration<? extends T> en;
        private Processor<T, R> process;

        public AltEn(Enumeration<? extends T> en, Processor<T, R> process) {
            this.en = en;
            this.process = process;
        }

        @Override
        public boolean hasMoreElements() {
            return this.en.hasMoreElements();
        }

        @Override
        public R nextElement() {
            return this.process.process(this.en.nextElement(), null);
        }
    }

    private static final class FilEn<T, R>
    implements Enumeration<R> {
        private static final Object EMPTY = new Object();
        private Enumeration<? extends T> en;
        private R next = this.empty();
        private Processor<T, R> filter;

        public FilEn(Enumeration<? extends T> en, Processor<T, R> filter) {
            this.en = en;
            this.filter = filter;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.next != this.empty()) {
                return true;
            }
            while (this.en.hasMoreElements()) {
                this.next = this.filter.process(this.en.nextElement(), null);
                if (this.next == null) continue;
                return true;
            }
            this.next = this.empty();
            return false;
        }

        @Override
        public R nextElement() {
            if (this.next == EMPTY && !this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            R res = this.next;
            this.next = this.empty();
            return res;
        }

        private R empty() {
            return (R)EMPTY;
        }
    }

    public static interface Processor<T, R> {
        public R process(T var1, Collection<T> var2);
    }

    private static class QEn<T, R>
    implements Enumeration<R> {
        private ListItem<T> next = null;
        private ListItem<T> last = null;
        private Processor<T, R> processor;

        public QEn(Processor<T, R> p) {
            this.processor = p;
        }

        public void put(T o) {
            if (this.last != null) {
                ListItem<T> li = new ListItem<T>(o);
                this.last.next = li;
                this.last = li;
            } else {
                this.last = new ListItem<T>(o);
                this.next = this.last;
            }
        }

        public void put(Collection<? extends T> arr) {
            for (T e : arr) {
                this.put(e);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public R nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object res = this.next.object;
            this.next = this.next.next;
            if (this.next == null) {
                this.last = null;
            }
            ToAdd toAdd = new ToAdd(this);
            R out = this.processor.process(res, toAdd);
            toAdd.finish();
            return out;
        }

        private static final class ListItem<T> {
            T object;
            ListItem<T> next;

            ListItem(T o) {
                this.object = o;
            }
        }

        private static final class ToAdd<T, R>
        implements Collection<T> {
            private QEn<T, R> q;

            public ToAdd(QEn<T, R> q) {
                this.q = q;
            }

            public void finish() {
                this.q = null;
            }

            @Override
            public boolean add(T o) {
                this.q.put(o);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                this.q.put(c);
                return true;
            }

            private String msg() {
                return "Only add and addAll are implemented";
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public boolean containsAll(Collection c) {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public boolean isEmpty() {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public Iterator<T> iterator() {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public boolean removeAll(Collection c) {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public boolean retainAll(Collection c) {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public <X> X[] toArray(X[] a) {
                throw new UnsupportedOperationException(this.msg());
            }
        }
    }

    private static class RNulls<T>
    implements Processor<T, T> {
        private RNulls() {
        }

        @Override
        public T process(T original, Collection<T> toAdd) {
            return original;
        }
    }

    private static final class SeqEn<T>
    implements Enumeration<T> {
        private Enumeration<? extends Enumeration<? extends T>> en;
        private Enumeration<? extends T> current;
        private boolean checked = false;

        public SeqEn(Enumeration<? extends Enumeration<? extends T>> en) {
            this.en = en;
        }

        private void ensureCurrent() {
            while (this.current == null || !this.current.hasMoreElements()) {
                if (this.en.hasMoreElements()) {
                    this.current = this.en.nextElement();
                    continue;
                }
                this.current = null;
                return;
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (!this.checked) {
                this.ensureCurrent();
                this.checked = true;
            }
            return this.current != null;
        }

        @Override
        public T nextElement() {
            if (!this.checked) {
                this.ensureCurrent();
            }
            if (this.current != null) {
                this.checked = false;
                return this.current.nextElement();
            }
            this.checked = true;
            throw new NoSuchElementException();
        }
    }
}

