/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Enumerated;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.LinkedList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class CertificateRequest
implements Handshake.Body {
    private final ClientType[] types;
    private final Principal[] authorities;
    static /* synthetic */ Class class$java$lang$String;

    static final CertificateRequest read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ClientType[] clientTypeArray = new ClientType[dataInputStream.readUnsignedByte()];
        int n = 0;
        while (n < clientTypeArray.length) {
            clientTypeArray[n] = ClientType.read(dataInputStream);
            ++n;
        }
        LinkedList linkedList = new LinkedList();
        byte[] byArray = new byte[dataInputStream.readUnsignedShort()];
        dataInputStream.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            String string = Util.getSecurityProperty("jessie.x500.class");
            if (string == null) {
                string = "org.metastatic.jessie.pki.X500Name";
            }
            Class clazz = null;
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            Constructor constructor = clazz.getConstructor(new Class[]{new byte[0].getClass()});
            while (byteArrayInputStream.available() > 0) {
                byArray = new byte[(byteArrayInputStream.read() & 0xFF) << 8 | byteArrayInputStream.read() & 0xFF];
                byteArrayInputStream.read(byArray);
                linkedList.add(constructor.newInstance(new Object[]{byArray}));
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new Error(exception.toString());
        }
        return new CertificateRequest(clientTypeArray, (Principal[])linkedList.toArray(new Principal[linkedList.size()]));
    }

    public final void write(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        outputStream.write(this.types.length);
        int n = 0;
        while (n < this.types.length) {
            outputStream.write(this.types[n].getValue());
            ++n;
        }
        try {
            Class clazz = this.authorities[0].getClass();
            Method method = clazz.getMethod("getEncoded", null);
            int n2 = 0;
            while (n2 < this.authorities.length) {
                byte[] byArray = (byte[])method.invoke(this.authorities[n2], null);
                byteArrayOutputStream.write(byArray.length >>> 8 & 0xFF);
                byteArrayOutputStream.write(byArray.length & 0xFF);
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new Error(exception.toString());
        }
        outputStream.write(byteArrayOutputStream.size() >>> 8 & 0xFF);
        outputStream.write(byteArrayOutputStream.size() & 0xFF);
        byteArrayOutputStream.writeTo(outputStream);
    }

    final ClientType[] getTypes() {
        return this.types;
    }

    final String[] getTypeStrings() {
        try {
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = CertificateRequest.class("[Ljava.lang.String;", false);
            }
            return (String[])Util.transform(this.types, clazz, "toString", null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    final Principal[] getAuthorities() {
        return this.authorities;
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("struct {");
        printWriter.print("  types = ");
        int n = 0;
        while (n < this.types.length) {
            printWriter.print(this.types[n]);
            if (n != this.types.length - 1) {
                printWriter.print(", ");
            }
            ++n;
        }
        printWriter.println(";");
        printWriter.println("  authorities =");
        n = 0;
        while (n < this.authorities.length) {
            printWriter.print("    ");
            printWriter.print(this.authorities[n].getName());
            if (n != this.types.length - 1) {
                printWriter.println(",");
            }
            ++n;
        }
        printWriter.println(";");
        printWriter.println("} CertificateRequest;");
        return stringWriter.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    CertificateRequest(ClientType[] clientTypeArray, Principal[] principalArray) {
        if (clientTypeArray == null) {
            throw new NullPointerException();
        }
        this.types = clientTypeArray;
        if (principalArray == null) {
            throw new NullPointerException();
        }
        this.authorities = principalArray;
    }

    static final class ClientType
    implements Enumerated {
        static final ClientType RSA_SIGN = new ClientType(1);
        static final ClientType DSS_SIGN = new ClientType(2);
        static final ClientType RSA_FIXED_DH = new ClientType(3);
        static final ClientType DSS_FIXED_DH = new ClientType(4);
        private final int value;

        static final ClientType read(InputStream inputStream) throws IOException {
            int n = inputStream.read();
            if (n == -1) {
                throw new EOFException("unexpected end of input stream");
            }
            switch (n & 0xFF) {
                case 1: {
                    return RSA_SIGN;
                }
                case 2: {
                    return DSS_SIGN;
                }
                case 3: {
                    return RSA_FIXED_DH;
                }
                case 4: {
                    return DSS_FIXED_DH;
                }
            }
            return new ClientType(n);
        }

        public final byte[] getEncoded() {
            return new byte[]{(byte)this.value};
        }

        public final int getValue() {
            return this.value;
        }

        public final String toString() {
            switch (this.value) {
                case 1: {
                    return "rsa_sign";
                }
                case 2: {
                    return "dss_sign";
                }
                case 3: {
                    return "rsa_fixed_dh";
                }
                case 4: {
                    return "dss_fixed_dh";
                }
            }
            return "unknown(" + this.value + ')';
        }

        private ClientType(int n) {
            this.value = n;
        }
    }
}

