/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Constructed;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class ProtocolVersion
implements Comparable,
Constructed {
    static final ProtocolVersion SSL_3 = new ProtocolVersion(3, 0);
    static final ProtocolVersion TLS_1 = new ProtocolVersion(3, 1);
    static final ProtocolVersion TLS_1_1 = new ProtocolVersion(3, 2);
    private final int major;
    private final int minor;

    static final ProtocolVersion read(InputStream inputStream) throws IOException {
        int n = inputStream.read() & 0xFF;
        int n2 = inputStream.read() & 0xFF;
        return ProtocolVersion.getInstance(n, n2);
    }

    static final ProtocolVersion getInstance(int n, int n2) {
        if (n == 3) {
            switch (n2) {
                case 0: {
                    return SSL_3;
                }
                case 1: {
                    return TLS_1;
                }
                case 2: {
                    return TLS_1_1;
                }
            }
        }
        return new ProtocolVersion(n, n2);
    }

    public final void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.major);
        outputStream.write(this.minor);
    }

    final byte[] getEncoded() {
        return new byte[]{(byte)this.major, (byte)this.minor};
    }

    final int getMajor() {
        return this.major;
    }

    final int getMinor() {
        return this.minor;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof ProtocolVersion)) {
            return false;
        }
        boolean bl = false;
        if (((ProtocolVersion)object).major == this.major && ((ProtocolVersion)object).minor == this.minor) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return this.major << 8 | this.minor;
    }

    public final int compareTo(Object object) {
        if (object == null || !(object instanceof ProtocolVersion)) {
            return 1;
        }
        if (this.equals(object)) {
            return 0;
        }
        if (this.major > ((ProtocolVersion)object).major) {
            return 1;
        }
        if (this.major < ((ProtocolVersion)object).major) {
            return -1;
        }
        if (this.minor > ((ProtocolVersion)object).minor) {
            return 1;
        }
        if (this.minor < ((ProtocolVersion)object).minor) {
            return -1;
        }
        return 0;
    }

    public final String toString() {
        if (this == SSL_3) {
            return "SSLv3";
        }
        if (this == TLS_1) {
            return "TLSv1";
        }
        if (this == TLS_1_1) {
            return "TLSv1.1";
        }
        return "Unsupported; major=" + this.major + " minor=" + this.minor;
    }

    private ProtocolVersion(int n, int n2) {
        this.major = n;
        this.minor = n2;
    }
}

