/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.text.AttributedFormatBuffer;
import gnu.java.text.FormatBuffer;
import gnu.java.text.FormatCharacterIterator;
import gnu.java.text.StringFormatBuffer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DecimalFormat
extends NumberFormat {
    private static final int MAXIMUM_INTEGER_DIGITS = 309;
    private static final long serialVersionUID = 864413376551465018L;
    private static final DecimalFormatSymbols nonLocalizedSymbols = new DecimalFormatSymbols(Locale.US);
    private boolean decimalSeparatorAlwaysShown;
    private byte groupingSize;
    private byte minExponentDigits;
    private int exponentRound;
    private int multiplier;
    private String negativePrefix;
    private String negativeSuffix;
    private String positivePrefix;
    private String positiveSuffix;
    private int[] negativePrefixRanges;
    private int[] positivePrefixRanges;
    private HashMap[] negativePrefixAttrs;
    private HashMap[] positivePrefixAttrs;
    private int[] negativeSuffixRanges;
    private int[] positiveSuffixRanges;
    private HashMap[] negativeSuffixAttrs;
    private HashMap[] positiveSuffixAttrs;
    private int serialVersionOnStream;
    private DecimalFormatSymbols symbols;
    private boolean useExponentialNotation;

    private final int scanFix(String string, int n, FormatBuffer formatBuffer, String string2, DecimalFormatSymbols decimalFormatSymbols, boolean bl) {
        int n2 = string.length();
        boolean bl2 = false;
        formatBuffer.clear();
        boolean bl3 = false;
        while (n < n2) {
            char c = string.charAt(n);
            if (bl2) {
                if (c == '\'') {
                    bl2 = false;
                } else {
                    formatBuffer.append(c);
                }
                ++n;
                continue;
            }
            if (c == '\'' && n + 1 < n2 && string.charAt(n + 1) == '\'') {
                formatBuffer.append(c);
                ++n;
            } else if (c == '\'') {
                bl2 = true;
            } else if (c == '\u00a4') {
                formatBuffer.append(c);
            } else if (c == decimalFormatSymbols.getPercent()) {
                if (bl3) {
                    throw new IllegalArgumentException("multiplier already set - index: " + n);
                }
                bl3 = true;
                this.multiplier = 100;
                formatBuffer.append(c, (AttributedCharacterIterator.Attribute)NumberFormat.Field.PERCENT);
            } else if (c == decimalFormatSymbols.getPerMill()) {
                if (bl3) {
                    throw new IllegalArgumentException("multiplier already set - index: " + n);
                }
                bl3 = true;
                this.multiplier = 1000;
                formatBuffer.append(c, (AttributedCharacterIterator.Attribute)NumberFormat.Field.PERMILLE);
            } else {
                if (string2.indexOf(c) != -1) break;
                formatBuffer.append(c);
            }
            ++n;
        }
        if (bl2) {
            throw new IllegalArgumentException("pattern is lacking a closing quote");
        }
        return n;
    }

    private final int scanFormat(String string, int n, String string2, DecimalFormatSymbols decimalFormatSymbols, boolean bl) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        while (n < n3) {
            n2 = string.charAt(n);
            if (n2 == decimalFormatSymbols.getDigit()) {
                if (n5 > 0) {
                    throw new IllegalArgumentException("digit mark following zero - index: " + n);
                }
                ++n4;
            } else if (n2 == decimalFormatSymbols.getZeroDigit()) {
                ++n5;
                ++n4;
            } else {
                if (n2 != decimalFormatSymbols.getGroupingSeparator()) break;
                n4 = 0;
                bl2 = true;
            }
            ++n;
        }
        if (bl) {
            this.groupingUsed = bl2;
            this.groupingSize = (byte)n4;
            if (n5 > 0) {
                this.minimumIntegerDigits = n5;
            }
        }
        if (n == n3 || string.charAt(n) == decimalFormatSymbols.getGroupingSeparator()) {
            if (bl) {
                this.decimalSeparatorAlwaysShown = false;
            }
            return n;
        }
        if (string.charAt(n) == decimalFormatSymbols.getDecimalSeparator()) {
            ++n;
            n2 = 0;
            n5 = 0;
            while (n < n3) {
                char c = string.charAt(n);
                if (c == decimalFormatSymbols.getZeroDigit()) {
                    if (n2 > 0) {
                        throw new IllegalArgumentException("zero mark following digit - index: " + n);
                    }
                    ++n5;
                } else if (c == decimalFormatSymbols.getDigit()) {
                    ++n2;
                } else {
                    if (c == decimalFormatSymbols.getExponential() || c == decimalFormatSymbols.getPatternSeparator() || c == decimalFormatSymbols.getPercent() || c == decimalFormatSymbols.getPerMill() || string2.indexOf(c) == -1) break;
                    throw new IllegalArgumentException("unexpected special character - index: " + n);
                }
                ++n;
            }
            if (bl) {
                this.maximumFractionDigits = n2 + n5;
                this.minimumFractionDigits = n5;
            }
            if (n == n3) {
                return n;
            }
        }
        if (string.charAt(n) == decimalFormatSymbols.getExponential()) {
            n5 = 0;
            ++n;
            while (n < n3) {
                n2 = string.charAt(n);
                if (n2 == decimalFormatSymbols.getZeroDigit()) {
                    ++n5;
                } else if (n2 == decimalFormatSymbols.getDigit()) {
                    if (n5 > 0) {
                        throw new IllegalArgumentException("digit mark following zero in exponent - index: " + n);
                    }
                } else {
                    if (string2.indexOf(n2) == -1) break;
                    throw new IllegalArgumentException("unexpected special character - index: " + n);
                }
                ++n;
            }
            if (bl) {
                this.useExponentialNotation = true;
                this.minExponentDigits = (byte)n5;
            }
            this.maximumIntegerDigits = this.groupingSize;
            this.groupingSize = 0;
            if (this.maximumIntegerDigits > this.minimumIntegerDigits && this.maximumIntegerDigits > 0) {
                this.minimumIntegerDigits = 1;
                this.exponentRound = this.maximumIntegerDigits;
            } else {
                this.exponentRound = 1;
            }
        }
        return n;
    }

    private final String patternChars(DecimalFormatSymbols decimalFormatSymbols) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(decimalFormatSymbols.getDecimalSeparator());
        stringBuffer.append(decimalFormatSymbols.getDigit());
        stringBuffer.append(decimalFormatSymbols.getExponential());
        stringBuffer.append(decimalFormatSymbols.getGroupingSeparator());
        stringBuffer.append(decimalFormatSymbols.getPatternSeparator());
        stringBuffer.append(decimalFormatSymbols.getPercent());
        stringBuffer.append(decimalFormatSymbols.getPerMill());
        stringBuffer.append(decimalFormatSymbols.getZeroDigit());
        stringBuffer.append('\u00a4');
        return stringBuffer.toString();
    }

    private final void applyPatternWithSymbols(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.negativePrefix = "";
        this.negativeSuffix = "";
        this.positivePrefix = "";
        this.positiveSuffix = "";
        this.decimalSeparatorAlwaysShown = false;
        this.groupingSize = 0;
        this.minExponentDigits = 0;
        this.multiplier = 1;
        this.useExponentialNotation = false;
        this.groupingUsed = false;
        this.maximumFractionDigits = 0;
        this.maximumIntegerDigits = 309;
        this.minimumFractionDigits = 0;
        this.minimumIntegerDigits = 1;
        AttributedFormatBuffer attributedFormatBuffer = new AttributedFormatBuffer();
        String string2 = this.patternChars(decimalFormatSymbols);
        int n = string.length();
        int n2 = this.scanFix(string, 0, attributedFormatBuffer, string2, decimalFormatSymbols, false);
        attributedFormatBuffer.sync();
        this.positivePrefix = attributedFormatBuffer.getBuffer().toString();
        this.positivePrefixRanges = attributedFormatBuffer.getRanges();
        this.positivePrefixAttrs = attributedFormatBuffer.getAttributes();
        n2 = this.scanFormat(string, n2, string2, decimalFormatSymbols, true);
        n2 = this.scanFix(string, n2, attributedFormatBuffer, string2, decimalFormatSymbols, true);
        attributedFormatBuffer.sync();
        this.positiveSuffix = attributedFormatBuffer.getBuffer().toString();
        this.positiveSuffixRanges = attributedFormatBuffer.getRanges();
        this.positiveSuffixAttrs = attributedFormatBuffer.getAttributes();
        if (n2 == string.length()) {
            this.negativePrefix = null;
            this.negativeSuffix = null;
        } else {
            if (string.charAt(n2) != decimalFormatSymbols.getPatternSeparator()) {
                throw new IllegalArgumentException("separator character expected - index: " + n2);
            }
            n2 = this.scanFix(string, n2 + 1, attributedFormatBuffer, string2, decimalFormatSymbols, false);
            attributedFormatBuffer.sync();
            this.negativePrefix = attributedFormatBuffer.getBuffer().toString();
            this.negativePrefixRanges = attributedFormatBuffer.getRanges();
            this.negativePrefixAttrs = attributedFormatBuffer.getAttributes();
            n2 = this.scanFormat(string, n2, string2, decimalFormatSymbols, false);
            n2 = this.scanFix(string, n2, attributedFormatBuffer, string2, decimalFormatSymbols, true);
            attributedFormatBuffer.sync();
            this.negativeSuffix = attributedFormatBuffer.getBuffer().toString();
            this.negativeSuffixRanges = attributedFormatBuffer.getRanges();
            this.negativeSuffixAttrs = attributedFormatBuffer.getAttributes();
            if (n2 != string.length()) {
                throw new IllegalArgumentException("end of pattern expected - index: " + n2);
            }
        }
    }

    public void applyLocalizedPattern(String string) {
        this.applyPatternWithSymbols(string, this.symbols);
    }

    public void applyPattern(String string) {
        this.applyPatternWithSymbols(string, nonLocalizedSymbols);
    }

    public Object clone() {
        DecimalFormat decimalFormat = (DecimalFormat)super.clone();
        decimalFormat.symbols = (DecimalFormatSymbols)this.symbols.clone();
        return decimalFormat;
    }

    private final boolean equals(String string, String string2) {
        if (string == null || string2 == null) {
            boolean bl = false;
            if (string == string2) {
                bl = true;
            }
            return bl;
        }
        return string.equals(string2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DecimalFormat)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)object;
        boolean bl = false;
        if (this.decimalSeparatorAlwaysShown == decimalFormat.decimalSeparatorAlwaysShown && this.groupingUsed == decimalFormat.groupingUsed && this.groupingSize == decimalFormat.groupingSize && this.multiplier == decimalFormat.multiplier && this.useExponentialNotation == decimalFormat.useExponentialNotation && this.minExponentDigits == decimalFormat.minExponentDigits && this.minimumIntegerDigits == decimalFormat.minimumIntegerDigits && this.maximumIntegerDigits == decimalFormat.maximumIntegerDigits && this.minimumFractionDigits == decimalFormat.minimumFractionDigits && this.maximumFractionDigits == decimalFormat.maximumFractionDigits && this.equals(this.negativePrefix, decimalFormat.negativePrefix) && this.equals(this.negativeSuffix, decimalFormat.negativeSuffix) && this.equals(this.positivePrefix, decimalFormat.positivePrefix) && this.equals(this.positiveSuffix, decimalFormat.positiveSuffix) && this.symbols.equals(decimalFormat.symbols)) {
            bl = true;
        }
        return bl;
    }

    private final void formatInternal(double d, FormatBuffer formatBuffer, FieldPosition fieldPosition) {
        boolean bl;
        if (Double.isNaN(d)) {
            formatBuffer.append(this.symbols.getNaN());
            if (fieldPosition != null && (fieldPosition.getField() == 0 || fieldPosition.getFieldAttribute() == NumberFormat.Field.INTEGER)) {
                int n = formatBuffer.length();
                fieldPosition.setBeginIndex(n - this.symbols.getNaN().length());
                fieldPosition.setEndIndex(n);
            }
            return;
        }
        boolean bl2 = false;
        if (d < 0.0) {
            bl2 = true;
        }
        if (bl = bl2) {
            if (this.negativePrefix != null) {
                formatBuffer.append(this.substituteCurrency(this.negativePrefix, d), this.negativePrefixRanges, this.negativePrefixAttrs);
            } else {
                formatBuffer.append(this.symbols.getMinusSign(), (AttributedCharacterIterator.Attribute)NumberFormat.Field.SIGN);
                formatBuffer.append(this.substituteCurrency(this.positivePrefix, d), this.positivePrefixRanges, this.positivePrefixAttrs);
            }
            d = -d;
        } else {
            formatBuffer.append(this.substituteCurrency(this.positivePrefix, d), this.positivePrefixRanges, this.positivePrefixAttrs);
        }
        int n = formatBuffer.length();
        int n2 = 0;
        int n3 = this.symbols.getZeroDigit() - 48;
        if (Double.isInfinite(d)) {
            formatBuffer.append(this.symbols.getInfinity());
            n2 = formatBuffer.length();
        } else {
            double d2;
            int n4;
            double d3;
            d *= (double)this.multiplier;
            long l = 0L;
            if (this.useExponentialNotation) {
                l = (long)Math.floor(Math.log(d) / Math.log(10.0));
                l -= l % (long)this.exponentRound;
                if (this.minimumIntegerDigits > 0) {
                    l -= (long)(this.minimumIntegerDigits - 1);
                }
                d3 = d / Math.pow(10.0, l);
            } else {
                d3 = d;
            }
            int n5 = formatBuffer.length();
            String string = Long.toString((long)Math.floor(d3 += (double)5 * Math.pow(10.0, -this.maximumFractionDigits - 1)));
            int n6 = string.length();
            formatBuffer.setDefaultAttribute(NumberFormat.Field.INTEGER);
            int n7 = 0;
            while (n7 < this.minimumIntegerDigits - string.length()) {
                formatBuffer.append(this.symbols.getZeroDigit());
                ++n7;
            }
            n7 = 0;
            while (n7 < this.maximumIntegerDigits && n7 < string.length()) {
                n4 = string.charAt(n7);
                if (this.groupingUsed && n7 > 0 && this.groupingSize != 0 && n6 % this.groupingSize == 0) {
                    formatBuffer.append(this.symbols.getGroupingSeparator(), (AttributedCharacterIterator.Attribute)NumberFormat.Field.GROUPING_SEPARATOR);
                    formatBuffer.setDefaultAttribute(NumberFormat.Field.INTEGER);
                }
                formatBuffer.append((char)(n3 + n4));
                --n6;
                ++n7;
            }
            formatBuffer.setDefaultAttribute(null);
            n4 = n2 = formatBuffer.length();
            int n8 = 0;
            int n9 = 0;
            int n10 = this.maximumFractionDigits;
            if (this.useExponentialNotation) {
                n10 += this.minimumIntegerDigits - n7;
            }
            if (((d2 = d3 - Math.floor(d3)) != 0.0 || this.minimumFractionDigits > 0) && n10 > 0 || this.decimalSeparatorAlwaysShown) {
                formatBuffer.append(this.symbols.getDecimalSeparator(), (AttributedCharacterIterator.Attribute)NumberFormat.Field.DECIMAL_SEPARATOR);
            }
            int n11 = formatBuffer.length();
            formatBuffer.setDefaultAttribute(NumberFormat.Field.FRACTION);
            n7 = 0;
            while (n7 < n10 && (d2 != 0.0 || n7 < this.minimumFractionDigits)) {
                ++n9;
                long l2 = (long)(d2 *= 10.0);
                n8 = l2 == 0L ? ++n8 : 0;
                formatBuffer.append((char)((long)this.symbols.getZeroDigit() + l2));
                d2 -= Math.floor(d2);
                ++n7;
            }
            int n12 = Math.min(n8, n9 - this.minimumFractionDigits);
            if (n12 > 0) {
                formatBuffer.cutTail(n12);
                if ((n9 -= n12) == 0 && !this.decimalSeparatorAlwaysShown) {
                    formatBuffer.cutTail(1);
                }
            }
            if (fieldPosition != null && fieldPosition.getField() == 1) {
                fieldPosition.setBeginIndex(n11);
                fieldPosition.setEndIndex(formatBuffer.length());
            }
            if (this.useExponentialNotation) {
                formatBuffer.append(this.symbols.getExponential(), (AttributedCharacterIterator.Attribute)NumberFormat.Field.EXPONENT_SYMBOL);
                if (l < 0L) {
                    formatBuffer.append(this.symbols.getMinusSign(), (AttributedCharacterIterator.Attribute)NumberFormat.Field.EXPONENT_SIGN);
                    l = -l;
                }
                n5 = formatBuffer.length();
                formatBuffer.setDefaultAttribute(NumberFormat.Field.EXPONENT);
                String string2 = Long.toString(l);
                n7 = 0;
                while (n7 < this.minExponentDigits - string2.length()) {
                    formatBuffer.append(this.symbols.getZeroDigit());
                    ++n7;
                }
                n7 = 0;
                while (n7 < string2.length()) {
                    char c = string2.charAt(n7);
                    formatBuffer.append((char)(n3 + c));
                    ++n7;
                }
            }
        }
        if (fieldPosition != null && (fieldPosition.getField() == 0 || fieldPosition.getFieldAttribute() == NumberFormat.Field.INTEGER)) {
            fieldPosition.setBeginIndex(n);
            fieldPosition.setEndIndex(n2);
        }
        if (bl && this.negativeSuffix != null) {
            formatBuffer.append(this.substituteCurrency(this.negativeSuffix, d), this.negativeSuffixRanges, this.negativeSuffixAttrs);
        } else {
            formatBuffer.append(this.substituteCurrency(this.positiveSuffix, d), this.positiveSuffixRanges, this.positiveSuffixAttrs);
        }
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.formatInternal(d, new StringFormatBuffer(stringBuffer), fieldPosition);
        return stringBuffer;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        AttributedFormatBuffer attributedFormatBuffer = new AttributedFormatBuffer();
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("Cannot format given Object as a Number");
        }
        this.formatInternal(((Number)object).doubleValue(), attributedFormatBuffer, null);
        attributedFormatBuffer.sync();
        return new FormatCharacterIterator(attributedFormatBuffer.getBuffer().toString(), attributedFormatBuffer.getRanges(), attributedFormatBuffer.getAttributes());
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        if (this.useExponentialNotation) {
            return this.format((double)l, stringBuffer, fieldPosition);
        }
        boolean bl2 = false;
        if (l < 0L) {
            bl2 = true;
        }
        if (bl = bl2) {
            if (this.negativePrefix != null) {
                stringBuffer.append(this.substituteCurrency(this.negativePrefix, l));
            } else {
                stringBuffer.append(this.symbols.getMinusSign());
                stringBuffer.append(this.substituteCurrency(this.positivePrefix, l));
            }
            l = -l;
        } else {
            stringBuffer.append(this.substituteCurrency(this.positivePrefix, l));
        }
        int n = stringBuffer.length();
        int n2 = stringBuffer.length();
        int n3 = 0;
        l *= (long)this.multiplier;
        while (n3 < this.maximumIntegerDigits && (l > 0L || n3 < this.minimumIntegerDigits)) {
            long l2 = l % 10L;
            l /= 10L;
            if (l2 < 0L) {
                l2 = -l2;
                l = -l;
            }
            if (this.groupingUsed && n3 > 0 && this.groupingSize != 0 && n3 % this.groupingSize == 0) {
                stringBuffer.insert(n2, this.symbols.getGroupingSeparator());
            }
            stringBuffer.insert(n2, (char)((long)this.symbols.getZeroDigit() + l2));
            ++n3;
        }
        if (fieldPosition != null && fieldPosition.getField() == 0) {
            fieldPosition.setBeginIndex(n);
            fieldPosition.setEndIndex(stringBuffer.length());
        }
        if (this.decimalSeparatorAlwaysShown || this.minimumFractionDigits > 0) {
            stringBuffer.append(this.symbols.getDecimalSeparator());
            if (fieldPosition != null && fieldPosition.getField() == 1) {
                fieldPosition.setBeginIndex(stringBuffer.length());
                fieldPosition.setEndIndex(stringBuffer.length() + this.minimumFractionDigits);
            }
        }
        n3 = 0;
        while (n3 < this.minimumFractionDigits) {
            stringBuffer.append(this.symbols.getZeroDigit());
            ++n3;
        }
        stringBuffer.append(bl && this.negativeSuffix != null ? this.substituteCurrency(this.negativeSuffix, l) : this.substituteCurrency(this.positiveSuffix, l));
        return stringBuffer;
    }

    public Currency getCurrency() {
        return this.symbols.getCurrency();
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return (DecimalFormatSymbols)this.symbols.clone();
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public int hashCode() {
        return this.toPattern().hashCode();
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public Number parse(String string, ParsePosition parsePosition) {
        boolean bl;
        int n;
        char c;
        boolean bl2 = false;
        int n2 = parsePosition.getIndex();
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = string.startsWith(this.positivePrefix, n2);
        String string2 = this.negativePrefix != null ? this.negativePrefix : this.positivePrefix + this.symbols.getMinusSign();
        boolean bl3 = string.startsWith(string2, n2);
        if (c2 != '\u0000' && bl3) {
            if (string2.length() > this.positivePrefix.length()) {
                bl2 = true;
                n2 += string2.length();
            } else {
                n2 += this.positivePrefix.length();
            }
        } else if (bl3) {
            bl2 = true;
            n2 += string2.length();
        } else if (c2 != '\u0000') {
            n2 += this.positivePrefix.length();
        } else {
            parsePosition.setErrorIndex(n2);
            return null;
        }
        StringBuffer stringBuffer2 = stringBuffer;
        StringBuffer stringBuffer3 = null;
        StringBuffer stringBuffer4 = null;
        int n3 = n2;
        int n4 = string.length();
        int n5 = -1;
        int n6 = n2 + this.maximumIntegerDigits;
        if (this.maximumFractionDigits > 0) {
            n6 += this.maximumFractionDigits + 1;
        }
        if (this.useExponentialNotation) {
            n6 += this.minExponentDigits + 1;
        }
        if (n6 > 0 && n4 > n6) {
            n4 = n6;
        }
        char c3 = this.symbols.getZeroDigit();
        int n7 = -1;
        boolean bl4 = true;
        boolean bl5 = false;
        while (n2 < n4) {
            c = string.charAt(n2);
            if (this.groupingUsed && c == this.symbols.getGroupingSeparator()) {
                if (n7 != -1 && this.groupingSize != 0 && (n2 - n7) % this.groupingSize != 0) {
                    parsePosition.setErrorIndex(n2);
                    return null;
                }
                n7 = n2 + 1;
            } else if (c >= c3 && c <= c3 + 9) {
                stringBuffer2.append((char)(c - c3 + 48));
            } else {
                if (this.parseIntegerOnly) break;
                if (c == this.symbols.getDecimalSeparator()) {
                    if (n7 != -1 && this.groupingSize != 0 && (n2 - n7) % this.groupingSize != 0) {
                        parsePosition.setErrorIndex(n2);
                        return null;
                    }
                    stringBuffer2 = stringBuffer3 = new StringBuffer();
                    stringBuffer3.append('.');
                    bl4 = false;
                } else if (c == this.symbols.getExponential()) {
                    stringBuffer2 = stringBuffer4 = new StringBuffer();
                    bl4 = false;
                    bl5 = true;
                    n5 = n2 + 1;
                } else {
                    if (!bl5 || c != '+' && c != '-' && c != this.symbols.getMinusSign()) break;
                    stringBuffer2.append(c);
                }
            }
            ++n2;
        }
        if (n2 == n3) {
            parsePosition.setErrorIndex(n2);
            return null;
        }
        c = (char)(string.startsWith(this.positiveSuffix, n2) ? 1 : 0);
        String string3 = this.negativePrefix == null ? this.positiveSuffix : this.negativeSuffix;
        boolean bl6 = string.startsWith(string3, n2);
        if (bl2) {
            if (!bl6) {
                parsePosition.setErrorIndex(n2);
                return null;
            }
        } else if (c2 != '\u0000' && bl3 && bl6) {
            bl2 = true;
        } else {
            if (c2 != c && bl3 != bl6) {
                parsePosition.setErrorIndex(n2);
                return null;
            }
            if (c == '\u0000') {
                parsePosition.setErrorIndex(n2);
                return null;
            }
        }
        String string4 = bl2 ? string3 : this.positiveSuffix;
        long l = 1L;
        if (bl2) {
            stringBuffer.insert(0, '-');
        }
        if (stringBuffer4 != null) {
            int n8;
            try {
                n = Integer.parseInt(stringBuffer4.toString());
            }
            catch (NumberFormatException numberFormatException) {
                parsePosition.setErrorIndex(n5);
                return null;
            }
            if (stringBuffer3 == null) {
                n8 = 0;
                while (n8 < n) {
                    stringBuffer.append('0');
                    ++n8;
                }
                bl = true;
            } else {
                int n9;
                if (n < stringBuffer3.length() - 1) {
                    n9 = -1;
                    int n10 = 1;
                    while (n10 < stringBuffer3.length()) {
                        if (stringBuffer3.charAt(n10) != '0') {
                            n9 = n10;
                        }
                        ++n10;
                    }
                    int n11 = 0;
                    if (n9 < 0 || n9 <= n) {
                        n11 = 1;
                    }
                    n8 = n11;
                } else {
                    n8 = 1;
                }
                if (n8 != 0) {
                    n9 = 1;
                    while (n9 < stringBuffer3.length() && n9 < n) {
                        stringBuffer.append(stringBuffer3.charAt(n9));
                        ++n9;
                    }
                    n9 = stringBuffer3.length() - 1;
                    while (n9 < n) {
                        stringBuffer.append('0');
                        ++n9;
                    }
                    bl = true;
                } else {
                    stringBuffer.append(stringBuffer3);
                    stringBuffer.append('E');
                    stringBuffer.append(stringBuffer4);
                    bl = false;
                }
            }
        } else if (stringBuffer3 != null) {
            n = 1;
            while (n < stringBuffer3.length()) {
                if (stringBuffer3.charAt(n) != '0') break;
                ++n;
            }
            if (n != stringBuffer3.length()) {
                bl = false;
                stringBuffer.append(stringBuffer3);
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        String string5 = stringBuffer.toString();
        Number number = null;
        if (bl) {
            try {
                number = new Long(string5);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            try {
                number = new Double(string5);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (number == null) {
            parsePosition.setErrorIndex(n2);
            return null;
        }
        parsePosition.setIndex(n2 + string4.length());
        return number;
    }

    public void setCurrency(Currency currency) {
        this.symbols.setCurrency(currency);
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decimalSeparatorAlwaysShown = bl;
    }

    public void setGroupingSize(int n) {
        this.groupingSize = (byte)n;
    }

    public void setMaximumFractionDigits(int n) {
        super.setMaximumFractionDigits(Math.min(n, 340));
    }

    public void setMaximumIntegerDigits(int n) {
        super.setMaximumIntegerDigits(Math.min(n, 309));
    }

    public void setMinimumFractionDigits(int n) {
        super.setMinimumFractionDigits(Math.min(n, 340));
    }

    public void setMinimumIntegerDigits(int n) {
        super.setMinimumIntegerDigits(Math.min(n, 309));
    }

    public void setMultiplier(int n) {
        this.multiplier = n;
    }

    public void setNegativePrefix(String string) {
        this.negativePrefix = string;
    }

    public void setNegativeSuffix(String string) {
        this.negativeSuffix = string;
    }

    public void setPositivePrefix(String string) {
        this.positivePrefix = string;
    }

    public void setPositiveSuffix(String string) {
        this.positiveSuffix = string;
    }

    private final void quoteFix(StringBuffer stringBuffer, String string, String string2) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (string2.indexOf(c) != -1) {
                stringBuffer.append('\'');
                stringBuffer.append(c);
                stringBuffer.append('\'');
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
    }

    private final String computePattern(DecimalFormatSymbols decimalFormatSymbols) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Math.max(this.minimumIntegerDigits, this.groupingUsed ? this.groupingSize + 1 : this.groupingSize);
        int n2 = 0;
        while (n2 < n - this.minimumIntegerDigits) {
            stringBuffer.append(decimalFormatSymbols.getDigit());
            ++n2;
        }
        n2 = n - this.minimumIntegerDigits;
        while (n2 < n) {
            stringBuffer.append(decimalFormatSymbols.getZeroDigit());
            ++n2;
        }
        if (this.groupingUsed) {
            stringBuffer.insert(stringBuffer.length() - this.groupingSize, decimalFormatSymbols.getGroupingSeparator());
        }
        if (this.minimumFractionDigits > 0 || this.maximumFractionDigits > 0 || this.decimalSeparatorAlwaysShown) {
            stringBuffer.append(decimalFormatSymbols.getDecimalSeparator());
        }
        n2 = 0;
        while (n2 < this.minimumFractionDigits) {
            stringBuffer.append(decimalFormatSymbols.getZeroDigit());
            ++n2;
        }
        n2 = this.minimumFractionDigits;
        while (n2 < this.maximumFractionDigits) {
            stringBuffer.append(decimalFormatSymbols.getDigit());
            ++n2;
        }
        if (this.useExponentialNotation) {
            stringBuffer.append(decimalFormatSymbols.getExponential());
            n2 = 0;
            while (n2 < this.minExponentDigits) {
                stringBuffer.append(decimalFormatSymbols.getZeroDigit());
                ++n2;
            }
            if (this.minExponentDigits == 0) {
                stringBuffer.append(decimalFormatSymbols.getDigit());
            }
        }
        String string = stringBuffer.toString();
        String string2 = this.patternChars(decimalFormatSymbols);
        stringBuffer.setLength(0);
        this.quoteFix(stringBuffer, this.positivePrefix, string2);
        stringBuffer.append(string);
        this.quoteFix(stringBuffer, this.positiveSuffix, string2);
        if (this.negativePrefix != null) {
            this.quoteFix(stringBuffer, this.negativePrefix, string2);
            stringBuffer.append(string);
            this.quoteFix(stringBuffer, this.negativeSuffix, string2);
        }
        return stringBuffer.toString();
    }

    public String toLocalizedPattern() {
        return this.computePattern(this.symbols);
    }

    public String toPattern() {
        return this.computePattern(nonLocalizedSymbols);
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.useExponentialNotation = false;
            this.serialVersionOnStream = 1;
        }
    }

    private final String substituteCurrency(String string, double d) {
        int n = 0;
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        while (n < n2) {
            char c = string.charAt(n);
            if (string.charAt(n) == '\u00a4') {
                if (n + 1 < n2 && string.charAt(n + 1) == '\u00a4') {
                    stringBuffer.append(this.symbols.getInternationalCurrencySymbol());
                    n += 2;
                    continue;
                }
                String string2 = this.symbols.getCurrencySymbol();
                if (string2.startsWith("=")) {
                    String[] stringArray = string2.substring(1).split("\\|");
                    int[] nArray = new int[3];
                    String[] stringArray2 = new String[3];
                    int n3 = 0;
                    while (n3 < 3) {
                        String[] stringArray3 = stringArray[n3].split("[#<]");
                        nArray[n3] = Integer.parseInt(stringArray3[0]);
                        stringArray2[n3] = stringArray3[1];
                        ++n3;
                    }
                    if (d <= (double)nArray[0]) {
                        stringBuffer.append(stringArray2[0]);
                    } else if (d >= (double)nArray[2]) {
                        stringBuffer.append(stringArray2[2]);
                    } else {
                        stringBuffer.append(stringArray2[1]);
                    }
                    ++n;
                    continue;
                }
                stringBuffer.append(string2);
                ++n;
                continue;
            }
            stringBuffer.append(string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.serialVersionOnStream = 1;
    }

    public DecimalFormat() {
        this("#,##0.###");
    }

    public DecimalFormat(String string) {
        this(string, new DecimalFormatSymbols());
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.this();
        this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        this.applyPattern(string);
    }
}

