/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MenuSelectionManager {
    private static final MenuSelectionManager manager = new MenuSelectionManager();
    protected ChangeEvent changeEvent;
    protected EventListenerList listenerList;
    private Vector selectedPath;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    protected void fireStateChanged() {
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        int n = 0;
        while (n < changeListenerArray.length) {
            changeListenerArray[n].stateChanged(this.changeEvent);
            ++n;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = MenuSelectionManager.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = MenuSelectionManager.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = MenuSelectionManager.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.listenerList.getListeners(clazz);
    }

    public void clearSelectedPath() {
        int n = this.selectedPath.size() - 1;
        while (n >= 0) {
            ((MenuElement)this.selectedPath.get(n)).menuSelectionChanged(false);
            --n;
        }
        this.selectedPath.clear();
        this.fireStateChanged();
    }

    public Component componentForPoint(Component component, Point point) {
        Point point2 = point;
        if (component.isShowing()) {
            SwingUtilities.convertPointToScreen(point2, component);
        }
        Component component2 = null;
        int n = 0;
        while (n < this.selectedPath.size()) {
            Component component3 = (Component)this.selectedPath.get(n);
            Dimension dimension = component3.getSize();
            Point point3 = component3.getLocationOnScreen();
            if (point3.x <= point2.x && point2.x < point3.x + dimension.width && point3.y <= point2.y && point2.y < point3.y + dimension.height) {
                Point point4 = point2;
                if (component3.isShowing()) {
                    SwingUtilities.convertPointFromScreen(point4, component3);
                }
                component2 = SwingUtilities.getDeepestComponentAt(component3, point4.x, point4.y);
                break;
            }
            ++n;
        }
        return component2;
    }

    public static MenuSelectionManager defaultManager() {
        return manager;
    }

    public MenuElement[] getSelectedPath() {
        MenuElement[] menuElementArray = new MenuElement[this.selectedPath.size()];
        int n = 0;
        while (n < menuElementArray.length) {
            menuElementArray[n] = (MenuElement)this.selectedPath.get(n);
            ++n;
        }
        return menuElementArray;
    }

    public boolean isComponentPartOfCurrentMenu(Component component) {
        boolean bl = false;
        int n = 0;
        while (n < this.selectedPath.size()) {
            MenuElement menuElement = (MenuElement)this.selectedPath.get(n);
            if (SwingUtilities.isDescendingFrom(component, menuElement.getComponent())) {
                bl = true;
                break;
            }
            MenuElement[] menuElementArray = menuElement.getSubElements();
            int n2 = 0;
            while (n2 < menuElementArray.length) {
                MenuElement menuElement2 = menuElementArray[n2];
                if (menuElement2 != null && SwingUtilities.isDescendingFrom(component, menuElement2.getComponent())) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return bl;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        Component component2 = mouseEvent.getID() == 506 || mouseEvent.getID() == 502 ? this.componentForPoint(component, mouseEvent.getPoint()) : component;
        if (component2 != null && component2 instanceof MenuElement) {
            MenuElement[] menuElementArray = this.getPath(component2);
            ((MenuElement)((Object)component2)).processMouseEvent(mouseEvent, menuElementArray, manager);
        } else if (mouseEvent.getID() == 502) {
            this.clearSelectedPath();
        }
    }

    public void setSelectedPath(MenuElement[] menuElementArray) {
        int n;
        if (menuElementArray == null) {
            this.clearSelectedPath();
            return;
        }
        int n2 = menuElementArray.length;
        if (menuElementArray.length > this.selectedPath.size()) {
            n2 = this.selectedPath.size();
            n = this.selectedPath.size();
            while (n < menuElementArray.length) {
                this.selectedPath.add(menuElementArray[n]);
                menuElementArray[n].menuSelectionChanged(true);
                ++n;
            }
        } else if (menuElementArray.length < this.selectedPath.size()) {
            n = this.selectedPath.size() - 1;
            while (n >= menuElementArray.length) {
                ((MenuElement)this.selectedPath.get(n)).menuSelectionChanged(false);
                this.selectedPath.remove(n);
                --n;
            }
            n2 = menuElementArray.length;
        }
        n = n2 - 1;
        while (n >= 0) {
            MenuElement menuElement = (MenuElement)this.selectedPath.get(n);
            if (menuElementArray[n].equals(menuElement)) break;
            menuElement.menuSelectionChanged(false);
            menuElementArray[n].menuSelectionChanged(true);
            this.selectedPath.setElementAt(menuElementArray[n], n);
            --n;
        }
        this.fireStateChanged();
    }

    private final MenuElement[] getPath(Component component) {
        ArrayList arrayList = new ArrayList();
        if (component instanceof JMenu) {
            arrayList.add(((JMenu)component).getPopupMenu());
        }
        while (component instanceof MenuElement) {
            arrayList.add(0, (MenuElement)((Object)component));
            component = component instanceof JPopupMenu ? ((JPopupMenu)component).getInvoker() : component.getParent();
        }
        Object[] objectArray = new MenuElement[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.changeEvent = new ChangeEvent(this);
        this.listenerList = new EventListenerList();
        this.selectedPath = new Vector();
    }

    public MenuSelectionManager() {
        this.this();
    }
}

