/*
 * Decompiled with CFR 0.152.
 */
package org.kaffe.util;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class UNIXTimeZone
extends TimeZone {
    public static final int TZ_MAGIC = 1415211366;
    private static final int MAX_TIMES = 1024;
    private static final int MAX_TYPES = 255;
    private static final int MAX_CHARS = 255;
    private static final int MAX_LEAPS = 255;
    private static final int SECSPERMIN = 60;
    private static final int MINSPERHOUR = 60;
    private static final int SECSPERHOUR = 3600;
    private static final int SECSPERDAY = 86400;
    private Transition[] trans;
    private TimeInfo defaultInfo;
    private Leap[] leaps;
    private boolean[] standard;
    private boolean[] gmt;

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.getTimeInfo((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6).offset;
    }

    public int getOffset(Date date) {
        return this.getTimeInfo((Date)date).offset;
    }

    public String getAbbreviation(Date date) {
        return this.getTimeInfo((Date)date).abbrev;
    }

    public void setRawOffset(int n) {
    }

    public int getRawOffset() {
        return this.defaultInfo.offset;
    }

    public boolean useDaylightTime() {
        int n = 0;
        while (n < this.trans.length) {
            if (this.trans[n].info.isDST) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean inDaylightTime(Date date) {
        return this.getTimeInfo((Date)date).isDST;
    }

    private final TimeInfo getTimeInfo(int n, int n2, int n3, int n4, int n5, int n6) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(0, "_temp"));
        gregorianCalendar.set(0, n);
        gregorianCalendar.set(1, n2);
        gregorianCalendar.set(2, n3);
        gregorianCalendar.set(5, n4);
        int n7 = n6 / 1000;
        int n8 = n7 / 3600;
        gregorianCalendar.set(11, n8);
        int n9 = (n7 -= n8 * 3600) / 60;
        gregorianCalendar.set(12, n9);
        gregorianCalendar.set(13, n7 -= n9 * 60);
        gregorianCalendar.set(14, n6 % 1000);
        Date date = gregorianCalendar.getTime();
        long l = date.getTime();
        int n10 = 0;
        while (n10 < this.trans.length) {
            if (Math.abs(l - this.trans[n10].time) < 86400000L) break;
            ++n10;
        }
        if (n10 == this.trans.length) {
            return this.getTimeInfo(date);
        }
        if (l - (long)this.trans[n10].info.offset >= this.trans[n10].time || n10 == 0) {
            return this.trans[n10].info;
        }
        return this.trans[n10 - 1].info;
    }

    private final TimeInfo getTimeInfo(Date date) {
        if (this.trans.length == 0) {
            return this.defaultInfo;
        }
        long l = date.getTime();
        int n = 0;
        while (n < this.trans.length - 1 && l >= this.trans[n + 1].time) {
            ++n;
        }
        return this.trans[n].info;
    }

    private final boolean read(DataInput dataInput) throws IOException {
        switch (dataInput.readInt()) {
            case 0: 
            case 1415211366: {
                break;
            }
            default: {
                return false;
            }
        }
        dataInput.readFully(new byte[16]);
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        int n4 = dataInput.readInt();
        int n5 = dataInput.readInt();
        int n6 = dataInput.readInt();
        if (n3 < 0 || n3 > 255 || n5 <= 0 || n5 > 255 || n4 < 0 || n4 > 1024 || n6 < 0 || n6 > 255 || n2 != 0 && n2 != n5 || n != 0 && n != n5) {
            return false;
        }
        this.trans = new Transition[n4];
        int n7 = 0;
        while (n7 < n4) {
            this.trans[n7] = new Transition();
            this.trans[n7].time = (long)dataInput.readInt() * 1000L;
            ++n7;
        }
        int[] nArray = new int[n4];
        int n8 = 0;
        while (n8 < n4) {
            nArray[n8] = dataInput.readUnsignedByte();
            if (nArray[n8] >= n5) {
                return false;
            }
            ++n8;
        }
        TimeInfo[] timeInfoArray = new TimeInfo[n5];
        int[] nArray2 = new int[n5];
        int n9 = 0;
        while (n9 < n5) {
            timeInfoArray[n9] = new TimeInfo();
            timeInfoArray[n9].offset = dataInput.readInt() * 1000;
            timeInfoArray[n9].isDST = this.readBooleanStrict(dataInput);
            nArray2[n9] = dataInput.readUnsignedByte();
            if (nArray2[n9] < 0 || nArray2[n9] > n6) {
                return false;
            }
            ++n9;
        }
        this.defaultInfo = timeInfoArray[0];
        n9 = 0;
        while (n9 < n4) {
            this.trans[n9].info = timeInfoArray[nArray[n9]];
            ++n9;
        }
        char[] cArray = new char[n6];
        int n10 = 0;
        while (n10 < n6) {
            cArray[n10] = (char)dataInput.readUnsignedByte();
            ++n10;
        }
        String string = new String(cArray);
        int n11 = 0;
        while (n11 < n5) {
            int n12 = nArray2[n11];
            while (n12 < n6 && cArray[n12] != '\u0000') {
                ++n12;
            }
            timeInfoArray[n11].abbrev = string.substring(nArray2[n11], n12);
            ++n11;
        }
        this.leaps = new Leap[n3];
        n11 = 0;
        while (n11 < n3) {
            this.leaps[n11] = new Leap();
            this.leaps[n11].time = (long)dataInput.readInt() * 1000L;
            this.leaps[n11].numSeconds = dataInput.readInt();
            ++n11;
        }
        this.standard = new boolean[n5];
        if (n2 != 0) {
            n11 = 0;
            while (n11 < n5) {
                this.standard[n11] = this.readBooleanStrict(dataInput);
                ++n11;
            }
        }
        this.gmt = new boolean[n5];
        if (n != 0) {
            n11 = 0;
            while (n11 < n5) {
                this.gmt[n11] = this.readBooleanStrict(dataInput);
                ++n11;
            }
        }
        return true;
    }

    private final boolean readBooleanStrict(DataInput dataInput) throws IOException {
        switch (dataInput.readByte()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IOException("invalid file contents");
    }

    public static void main(String[] stringArray) throws Exception {
        int[][] nArrayArray = new int[100][];
        int n = 0;
        nArrayArray[n++] = new int[]{2000, 3, 2, 1, 30};
        nArrayArray[n++] = new int[]{2000, 3, 2, 2, 30};
        nArrayArray[n++] = new int[]{2000, 3, 2, 3, 30};
        int n2 = n++;
        int[] nArray = new int[5];
        nArray[0] = 2000;
        nArray[1] = 9;
        nArray[2] = 29;
        nArray[4] = 30;
        nArrayArray[n2] = nArray;
        nArrayArray[n++] = new int[]{2000, 9, 29, 1, 30};
        nArrayArray[n++] = new int[]{2000, 9, 29, 2, 30};
        int n3 = n++;
        int[] nArray2 = new int[5];
        nArray2[0] = 1;
        nArray2[2] = 1;
        nArrayArray[n3] = nArray2;
        int n4 = n++;
        int[] nArray3 = new int[5];
        nArray3[0] = 9999;
        nArray3[1] = 11;
        nArray3[2] = 31;
        nArrayArray[n4] = nArray3;
        File file = null;
        switch (stringArray.length) {
            case 1: {
                file = new File(stringArray[0]);
                break;
            }
            default: {
                System.err.println("Usage: UNIXTimeZone filename");
                System.exit(1);
            }
        }
        UNIXTimeZone uNIXTimeZone = new UNIXTimeZone("foobar", file);
        System.out.println("Time zone uses daylight savings = " + uNIXTimeZone.useDaylightTime());
        int n5 = 0;
        while (n5 < nArrayArray.length && nArrayArray[n5] != null) {
            boolean bl;
            System.out.println("Date: " + nArrayArray[n5][0] + '/' + (nArrayArray[n5][1] + 1) + '/' + nArrayArray[n5][2] + ' ' + nArrayArray[n5][3] + ':' + nArrayArray[n5][4]);
            int n6 = uNIXTimeZone.getOffset(1, nArrayArray[n5][0], nArrayArray[n5][1], nArrayArray[n5][2], 0, (nArrayArray[n5][3] * 3600 + nArrayArray[n5][4] * 60) * 1000);
            GregorianCalendar gregorianCalendar = new GregorianCalendar(uNIXTimeZone);
            gregorianCalendar.set(0, 1);
            gregorianCalendar.set(1, nArrayArray[n5][0]);
            gregorianCalendar.set(2, nArrayArray[n5][1]);
            gregorianCalendar.set(5, nArrayArray[n5][2]);
            gregorianCalendar.set(11, nArrayArray[n5][3]);
            gregorianCalendar.set(12, nArrayArray[n5][4]);
            boolean bl2 = uNIXTimeZone.inDaylightTime(gregorianCalendar.getTime());
            String string = uNIXTimeZone.getAbbreviation(gregorianCalendar.getTime());
            int n7 = n6 / 1000;
            boolean bl3 = false;
            if (n7 < 0) {
                bl3 = true;
            }
            if (bl = bl3) {
                n7 = -n7;
            }
            int n8 = n7 / 3600;
            int n9 = (n7 -= n8 * 3600) / 60;
            System.out.print("  offset=" + (bl ? (char)'-' : '+'));
            System.out.println(n8 + " hrs " + n9 + " mins " + (n7 -= n9 * 60) + " secs");
            System.out.println("  DST=" + bl2);
            System.out.println("  Abbreviation=" + string);
            ++n5;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UNIXTimeZone(String string, File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            if (!this.read(new DataInputStream(new BufferedInputStream(fileInputStream)))) {
                throw new IOException("invalid file contents");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileInputStream.close();
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        fileInputStream.close();
        this.setID(string.toString());
    }

    private static class TimeInfo {
        int offset;
        boolean isDST;
        String abbrev;

        private TimeInfo() {
        }
    }

    private static class Transition {
        long time;
        TimeInfo info;

        private Transition() {
        }
    }

    private static class Leap {
        long time;
        int numSeconds;

        private Leap() {
        }
    }
}

