/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.VoiceStatus;
import org.tritonus.midi.device.alsa.AlsaMidiChannel;
import org.tritonus.midi.device.alsa.AlsaMidiDevice;
import org.tritonus.share.GlobalInfo;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.TMidiDevice;

public class AlsaSynthesizer
extends AlsaMidiDevice
implements Synthesizer {
    private static final MidiChannel[] EMPTY_MIDICHANNEL_ARRAY = new MidiChannel[0];
    private static final VoiceStatus[] EMPTY_VOICESTATUS_ARRAY = new VoiceStatus[0];
    private List m_channels;
    private int m_nVoices;

    protected void openImpl() {
        Receiver receiver;
        block3: {
            super.openImpl();
            this.m_channels.clear();
            receiver = null;
            try {
                receiver = this.getReceiver();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                if (!TDebug.TraceAllExceptions) break block3;
                TDebug.out(midiUnavailableException);
            }
        }
        int n = 0;
        while (n < 16) {
            AlsaMidiChannel alsaMidiChannel = new AlsaMidiChannel(receiver, n);
            this.m_channels.add(alsaMidiChannel);
            ++n;
        }
    }

    protected void closeImpl() {
        super.closeImpl();
    }

    public int getMaxPolyphony() {
        return this.m_nVoices;
    }

    public long getLatency() {
        return -1;
    }

    public MidiChannel[] getChannels() {
        return (MidiChannel[])this.m_channels.toArray(EMPTY_MIDICHANNEL_ARRAY);
    }

    public VoiceStatus[] getVoiceStatus() {
        return EMPTY_VOICESTATUS_ARRAY;
    }

    public boolean isSoundbankSupported(Soundbank soundbank) {
        return false;
    }

    public boolean loadInstrument(Instrument instrument) {
        return false;
    }

    public void unloadInstrument(Instrument instrument) {
    }

    public boolean remapInstrument(Instrument instrument, Instrument instrument2) {
        return false;
    }

    public Soundbank getDefaultSoundbank() {
        return null;
    }

    public Instrument[] getAvailableInstruments() {
        return null;
    }

    public Instrument[] getLoadedInstruments() {
        return null;
    }

    public boolean loadAllInstruments(Soundbank soundbank) {
        return false;
    }

    public void unloadAllInstruments(Soundbank soundbank) {
    }

    public boolean loadInstruments(Soundbank soundbank, Patch[] patchArray) {
        return false;
    }

    public void unloadInstruments(Soundbank soundbank, Patch[] patchArray) {
    }

    public AlsaSynthesizer(int n, int n2, int n3) {
        super(new TMidiDevice.Info("ALSA Synthesizer (" + n + ':' + n2 + ')', GlobalInfo.getVendor(), "Synthesizer based on the ALSA sequencer", GlobalInfo.getVersion()), n, n2, false, true);
        this.m_nVoices = n3;
        this.m_channels = new ArrayList();
    }
}

