/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.swing.NodeWidget;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.IntHashMap;
import org.igoweb.util.swing.Prefs;

public class Map
extends JPanel
implements LayoutManager2,
EventListener,
Scrollable,
PropertyChangeListener {
    private Tree tree;
    private int maxX = 0;
    private int maxY = 0;
    private boolean placeNodesNeeded = true;
    private final IntHashMap<LayoutInfo> nodeIdToLayoutInfo = new IntHashMap();
    private ActionListener listener = null;
    private boolean forceScrollPending = false;
    private boolean forceScrollNeeded = true;
    private final int WIDGET_SIZE_MULTIPLIER = 3;
    public static final int connectorW = 2;
    private JPopupMenu nodePopup;

    public Map(Tree tree, JPopupMenu nodePopup) {
        this.setOpaque(false);
        this.tree = tree;
        tree.addListener(this);
        this.setLayout(this);
        this.nodePopup = nodePopup;
        Node.NodeIterator nodes = tree.nodes();
        while (nodes.hasNext()) {
            NodeWidget widget = new NodeWidget(nodes.nextNode(), null);
            widget.setPopupMenu(nodePopup);
            this.nodeIdToLayoutInfo.put(widget.node.id, new LayoutInfo(widget));
            this.add(widget);
        }
    }

    public void setListener(ActionListener newListener) {
        if (this.listener != newListener) {
            this.listener = newListener;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component widget = this.getComponent(i);
                if (!(widget instanceof NodeWidget)) continue;
                ((NodeWidget)widget).setListener(this.listener);
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        this.placeNodes();
        Dimension min = new Dimension();
        Insets insets = this.getInsets();
        int nodeSize = this.getFont().getSize() * 3;
        min.width = insets.left + nodeSize * (this.maxX + 1) + nodeSize / 6 + insets.right;
        min.height = insets.top + nodeSize * (this.maxY + 1) + nodeSize / 6 + insets.bottom;
        return min;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 5: {
                this.forceScrollNeeded = true;
                int[] args = (int[])event.arg;
                NodeWidget widget = new NodeWidget(this.tree.getNode(args[0]), this.listener);
                widget.setPopupMenu(this.nodePopup);
                this.nodeIdToLayoutInfo.put(widget.node.id, new LayoutInfo(widget));
                this.add(widget);
                this.revalidate();
                break;
            }
            case 7: {
                this.delayedForceScroll();
                break;
            }
            case 6: {
                this.forceScrollNeeded = true;
                Node.NodeIterator nodes = new Node.NodeIterator((Node)event.source);
                while (nodes.hasNext()) {
                    this.nodeRemoved(nodes.nextNode());
                }
                break;
            }
            case 4: {
                this.forceScrollNeeded = true;
                this.revalidate();
            }
        }
    }

    private void nodeRemoved(Node node) {
        LayoutInfo layoutInfo = this.nodeIdToLayoutInfo.remove(node.id);
        if (layoutInfo != null) {
            this.remove(layoutInfo.widget);
            if (layoutInfo.connectorToParent != null) {
                this.remove(layoutInfo.connectorToParent);
            }
        }
    }

    private void newActiveNode() {
        this.forceScrollPending = false;
        Rectangle visible = this.nodeIdToLayoutInfo.get((int)this.tree.getActiveNode().id).widget.getBounds();
        visible.x -= visible.width;
        visible.y -= visible.height;
        visible.width *= 3;
        visible.height *= 3;
        if (visible.x < 0) {
            visible.width += visible.x;
            visible.x = 0;
        }
        if (visible.y < 0) {
            visible.height += visible.y;
            visible.y = 0;
        }
        Dimension size = this.getSize();
        if (visible.x + visible.width > size.width) {
            visible.width = size.width - visible.x;
        }
        if (visible.y + visible.height > size.height) {
            visible.height = size.height - visible.y;
        }
        this.scrollRectToVisible(visible);
    }

    private void delayedForceScroll() {
        if (!this.forceScrollNeeded && !this.forceScrollPending) {
            this.forceScrollPending = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Map.this.newActiveNode();
                }
            });
        }
    }

    @Override
    public void layoutContainer(Container cont) {
        this.placeNodes();
        int nodeSize = this.getFont().getSize() * 3;
        Insets insets = this.getInsets();
        int xOff = insets.left + nodeSize / 6;
        int yOff = insets.top + nodeSize / 6;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component widget = this.getComponent(i);
            if (!(widget instanceof NodeWidget)) continue;
            LayoutInfo layoutInfo = this.nodeIdToLayoutInfo.get(((NodeWidget)widget).node.id);
            widget.setBounds(layoutInfo.x * nodeSize + xOff - 2, layoutInfo.y * nodeSize + yOff - 2, nodeSize + 4, nodeSize + 4);
            if (layoutInfo.connectorToParent == null) continue;
            layoutInfo.connectorToParent.setBounds((layoutInfo.x - 1) * nodeSize + xOff, (layoutInfo.y - layoutInfo.connectorH) * nodeSize + yOff, nodeSize, layoutInfo.connectorH * nodeSize);
        }
        if (this.forceScrollNeeded) {
            this.forceScrollNeeded = false;
            this.delayedForceScroll();
        }
    }

    private void placeNodes() {
        if (!this.placeNodesNeeded) {
            return;
        }
        this.maxX = 0;
        this.maxY = 0;
        this.placeNodes(this.tree.root, -1, 0, new int[this.getComponentCount()]);
        this.placeNodesNeeded = false;
    }

    private void placeNodes(Node node, int x, int y, int[] heights) {
        int nMaxX = x + 1;
        int nMaxY = y;
        int maxHop = 0;
        Node current = node;
        while (true) {
            int hop;
            if (heights[nMaxX] + 1 > nMaxY) {
                nMaxY = heights[nMaxX] + 1;
            }
            if ((hop = nMaxY - y - (nMaxX - x)) > maxHop) {
                maxHop = hop;
            }
            if (current.countChildren() <= 0) break;
            current = current.getChild(0);
            ++nMaxX;
        }
        if (nMaxY > this.maxY) {
            this.maxY = nMaxY;
        }
        if (nMaxX > this.maxX) {
            this.maxX = nMaxX;
        }
        while (true) {
            int parentY;
            int thisY;
            if ((thisY = y + maxHop + (nMaxX - x)) > nMaxY) {
                thisY = nMaxY;
            }
            if (current == node) {
                parentY = y;
            } else {
                parentY = y + maxHop + (nMaxX - 1 - x);
                if (parentY > nMaxY) {
                    parentY = nMaxY;
                }
            }
            LayoutInfo layoutInfo = this.nodeIdToLayoutInfo.get(current.id);
            NodeWidget widget = layoutInfo.widget;
            heights[nMaxX] = thisY;
            for (int i = 1; i < current.countChildren(); ++i) {
                this.placeNodes(current.getChild(i), nMaxX, thisY, heights);
            }
            layoutInfo.x = nMaxX;
            layoutInfo.y = thisY - 1;
            if (nMaxX > 0) {
                layoutInfo.connectorH = thisY - parentY - 1;
                widget.setParentLines(thisY - parentY, this.nodeIdToLayoutInfo.get((int)current.parent.id).widget);
            } else {
                widget.setParentLines(-1, null);
            }
            if (layoutInfo.connectorH > 0) {
                if (layoutInfo.connectorToParent == null) {
                    layoutInfo.connectorToParent = new NodeConnector();
                    this.add(layoutInfo.connectorToParent);
                }
            } else if (layoutInfo.connectorToParent != null) {
                this.remove(layoutInfo.connectorToParent);
                layoutInfo.connectorToParent = null;
            }
            --nMaxX;
            if (current == node) {
                if (maxHop > 0 && nMaxX >= 0) {
                    heights[nMaxX] = thisY - 1;
                }
                return;
            }
            current = current.parent;
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container cont) {
        Insets insets = this.getInsets();
        int fontH = this.getFont().getSize();
        return new Dimension(fontH * (this.maxX * 3 + 4) * 3 / 3 + insets.left + insets.right, fontH * (this.maxY * 3 + 1) * 3 / 3 + insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container cont) {
        return this.preferredLayoutSize(cont);
    }

    @Override
    public void addLayoutComponent(String s, Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object info) {
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        int size = this.getFont().getSize() * 3;
        return new Dimension(size, size);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getFont().getSize() * 3;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height;
        }
        return visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setNodePopupMenu(JPopupMenu newNodePopupMenu) {
        if (this.nodePopup != newNodePopupMenu) {
            this.nodePopup = newNodePopupMenu;
            Component[] comps = this.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof NodeWidget)) continue;
                ((NodeWidget)comps[i]).setPopupMenu(newNodePopupMenu);
            }
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public void removeNotify() {
        Prefs.removeListener("d][N'B&\"", this);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Prefs.addListener("d][N'B&\"", this);
        super.addNotify();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component comp = this.getComponent(i);
            if (!(comp instanceof NodeWidget)) continue;
            ((NodeWidget)comp).clearImages();
        }
        this.repaint();
    }

    @Override
    public void invalidateLayout(Container c) {
        this.placeNodesNeeded = true;
    }

    @Override
    public float getLayoutAlignmentX(Container c) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container c) {
        return 0.0f;
    }

    @Override
    public Dimension maximumLayoutSize(Container c) {
        return this.getMinimumSize();
    }

    private static class NodeConnector
    extends Component {
        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.black);
            g2d.setStroke(new BasicStroke(2.0f));
            GeneralPath path = new GeneralPath();
            Dimension size = this.getSize();
            g2d.translate(2, 2);
            size.width -= 4;
            size.height -= 4;
            float halfWidth = (float)size.width * 0.5f;
            path.moveTo(halfWidth, 0.0f);
            path.lineTo(halfWidth, (float)size.height - halfWidth);
            path.lineTo(size.width, size.height);
            g2d.draw(path);
        }
    }

    private static class LayoutInfo {
        public int x;
        public int y;
        public int connectorH;
        public Component connectorToParent;
        public final NodeWidget widget;

        public LayoutInfo(NodeWidget widget) {
            this.widget = widget;
        }
    }
}

