/*
 * Decompiled with CFR 0.152.
 */
package javax.media.util;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class BufferToImage {
    private VideoFormat format;
    private Codec converter = null;
    private RGBFormat prefFormat;
    private Buffer outputBuffer;
    private Dimension size;
    private boolean converterNotRequired = false;

    public BufferToImage(VideoFormat format) {
        if (format instanceof YUVFormat || format instanceof RGBFormat) {
            this.format = format;
            this.size = format.getSize();
            this.prefFormat = new RGBFormat(this.size, this.size.width * this.size.height, Format.intArray, format.getFrameRate(), 32, -1, -1, -1, 1, -1, 0, -1);
            if (format.matches(this.prefFormat)) {
                this.converterNotRequired = true;
                return;
            }
            Codec codec = this.findCodec(format, this.prefFormat);
            if (codec != null) {
                this.converter = codec;
            }
            this.outputBuffer = new Buffer();
        }
    }

    private Codec findCodec(VideoFormat input, VideoFormat output) {
        Vector codecList = PlugInManager.getPlugInList(input, output, 2);
        if (codecList == null || codecList.size() == 0) {
            return null;
        }
        int i2 = 0;
        while (i2 < codecList.size()) {
            Format[] outputs;
            String codecName = (String)codecList.elementAt(i2);
            Class<?> codecClass = null;
            Codec codec = null;
            try {
                codecClass = Class.forName(codecName);
                if (codecClass != null) {
                    codec = (Codec)codecClass.newInstance();
                }
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (InstantiationException ie) {
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
            if (codec != null && codec.setInputFormat(input) != null && (outputs = codec.getSupportedOutputFormats(input)) != null && outputs.length != 0) {
                int j2 = 0;
                while (j2 < outputs.length) {
                    Format out;
                    if (outputs[j2].matches(output) && (out = codec.setOutputFormat(outputs[j2])) != null && out.matches(output)) {
                        try {
                            codec.open();
                            return codec;
                        }
                        catch (ResourceUnavailableException rue) {
                            // empty catch block
                        }
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        return null;
    }

    public Image createImage(Buffer buffer) {
        RGBFormat vf;
        int[] outputData;
        if (buffer == null || this.converter == null && !this.converterNotRequired || this.prefFormat == null || buffer.getFormat() == null || !buffer.getFormat().matches(this.format) || buffer.getData() == null || buffer.isEOM() || buffer.isDiscard()) {
            return null;
        }
        try {
            if (this.converterNotRequired) {
                outputData = (int[])buffer.getData();
                vf = (RGBFormat)buffer.getFormat();
                this.outputBuffer = buffer;
            } else {
                int retVal = this.converter.process(buffer, this.outputBuffer);
                if (retVal != 0) {
                    return null;
                }
                outputData = (int[])this.outputBuffer.getData();
                vf = (RGBFormat)this.outputBuffer.getFormat();
            }
        }
        catch (Exception ex) {
            System.err.println("Exception " + ex);
            return null;
        }
        Image outputImage = null;
        BufferToImage waFor2DBug = null;
        try {
            Class<?> cl = Class.forName("com.sun.media.util.BufferToBufferedImage");
            waFor2DBug = (BufferToImage)cl.newInstance();
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (waFor2DBug != null) {
            outputImage = waFor2DBug.createImage(this.outputBuffer);
        } else {
            int redMask = vf.getRedMask();
            int greenMask = vf.getGreenMask();
            int blueMask = vf.getBlueMask();
            DirectColorModel dcm = new DirectColorModel(32, redMask, greenMask, blueMask);
            MemoryImageSource sourceImage = new MemoryImageSource(this.size.width, this.size.height, (ColorModel)dcm, outputData, 0, this.size.width);
            outputImage = Toolkit.getDefaultToolkit().createImage(sourceImage);
        }
        return outputImage;
    }
}

