/*
 * Decompiled with CFR 0.152.
 */
package jflex.unicode;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jflex.IntCharSet;
import jflex.Interval;
import jflex.unicode.data.Unicode_1_1;
import jflex.unicode.data.Unicode_2_0;
import jflex.unicode.data.Unicode_2_1;
import jflex.unicode.data.Unicode_3_0;
import jflex.unicode.data.Unicode_3_1;
import jflex.unicode.data.Unicode_3_2;
import jflex.unicode.data.Unicode_4_0;
import jflex.unicode.data.Unicode_4_1;
import jflex.unicode.data.Unicode_5_0;
import jflex.unicode.data.Unicode_5_1;
import jflex.unicode.data.Unicode_5_2;
import jflex.unicode.data.Unicode_6_0;
import jflex.unicode.data.Unicode_6_1;
import jflex.unicode.data.Unicode_6_2;
import jflex.unicode.data.Unicode_6_3;
import jflex.unicode.data.Unicode_7_0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicodeProperties {
    public static final String UNICODE_VERSIONS = "1.1, 1.1.5, 2, 2.0, 2.0.14, 2.1, 2.1.9, 3, 3.0, 3.0.1, 3.1, 3.1.0, 3.2, 3.2.0, 4, 4.0, 4.0.1, 4.1, 4.1.0, 5, 5.0, 5.0.0, 5.1, 5.1.0, 5.2, 5.2.0, 6, 6.0, 6.0.0, 6.1, 6.1.0, 6.2, 6.2.0, 6.3, 6.3.0, 7, 7.0, 7.0.0";
    private static final String DEFAULT_UNICODE_VERSION = "7.0";
    private static final Pattern WORD_SEP_PATTERN = Pattern.compile("[-_\\s()]");
    private int maximumCodePoint;
    private Map<String, IntCharSet> propertyValueIntervals = new HashMap<String, IntCharSet>();
    private String caselessMatchPartitions;
    private int caselessMatchPartitionSize;
    private IntCharSet[] caselessMatches;

    public UnicodeProperties() throws UnsupportedUnicodeVersionException {
        this.init(DEFAULT_UNICODE_VERSION);
    }

    public UnicodeProperties(String version) throws UnsupportedUnicodeVersionException {
        this.init(version);
    }

    public int getMaximumCodePoint() {
        return this.maximumCodePoint;
    }

    public IntCharSet getIntCharSet(String propertyValue) {
        return this.propertyValueIntervals.get(this.normalize(propertyValue));
    }

    public Set<String> getPropertyValues() {
        return this.propertyValueIntervals.keySet();
    }

    public IntCharSet getCaselessMatches(int c) {
        if (null == this.caselessMatches) {
            this.initCaselessMatches();
        }
        return this.caselessMatches[c];
    }

    private void initCaselessMatches() {
        this.caselessMatches = new IntCharSet[this.maximumCodePoint + 1];
        int[] members = new int[this.caselessMatchPartitionSize];
        int index = 0;
        while (index < this.caselessMatchPartitions.length()) {
            int n;
            IntCharSet partition = new IntCharSet();
            for (n = 0; n < this.caselessMatchPartitionSize; ++n) {
                int c = this.caselessMatchPartitions.codePointAt(index);
                index += Character.charCount(c);
                members[n] = c;
                if (c <= 0) continue;
                partition.add(c);
            }
            if (!partition.containsElements()) continue;
            for (n = 0; n < this.caselessMatchPartitionSize; ++n) {
                if (members[n] <= 0) continue;
                this.caselessMatches[members[n]] = partition;
            }
        }
    }

    private void init(String version) throws UnsupportedUnicodeVersionException {
        if (version.equals("1.1") || version.equals("1.1.5")) {
            this.bind(Unicode_1_1.propertyValues, Unicode_1_1.intervals, Unicode_1_1.propertyValueAliases, 65535, "Aa\u0000Bb\u0000Cc\u0000Dd\u0000Ee\u0000Ff\u0000Gg\u0000Hh\u0000Ii\u0000Jj\u0000Kk\u0000Ll\u0000Mm\u0000Nn\u0000Oo\u0000Pp\u0000Qq\u0000Rr\u0000Ss\u017fTt\u0000Uu\u0000Vv\u0000Ww\u0000Xx\u0000Yy\u0000Zz\u0000\u00c0\u00e0\u0000\u00c1\u00e1\u0000\u00c2\u00e2\u0000\u00c3\u00e3\u0000\u00c4\u00e4\u0000\u00c5\u00e5\u0000\u00c6\u00e6\u0000\u00c7\u00e7\u0000\u00c8\u00e8\u0000\u00c9\u00e9\u0000\u00ca\u00ea\u0000\u00cb\u00eb\u0000\u00cc\u00ec\u0000\u00cd\u00ed\u0000\u00ce\u00ee\u0000\u00cf\u00ef\u0000\u00d0\u00f0\u0000\u00d1\u00f1\u0000\u00d2\u00f2\u0000\u00d3\u00f3\u0000\u00d4\u00f4\u0000\u00d5\u00f5\u0000\u00d6\u00f6\u0000\u00d8\u00f8\u0000\u00d9\u00f9\u0000\u00da\u00fa\u0000\u00db\u00fb\u0000\u00dc\u00fc\u0000\u00dd\u00fd\u0000\u00de\u00fe\u0000\u00ff\u0178\u0000\u0100\u0101\u0000\u0102\u0103\u0000\u0104\u0105\u0000\u0106\u0107\u0000\u0108\u0109\u0000\u010a\u010b\u0000\u010c\u010d\u0000\u010e\u010f\u0000\u0110\u0111\u0000\u0112\u0113\u0000\u0114\u0115\u0000\u0116\u0117\u0000\u0118\u0119\u0000\u011a\u011b\u0000\u011c\u011d\u0000\u011e\u011f\u0000\u0120\u0121\u0000\u0122\u0123\u0000\u0124\u0125\u0000\u0126\u0127\u0000\u0128\u0129\u0000\u012a\u012b\u0000\u012c\u012d\u0000\u012e\u012f\u0000\u0132\u0133\u0000\u0134\u0135\u0000\u0136\u0137\u0000\u0139\u013a\u0000\u013b\u013c\u0000\u013d\u013e\u0000\u013f\u0140\u0000\u0141\u0142\u0000\u0143\u0144\u0000\u0145\u0146\u0000\u0147\u0148\u0000\u014a\u014b\u0000\u014c\u014d\u0000\u014e\u014f\u0000\u0150\u0151\u0000\u0152\u0153\u0000\u0154\u0155\u0000\u0156\u0157\u0000\u0158\u0159\u0000\u015a\u015b\u0000\u015c\u015d\u0000\u015e\u015f\u0000\u0160\u0161\u0000\u0162\u0163\u0000\u0164\u0165\u0000\u0166\u0167\u0000\u0168\u0169\u0000\u016a\u016b\u0000\u016c\u016d\u0000\u016e\u016f\u0000\u0170\u0171\u0000\u0172\u0173\u0000\u0174\u0175\u0000\u0176\u0177\u0000\u0179\u017a\u0000\u017b\u017c\u0000\u017d\u017e\u0000\u0181\u0253\u0000\u0182\u0183\u0000\u0184\u0185\u0000\u0186\u0254\u0000\u0187\u0188\u0000\u018a\u0257\u0000\u018b\u018c\u0000\u018e\u0258\u0000\u018f\u0259\u0000\u0190\u025b\u0000\u0191\u0192\u0000\u0193\u0260\u0000\u0194\u0263\u0000\u0196\u0269\u0000\u0197\u0268\u0000\u0198\u0199\u0000\u019c\u026f\u0000\u019d\u0272\u0000\u01a0\u01a1\u0000\u01a2\u01a3\u0000\u01a4\u01a5\u0000\u01a7\u01a8\u0000\u01a9\u0283\u0000\u01ac\u01ad\u0000\u01ae\u0288\u0000\u01af\u01b0\u0000\u01b1\u028a\u0000\u01b2\u028b\u0000\u01b3\u01b4\u0000\u01b5\u01b6\u0000\u01b7\u0292\u0000\u01b8\u01b9\u0000\u01bc\u01bd\u0000\u01c4\u01c5\u01c6\u01c7\u01c8\u01c9\u01ca\u01cb\u01cc\u01cd\u01ce\u0000\u01cf\u01d0\u0000\u01d1\u01d2\u0000\u01d3\u01d4\u0000\u01d5\u01d6\u0000\u01d7\u01d8\u0000\u01d9\u01da\u0000\u01db\u01dc\u0000\u01de\u01df\u0000\u01e0\u01e1\u0000\u01e2\u01e3\u0000\u01e4\u01e5\u0000\u01e6\u01e7\u0000\u01e8\u01e9\u0000\u01ea\u01eb\u0000\u01ec\u01ed\u0000\u01ee\u01ef\u0000\u01f1\u01f2\u01f3\u01f4\u01f5\u0000\u01fa\u01fb\u0000\u01fc\u01fd\u0000\u01fe\u01ff\u0000\u0200\u0201\u0000\u0202\u0203\u0000\u0204\u0205\u0000\u0206\u0207\u0000\u0208\u0209\u0000\u020a\u020b\u0000\u020c\u020d\u0000\u020e\u020f\u0000\u0210\u0211\u0000\u0212\u0213\u0000\u0214\u0215\u0000\u0216\u0217\u0000\u0386\u03ac\u0000\u0388\u03ad\u0000\u0389\u03ae\u0000\u038a\u03af\u0000\u038c\u03cc\u0000\u038e\u03cd\u0000\u038f\u03ce\u0000\u0391\u03b1\u0000\u0392\u03b2\u03d0\u0393\u03b3\u0000\u0394\u03b4\u0000\u0395\u03b5\u0000\u0396\u03b6\u0000\u0397\u03b7\u0000\u0398\u03b8\u03d1\u0399\u03b9\u0000\u039a\u03ba\u03f0\u039b\u03bb\u0000\u039c\u03bc\u0000\u039d\u03bd\u0000\u039e\u03be\u0000\u039f\u03bf\u0000\u03a0\u03c0\u03d6\u03a1\u03c1\u03f1\u03a3\u03c3\u0000\u03a4\u03c4\u0000\u03a5\u03c5\u0000\u03a6\u03c6\u03d5\u03a7\u03c7\u0000\u03a8\u03c8\u0000\u03a9\u03c9\u0000\u03aa\u03ca\u0000\u03ab\u03cb\u0000\u03da\u03db\u0000\u03dc\u03dd\u0000\u03de\u03df\u0000\u03e0\u03e1\u0000\u03e2\u03e3\u0000\u03e4\u03e5\u0000\u03e6\u03e7\u0000\u03e8\u03e9\u0000\u03ea\u03eb\u0000\u03ec\u03ed\u0000\u03ee\u03ef\u0000\u0401\u0451\u0000\u0402\u0452\u0000\u0403\u0453\u0000\u0404\u0454\u0000\u0405\u0455\u0000\u0406\u0456\u0000\u0407\u0457\u0000\u0408\u0458\u0000\u0409\u0459\u0000\u040a\u045a\u0000\u040b\u045b\u0000\u040c\u045c\u0000\u040e\u045e\u0000\u040f\u045f\u0000\u0410\u0430\u0000\u0411\u0431\u0000\u0412\u0432\u0000\u0413\u0433\u0000\u0414\u0434\u0000\u0415\u0435\u0000\u0416\u0436\u0000\u0417\u0437\u0000\u0418\u0438\u0000\u0419\u0439\u0000\u041a\u043a\u0000\u041b\u043b\u0000\u041c\u043c\u0000\u041d\u043d\u0000\u041e\u043e\u0000\u041f\u043f\u0000\u0420\u0440\u0000\u0421\u0441\u0000\u0422\u0442\u0000\u0423\u0443\u0000\u0424\u0444\u0000\u0425\u0445\u0000\u0426\u0446\u0000\u0427\u0447\u0000\u0428\u0448\u0000\u0429\u0449\u0000\u042a\u044a\u0000\u042b\u044b\u0000\u042c\u044c\u0000\u042d\u044d\u0000\u042e\u044e\u0000\u042f\u044f\u0000\u0460\u0461\u0000\u0462\u0463\u0000\u0464\u0465\u0000\u0466\u0467\u0000\u0468\u0469\u0000\u046a\u046b\u0000\u046c\u046d\u0000\u046e\u046f\u0000\u0470\u0471\u0000\u0472\u0473\u0000\u0474\u0475\u0000\u0476\u0477\u0000\u0478\u0479\u0000\u047a\u047b\u0000\u047c\u047d\u0000\u047e\u047f\u0000\u0480\u0481\u0000\u0490\u0491\u0000\u0492\u0493\u0000\u0494\u0495\u0000\u0496\u0497\u0000\u0498\u0499\u0000\u049a\u049b\u0000\u049c\u049d\u0000\u049e\u049f\u0000\u04a0\u04a1\u0000\u04a2\u04a3\u0000\u04a4\u04a5\u0000\u04a6\u04a7\u0000\u04a8\u04a9\u0000\u04aa\u04ab\u0000\u04ac\u04ad\u0000\u04ae\u04af\u0000\u04b0\u04b1\u0000\u04b2\u04b3\u0000\u04b4\u04b5\u0000\u04b6\u04b7\u0000\u04b8\u04b9\u0000\u04ba\u04bb\u0000\u04bc\u04bd\u0000\u04be\u04bf\u0000\u04c1\u04c2\u0000\u04c3\u04c4\u0000\u04c7\u04c8\u0000\u04cb\u04cc\u0000\u04d0\u04d1\u0000\u04d2\u04d3\u0000\u04d4\u04d5\u0000\u04d6\u04d7\u0000\u04d8\u04d9\u0000\u04da\u04db\u0000\u04dc\u04dd\u0000\u04de\u04df\u0000\u04e0\u04e1\u0000\u04e2\u04e3\u0000\u04e4\u04e5\u0000\u04e6\u04e7\u0000\u04e8\u04e9\u0000\u04ea\u04eb\u0000\u04ee\u04ef\u0000\u04f0\u04f1\u0000\u04f2\u04f3\u0000\u04f4\u04f5\u0000\u04f8\u04f9\u0000\u0531\u0561\u0000\u0532\u0562\u0000\u0533\u0563\u0000\u0534\u0564\u0000\u0535\u0565\u0000\u0536\u0566\u0000\u0537\u0567\u0000\u0538\u0568\u0000\u0539\u0569\u0000\u053a\u056a\u0000\u053b\u056b\u0000\u053c\u056c\u0000\u053d\u056d\u0000\u053e\u056e\u0000\u053f\u056f\u0000\u0540\u0570\u0000\u0541\u0571\u0000\u0542\u0572\u0000\u0543\u0573\u0000\u0544\u0574\u0000\u0545\u0575\u0000\u0546\u0576\u0000\u0547\u0577\u0000\u0548\u0578\u0000\u0549\u0579\u0000\u054a\u057a\u0000\u054b\u057b\u0000\u054c\u057c\u0000\u054d\u057d\u0000\u054e\u057e\u0000\u054f\u057f\u0000\u0550\u0580\u0000\u0551\u0581\u0000\u0552\u0582\u0000\u0553\u0583\u0000\u0554\u0584\u0000\u0555\u0585\u0000\u0556\u0586\u0000\u10a0\u10d0\u0000\u10a1\u10d1\u0000\u10a2\u10d2\u0000\u10a3\u10d3\u0000\u10a4\u10d4\u0000\u10a5\u10d5\u0000\u10a6\u10d6\u0000\u10a7\u10d7\u0000\u10a8\u10d8\u0000\u10a9\u10d9\u0000\u10aa\u10da\u0000\u10ab\u10db\u0000\u10ac\u10dc\u0000\u10ad\u10dd\u0000\u10ae\u10de\u0000\u10af\u10df\u0000\u10b0\u10e0\u0000\u10b1\u10e1\u0000\u10b2\u10e2\u0000\u10b3\u10e3\u0000\u10b4\u10e4\u0000\u10b5\u10e5\u0000\u10b6\u10e6\u0000\u10b7\u10e7\u0000\u10b8\u10e8\u0000\u10b9\u10e9\u0000\u10ba\u10ea\u0000\u10bb\u10eb\u0000\u10bc\u10ec\u0000\u10bd\u10ed\u0000\u10be\u10ee\u0000\u10bf\u10ef\u0000\u10c0\u10f0\u0000\u10c1\u10f1\u0000\u10c2\u10f2\u0000\u10c3\u10f3\u0000\u10c4\u10f4\u0000\u10c5\u10f5\u0000\u1e00\u1e01\u0000\u1e02\u1e03\u0000\u1e04\u1e05\u0000\u1e06\u1e07\u0000\u1e08\u1e09\u0000\u1e0a\u1e0b\u0000\u1e0c\u1e0d\u0000\u1e0e\u1e0f\u0000\u1e10\u1e11\u0000\u1e12\u1e13\u0000\u1e14\u1e15\u0000\u1e16\u1e17\u0000\u1e18\u1e19\u0000\u1e1a\u1e1b\u0000\u1e1c\u1e1d\u0000\u1e1e\u1e1f\u0000\u1e20\u1e21\u0000\u1e22\u1e23\u0000\u1e24\u1e25\u0000\u1e26\u1e27\u0000\u1e28\u1e29\u0000\u1e2a\u1e2b\u0000\u1e2c\u1e2d\u0000\u1e2e\u1e2f\u0000\u1e30\u1e31\u0000\u1e32\u1e33\u0000\u1e34\u1e35\u0000\u1e36\u1e37\u0000\u1e38\u1e39\u0000\u1e3a\u1e3b\u0000\u1e3c\u1e3d\u0000\u1e3e\u1e3f\u0000\u1e40\u1e41\u0000\u1e42\u1e43\u0000\u1e44\u1e45\u0000\u1e46\u1e47\u0000\u1e48\u1e49\u0000\u1e4a\u1e4b\u0000\u1e4c\u1e4d\u0000\u1e4e\u1e4f\u0000\u1e50\u1e51\u0000\u1e52\u1e53\u0000\u1e54\u1e55\u0000\u1e56\u1e57\u0000\u1e58\u1e59\u0000\u1e5a\u1e5b\u0000\u1e5c\u1e5d\u0000\u1e5e\u1e5f\u0000\u1e60\u1e61\u0000\u1e62\u1e63\u0000\u1e64\u1e65\u0000\u1e66\u1e67\u0000\u1e68\u1e69\u0000\u1e6a\u1e6b\u0000\u1e6c\u1e6d\u0000\u1e6e\u1e6f\u0000\u1e70\u1e71\u0000\u1e72\u1e73\u0000\u1e74\u1e75\u0000\u1e76\u1e77\u0000\u1e78\u1e79\u0000\u1e7a\u1e7b\u0000\u1e7c\u1e7d\u0000\u1e7e\u1e7f\u0000\u1e80\u1e81\u0000\u1e82\u1e83\u0000\u1e84\u1e85\u0000\u1e86\u1e87\u0000\u1e88\u1e89\u0000\u1e8a\u1e8b\u0000\u1e8c\u1e8d\u0000\u1e8e\u1e8f\u0000\u1e90\u1e91\u0000\u1e92\u1e93\u0000\u1e94\u1e95\u0000\u1ea0\u1ea1\u0000\u1ea2\u1ea3\u0000\u1ea4\u1ea5\u0000\u1ea6\u1ea7\u0000\u1ea8\u1ea9\u0000\u1eaa\u1eab\u0000\u1eac\u1ead\u0000\u1eae\u1eaf\u0000\u1eb0\u1eb1\u0000\u1eb2\u1eb3\u0000\u1eb4\u1eb5\u0000\u1eb6\u1eb7\u0000\u1eb8\u1eb9\u0000\u1eba\u1ebb\u0000\u1ebc\u1ebd\u0000\u1ebe\u1ebf\u0000\u1ec0\u1ec1\u0000\u1ec2\u1ec3\u0000\u1ec4\u1ec5\u0000\u1ec6\u1ec7\u0000\u1ec8\u1ec9\u0000\u1eca\u1ecb\u0000\u1ecc\u1ecd\u0000\u1ece\u1ecf\u0000\u1ed0\u1ed1\u0000\u1ed2\u1ed3\u0000\u1ed4\u1ed5\u0000\u1ed6\u1ed7\u0000\u1ed8\u1ed9\u0000\u1eda\u1edb\u0000\u1edc\u1edd\u0000\u1ede\u1edf\u0000\u1ee0\u1ee1\u0000\u1ee2\u1ee3\u0000\u1ee4\u1ee5\u0000\u1ee6\u1ee7\u0000\u1ee8\u1ee9\u0000\u1eea\u1eeb\u0000\u1eec\u1eed\u0000\u1eee\u1eef\u0000\u1ef0\u1ef1\u0000\u1ef2\u1ef3\u0000\u1ef4\u1ef5\u0000\u1ef6\u1ef7\u0000\u1ef8\u1ef9\u0000\u1f00\u1f08\u0000\u1f01\u1f09\u0000\u1f02\u1f0a\u0000\u1f03\u1f0b\u0000\u1f04\u1f0c\u0000\u1f05\u1f0d\u0000\u1f06\u1f0e\u0000\u1f07\u1f0f\u0000\u1f10\u1f18\u0000\u1f11\u1f19\u0000\u1f12\u1f1a\u0000\u1f13\u1f1b\u0000\u1f14\u1f1c\u0000\u1f15\u1f1d\u0000\u1f20\u1f28\u0000\u1f21\u1f29\u0000\u1f22\u1f2a\u0000\u1f23\u1f2b\u0000\u1f24\u1f2c\u0000\u1f25\u1f2d\u0000\u1f26\u1f2e\u0000\u1f27\u1f2f\u0000\u1f30\u1f38\u0000\u1f31\u1f39\u0000\u1f32\u1f3a\u0000\u1f33\u1f3b\u0000\u1f34\u1f3c\u0000\u1f35\u1f3d\u0000\u1f36\u1f3e\u0000\u1f37\u1f3f\u0000\u1f40\u1f48\u0000\u1f41\u1f49\u0000\u1f42\u1f4a\u0000\u1f43\u1f4b\u0000\u1f44\u1f4c\u0000\u1f45\u1f4d\u0000\u1f51\u1f59\u0000\u1f53\u1f5b\u0000\u1f55\u1f5d\u0000\u1f57\u1f5f\u0000\u1f60\u1f68\u0000\u1f61\u1f69\u0000\u1f62\u1f6a\u0000\u1f63\u1f6b\u0000\u1f64\u1f6c\u0000\u1f65\u1f6d\u0000\u1f66\u1f6e\u0000\u1f67\u1f6f\u0000\u1f70\u1fba\u0000\u1f71\u1fbb\u0000\u1f72\u1fc8\u0000\u1f73\u1fc9\u0000\u1f74\u1fca\u0000\u1f75\u1fcb\u0000\u1f76\u1fda\u0000\u1f77\u1fdb\u0000\u1f78\u1ff8\u0000\u1f79\u1ff9\u0000\u1f7a\u1fea\u0000\u1f7b\u1feb\u0000\u1f7c\u1ffa\u0000\u1f7d\u1ffb\u0000\u1f80\u1f88\u0000\u1f81\u1f89\u0000\u1f82\u1f8a\u0000\u1f83\u1f8b\u0000\u1f84\u1f8c\u0000\u1f85\u1f8d\u0000\u1f86\u1f8e\u0000\u1f87\u1f8f\u0000\u1f90\u1f98\u0000\u1f91\u1f99\u0000\u1f92\u1f9a\u0000\u1f93\u1f9b\u0000\u1f94\u1f9c\u0000\u1f95\u1f9d\u0000\u1f96\u1f9e\u0000\u1f97\u1f9f\u0000\u1fa0\u1fa8\u0000\u1fa1\u1fa9\u0000\u1fa2\u1faa\u0000\u1fa3\u1fab\u0000\u1fa4\u1fac\u0000\u1fa5\u1fad\u0000\u1fa6\u1fae\u0000\u1fa7\u1faf\u0000\u1fb0\u1fb8\u0000\u1fb1\u1fb9\u0000\u1fb3\u1fbc\u0000\u1fc3\u1fcc\u0000\u1fd0\u1fd8\u0000\u1fd1\u1fd9\u0000\u1fe0\u1fe8\u0000\u1fe1\u1fe9\u0000\u1fe5\u1fec\u0000\u1ff3\u1ffc\u0000\u2160\u2170\u0000\u2161\u2171\u0000\u2162\u2172\u0000\u2163\u2173\u0000\u2164\u2174\u0000\u2165\u2175\u0000\u2166\u2176\u0000\u2167\u2177\u0000\u2168\u2178\u0000\u2169\u2179\u0000\u216a\u217a\u0000\u216b\u217b\u0000\u216c\u217c\u0000\u216d\u217d\u0000\u216e\u217e\u0000\u216f\u217f\u0000\u24b6\u24d0\u0000\u24b7\u24d1\u0000\u24b8\u24d2\u0000\u24b9\u24d3\u0000\u24ba\u24d4\u0000\u24bb\u24d5\u0000\u24bc\u24d6\u0000\u24bd\u24d7\u0000\u24be\u24d8\u0000\u24bf\u24d9\u0000\u24c0\u24da\u0000\u24c1\u24db\u0000\u24c2\u24dc\u0000\u24c3\u24dd\u0000\u24c4\u24de\u0000\u24c5\u24df\u0000\u24c6\u24e0\u0000\u24c7\u24e1\u0000\u24c8\u24e2\u0000\u24c9\u24e3\u0000\u24ca\u24e4\u0000\u24cb\u24e5\u0000\u24cc\u24e6\u0000\u24cd\u24e7\u0000\u24ce\u24e8\u0000\u24cf\u24e9\u0000\uff21\uff41\u0000\uff22\uff42\u0000\uff23\uff43\u0000\uff24\uff44\u0000\uff25\uff45\u0000\uff26\uff46\u0000\uff27\uff47\u0000\uff28\uff48\u0000\uff29\uff49\u0000\uff2a\uff4a\u0000\uff2b\uff4b\u0000\uff2c\uff4c\u0000\uff2d\uff4d\u0000\uff2e\uff4e\u0000\uff2f\uff4f\u0000\uff30\uff50\u0000\uff31\uff51\u0000\uff32\uff52\u0000\uff33\uff53\u0000\uff34\uff54\u0000\uff35\uff55\u0000\uff36\uff56\u0000\uff37\uff57\u0000\uff38\uff58\u0000\uff39\uff59\u0000\uff3a\uff5a\u0000", 3);
        } else if (version.equals("2") || version.equals("2.0") || version.equals("2.0.14")) {
            this.bind(Unicode_2_0.propertyValues, Unicode_2_0.intervals, Unicode_2_0.propertyValueAliases, 65535, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u0000\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u0000\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u0258\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u0000\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u0000\u0399\u03b9\u0000\u0000\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039c\u03bc\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c3\u0000\u0000\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u0000\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c7\u04c8\u0000\u0000\u04cb\u04cc\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f8\u04f9\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u10a0\u10d0\u0000\u0000\u10a1\u10d1\u0000\u0000\u10a2\u10d2\u0000\u0000\u10a3\u10d3\u0000\u0000\u10a4\u10d4\u0000\u0000\u10a5\u10d5\u0000\u0000\u10a6\u10d6\u0000\u0000\u10a7\u10d7\u0000\u0000\u10a8\u10d8\u0000\u0000\u10a9\u10d9\u0000\u0000\u10aa\u10da\u0000\u0000\u10ab\u10db\u0000\u0000\u10ac\u10dc\u0000\u0000\u10ad\u10dd\u0000\u0000\u10ae\u10de\u0000\u0000\u10af\u10df\u0000\u0000\u10b0\u10e0\u0000\u0000\u10b1\u10e1\u0000\u0000\u10b2\u10e2\u0000\u0000\u10b3\u10e3\u0000\u0000\u10b4\u10e4\u0000\u0000\u10b5\u10e5\u0000\u0000\u10b6\u10e6\u0000\u0000\u10b7\u10e7\u0000\u0000\u10b8\u10e8\u0000\u0000\u10b9\u10e9\u0000\u0000\u10ba\u10ea\u0000\u0000\u10bb\u10eb\u0000\u0000\u10bc\u10ec\u0000\u0000\u10bd\u10ed\u0000\u0000\u10be\u10ee\u0000\u0000\u10bf\u10ef\u0000\u0000\u10c0\u10f0\u0000\u0000\u10c1\u10f1\u0000\u0000\u10c2\u10f2\u0000\u0000\u10c3\u10f3\u0000\u0000\u10c4\u10f4\u0000\u0000\u10c5\u10f5\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u0000\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000", 4);
        } else if (version.equals("2.1") || version.equals("2.1.9")) {
            this.bind(Unicode_2_1.propertyValues, Unicode_2_1.intervals, Unicode_2_1.propertyValueAliases, 65535, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u0000\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u0000\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u0000\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u0000\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039c\u03bc\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u03f2\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u0000\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c7\u04c8\u0000\u0000\u04cb\u04cc\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f8\u04f9\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u10a0\u10d0\u0000\u0000\u10a1\u10d1\u0000\u0000\u10a2\u10d2\u0000\u0000\u10a3\u10d3\u0000\u0000\u10a4\u10d4\u0000\u0000\u10a5\u10d5\u0000\u0000\u10a6\u10d6\u0000\u0000\u10a7\u10d7\u0000\u0000\u10a8\u10d8\u0000\u0000\u10a9\u10d9\u0000\u0000\u10aa\u10da\u0000\u0000\u10ab\u10db\u0000\u0000\u10ac\u10dc\u0000\u0000\u10ad\u10dd\u0000\u0000\u10ae\u10de\u0000\u0000\u10af\u10df\u0000\u0000\u10b0\u10e0\u0000\u0000\u10b1\u10e1\u0000\u0000\u10b2\u10e2\u0000\u0000\u10b3\u10e3\u0000\u0000\u10b4\u10e4\u0000\u0000\u10b5\u10e5\u0000\u0000\u10b6\u10e6\u0000\u0000\u10b7\u10e7\u0000\u0000\u10b8\u10e8\u0000\u0000\u10b9\u10e9\u0000\u0000\u10ba\u10ea\u0000\u0000\u10bb\u10eb\u0000\u0000\u10bc\u10ec\u0000\u0000\u10bd\u10ed\u0000\u0000\u10be\u10ee\u0000\u0000\u10bf\u10ef\u0000\u0000\u10c0\u10f0\u0000\u0000\u10c1\u10f1\u0000\u0000\u10c2\u10f2\u0000\u0000\u10c3\u10f3\u0000\u0000\u10c4\u10f4\u0000\u0000\u10c5\u10f5\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000", 4);
        } else if (version.equals("3") || version.equals("3.0") || version.equals("3.0.1")) {
            this.bind(Unicode_3_0.propertyValues, Unicode_3_0.intervals, Unicode_3_0.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u0000\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u0000\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u03f2\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c7\u04c8\u0000\u0000\u04cb\u04cc\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f8\u04f9\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000", 4);
        } else if (version.equals("3.1") || version.equals("3.1.0")) {
            this.bind(Unicode_3_1.propertyValues, Unicode_3_1.intervals, Unicode_3_1.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u03f5\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u03f4\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u03f2\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c7\u04c8\u0000\u0000\u04cb\u04cc\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f8\u04f9\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000\ud801\udc00\ud801\udc28\u0000\u0000\ud801\udc01\ud801\udc29\u0000\u0000\ud801\udc02\ud801\udc2a\u0000\u0000\ud801\udc03\ud801\udc2b\u0000\u0000\ud801\udc04\ud801\udc2c\u0000\u0000\ud801\udc05\ud801\udc2d\u0000\u0000\ud801\udc06\ud801\udc2e\u0000\u0000\ud801\udc07\ud801\udc2f\u0000\u0000\ud801\udc08\ud801\udc30\u0000\u0000\ud801\udc09\ud801\udc31\u0000\u0000\ud801\udc0a\ud801\udc32\u0000\u0000\ud801\udc0b\ud801\udc33\u0000\u0000\ud801\udc0c\ud801\udc34\u0000\u0000\ud801\udc0d\ud801\udc35\u0000\u0000\ud801\udc0e\ud801\udc36\u0000\u0000\ud801\udc0f\ud801\udc37\u0000\u0000\ud801\udc10\ud801\udc38\u0000\u0000\ud801\udc11\ud801\udc39\u0000\u0000\ud801\udc12\ud801\udc3a\u0000\u0000\ud801\udc13\ud801\udc3b\u0000\u0000\ud801\udc14\ud801\udc3c\u0000\u0000\ud801\udc15\ud801\udc3d\u0000\u0000\ud801\udc16\ud801\udc3e\u0000\u0000\ud801\udc17\ud801\udc3f\u0000\u0000\ud801\udc18\ud801\udc40\u0000\u0000\ud801\udc19\ud801\udc41\u0000\u0000\ud801\udc1a\ud801\udc42\u0000\u0000\ud801\udc1b\ud801\udc43\u0000\u0000\ud801\udc1c\ud801\udc44\u0000\u0000\ud801\udc1d\ud801\udc45\u0000\u0000\ud801\udc1e\ud801\udc46\u0000\u0000\ud801\udc1f\ud801\udc47\u0000\u0000\ud801\udc20\ud801\udc48\u0000\u0000\ud801\udc21\ud801\udc49\u0000\u0000\ud801\udc22\ud801\udc4a\u0000\u0000\ud801\udc23\ud801\udc4b\u0000\u0000\ud801\udc24\ud801\udc4c\u0000\u0000\ud801\udc25\ud801\udc4d\u0000\u0000", 4);
        } else if (version.equals("3.2") || version.equals("3.2.0")) {
            this.bind(Unicode_3_2.propertyValues, Unicode_3_2.intervals, Unicode_3_2.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019e\u0220\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u03f5\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u03f4\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u03f2\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03d8\u03d9\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048a\u048b\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c5\u04c6\u0000\u0000\u04c7\u04c8\u0000\u0000\u04c9\u04ca\u0000\u0000\u04cb\u04cc\u0000\u0000\u04cd\u04ce\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f8\u04f9\u0000\u0000\u0500\u0501\u0000\u0000\u0502\u0503\u0000\u0000\u0504\u0505\u0000\u0000\u0506\u0507\u0000\u0000\u0508\u0509\u0000\u0000\u050a\u050b\u0000\u0000\u050c\u050d\u0000\u0000\u050e\u050f\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000\ud801\udc00\ud801\udc28\u0000\u0000\ud801\udc01\ud801\udc29\u0000\u0000\ud801\udc02\ud801\udc2a\u0000\u0000\ud801\udc03\ud801\udc2b\u0000\u0000\ud801\udc04\ud801\udc2c\u0000\u0000\ud801\udc05\ud801\udc2d\u0000\u0000\ud801\udc06\ud801\udc2e\u0000\u0000\ud801\udc07\ud801\udc2f\u0000\u0000\ud801\udc08\ud801\udc30\u0000\u0000\ud801\udc09\ud801\udc31\u0000\u0000\ud801\udc0a\ud801\udc32\u0000\u0000\ud801\udc0b\ud801\udc33\u0000\u0000\ud801\udc0c\ud801\udc34\u0000\u0000\ud801\udc0d\ud801\udc35\u0000\u0000\ud801\udc0e\ud801\udc36\u0000\u0000\ud801\udc0f\ud801\udc37\u0000\u0000\ud801\udc10\ud801\udc38\u0000\u0000\ud801\udc11\ud801\udc39\u0000\u0000\ud801\udc12\ud801\udc3a\u0000\u0000\ud801\udc13\ud801\udc3b\u0000\u0000\ud801\udc14\ud801\udc3c\u0000\u0000\ud801\udc15\ud801\udc3d\u0000\u0000\ud801\udc16\ud801\udc3e\u0000\u0000\ud801\udc17\ud801\udc3f\u0000\u0000\ud801\udc18\ud801\udc40\u0000\u0000\ud801\udc19\ud801\udc41\u0000\u0000\ud801\udc1a\ud801\udc42\u0000\u0000\ud801\udc1b\ud801\udc43\u0000\u0000\ud801\udc1c\ud801\udc44\u0000\u0000\ud801\udc1d\ud801\udc45\u0000\u0000\ud801\udc1e\ud801\udc46\u0000\u0000\ud801\udc1f\ud801\udc47\u0000\u0000\ud801\udc20\ud801\udc48\u0000\u0000\ud801\udc21\ud801\udc49\u0000\u0000\ud801\udc22\ud801\udc4a\u0000\u0000\ud801\udc23\ud801\udc4b\u0000\u0000\ud801\udc24\ud801\udc4c\u0000\u0000\ud801\udc25\ud801\udc4d\u0000\u0000", 4);
        } else if (version.equals("4") || version.equals("4.0") || version.equals("4.0.1")) {
            this.bind(Unicode_4_0.propertyValues, Unicode_4_0.intervals, Unicode_4_0.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019e\u0220\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u03f5\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u03f4\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u0000\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03d8\u03d9\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u03f2\u03f9\u0000\u0000\u03f7\u03f8\u0000\u0000\u03fa\u03fb\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048a\u048b\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c5\u04c6\u0000\u0000\u04c7\u04c8\u0000\u0000\u04c9\u04ca\u0000\u0000\u04cb\u04cc\u0000\u0000\u04cd\u04ce\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f8\u04f9\u0000\u0000\u0500\u0501\u0000\u0000\u0502\u0503\u0000\u0000\u0504\u0505\u0000\u0000\u0506\u0507\u0000\u0000\u0508\u0509\u0000\u0000\u050a\u050b\u0000\u0000\u050c\u050d\u0000\u0000\u050e\u050f\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000\ud801\udc00\ud801\udc28\u0000\u0000\ud801\udc01\ud801\udc29\u0000\u0000\ud801\udc02\ud801\udc2a\u0000\u0000\ud801\udc03\ud801\udc2b\u0000\u0000\ud801\udc04\ud801\udc2c\u0000\u0000\ud801\udc05\ud801\udc2d\u0000\u0000\ud801\udc06\ud801\udc2e\u0000\u0000\ud801\udc07\ud801\udc2f\u0000\u0000\ud801\udc08\ud801\udc30\u0000\u0000\ud801\udc09\ud801\udc31\u0000\u0000\ud801\udc0a\ud801\udc32\u0000\u0000\ud801\udc0b\ud801\udc33\u0000\u0000\ud801\udc0c\ud801\udc34\u0000\u0000\ud801\udc0d\ud801\udc35\u0000\u0000\ud801\udc0e\ud801\udc36\u0000\u0000\ud801\udc0f\ud801\udc37\u0000\u0000\ud801\udc10\ud801\udc38\u0000\u0000\ud801\udc11\ud801\udc39\u0000\u0000\ud801\udc12\ud801\udc3a\u0000\u0000\ud801\udc13\ud801\udc3b\u0000\u0000\ud801\udc14\ud801\udc3c\u0000\u0000\ud801\udc15\ud801\udc3d\u0000\u0000\ud801\udc16\ud801\udc3e\u0000\u0000\ud801\udc17\ud801\udc3f\u0000\u0000\ud801\udc18\ud801\udc40\u0000\u0000\ud801\udc19\ud801\udc41\u0000\u0000\ud801\udc1a\ud801\udc42\u0000\u0000\ud801\udc1b\ud801\udc43\u0000\u0000\ud801\udc1c\ud801\udc44\u0000\u0000\ud801\udc1d\ud801\udc45\u0000\u0000\ud801\udc1e\ud801\udc46\u0000\u0000\ud801\udc1f\ud801\udc47\u0000\u0000\ud801\udc20\ud801\udc48\u0000\u0000\ud801\udc21\ud801\udc49\u0000\u0000\ud801\udc22\ud801\udc4a\u0000\u0000\ud801\udc23\ud801\udc4b\u0000\u0000\ud801\udc24\ud801\udc4c\u0000\u0000\ud801\udc25\ud801\udc4d\u0000\u0000\ud801\udc26\ud801\udc4e\u0000\u0000\ud801\udc27\ud801\udc4f\u0000\u0000", 4);
        } else if (version.equals("4.1") || version.equals("4.1.0")) {
            this.bind(Unicode_4_1.propertyValues, Unicode_4_1.intervals, Unicode_4_1.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019a\u023d\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019e\u0220\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u023b\u023c\u0000\u0000\u0241\u0294\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u03f5\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u03f4\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u0000\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03d8\u03d9\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u03f2\u03f9\u0000\u0000\u03f7\u03f8\u0000\u0000\u03fa\u03fb\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048a\u048b\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c5\u04c6\u0000\u0000\u04c7\u04c8\u0000\u0000\u04c9\u04ca\u0000\u0000\u04cb\u04cc\u0000\u0000\u04cd\u04ce\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f6\u04f7\u0000\u0000\u04f8\u04f9\u0000\u0000\u0500\u0501\u0000\u0000\u0502\u0503\u0000\u0000\u0504\u0505\u0000\u0000\u0506\u0507\u0000\u0000\u0508\u0509\u0000\u0000\u050a\u050b\u0000\u0000\u050c\u050d\u0000\u0000\u050e\u050f\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u10a0\u2d00\u0000\u0000\u10a1\u2d01\u0000\u0000\u10a2\u2d02\u0000\u0000\u10a3\u2d03\u0000\u0000\u10a4\u2d04\u0000\u0000\u10a5\u2d05\u0000\u0000\u10a6\u2d06\u0000\u0000\u10a7\u2d07\u0000\u0000\u10a8\u2d08\u0000\u0000\u10a9\u2d09\u0000\u0000\u10aa\u2d0a\u0000\u0000\u10ab\u2d0b\u0000\u0000\u10ac\u2d0c\u0000\u0000\u10ad\u2d0d\u0000\u0000\u10ae\u2d0e\u0000\u0000\u10af\u2d0f\u0000\u0000\u10b0\u2d10\u0000\u0000\u10b1\u2d11\u0000\u0000\u10b2\u2d12\u0000\u0000\u10b3\u2d13\u0000\u0000\u10b4\u2d14\u0000\u0000\u10b5\u2d15\u0000\u0000\u10b6\u2d16\u0000\u0000\u10b7\u2d17\u0000\u0000\u10b8\u2d18\u0000\u0000\u10b9\u2d19\u0000\u0000\u10ba\u2d1a\u0000\u0000\u10bb\u2d1b\u0000\u0000\u10bc\u2d1c\u0000\u0000\u10bd\u2d1d\u0000\u0000\u10be\u2d1e\u0000\u0000\u10bf\u2d1f\u0000\u0000\u10c0\u2d20\u0000\u0000\u10c1\u2d21\u0000\u0000\u10c2\u2d22\u0000\u0000\u10c3\u2d23\u0000\u0000\u10c4\u2d24\u0000\u0000\u10c5\u2d25\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\u2c00\u2c30\u0000\u0000\u2c01\u2c31\u0000\u0000\u2c02\u2c32\u0000\u0000\u2c03\u2c33\u0000\u0000\u2c04\u2c34\u0000\u0000\u2c05\u2c35\u0000\u0000\u2c06\u2c36\u0000\u0000\u2c07\u2c37\u0000\u0000\u2c08\u2c38\u0000\u0000\u2c09\u2c39\u0000\u0000\u2c0a\u2c3a\u0000\u0000\u2c0b\u2c3b\u0000\u0000\u2c0c\u2c3c\u0000\u0000\u2c0d\u2c3d\u0000\u0000\u2c0e\u2c3e\u0000\u0000\u2c0f\u2c3f\u0000\u0000\u2c10\u2c40\u0000\u0000\u2c11\u2c41\u0000\u0000\u2c12\u2c42\u0000\u0000\u2c13\u2c43\u0000\u0000\u2c14\u2c44\u0000\u0000\u2c15\u2c45\u0000\u0000\u2c16\u2c46\u0000\u0000\u2c17\u2c47\u0000\u0000\u2c18\u2c48\u0000\u0000\u2c19\u2c49\u0000\u0000\u2c1a\u2c4a\u0000\u0000\u2c1b\u2c4b\u0000\u0000\u2c1c\u2c4c\u0000\u0000\u2c1d\u2c4d\u0000\u0000\u2c1e\u2c4e\u0000\u0000\u2c1f\u2c4f\u0000\u0000\u2c20\u2c50\u0000\u0000\u2c21\u2c51\u0000\u0000\u2c22\u2c52\u0000\u0000\u2c23\u2c53\u0000\u0000\u2c24\u2c54\u0000\u0000\u2c25\u2c55\u0000\u0000\u2c26\u2c56\u0000\u0000\u2c27\u2c57\u0000\u0000\u2c28\u2c58\u0000\u0000\u2c29\u2c59\u0000\u0000\u2c2a\u2c5a\u0000\u0000\u2c2b\u2c5b\u0000\u0000\u2c2c\u2c5c\u0000\u0000\u2c2d\u2c5d\u0000\u0000\u2c2e\u2c5e\u0000\u0000\u2c80\u2c81\u0000\u0000\u2c82\u2c83\u0000\u0000\u2c84\u2c85\u0000\u0000\u2c86\u2c87\u0000\u0000\u2c88\u2c89\u0000\u0000\u2c8a\u2c8b\u0000\u0000\u2c8c\u2c8d\u0000\u0000\u2c8e\u2c8f\u0000\u0000\u2c90\u2c91\u0000\u0000\u2c92\u2c93\u0000\u0000\u2c94\u2c95\u0000\u0000\u2c96\u2c97\u0000\u0000\u2c98\u2c99\u0000\u0000\u2c9a\u2c9b\u0000\u0000\u2c9c\u2c9d\u0000\u0000\u2c9e\u2c9f\u0000\u0000\u2ca0\u2ca1\u0000\u0000\u2ca2\u2ca3\u0000\u0000\u2ca4\u2ca5\u0000\u0000\u2ca6\u2ca7\u0000\u0000\u2ca8\u2ca9\u0000\u0000\u2caa\u2cab\u0000\u0000\u2cac\u2cad\u0000\u0000\u2cae\u2caf\u0000\u0000\u2cb0\u2cb1\u0000\u0000\u2cb2\u2cb3\u0000\u0000\u2cb4\u2cb5\u0000\u0000\u2cb6\u2cb7\u0000\u0000\u2cb8\u2cb9\u0000\u0000\u2cba\u2cbb\u0000\u0000\u2cbc\u2cbd\u0000\u0000\u2cbe\u2cbf\u0000\u0000\u2cc0\u2cc1\u0000\u0000\u2cc2\u2cc3\u0000\u0000\u2cc4\u2cc5\u0000\u0000\u2cc6\u2cc7\u0000\u0000\u2cc8\u2cc9\u0000\u0000\u2cca\u2ccb\u0000\u0000\u2ccc\u2ccd\u0000\u0000\u2cce\u2ccf\u0000\u0000\u2cd0\u2cd1\u0000\u0000\u2cd2\u2cd3\u0000\u0000\u2cd4\u2cd5\u0000\u0000\u2cd6\u2cd7\u0000\u0000\u2cd8\u2cd9\u0000\u0000\u2cda\u2cdb\u0000\u0000\u2cdc\u2cdd\u0000\u0000\u2cde\u2cdf\u0000\u0000\u2ce0\u2ce1\u0000\u0000\u2ce2\u2ce3\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000\ud801\udc00\ud801\udc28\u0000\u0000\ud801\udc01\ud801\udc29\u0000\u0000\ud801\udc02\ud801\udc2a\u0000\u0000\ud801\udc03\ud801\udc2b\u0000\u0000\ud801\udc04\ud801\udc2c\u0000\u0000\ud801\udc05\ud801\udc2d\u0000\u0000\ud801\udc06\ud801\udc2e\u0000\u0000\ud801\udc07\ud801\udc2f\u0000\u0000\ud801\udc08\ud801\udc30\u0000\u0000\ud801\udc09\ud801\udc31\u0000\u0000\ud801\udc0a\ud801\udc32\u0000\u0000\ud801\udc0b\ud801\udc33\u0000\u0000\ud801\udc0c\ud801\udc34\u0000\u0000\ud801\udc0d\ud801\udc35\u0000\u0000\ud801\udc0e\ud801\udc36\u0000\u0000\ud801\udc0f\ud801\udc37\u0000\u0000\ud801\udc10\ud801\udc38\u0000\u0000\ud801\udc11\ud801\udc39\u0000\u0000\ud801\udc12\ud801\udc3a\u0000\u0000\ud801\udc13\ud801\udc3b\u0000\u0000\ud801\udc14\ud801\udc3c\u0000\u0000\ud801\udc15\ud801\udc3d\u0000\u0000\ud801\udc16\ud801\udc3e\u0000\u0000\ud801\udc17\ud801\udc3f\u0000\u0000\ud801\udc18\ud801\udc40\u0000\u0000\ud801\udc19\ud801\udc41\u0000\u0000\ud801\udc1a\ud801\udc42\u0000\u0000\ud801\udc1b\ud801\udc43\u0000\u0000\ud801\udc1c\ud801\udc44\u0000\u0000\ud801\udc1d\ud801\udc45\u0000\u0000\ud801\udc1e\ud801\udc46\u0000\u0000\ud801\udc1f\ud801\udc47\u0000\u0000\ud801\udc20\ud801\udc48\u0000\u0000\ud801\udc21\ud801\udc49\u0000\u0000\ud801\udc22\ud801\udc4a\u0000\u0000\ud801\udc23\ud801\udc4b\u0000\u0000\ud801\udc24\ud801\udc4c\u0000\u0000\ud801\udc25\ud801\udc4d\u0000\u0000\ud801\udc26\ud801\udc4e\u0000\u0000\ud801\udc27\ud801\udc4f\u0000\u0000", 4);
        } else if (version.equals("5") || version.equals("5.0") || version.equals("5.0.0")) {
            this.bind(Unicode_5_0.propertyValues, Unicode_5_0.intervals, Unicode_5_0.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0180\u0243\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019a\u023d\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019e\u0220\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u023a\u2c65\u0000\u0000\u023b\u023c\u0000\u0000\u023e\u2c66\u0000\u0000\u0241\u0242\u0000\u0000\u0244\u0289\u0000\u0000\u0245\u028c\u0000\u0000\u0246\u0247\u0000\u0000\u0248\u0249\u0000\u0000\u024a\u024b\u0000\u0000\u024c\u024d\u0000\u0000\u024e\u024f\u0000\u0000\u026b\u2c62\u0000\u0000\u027d\u2c64\u0000\u0000\u0345\u0399\u03b9\u1fbe\u037b\u03fd\u0000\u0000\u037c\u03fe\u0000\u0000\u037d\u03ff\u0000\u0000\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u03f5\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u03f4\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u0000\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03d8\u03d9\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u03f2\u03f9\u0000\u0000\u03f7\u03f8\u0000\u0000\u03fa\u03fb\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048a\u048b\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c0\u04cf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c5\u04c6\u0000\u0000\u04c7\u04c8\u0000\u0000\u04c9\u04ca\u0000\u0000\u04cb\u04cc\u0000\u0000\u04cd\u04ce\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f6\u04f7\u0000\u0000\u04f8\u04f9\u0000\u0000\u04fa\u04fb\u0000\u0000\u04fc\u04fd\u0000\u0000\u04fe\u04ff\u0000\u0000\u0500\u0501\u0000\u0000\u0502\u0503\u0000\u0000\u0504\u0505\u0000\u0000\u0506\u0507\u0000\u0000\u0508\u0509\u0000\u0000\u050a\u050b\u0000\u0000\u050c\u050d\u0000\u0000\u050e\u050f\u0000\u0000\u0510\u0511\u0000\u0000\u0512\u0513\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u10a0\u2d00\u0000\u0000\u10a1\u2d01\u0000\u0000\u10a2\u2d02\u0000\u0000\u10a3\u2d03\u0000\u0000\u10a4\u2d04\u0000\u0000\u10a5\u2d05\u0000\u0000\u10a6\u2d06\u0000\u0000\u10a7\u2d07\u0000\u0000\u10a8\u2d08\u0000\u0000\u10a9\u2d09\u0000\u0000\u10aa\u2d0a\u0000\u0000\u10ab\u2d0b\u0000\u0000\u10ac\u2d0c\u0000\u0000\u10ad\u2d0d\u0000\u0000\u10ae\u2d0e\u0000\u0000\u10af\u2d0f\u0000\u0000\u10b0\u2d10\u0000\u0000\u10b1\u2d11\u0000\u0000\u10b2\u2d12\u0000\u0000\u10b3\u2d13\u0000\u0000\u10b4\u2d14\u0000\u0000\u10b5\u2d15\u0000\u0000\u10b6\u2d16\u0000\u0000\u10b7\u2d17\u0000\u0000\u10b8\u2d18\u0000\u0000\u10b9\u2d19\u0000\u0000\u10ba\u2d1a\u0000\u0000\u10bb\u2d1b\u0000\u0000\u10bc\u2d1c\u0000\u0000\u10bd\u2d1d\u0000\u0000\u10be\u2d1e\u0000\u0000\u10bf\u2d1f\u0000\u0000\u10c0\u2d20\u0000\u0000\u10c1\u2d21\u0000\u0000\u10c2\u2d22\u0000\u0000\u10c3\u2d23\u0000\u0000\u10c4\u2d24\u0000\u0000\u10c5\u2d25\u0000\u0000\u1d7d\u2c63\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2132\u214e\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u2183\u2184\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\u2c00\u2c30\u0000\u0000\u2c01\u2c31\u0000\u0000\u2c02\u2c32\u0000\u0000\u2c03\u2c33\u0000\u0000\u2c04\u2c34\u0000\u0000\u2c05\u2c35\u0000\u0000\u2c06\u2c36\u0000\u0000\u2c07\u2c37\u0000\u0000\u2c08\u2c38\u0000\u0000\u2c09\u2c39\u0000\u0000\u2c0a\u2c3a\u0000\u0000\u2c0b\u2c3b\u0000\u0000\u2c0c\u2c3c\u0000\u0000\u2c0d\u2c3d\u0000\u0000\u2c0e\u2c3e\u0000\u0000\u2c0f\u2c3f\u0000\u0000\u2c10\u2c40\u0000\u0000\u2c11\u2c41\u0000\u0000\u2c12\u2c42\u0000\u0000\u2c13\u2c43\u0000\u0000\u2c14\u2c44\u0000\u0000\u2c15\u2c45\u0000\u0000\u2c16\u2c46\u0000\u0000\u2c17\u2c47\u0000\u0000\u2c18\u2c48\u0000\u0000\u2c19\u2c49\u0000\u0000\u2c1a\u2c4a\u0000\u0000\u2c1b\u2c4b\u0000\u0000\u2c1c\u2c4c\u0000\u0000\u2c1d\u2c4d\u0000\u0000\u2c1e\u2c4e\u0000\u0000\u2c1f\u2c4f\u0000\u0000\u2c20\u2c50\u0000\u0000\u2c21\u2c51\u0000\u0000\u2c22\u2c52\u0000\u0000\u2c23\u2c53\u0000\u0000\u2c24\u2c54\u0000\u0000\u2c25\u2c55\u0000\u0000\u2c26\u2c56\u0000\u0000\u2c27\u2c57\u0000\u0000\u2c28\u2c58\u0000\u0000\u2c29\u2c59\u0000\u0000\u2c2a\u2c5a\u0000\u0000\u2c2b\u2c5b\u0000\u0000\u2c2c\u2c5c\u0000\u0000\u2c2d\u2c5d\u0000\u0000\u2c2e\u2c5e\u0000\u0000\u2c60\u2c61\u0000\u0000\u2c67\u2c68\u0000\u0000\u2c69\u2c6a\u0000\u0000\u2c6b\u2c6c\u0000\u0000\u2c75\u2c76\u0000\u0000\u2c80\u2c81\u0000\u0000\u2c82\u2c83\u0000\u0000\u2c84\u2c85\u0000\u0000\u2c86\u2c87\u0000\u0000\u2c88\u2c89\u0000\u0000\u2c8a\u2c8b\u0000\u0000\u2c8c\u2c8d\u0000\u0000\u2c8e\u2c8f\u0000\u0000\u2c90\u2c91\u0000\u0000\u2c92\u2c93\u0000\u0000\u2c94\u2c95\u0000\u0000\u2c96\u2c97\u0000\u0000\u2c98\u2c99\u0000\u0000\u2c9a\u2c9b\u0000\u0000\u2c9c\u2c9d\u0000\u0000\u2c9e\u2c9f\u0000\u0000\u2ca0\u2ca1\u0000\u0000\u2ca2\u2ca3\u0000\u0000\u2ca4\u2ca5\u0000\u0000\u2ca6\u2ca7\u0000\u0000\u2ca8\u2ca9\u0000\u0000\u2caa\u2cab\u0000\u0000\u2cac\u2cad\u0000\u0000\u2cae\u2caf\u0000\u0000\u2cb0\u2cb1\u0000\u0000\u2cb2\u2cb3\u0000\u0000\u2cb4\u2cb5\u0000\u0000\u2cb6\u2cb7\u0000\u0000\u2cb8\u2cb9\u0000\u0000\u2cba\u2cbb\u0000\u0000\u2cbc\u2cbd\u0000\u0000\u2cbe\u2cbf\u0000\u0000\u2cc0\u2cc1\u0000\u0000\u2cc2\u2cc3\u0000\u0000\u2cc4\u2cc5\u0000\u0000\u2cc6\u2cc7\u0000\u0000\u2cc8\u2cc9\u0000\u0000\u2cca\u2ccb\u0000\u0000\u2ccc\u2ccd\u0000\u0000\u2cce\u2ccf\u0000\u0000\u2cd0\u2cd1\u0000\u0000\u2cd2\u2cd3\u0000\u0000\u2cd4\u2cd5\u0000\u0000\u2cd6\u2cd7\u0000\u0000\u2cd8\u2cd9\u0000\u0000\u2cda\u2cdb\u0000\u0000\u2cdc\u2cdd\u0000\u0000\u2cde\u2cdf\u0000\u0000\u2ce0\u2ce1\u0000\u0000\u2ce2\u2ce3\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000\ud801\udc00\ud801\udc28\u0000\u0000\ud801\udc01\ud801\udc29\u0000\u0000\ud801\udc02\ud801\udc2a\u0000\u0000\ud801\udc03\ud801\udc2b\u0000\u0000\ud801\udc04\ud801\udc2c\u0000\u0000\ud801\udc05\ud801\udc2d\u0000\u0000\ud801\udc06\ud801\udc2e\u0000\u0000\ud801\udc07\ud801\udc2f\u0000\u0000\ud801\udc08\ud801\udc30\u0000\u0000\ud801\udc09\ud801\udc31\u0000\u0000\ud801\udc0a\ud801\udc32\u0000\u0000\ud801\udc0b\ud801\udc33\u0000\u0000\ud801\udc0c\ud801\udc34\u0000\u0000\ud801\udc0d\ud801\udc35\u0000\u0000\ud801\udc0e\ud801\udc36\u0000\u0000\ud801\udc0f\ud801\udc37\u0000\u0000\ud801\udc10\ud801\udc38\u0000\u0000\ud801\udc11\ud801\udc39\u0000\u0000\ud801\udc12\ud801\udc3a\u0000\u0000\ud801\udc13\ud801\udc3b\u0000\u0000\ud801\udc14\ud801\udc3c\u0000\u0000\ud801\udc15\ud801\udc3d\u0000\u0000\ud801\udc16\ud801\udc3e\u0000\u0000\ud801\udc17\ud801\udc3f\u0000\u0000\ud801\udc18\ud801\udc40\u0000\u0000\ud801\udc19\ud801\udc41\u0000\u0000\ud801\udc1a\ud801\udc42\u0000\u0000\ud801\udc1b\ud801\udc43\u0000\u0000\ud801\udc1c\ud801\udc44\u0000\u0000\ud801\udc1d\ud801\udc45\u0000\u0000\ud801\udc1e\ud801\udc46\u0000\u0000\ud801\udc1f\ud801\udc47\u0000\u0000\ud801\udc20\ud801\udc48\u0000\u0000\ud801\udc21\ud801\udc49\u0000\u0000\ud801\udc22\ud801\udc4a\u0000\u0000\ud801\udc23\ud801\udc4b\u0000\u0000\ud801\udc24\ud801\udc4c\u0000\u0000\ud801\udc25\ud801\udc4d\u0000\u0000\ud801\udc26\ud801\udc4e\u0000\u0000\ud801\udc27\ud801\udc4f\u0000\u0000", 4);
        } else if (version.equals("5.1") || version.equals("5.1.0")) {
            this.bind(Unicode_5_1.propertyValues, Unicode_5_1.intervals, Unicode_5_1.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00df\u1e9e\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0180\u0243\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019a\u023d\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019e\u0220\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u023a\u2c65\u0000\u0000\u023b\u023c\u0000\u0000\u023e\u2c66\u0000\u0000\u0241\u0242\u0000\u0000\u0244\u0289\u0000\u0000\u0245\u028c\u0000\u0000\u0246\u0247\u0000\u0000\u0248\u0249\u0000\u0000\u024a\u024b\u0000\u0000\u024c\u024d\u0000\u0000\u024e\u024f\u0000\u0000\u0250\u2c6f\u0000\u0000\u0251\u2c6d\u0000\u0000\u026b\u2c62\u0000\u0000\u0271\u2c6e\u0000\u0000\u027d\u2c64\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0370\u0371\u0000\u0000\u0372\u0373\u0000\u0000\u0376\u0377\u0000\u0000\u037b\u03fd\u0000\u0000\u037c\u03fe\u0000\u0000\u037d\u03ff\u0000\u0000\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u03f5\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u03f4\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u0000\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03cf\u03d7\u0000\u0000\u03d8\u03d9\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u03f2\u03f9\u0000\u0000\u03f7\u03f8\u0000\u0000\u03fa\u03fb\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048a\u048b\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c0\u04cf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c5\u04c6\u0000\u0000\u04c7\u04c8\u0000\u0000\u04c9\u04ca\u0000\u0000\u04cb\u04cc\u0000\u0000\u04cd\u04ce\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f6\u04f7\u0000\u0000\u04f8\u04f9\u0000\u0000\u04fa\u04fb\u0000\u0000\u04fc\u04fd\u0000\u0000\u04fe\u04ff\u0000\u0000\u0500\u0501\u0000\u0000\u0502\u0503\u0000\u0000\u0504\u0505\u0000\u0000\u0506\u0507\u0000\u0000\u0508\u0509\u0000\u0000\u050a\u050b\u0000\u0000\u050c\u050d\u0000\u0000\u050e\u050f\u0000\u0000\u0510\u0511\u0000\u0000\u0512\u0513\u0000\u0000\u0514\u0515\u0000\u0000\u0516\u0517\u0000\u0000\u0518\u0519\u0000\u0000\u051a\u051b\u0000\u0000\u051c\u051d\u0000\u0000\u051e\u051f\u0000\u0000\u0520\u0521\u0000\u0000\u0522\u0523\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u10a0\u2d00\u0000\u0000\u10a1\u2d01\u0000\u0000\u10a2\u2d02\u0000\u0000\u10a3\u2d03\u0000\u0000\u10a4\u2d04\u0000\u0000\u10a5\u2d05\u0000\u0000\u10a6\u2d06\u0000\u0000\u10a7\u2d07\u0000\u0000\u10a8\u2d08\u0000\u0000\u10a9\u2d09\u0000\u0000\u10aa\u2d0a\u0000\u0000\u10ab\u2d0b\u0000\u0000\u10ac\u2d0c\u0000\u0000\u10ad\u2d0d\u0000\u0000\u10ae\u2d0e\u0000\u0000\u10af\u2d0f\u0000\u0000\u10b0\u2d10\u0000\u0000\u10b1\u2d11\u0000\u0000\u10b2\u2d12\u0000\u0000\u10b3\u2d13\u0000\u0000\u10b4\u2d14\u0000\u0000\u10b5\u2d15\u0000\u0000\u10b6\u2d16\u0000\u0000\u10b7\u2d17\u0000\u0000\u10b8\u2d18\u0000\u0000\u10b9\u2d19\u0000\u0000\u10ba\u2d1a\u0000\u0000\u10bb\u2d1b\u0000\u0000\u10bc\u2d1c\u0000\u0000\u10bd\u2d1d\u0000\u0000\u10be\u2d1e\u0000\u0000\u10bf\u2d1f\u0000\u0000\u10c0\u2d20\u0000\u0000\u10c1\u2d21\u0000\u0000\u10c2\u2d22\u0000\u0000\u10c3\u2d23\u0000\u0000\u10c4\u2d24\u0000\u0000\u10c5\u2d25\u0000\u0000\u1d79\ua77d\u0000\u0000\u1d7d\u2c63\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1efa\u1efb\u0000\u0000\u1efc\u1efd\u0000\u0000\u1efe\u1eff\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2132\u214e\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u2183\u2184\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\u2c00\u2c30\u0000\u0000\u2c01\u2c31\u0000\u0000\u2c02\u2c32\u0000\u0000\u2c03\u2c33\u0000\u0000\u2c04\u2c34\u0000\u0000\u2c05\u2c35\u0000\u0000\u2c06\u2c36\u0000\u0000\u2c07\u2c37\u0000\u0000\u2c08\u2c38\u0000\u0000\u2c09\u2c39\u0000\u0000\u2c0a\u2c3a\u0000\u0000\u2c0b\u2c3b\u0000\u0000\u2c0c\u2c3c\u0000\u0000\u2c0d\u2c3d\u0000\u0000\u2c0e\u2c3e\u0000\u0000\u2c0f\u2c3f\u0000\u0000\u2c10\u2c40\u0000\u0000\u2c11\u2c41\u0000\u0000\u2c12\u2c42\u0000\u0000\u2c13\u2c43\u0000\u0000\u2c14\u2c44\u0000\u0000\u2c15\u2c45\u0000\u0000\u2c16\u2c46\u0000\u0000\u2c17\u2c47\u0000\u0000\u2c18\u2c48\u0000\u0000\u2c19\u2c49\u0000\u0000\u2c1a\u2c4a\u0000\u0000\u2c1b\u2c4b\u0000\u0000\u2c1c\u2c4c\u0000\u0000\u2c1d\u2c4d\u0000\u0000\u2c1e\u2c4e\u0000\u0000\u2c1f\u2c4f\u0000\u0000\u2c20\u2c50\u0000\u0000\u2c21\u2c51\u0000\u0000\u2c22\u2c52\u0000\u0000\u2c23\u2c53\u0000\u0000\u2c24\u2c54\u0000\u0000\u2c25\u2c55\u0000\u0000\u2c26\u2c56\u0000\u0000\u2c27\u2c57\u0000\u0000\u2c28\u2c58\u0000\u0000\u2c29\u2c59\u0000\u0000\u2c2a\u2c5a\u0000\u0000\u2c2b\u2c5b\u0000\u0000\u2c2c\u2c5c\u0000\u0000\u2c2d\u2c5d\u0000\u0000\u2c2e\u2c5e\u0000\u0000\u2c60\u2c61\u0000\u0000\u2c67\u2c68\u0000\u0000\u2c69\u2c6a\u0000\u0000\u2c6b\u2c6c\u0000\u0000\u2c72\u2c73\u0000\u0000\u2c75\u2c76\u0000\u0000\u2c80\u2c81\u0000\u0000\u2c82\u2c83\u0000\u0000\u2c84\u2c85\u0000\u0000\u2c86\u2c87\u0000\u0000\u2c88\u2c89\u0000\u0000\u2c8a\u2c8b\u0000\u0000\u2c8c\u2c8d\u0000\u0000\u2c8e\u2c8f\u0000\u0000\u2c90\u2c91\u0000\u0000\u2c92\u2c93\u0000\u0000\u2c94\u2c95\u0000\u0000\u2c96\u2c97\u0000\u0000\u2c98\u2c99\u0000\u0000\u2c9a\u2c9b\u0000\u0000\u2c9c\u2c9d\u0000\u0000\u2c9e\u2c9f\u0000\u0000\u2ca0\u2ca1\u0000\u0000\u2ca2\u2ca3\u0000\u0000\u2ca4\u2ca5\u0000\u0000\u2ca6\u2ca7\u0000\u0000\u2ca8\u2ca9\u0000\u0000\u2caa\u2cab\u0000\u0000\u2cac\u2cad\u0000\u0000\u2cae\u2caf\u0000\u0000\u2cb0\u2cb1\u0000\u0000\u2cb2\u2cb3\u0000\u0000\u2cb4\u2cb5\u0000\u0000\u2cb6\u2cb7\u0000\u0000\u2cb8\u2cb9\u0000\u0000\u2cba\u2cbb\u0000\u0000\u2cbc\u2cbd\u0000\u0000\u2cbe\u2cbf\u0000\u0000\u2cc0\u2cc1\u0000\u0000\u2cc2\u2cc3\u0000\u0000\u2cc4\u2cc5\u0000\u0000\u2cc6\u2cc7\u0000\u0000\u2cc8\u2cc9\u0000\u0000\u2cca\u2ccb\u0000\u0000\u2ccc\u2ccd\u0000\u0000\u2cce\u2ccf\u0000\u0000\u2cd0\u2cd1\u0000\u0000\u2cd2\u2cd3\u0000\u0000\u2cd4\u2cd5\u0000\u0000\u2cd6\u2cd7\u0000\u0000\u2cd8\u2cd9\u0000\u0000\u2cda\u2cdb\u0000\u0000\u2cdc\u2cdd\u0000\u0000\u2cde\u2cdf\u0000\u0000\u2ce0\u2ce1\u0000\u0000\u2ce2\u2ce3\u0000\u0000\ua640\ua641\u0000\u0000\ua642\ua643\u0000\u0000\ua644\ua645\u0000\u0000\ua646\ua647\u0000\u0000\ua648\ua649\u0000\u0000\ua64a\ua64b\u0000\u0000\ua64c\ua64d\u0000\u0000\ua64e\ua64f\u0000\u0000\ua650\ua651\u0000\u0000\ua652\ua653\u0000\u0000\ua654\ua655\u0000\u0000\ua656\ua657\u0000\u0000\ua658\ua659\u0000\u0000\ua65a\ua65b\u0000\u0000\ua65c\ua65d\u0000\u0000\ua65e\ua65f\u0000\u0000\ua662\ua663\u0000\u0000\ua664\ua665\u0000\u0000\ua666\ua667\u0000\u0000\ua668\ua669\u0000\u0000\ua66a\ua66b\u0000\u0000\ua66c\ua66d\u0000\u0000\ua680\ua681\u0000\u0000\ua682\ua683\u0000\u0000\ua684\ua685\u0000\u0000\ua686\ua687\u0000\u0000\ua688\ua689\u0000\u0000\ua68a\ua68b\u0000\u0000\ua68c\ua68d\u0000\u0000\ua68e\ua68f\u0000\u0000\ua690\ua691\u0000\u0000\ua692\ua693\u0000\u0000\ua694\ua695\u0000\u0000\ua696\ua697\u0000\u0000\ua722\ua723\u0000\u0000\ua724\ua725\u0000\u0000\ua726\ua727\u0000\u0000\ua728\ua729\u0000\u0000\ua72a\ua72b\u0000\u0000\ua72c\ua72d\u0000\u0000\ua72e\ua72f\u0000\u0000\ua732\ua733\u0000\u0000\ua734\ua735\u0000\u0000\ua736\ua737\u0000\u0000\ua738\ua739\u0000\u0000\ua73a\ua73b\u0000\u0000\ua73c\ua73d\u0000\u0000\ua73e\ua73f\u0000\u0000\ua740\ua741\u0000\u0000\ua742\ua743\u0000\u0000\ua744\ua745\u0000\u0000\ua746\ua747\u0000\u0000\ua748\ua749\u0000\u0000\ua74a\ua74b\u0000\u0000\ua74c\ua74d\u0000\u0000\ua74e\ua74f\u0000\u0000\ua750\ua751\u0000\u0000\ua752\ua753\u0000\u0000\ua754\ua755\u0000\u0000\ua756\ua757\u0000\u0000\ua758\ua759\u0000\u0000\ua75a\ua75b\u0000\u0000\ua75c\ua75d\u0000\u0000\ua75e\ua75f\u0000\u0000\ua760\ua761\u0000\u0000\ua762\ua763\u0000\u0000\ua764\ua765\u0000\u0000\ua766\ua767\u0000\u0000\ua768\ua769\u0000\u0000\ua76a\ua76b\u0000\u0000\ua76c\ua76d\u0000\u0000\ua76e\ua76f\u0000\u0000\ua779\ua77a\u0000\u0000\ua77b\ua77c\u0000\u0000\ua77e\ua77f\u0000\u0000\ua780\ua781\u0000\u0000\ua782\ua783\u0000\u0000\ua784\ua785\u0000\u0000\ua786\ua787\u0000\u0000\ua78b\ua78c\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000\ud801\udc00\ud801\udc28\u0000\u0000\ud801\udc01\ud801\udc29\u0000\u0000\ud801\udc02\ud801\udc2a\u0000\u0000\ud801\udc03\ud801\udc2b\u0000\u0000\ud801\udc04\ud801\udc2c\u0000\u0000\ud801\udc05\ud801\udc2d\u0000\u0000\ud801\udc06\ud801\udc2e\u0000\u0000\ud801\udc07\ud801\udc2f\u0000\u0000\ud801\udc08\ud801\udc30\u0000\u0000\ud801\udc09\ud801\udc31\u0000\u0000\ud801\udc0a\ud801\udc32\u0000\u0000\ud801\udc0b\ud801\udc33\u0000\u0000\ud801\udc0c\ud801\udc34\u0000\u0000\ud801\udc0d\ud801\udc35\u0000\u0000\ud801\udc0e\ud801\udc36\u0000\u0000\ud801\udc0f\ud801\udc37\u0000\u0000\ud801\udc10\ud801\udc38\u0000\u0000\ud801\udc11\ud801\udc39\u0000\u0000\ud801\udc12\ud801\udc3a\u0000\u0000\ud801\udc13\ud801\udc3b\u0000\u0000\ud801\udc14\ud801\udc3c\u0000\u0000\ud801\udc15\ud801\udc3d\u0000\u0000\ud801\udc16\ud801\udc3e\u0000\u0000\ud801\udc17\ud801\udc3f\u0000\u0000\ud801\udc18\ud801\udc40\u0000\u0000\ud801\udc19\ud801\udc41\u0000\u0000\ud801\udc1a\ud801\udc42\u0000\u0000\ud801\udc1b\ud801\udc43\u0000\u0000\ud801\udc1c\ud801\udc44\u0000\u0000\ud801\udc1d\ud801\udc45\u0000\u0000\ud801\udc1e\ud801\udc46\u0000\u0000\ud801\udc1f\ud801\udc47\u0000\u0000\ud801\udc20\ud801\udc48\u0000\u0000\ud801\udc21\ud801\udc49\u0000\u0000\ud801\udc22\ud801\udc4a\u0000\u0000\ud801\udc23\ud801\udc4b\u0000\u0000\ud801\udc24\ud801\udc4c\u0000\u0000\ud801\udc25\ud801\udc4d\u0000\u0000\ud801\udc26\ud801\udc4e\u0000\u0000\ud801\udc27\ud801\udc4f\u0000\u0000", 4);
        } else if (version.equals("5.2") || version.equals("5.2.0")) {
            this.bind(Unicode_5_2.propertyValues, Unicode_5_2.intervals, Unicode_5_2.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00df\u1e9e\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0180\u0243\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019a\u023d\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019e\u0220\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u023a\u2c65\u0000\u0000\u023b\u023c\u0000\u0000\u023e\u2c66\u0000\u0000\u023f\u2c7e\u0000\u0000\u0240\u2c7f\u0000\u0000\u0241\u0242\u0000\u0000\u0244\u0289\u0000\u0000\u0245\u028c\u0000\u0000\u0246\u0247\u0000\u0000\u0248\u0249\u0000\u0000\u024a\u024b\u0000\u0000\u024c\u024d\u0000\u0000\u024e\u024f\u0000\u0000\u0250\u2c6f\u0000\u0000\u0251\u2c6d\u0000\u0000\u0252\u2c70\u0000\u0000\u026b\u2c62\u0000\u0000\u0271\u2c6e\u0000\u0000\u027d\u2c64\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0370\u0371\u0000\u0000\u0372\u0373\u0000\u0000\u0376\u0377\u0000\u0000\u037b\u03fd\u0000\u0000\u037c\u03fe\u0000\u0000\u037d\u03ff\u0000\u0000\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u03f5\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u03f4\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u0000\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03cf\u03d7\u0000\u0000\u03d8\u03d9\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u03f2\u03f9\u0000\u0000\u03f7\u03f8\u0000\u0000\u03fa\u03fb\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048a\u048b\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c0\u04cf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c5\u04c6\u0000\u0000\u04c7\u04c8\u0000\u0000\u04c9\u04ca\u0000\u0000\u04cb\u04cc\u0000\u0000\u04cd\u04ce\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f6\u04f7\u0000\u0000\u04f8\u04f9\u0000\u0000\u04fa\u04fb\u0000\u0000\u04fc\u04fd\u0000\u0000\u04fe\u04ff\u0000\u0000\u0500\u0501\u0000\u0000\u0502\u0503\u0000\u0000\u0504\u0505\u0000\u0000\u0506\u0507\u0000\u0000\u0508\u0509\u0000\u0000\u050a\u050b\u0000\u0000\u050c\u050d\u0000\u0000\u050e\u050f\u0000\u0000\u0510\u0511\u0000\u0000\u0512\u0513\u0000\u0000\u0514\u0515\u0000\u0000\u0516\u0517\u0000\u0000\u0518\u0519\u0000\u0000\u051a\u051b\u0000\u0000\u051c\u051d\u0000\u0000\u051e\u051f\u0000\u0000\u0520\u0521\u0000\u0000\u0522\u0523\u0000\u0000\u0524\u0525\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u10a0\u2d00\u0000\u0000\u10a1\u2d01\u0000\u0000\u10a2\u2d02\u0000\u0000\u10a3\u2d03\u0000\u0000\u10a4\u2d04\u0000\u0000\u10a5\u2d05\u0000\u0000\u10a6\u2d06\u0000\u0000\u10a7\u2d07\u0000\u0000\u10a8\u2d08\u0000\u0000\u10a9\u2d09\u0000\u0000\u10aa\u2d0a\u0000\u0000\u10ab\u2d0b\u0000\u0000\u10ac\u2d0c\u0000\u0000\u10ad\u2d0d\u0000\u0000\u10ae\u2d0e\u0000\u0000\u10af\u2d0f\u0000\u0000\u10b0\u2d10\u0000\u0000\u10b1\u2d11\u0000\u0000\u10b2\u2d12\u0000\u0000\u10b3\u2d13\u0000\u0000\u10b4\u2d14\u0000\u0000\u10b5\u2d15\u0000\u0000\u10b6\u2d16\u0000\u0000\u10b7\u2d17\u0000\u0000\u10b8\u2d18\u0000\u0000\u10b9\u2d19\u0000\u0000\u10ba\u2d1a\u0000\u0000\u10bb\u2d1b\u0000\u0000\u10bc\u2d1c\u0000\u0000\u10bd\u2d1d\u0000\u0000\u10be\u2d1e\u0000\u0000\u10bf\u2d1f\u0000\u0000\u10c0\u2d20\u0000\u0000\u10c1\u2d21\u0000\u0000\u10c2\u2d22\u0000\u0000\u10c3\u2d23\u0000\u0000\u10c4\u2d24\u0000\u0000\u10c5\u2d25\u0000\u0000\u1d79\ua77d\u0000\u0000\u1d7d\u2c63\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1efa\u1efb\u0000\u0000\u1efc\u1efd\u0000\u0000\u1efe\u1eff\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2132\u214e\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u2183\u2184\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\u2c00\u2c30\u0000\u0000\u2c01\u2c31\u0000\u0000\u2c02\u2c32\u0000\u0000\u2c03\u2c33\u0000\u0000\u2c04\u2c34\u0000\u0000\u2c05\u2c35\u0000\u0000\u2c06\u2c36\u0000\u0000\u2c07\u2c37\u0000\u0000\u2c08\u2c38\u0000\u0000\u2c09\u2c39\u0000\u0000\u2c0a\u2c3a\u0000\u0000\u2c0b\u2c3b\u0000\u0000\u2c0c\u2c3c\u0000\u0000\u2c0d\u2c3d\u0000\u0000\u2c0e\u2c3e\u0000\u0000\u2c0f\u2c3f\u0000\u0000\u2c10\u2c40\u0000\u0000\u2c11\u2c41\u0000\u0000\u2c12\u2c42\u0000\u0000\u2c13\u2c43\u0000\u0000\u2c14\u2c44\u0000\u0000\u2c15\u2c45\u0000\u0000\u2c16\u2c46\u0000\u0000\u2c17\u2c47\u0000\u0000\u2c18\u2c48\u0000\u0000\u2c19\u2c49\u0000\u0000\u2c1a\u2c4a\u0000\u0000\u2c1b\u2c4b\u0000\u0000\u2c1c\u2c4c\u0000\u0000\u2c1d\u2c4d\u0000\u0000\u2c1e\u2c4e\u0000\u0000\u2c1f\u2c4f\u0000\u0000\u2c20\u2c50\u0000\u0000\u2c21\u2c51\u0000\u0000\u2c22\u2c52\u0000\u0000\u2c23\u2c53\u0000\u0000\u2c24\u2c54\u0000\u0000\u2c25\u2c55\u0000\u0000\u2c26\u2c56\u0000\u0000\u2c27\u2c57\u0000\u0000\u2c28\u2c58\u0000\u0000\u2c29\u2c59\u0000\u0000\u2c2a\u2c5a\u0000\u0000\u2c2b\u2c5b\u0000\u0000\u2c2c\u2c5c\u0000\u0000\u2c2d\u2c5d\u0000\u0000\u2c2e\u2c5e\u0000\u0000\u2c60\u2c61\u0000\u0000\u2c67\u2c68\u0000\u0000\u2c69\u2c6a\u0000\u0000\u2c6b\u2c6c\u0000\u0000\u2c72\u2c73\u0000\u0000\u2c75\u2c76\u0000\u0000\u2c80\u2c81\u0000\u0000\u2c82\u2c83\u0000\u0000\u2c84\u2c85\u0000\u0000\u2c86\u2c87\u0000\u0000\u2c88\u2c89\u0000\u0000\u2c8a\u2c8b\u0000\u0000\u2c8c\u2c8d\u0000\u0000\u2c8e\u2c8f\u0000\u0000\u2c90\u2c91\u0000\u0000\u2c92\u2c93\u0000\u0000\u2c94\u2c95\u0000\u0000\u2c96\u2c97\u0000\u0000\u2c98\u2c99\u0000\u0000\u2c9a\u2c9b\u0000\u0000\u2c9c\u2c9d\u0000\u0000\u2c9e\u2c9f\u0000\u0000\u2ca0\u2ca1\u0000\u0000\u2ca2\u2ca3\u0000\u0000\u2ca4\u2ca5\u0000\u0000\u2ca6\u2ca7\u0000\u0000\u2ca8\u2ca9\u0000\u0000\u2caa\u2cab\u0000\u0000\u2cac\u2cad\u0000\u0000\u2cae\u2caf\u0000\u0000\u2cb0\u2cb1\u0000\u0000\u2cb2\u2cb3\u0000\u0000\u2cb4\u2cb5\u0000\u0000\u2cb6\u2cb7\u0000\u0000\u2cb8\u2cb9\u0000\u0000\u2cba\u2cbb\u0000\u0000\u2cbc\u2cbd\u0000\u0000\u2cbe\u2cbf\u0000\u0000\u2cc0\u2cc1\u0000\u0000\u2cc2\u2cc3\u0000\u0000\u2cc4\u2cc5\u0000\u0000\u2cc6\u2cc7\u0000\u0000\u2cc8\u2cc9\u0000\u0000\u2cca\u2ccb\u0000\u0000\u2ccc\u2ccd\u0000\u0000\u2cce\u2ccf\u0000\u0000\u2cd0\u2cd1\u0000\u0000\u2cd2\u2cd3\u0000\u0000\u2cd4\u2cd5\u0000\u0000\u2cd6\u2cd7\u0000\u0000\u2cd8\u2cd9\u0000\u0000\u2cda\u2cdb\u0000\u0000\u2cdc\u2cdd\u0000\u0000\u2cde\u2cdf\u0000\u0000\u2ce0\u2ce1\u0000\u0000\u2ce2\u2ce3\u0000\u0000\u2ceb\u2cec\u0000\u0000\u2ced\u2cee\u0000\u0000\ua640\ua641\u0000\u0000\ua642\ua643\u0000\u0000\ua644\ua645\u0000\u0000\ua646\ua647\u0000\u0000\ua648\ua649\u0000\u0000\ua64a\ua64b\u0000\u0000\ua64c\ua64d\u0000\u0000\ua64e\ua64f\u0000\u0000\ua650\ua651\u0000\u0000\ua652\ua653\u0000\u0000\ua654\ua655\u0000\u0000\ua656\ua657\u0000\u0000\ua658\ua659\u0000\u0000\ua65a\ua65b\u0000\u0000\ua65c\ua65d\u0000\u0000\ua65e\ua65f\u0000\u0000\ua662\ua663\u0000\u0000\ua664\ua665\u0000\u0000\ua666\ua667\u0000\u0000\ua668\ua669\u0000\u0000\ua66a\ua66b\u0000\u0000\ua66c\ua66d\u0000\u0000\ua680\ua681\u0000\u0000\ua682\ua683\u0000\u0000\ua684\ua685\u0000\u0000\ua686\ua687\u0000\u0000\ua688\ua689\u0000\u0000\ua68a\ua68b\u0000\u0000\ua68c\ua68d\u0000\u0000\ua68e\ua68f\u0000\u0000\ua690\ua691\u0000\u0000\ua692\ua693\u0000\u0000\ua694\ua695\u0000\u0000\ua696\ua697\u0000\u0000\ua722\ua723\u0000\u0000\ua724\ua725\u0000\u0000\ua726\ua727\u0000\u0000\ua728\ua729\u0000\u0000\ua72a\ua72b\u0000\u0000\ua72c\ua72d\u0000\u0000\ua72e\ua72f\u0000\u0000\ua732\ua733\u0000\u0000\ua734\ua735\u0000\u0000\ua736\ua737\u0000\u0000\ua738\ua739\u0000\u0000\ua73a\ua73b\u0000\u0000\ua73c\ua73d\u0000\u0000\ua73e\ua73f\u0000\u0000\ua740\ua741\u0000\u0000\ua742\ua743\u0000\u0000\ua744\ua745\u0000\u0000\ua746\ua747\u0000\u0000\ua748\ua749\u0000\u0000\ua74a\ua74b\u0000\u0000\ua74c\ua74d\u0000\u0000\ua74e\ua74f\u0000\u0000\ua750\ua751\u0000\u0000\ua752\ua753\u0000\u0000\ua754\ua755\u0000\u0000\ua756\ua757\u0000\u0000\ua758\ua759\u0000\u0000\ua75a\ua75b\u0000\u0000\ua75c\ua75d\u0000\u0000\ua75e\ua75f\u0000\u0000\ua760\ua761\u0000\u0000\ua762\ua763\u0000\u0000\ua764\ua765\u0000\u0000\ua766\ua767\u0000\u0000\ua768\ua769\u0000\u0000\ua76a\ua76b\u0000\u0000\ua76c\ua76d\u0000\u0000\ua76e\ua76f\u0000\u0000\ua779\ua77a\u0000\u0000\ua77b\ua77c\u0000\u0000\ua77e\ua77f\u0000\u0000\ua780\ua781\u0000\u0000\ua782\ua783\u0000\u0000\ua784\ua785\u0000\u0000\ua786\ua787\u0000\u0000\ua78b\ua78c\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000\ud801\udc00\ud801\udc28\u0000\u0000\ud801\udc01\ud801\udc29\u0000\u0000\ud801\udc02\ud801\udc2a\u0000\u0000\ud801\udc03\ud801\udc2b\u0000\u0000\ud801\udc04\ud801\udc2c\u0000\u0000\ud801\udc05\ud801\udc2d\u0000\u0000\ud801\udc06\ud801\udc2e\u0000\u0000\ud801\udc07\ud801\udc2f\u0000\u0000\ud801\udc08\ud801\udc30\u0000\u0000\ud801\udc09\ud801\udc31\u0000\u0000\ud801\udc0a\ud801\udc32\u0000\u0000\ud801\udc0b\ud801\udc33\u0000\u0000\ud801\udc0c\ud801\udc34\u0000\u0000\ud801\udc0d\ud801\udc35\u0000\u0000\ud801\udc0e\ud801\udc36\u0000\u0000\ud801\udc0f\ud801\udc37\u0000\u0000\ud801\udc10\ud801\udc38\u0000\u0000\ud801\udc11\ud801\udc39\u0000\u0000\ud801\udc12\ud801\udc3a\u0000\u0000\ud801\udc13\ud801\udc3b\u0000\u0000\ud801\udc14\ud801\udc3c\u0000\u0000\ud801\udc15\ud801\udc3d\u0000\u0000\ud801\udc16\ud801\udc3e\u0000\u0000\ud801\udc17\ud801\udc3f\u0000\u0000\ud801\udc18\ud801\udc40\u0000\u0000\ud801\udc19\ud801\udc41\u0000\u0000\ud801\udc1a\ud801\udc42\u0000\u0000\ud801\udc1b\ud801\udc43\u0000\u0000\ud801\udc1c\ud801\udc44\u0000\u0000\ud801\udc1d\ud801\udc45\u0000\u0000\ud801\udc1e\ud801\udc46\u0000\u0000\ud801\udc1f\ud801\udc47\u0000\u0000\ud801\udc20\ud801\udc48\u0000\u0000\ud801\udc21\ud801\udc49\u0000\u0000\ud801\udc22\ud801\udc4a\u0000\u0000\ud801\udc23\ud801\udc4b\u0000\u0000\ud801\udc24\ud801\udc4c\u0000\u0000\ud801\udc25\ud801\udc4d\u0000\u0000\ud801\udc26\ud801\udc4e\u0000\u0000\ud801\udc27\ud801\udc4f\u0000\u0000", 4);
        } else if (version.equals("6") || version.equals("6.0") || version.equals("6.0.0")) {
            this.bind(Unicode_6_0.propertyValues, Unicode_6_0.intervals, Unicode_6_0.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00df\u1e9e\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0180\u0243\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019a\u023d\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019e\u0220\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u023a\u2c65\u0000\u0000\u023b\u023c\u0000\u0000\u023e\u2c66\u0000\u0000\u023f\u2c7e\u0000\u0000\u0240\u2c7f\u0000\u0000\u0241\u0242\u0000\u0000\u0244\u0289\u0000\u0000\u0245\u028c\u0000\u0000\u0246\u0247\u0000\u0000\u0248\u0249\u0000\u0000\u024a\u024b\u0000\u0000\u024c\u024d\u0000\u0000\u024e\u024f\u0000\u0000\u0250\u2c6f\u0000\u0000\u0251\u2c6d\u0000\u0000\u0252\u2c70\u0000\u0000\u0265\ua78d\u0000\u0000\u026b\u2c62\u0000\u0000\u0271\u2c6e\u0000\u0000\u027d\u2c64\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0370\u0371\u0000\u0000\u0372\u0373\u0000\u0000\u0376\u0377\u0000\u0000\u037b\u03fd\u0000\u0000\u037c\u03fe\u0000\u0000\u037d\u03ff\u0000\u0000\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u03f5\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u03f4\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u0000\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03cf\u03d7\u0000\u0000\u03d8\u03d9\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u03f2\u03f9\u0000\u0000\u03f7\u03f8\u0000\u0000\u03fa\u03fb\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048a\u048b\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c0\u04cf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c5\u04c6\u0000\u0000\u04c7\u04c8\u0000\u0000\u04c9\u04ca\u0000\u0000\u04cb\u04cc\u0000\u0000\u04cd\u04ce\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f6\u04f7\u0000\u0000\u04f8\u04f9\u0000\u0000\u04fa\u04fb\u0000\u0000\u04fc\u04fd\u0000\u0000\u04fe\u04ff\u0000\u0000\u0500\u0501\u0000\u0000\u0502\u0503\u0000\u0000\u0504\u0505\u0000\u0000\u0506\u0507\u0000\u0000\u0508\u0509\u0000\u0000\u050a\u050b\u0000\u0000\u050c\u050d\u0000\u0000\u050e\u050f\u0000\u0000\u0510\u0511\u0000\u0000\u0512\u0513\u0000\u0000\u0514\u0515\u0000\u0000\u0516\u0517\u0000\u0000\u0518\u0519\u0000\u0000\u051a\u051b\u0000\u0000\u051c\u051d\u0000\u0000\u051e\u051f\u0000\u0000\u0520\u0521\u0000\u0000\u0522\u0523\u0000\u0000\u0524\u0525\u0000\u0000\u0526\u0527\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u10a0\u2d00\u0000\u0000\u10a1\u2d01\u0000\u0000\u10a2\u2d02\u0000\u0000\u10a3\u2d03\u0000\u0000\u10a4\u2d04\u0000\u0000\u10a5\u2d05\u0000\u0000\u10a6\u2d06\u0000\u0000\u10a7\u2d07\u0000\u0000\u10a8\u2d08\u0000\u0000\u10a9\u2d09\u0000\u0000\u10aa\u2d0a\u0000\u0000\u10ab\u2d0b\u0000\u0000\u10ac\u2d0c\u0000\u0000\u10ad\u2d0d\u0000\u0000\u10ae\u2d0e\u0000\u0000\u10af\u2d0f\u0000\u0000\u10b0\u2d10\u0000\u0000\u10b1\u2d11\u0000\u0000\u10b2\u2d12\u0000\u0000\u10b3\u2d13\u0000\u0000\u10b4\u2d14\u0000\u0000\u10b5\u2d15\u0000\u0000\u10b6\u2d16\u0000\u0000\u10b7\u2d17\u0000\u0000\u10b8\u2d18\u0000\u0000\u10b9\u2d19\u0000\u0000\u10ba\u2d1a\u0000\u0000\u10bb\u2d1b\u0000\u0000\u10bc\u2d1c\u0000\u0000\u10bd\u2d1d\u0000\u0000\u10be\u2d1e\u0000\u0000\u10bf\u2d1f\u0000\u0000\u10c0\u2d20\u0000\u0000\u10c1\u2d21\u0000\u0000\u10c2\u2d22\u0000\u0000\u10c3\u2d23\u0000\u0000\u10c4\u2d24\u0000\u0000\u10c5\u2d25\u0000\u0000\u1d79\ua77d\u0000\u0000\u1d7d\u2c63\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1efa\u1efb\u0000\u0000\u1efc\u1efd\u0000\u0000\u1efe\u1eff\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2132\u214e\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u2183\u2184\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\u2c00\u2c30\u0000\u0000\u2c01\u2c31\u0000\u0000\u2c02\u2c32\u0000\u0000\u2c03\u2c33\u0000\u0000\u2c04\u2c34\u0000\u0000\u2c05\u2c35\u0000\u0000\u2c06\u2c36\u0000\u0000\u2c07\u2c37\u0000\u0000\u2c08\u2c38\u0000\u0000\u2c09\u2c39\u0000\u0000\u2c0a\u2c3a\u0000\u0000\u2c0b\u2c3b\u0000\u0000\u2c0c\u2c3c\u0000\u0000\u2c0d\u2c3d\u0000\u0000\u2c0e\u2c3e\u0000\u0000\u2c0f\u2c3f\u0000\u0000\u2c10\u2c40\u0000\u0000\u2c11\u2c41\u0000\u0000\u2c12\u2c42\u0000\u0000\u2c13\u2c43\u0000\u0000\u2c14\u2c44\u0000\u0000\u2c15\u2c45\u0000\u0000\u2c16\u2c46\u0000\u0000\u2c17\u2c47\u0000\u0000\u2c18\u2c48\u0000\u0000\u2c19\u2c49\u0000\u0000\u2c1a\u2c4a\u0000\u0000\u2c1b\u2c4b\u0000\u0000\u2c1c\u2c4c\u0000\u0000\u2c1d\u2c4d\u0000\u0000\u2c1e\u2c4e\u0000\u0000\u2c1f\u2c4f\u0000\u0000\u2c20\u2c50\u0000\u0000\u2c21\u2c51\u0000\u0000\u2c22\u2c52\u0000\u0000\u2c23\u2c53\u0000\u0000\u2c24\u2c54\u0000\u0000\u2c25\u2c55\u0000\u0000\u2c26\u2c56\u0000\u0000\u2c27\u2c57\u0000\u0000\u2c28\u2c58\u0000\u0000\u2c29\u2c59\u0000\u0000\u2c2a\u2c5a\u0000\u0000\u2c2b\u2c5b\u0000\u0000\u2c2c\u2c5c\u0000\u0000\u2c2d\u2c5d\u0000\u0000\u2c2e\u2c5e\u0000\u0000\u2c60\u2c61\u0000\u0000\u2c67\u2c68\u0000\u0000\u2c69\u2c6a\u0000\u0000\u2c6b\u2c6c\u0000\u0000\u2c72\u2c73\u0000\u0000\u2c75\u2c76\u0000\u0000\u2c80\u2c81\u0000\u0000\u2c82\u2c83\u0000\u0000\u2c84\u2c85\u0000\u0000\u2c86\u2c87\u0000\u0000\u2c88\u2c89\u0000\u0000\u2c8a\u2c8b\u0000\u0000\u2c8c\u2c8d\u0000\u0000\u2c8e\u2c8f\u0000\u0000\u2c90\u2c91\u0000\u0000\u2c92\u2c93\u0000\u0000\u2c94\u2c95\u0000\u0000\u2c96\u2c97\u0000\u0000\u2c98\u2c99\u0000\u0000\u2c9a\u2c9b\u0000\u0000\u2c9c\u2c9d\u0000\u0000\u2c9e\u2c9f\u0000\u0000\u2ca0\u2ca1\u0000\u0000\u2ca2\u2ca3\u0000\u0000\u2ca4\u2ca5\u0000\u0000\u2ca6\u2ca7\u0000\u0000\u2ca8\u2ca9\u0000\u0000\u2caa\u2cab\u0000\u0000\u2cac\u2cad\u0000\u0000\u2cae\u2caf\u0000\u0000\u2cb0\u2cb1\u0000\u0000\u2cb2\u2cb3\u0000\u0000\u2cb4\u2cb5\u0000\u0000\u2cb6\u2cb7\u0000\u0000\u2cb8\u2cb9\u0000\u0000\u2cba\u2cbb\u0000\u0000\u2cbc\u2cbd\u0000\u0000\u2cbe\u2cbf\u0000\u0000\u2cc0\u2cc1\u0000\u0000\u2cc2\u2cc3\u0000\u0000\u2cc4\u2cc5\u0000\u0000\u2cc6\u2cc7\u0000\u0000\u2cc8\u2cc9\u0000\u0000\u2cca\u2ccb\u0000\u0000\u2ccc\u2ccd\u0000\u0000\u2cce\u2ccf\u0000\u0000\u2cd0\u2cd1\u0000\u0000\u2cd2\u2cd3\u0000\u0000\u2cd4\u2cd5\u0000\u0000\u2cd6\u2cd7\u0000\u0000\u2cd8\u2cd9\u0000\u0000\u2cda\u2cdb\u0000\u0000\u2cdc\u2cdd\u0000\u0000\u2cde\u2cdf\u0000\u0000\u2ce0\u2ce1\u0000\u0000\u2ce2\u2ce3\u0000\u0000\u2ceb\u2cec\u0000\u0000\u2ced\u2cee\u0000\u0000\ua640\ua641\u0000\u0000\ua642\ua643\u0000\u0000\ua644\ua645\u0000\u0000\ua646\ua647\u0000\u0000\ua648\ua649\u0000\u0000\ua64a\ua64b\u0000\u0000\ua64c\ua64d\u0000\u0000\ua64e\ua64f\u0000\u0000\ua650\ua651\u0000\u0000\ua652\ua653\u0000\u0000\ua654\ua655\u0000\u0000\ua656\ua657\u0000\u0000\ua658\ua659\u0000\u0000\ua65a\ua65b\u0000\u0000\ua65c\ua65d\u0000\u0000\ua65e\ua65f\u0000\u0000\ua660\ua661\u0000\u0000\ua662\ua663\u0000\u0000\ua664\ua665\u0000\u0000\ua666\ua667\u0000\u0000\ua668\ua669\u0000\u0000\ua66a\ua66b\u0000\u0000\ua66c\ua66d\u0000\u0000\ua680\ua681\u0000\u0000\ua682\ua683\u0000\u0000\ua684\ua685\u0000\u0000\ua686\ua687\u0000\u0000\ua688\ua689\u0000\u0000\ua68a\ua68b\u0000\u0000\ua68c\ua68d\u0000\u0000\ua68e\ua68f\u0000\u0000\ua690\ua691\u0000\u0000\ua692\ua693\u0000\u0000\ua694\ua695\u0000\u0000\ua696\ua697\u0000\u0000\ua722\ua723\u0000\u0000\ua724\ua725\u0000\u0000\ua726\ua727\u0000\u0000\ua728\ua729\u0000\u0000\ua72a\ua72b\u0000\u0000\ua72c\ua72d\u0000\u0000\ua72e\ua72f\u0000\u0000\ua732\ua733\u0000\u0000\ua734\ua735\u0000\u0000\ua736\ua737\u0000\u0000\ua738\ua739\u0000\u0000\ua73a\ua73b\u0000\u0000\ua73c\ua73d\u0000\u0000\ua73e\ua73f\u0000\u0000\ua740\ua741\u0000\u0000\ua742\ua743\u0000\u0000\ua744\ua745\u0000\u0000\ua746\ua747\u0000\u0000\ua748\ua749\u0000\u0000\ua74a\ua74b\u0000\u0000\ua74c\ua74d\u0000\u0000\ua74e\ua74f\u0000\u0000\ua750\ua751\u0000\u0000\ua752\ua753\u0000\u0000\ua754\ua755\u0000\u0000\ua756\ua757\u0000\u0000\ua758\ua759\u0000\u0000\ua75a\ua75b\u0000\u0000\ua75c\ua75d\u0000\u0000\ua75e\ua75f\u0000\u0000\ua760\ua761\u0000\u0000\ua762\ua763\u0000\u0000\ua764\ua765\u0000\u0000\ua766\ua767\u0000\u0000\ua768\ua769\u0000\u0000\ua76a\ua76b\u0000\u0000\ua76c\ua76d\u0000\u0000\ua76e\ua76f\u0000\u0000\ua779\ua77a\u0000\u0000\ua77b\ua77c\u0000\u0000\ua77e\ua77f\u0000\u0000\ua780\ua781\u0000\u0000\ua782\ua783\u0000\u0000\ua784\ua785\u0000\u0000\ua786\ua787\u0000\u0000\ua78b\ua78c\u0000\u0000\ua790\ua791\u0000\u0000\ua7a0\ua7a1\u0000\u0000\ua7a2\ua7a3\u0000\u0000\ua7a4\ua7a5\u0000\u0000\ua7a6\ua7a7\u0000\u0000\ua7a8\ua7a9\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000\ud801\udc00\ud801\udc28\u0000\u0000\ud801\udc01\ud801\udc29\u0000\u0000\ud801\udc02\ud801\udc2a\u0000\u0000\ud801\udc03\ud801\udc2b\u0000\u0000\ud801\udc04\ud801\udc2c\u0000\u0000\ud801\udc05\ud801\udc2d\u0000\u0000\ud801\udc06\ud801\udc2e\u0000\u0000\ud801\udc07\ud801\udc2f\u0000\u0000\ud801\udc08\ud801\udc30\u0000\u0000\ud801\udc09\ud801\udc31\u0000\u0000\ud801\udc0a\ud801\udc32\u0000\u0000\ud801\udc0b\ud801\udc33\u0000\u0000\ud801\udc0c\ud801\udc34\u0000\u0000\ud801\udc0d\ud801\udc35\u0000\u0000\ud801\udc0e\ud801\udc36\u0000\u0000\ud801\udc0f\ud801\udc37\u0000\u0000\ud801\udc10\ud801\udc38\u0000\u0000\ud801\udc11\ud801\udc39\u0000\u0000\ud801\udc12\ud801\udc3a\u0000\u0000\ud801\udc13\ud801\udc3b\u0000\u0000\ud801\udc14\ud801\udc3c\u0000\u0000\ud801\udc15\ud801\udc3d\u0000\u0000\ud801\udc16\ud801\udc3e\u0000\u0000\ud801\udc17\ud801\udc3f\u0000\u0000\ud801\udc18\ud801\udc40\u0000\u0000\ud801\udc19\ud801\udc41\u0000\u0000\ud801\udc1a\ud801\udc42\u0000\u0000\ud801\udc1b\ud801\udc43\u0000\u0000\ud801\udc1c\ud801\udc44\u0000\u0000\ud801\udc1d\ud801\udc45\u0000\u0000\ud801\udc1e\ud801\udc46\u0000\u0000\ud801\udc1f\ud801\udc47\u0000\u0000\ud801\udc20\ud801\udc48\u0000\u0000\ud801\udc21\ud801\udc49\u0000\u0000\ud801\udc22\ud801\udc4a\u0000\u0000\ud801\udc23\ud801\udc4b\u0000\u0000\ud801\udc24\ud801\udc4c\u0000\u0000\ud801\udc25\ud801\udc4d\u0000\u0000\ud801\udc26\ud801\udc4e\u0000\u0000\ud801\udc27\ud801\udc4f\u0000\u0000", 4);
        } else if (version.equals("6.1") || version.equals("6.1.0")) {
            this.bind(Unicode_6_1.propertyValues, Unicode_6_1.intervals, Unicode_6_1.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00df\u1e9e\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0180\u0243\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019a\u023d\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019e\u0220\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u023a\u2c65\u0000\u0000\u023b\u023c\u0000\u0000\u023e\u2c66\u0000\u0000\u023f\u2c7e\u0000\u0000\u0240\u2c7f\u0000\u0000\u0241\u0242\u0000\u0000\u0244\u0289\u0000\u0000\u0245\u028c\u0000\u0000\u0246\u0247\u0000\u0000\u0248\u0249\u0000\u0000\u024a\u024b\u0000\u0000\u024c\u024d\u0000\u0000\u024e\u024f\u0000\u0000\u0250\u2c6f\u0000\u0000\u0251\u2c6d\u0000\u0000\u0252\u2c70\u0000\u0000\u0265\ua78d\u0000\u0000\u0266\ua7aa\u0000\u0000\u026b\u2c62\u0000\u0000\u0271\u2c6e\u0000\u0000\u027d\u2c64\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0370\u0371\u0000\u0000\u0372\u0373\u0000\u0000\u0376\u0377\u0000\u0000\u037b\u03fd\u0000\u0000\u037c\u03fe\u0000\u0000\u037d\u03ff\u0000\u0000\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u03f5\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u03f4\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u0000\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03cf\u03d7\u0000\u0000\u03d8\u03d9\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u03f2\u03f9\u0000\u0000\u03f7\u03f8\u0000\u0000\u03fa\u03fb\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048a\u048b\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c0\u04cf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c5\u04c6\u0000\u0000\u04c7\u04c8\u0000\u0000\u04c9\u04ca\u0000\u0000\u04cb\u04cc\u0000\u0000\u04cd\u04ce\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f6\u04f7\u0000\u0000\u04f8\u04f9\u0000\u0000\u04fa\u04fb\u0000\u0000\u04fc\u04fd\u0000\u0000\u04fe\u04ff\u0000\u0000\u0500\u0501\u0000\u0000\u0502\u0503\u0000\u0000\u0504\u0505\u0000\u0000\u0506\u0507\u0000\u0000\u0508\u0509\u0000\u0000\u050a\u050b\u0000\u0000\u050c\u050d\u0000\u0000\u050e\u050f\u0000\u0000\u0510\u0511\u0000\u0000\u0512\u0513\u0000\u0000\u0514\u0515\u0000\u0000\u0516\u0517\u0000\u0000\u0518\u0519\u0000\u0000\u051a\u051b\u0000\u0000\u051c\u051d\u0000\u0000\u051e\u051f\u0000\u0000\u0520\u0521\u0000\u0000\u0522\u0523\u0000\u0000\u0524\u0525\u0000\u0000\u0526\u0527\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u10a0\u2d00\u0000\u0000\u10a1\u2d01\u0000\u0000\u10a2\u2d02\u0000\u0000\u10a3\u2d03\u0000\u0000\u10a4\u2d04\u0000\u0000\u10a5\u2d05\u0000\u0000\u10a6\u2d06\u0000\u0000\u10a7\u2d07\u0000\u0000\u10a8\u2d08\u0000\u0000\u10a9\u2d09\u0000\u0000\u10aa\u2d0a\u0000\u0000\u10ab\u2d0b\u0000\u0000\u10ac\u2d0c\u0000\u0000\u10ad\u2d0d\u0000\u0000\u10ae\u2d0e\u0000\u0000\u10af\u2d0f\u0000\u0000\u10b0\u2d10\u0000\u0000\u10b1\u2d11\u0000\u0000\u10b2\u2d12\u0000\u0000\u10b3\u2d13\u0000\u0000\u10b4\u2d14\u0000\u0000\u10b5\u2d15\u0000\u0000\u10b6\u2d16\u0000\u0000\u10b7\u2d17\u0000\u0000\u10b8\u2d18\u0000\u0000\u10b9\u2d19\u0000\u0000\u10ba\u2d1a\u0000\u0000\u10bb\u2d1b\u0000\u0000\u10bc\u2d1c\u0000\u0000\u10bd\u2d1d\u0000\u0000\u10be\u2d1e\u0000\u0000\u10bf\u2d1f\u0000\u0000\u10c0\u2d20\u0000\u0000\u10c1\u2d21\u0000\u0000\u10c2\u2d22\u0000\u0000\u10c3\u2d23\u0000\u0000\u10c4\u2d24\u0000\u0000\u10c5\u2d25\u0000\u0000\u10c7\u2d27\u0000\u0000\u10cd\u2d2d\u0000\u0000\u1d79\ua77d\u0000\u0000\u1d7d\u2c63\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1efa\u1efb\u0000\u0000\u1efc\u1efd\u0000\u0000\u1efe\u1eff\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2132\u214e\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u2183\u2184\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\u2c00\u2c30\u0000\u0000\u2c01\u2c31\u0000\u0000\u2c02\u2c32\u0000\u0000\u2c03\u2c33\u0000\u0000\u2c04\u2c34\u0000\u0000\u2c05\u2c35\u0000\u0000\u2c06\u2c36\u0000\u0000\u2c07\u2c37\u0000\u0000\u2c08\u2c38\u0000\u0000\u2c09\u2c39\u0000\u0000\u2c0a\u2c3a\u0000\u0000\u2c0b\u2c3b\u0000\u0000\u2c0c\u2c3c\u0000\u0000\u2c0d\u2c3d\u0000\u0000\u2c0e\u2c3e\u0000\u0000\u2c0f\u2c3f\u0000\u0000\u2c10\u2c40\u0000\u0000\u2c11\u2c41\u0000\u0000\u2c12\u2c42\u0000\u0000\u2c13\u2c43\u0000\u0000\u2c14\u2c44\u0000\u0000\u2c15\u2c45\u0000\u0000\u2c16\u2c46\u0000\u0000\u2c17\u2c47\u0000\u0000\u2c18\u2c48\u0000\u0000\u2c19\u2c49\u0000\u0000\u2c1a\u2c4a\u0000\u0000\u2c1b\u2c4b\u0000\u0000\u2c1c\u2c4c\u0000\u0000\u2c1d\u2c4d\u0000\u0000\u2c1e\u2c4e\u0000\u0000\u2c1f\u2c4f\u0000\u0000\u2c20\u2c50\u0000\u0000\u2c21\u2c51\u0000\u0000\u2c22\u2c52\u0000\u0000\u2c23\u2c53\u0000\u0000\u2c24\u2c54\u0000\u0000\u2c25\u2c55\u0000\u0000\u2c26\u2c56\u0000\u0000\u2c27\u2c57\u0000\u0000\u2c28\u2c58\u0000\u0000\u2c29\u2c59\u0000\u0000\u2c2a\u2c5a\u0000\u0000\u2c2b\u2c5b\u0000\u0000\u2c2c\u2c5c\u0000\u0000\u2c2d\u2c5d\u0000\u0000\u2c2e\u2c5e\u0000\u0000\u2c60\u2c61\u0000\u0000\u2c67\u2c68\u0000\u0000\u2c69\u2c6a\u0000\u0000\u2c6b\u2c6c\u0000\u0000\u2c72\u2c73\u0000\u0000\u2c75\u2c76\u0000\u0000\u2c80\u2c81\u0000\u0000\u2c82\u2c83\u0000\u0000\u2c84\u2c85\u0000\u0000\u2c86\u2c87\u0000\u0000\u2c88\u2c89\u0000\u0000\u2c8a\u2c8b\u0000\u0000\u2c8c\u2c8d\u0000\u0000\u2c8e\u2c8f\u0000\u0000\u2c90\u2c91\u0000\u0000\u2c92\u2c93\u0000\u0000\u2c94\u2c95\u0000\u0000\u2c96\u2c97\u0000\u0000\u2c98\u2c99\u0000\u0000\u2c9a\u2c9b\u0000\u0000\u2c9c\u2c9d\u0000\u0000\u2c9e\u2c9f\u0000\u0000\u2ca0\u2ca1\u0000\u0000\u2ca2\u2ca3\u0000\u0000\u2ca4\u2ca5\u0000\u0000\u2ca6\u2ca7\u0000\u0000\u2ca8\u2ca9\u0000\u0000\u2caa\u2cab\u0000\u0000\u2cac\u2cad\u0000\u0000\u2cae\u2caf\u0000\u0000\u2cb0\u2cb1\u0000\u0000\u2cb2\u2cb3\u0000\u0000\u2cb4\u2cb5\u0000\u0000\u2cb6\u2cb7\u0000\u0000\u2cb8\u2cb9\u0000\u0000\u2cba\u2cbb\u0000\u0000\u2cbc\u2cbd\u0000\u0000\u2cbe\u2cbf\u0000\u0000\u2cc0\u2cc1\u0000\u0000\u2cc2\u2cc3\u0000\u0000\u2cc4\u2cc5\u0000\u0000\u2cc6\u2cc7\u0000\u0000\u2cc8\u2cc9\u0000\u0000\u2cca\u2ccb\u0000\u0000\u2ccc\u2ccd\u0000\u0000\u2cce\u2ccf\u0000\u0000\u2cd0\u2cd1\u0000\u0000\u2cd2\u2cd3\u0000\u0000\u2cd4\u2cd5\u0000\u0000\u2cd6\u2cd7\u0000\u0000\u2cd8\u2cd9\u0000\u0000\u2cda\u2cdb\u0000\u0000\u2cdc\u2cdd\u0000\u0000\u2cde\u2cdf\u0000\u0000\u2ce0\u2ce1\u0000\u0000\u2ce2\u2ce3\u0000\u0000\u2ceb\u2cec\u0000\u0000\u2ced\u2cee\u0000\u0000\u2cf2\u2cf3\u0000\u0000\ua640\ua641\u0000\u0000\ua642\ua643\u0000\u0000\ua644\ua645\u0000\u0000\ua646\ua647\u0000\u0000\ua648\ua649\u0000\u0000\ua64a\ua64b\u0000\u0000\ua64c\ua64d\u0000\u0000\ua64e\ua64f\u0000\u0000\ua650\ua651\u0000\u0000\ua652\ua653\u0000\u0000\ua654\ua655\u0000\u0000\ua656\ua657\u0000\u0000\ua658\ua659\u0000\u0000\ua65a\ua65b\u0000\u0000\ua65c\ua65d\u0000\u0000\ua65e\ua65f\u0000\u0000\ua660\ua661\u0000\u0000\ua662\ua663\u0000\u0000\ua664\ua665\u0000\u0000\ua666\ua667\u0000\u0000\ua668\ua669\u0000\u0000\ua66a\ua66b\u0000\u0000\ua66c\ua66d\u0000\u0000\ua680\ua681\u0000\u0000\ua682\ua683\u0000\u0000\ua684\ua685\u0000\u0000\ua686\ua687\u0000\u0000\ua688\ua689\u0000\u0000\ua68a\ua68b\u0000\u0000\ua68c\ua68d\u0000\u0000\ua68e\ua68f\u0000\u0000\ua690\ua691\u0000\u0000\ua692\ua693\u0000\u0000\ua694\ua695\u0000\u0000\ua696\ua697\u0000\u0000\ua722\ua723\u0000\u0000\ua724\ua725\u0000\u0000\ua726\ua727\u0000\u0000\ua728\ua729\u0000\u0000\ua72a\ua72b\u0000\u0000\ua72c\ua72d\u0000\u0000\ua72e\ua72f\u0000\u0000\ua732\ua733\u0000\u0000\ua734\ua735\u0000\u0000\ua736\ua737\u0000\u0000\ua738\ua739\u0000\u0000\ua73a\ua73b\u0000\u0000\ua73c\ua73d\u0000\u0000\ua73e\ua73f\u0000\u0000\ua740\ua741\u0000\u0000\ua742\ua743\u0000\u0000\ua744\ua745\u0000\u0000\ua746\ua747\u0000\u0000\ua748\ua749\u0000\u0000\ua74a\ua74b\u0000\u0000\ua74c\ua74d\u0000\u0000\ua74e\ua74f\u0000\u0000\ua750\ua751\u0000\u0000\ua752\ua753\u0000\u0000\ua754\ua755\u0000\u0000\ua756\ua757\u0000\u0000\ua758\ua759\u0000\u0000\ua75a\ua75b\u0000\u0000\ua75c\ua75d\u0000\u0000\ua75e\ua75f\u0000\u0000\ua760\ua761\u0000\u0000\ua762\ua763\u0000\u0000\ua764\ua765\u0000\u0000\ua766\ua767\u0000\u0000\ua768\ua769\u0000\u0000\ua76a\ua76b\u0000\u0000\ua76c\ua76d\u0000\u0000\ua76e\ua76f\u0000\u0000\ua779\ua77a\u0000\u0000\ua77b\ua77c\u0000\u0000\ua77e\ua77f\u0000\u0000\ua780\ua781\u0000\u0000\ua782\ua783\u0000\u0000\ua784\ua785\u0000\u0000\ua786\ua787\u0000\u0000\ua78b\ua78c\u0000\u0000\ua790\ua791\u0000\u0000\ua792\ua793\u0000\u0000\ua7a0\ua7a1\u0000\u0000\ua7a2\ua7a3\u0000\u0000\ua7a4\ua7a5\u0000\u0000\ua7a6\ua7a7\u0000\u0000\ua7a8\ua7a9\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000\ud801\udc00\ud801\udc28\u0000\u0000\ud801\udc01\ud801\udc29\u0000\u0000\ud801\udc02\ud801\udc2a\u0000\u0000\ud801\udc03\ud801\udc2b\u0000\u0000\ud801\udc04\ud801\udc2c\u0000\u0000\ud801\udc05\ud801\udc2d\u0000\u0000\ud801\udc06\ud801\udc2e\u0000\u0000\ud801\udc07\ud801\udc2f\u0000\u0000\ud801\udc08\ud801\udc30\u0000\u0000\ud801\udc09\ud801\udc31\u0000\u0000\ud801\udc0a\ud801\udc32\u0000\u0000\ud801\udc0b\ud801\udc33\u0000\u0000\ud801\udc0c\ud801\udc34\u0000\u0000\ud801\udc0d\ud801\udc35\u0000\u0000\ud801\udc0e\ud801\udc36\u0000\u0000\ud801\udc0f\ud801\udc37\u0000\u0000\ud801\udc10\ud801\udc38\u0000\u0000\ud801\udc11\ud801\udc39\u0000\u0000\ud801\udc12\ud801\udc3a\u0000\u0000\ud801\udc13\ud801\udc3b\u0000\u0000\ud801\udc14\ud801\udc3c\u0000\u0000\ud801\udc15\ud801\udc3d\u0000\u0000\ud801\udc16\ud801\udc3e\u0000\u0000\ud801\udc17\ud801\udc3f\u0000\u0000\ud801\udc18\ud801\udc40\u0000\u0000\ud801\udc19\ud801\udc41\u0000\u0000\ud801\udc1a\ud801\udc42\u0000\u0000\ud801\udc1b\ud801\udc43\u0000\u0000\ud801\udc1c\ud801\udc44\u0000\u0000\ud801\udc1d\ud801\udc45\u0000\u0000\ud801\udc1e\ud801\udc46\u0000\u0000\ud801\udc1f\ud801\udc47\u0000\u0000\ud801\udc20\ud801\udc48\u0000\u0000\ud801\udc21\ud801\udc49\u0000\u0000\ud801\udc22\ud801\udc4a\u0000\u0000\ud801\udc23\ud801\udc4b\u0000\u0000\ud801\udc24\ud801\udc4c\u0000\u0000\ud801\udc25\ud801\udc4d\u0000\u0000\ud801\udc26\ud801\udc4e\u0000\u0000\ud801\udc27\ud801\udc4f\u0000\u0000", 4);
        } else if (version.equals("6.2") || version.equals("6.2.0")) {
            this.bind(Unicode_6_2.propertyValues, Unicode_6_2.intervals, Unicode_6_2.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00df\u1e9e\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0180\u0243\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019a\u023d\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019e\u0220\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u023a\u2c65\u0000\u0000\u023b\u023c\u0000\u0000\u023e\u2c66\u0000\u0000\u023f\u2c7e\u0000\u0000\u0240\u2c7f\u0000\u0000\u0241\u0242\u0000\u0000\u0244\u0289\u0000\u0000\u0245\u028c\u0000\u0000\u0246\u0247\u0000\u0000\u0248\u0249\u0000\u0000\u024a\u024b\u0000\u0000\u024c\u024d\u0000\u0000\u024e\u024f\u0000\u0000\u0250\u2c6f\u0000\u0000\u0251\u2c6d\u0000\u0000\u0252\u2c70\u0000\u0000\u0265\ua78d\u0000\u0000\u0266\ua7aa\u0000\u0000\u026b\u2c62\u0000\u0000\u0271\u2c6e\u0000\u0000\u027d\u2c64\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0370\u0371\u0000\u0000\u0372\u0373\u0000\u0000\u0376\u0377\u0000\u0000\u037b\u03fd\u0000\u0000\u037c\u03fe\u0000\u0000\u037d\u03ff\u0000\u0000\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u03f5\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u03f4\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u0000\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03cf\u03d7\u0000\u0000\u03d8\u03d9\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u03f2\u03f9\u0000\u0000\u03f7\u03f8\u0000\u0000\u03fa\u03fb\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048a\u048b\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c0\u04cf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c5\u04c6\u0000\u0000\u04c7\u04c8\u0000\u0000\u04c9\u04ca\u0000\u0000\u04cb\u04cc\u0000\u0000\u04cd\u04ce\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f6\u04f7\u0000\u0000\u04f8\u04f9\u0000\u0000\u04fa\u04fb\u0000\u0000\u04fc\u04fd\u0000\u0000\u04fe\u04ff\u0000\u0000\u0500\u0501\u0000\u0000\u0502\u0503\u0000\u0000\u0504\u0505\u0000\u0000\u0506\u0507\u0000\u0000\u0508\u0509\u0000\u0000\u050a\u050b\u0000\u0000\u050c\u050d\u0000\u0000\u050e\u050f\u0000\u0000\u0510\u0511\u0000\u0000\u0512\u0513\u0000\u0000\u0514\u0515\u0000\u0000\u0516\u0517\u0000\u0000\u0518\u0519\u0000\u0000\u051a\u051b\u0000\u0000\u051c\u051d\u0000\u0000\u051e\u051f\u0000\u0000\u0520\u0521\u0000\u0000\u0522\u0523\u0000\u0000\u0524\u0525\u0000\u0000\u0526\u0527\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u10a0\u2d00\u0000\u0000\u10a1\u2d01\u0000\u0000\u10a2\u2d02\u0000\u0000\u10a3\u2d03\u0000\u0000\u10a4\u2d04\u0000\u0000\u10a5\u2d05\u0000\u0000\u10a6\u2d06\u0000\u0000\u10a7\u2d07\u0000\u0000\u10a8\u2d08\u0000\u0000\u10a9\u2d09\u0000\u0000\u10aa\u2d0a\u0000\u0000\u10ab\u2d0b\u0000\u0000\u10ac\u2d0c\u0000\u0000\u10ad\u2d0d\u0000\u0000\u10ae\u2d0e\u0000\u0000\u10af\u2d0f\u0000\u0000\u10b0\u2d10\u0000\u0000\u10b1\u2d11\u0000\u0000\u10b2\u2d12\u0000\u0000\u10b3\u2d13\u0000\u0000\u10b4\u2d14\u0000\u0000\u10b5\u2d15\u0000\u0000\u10b6\u2d16\u0000\u0000\u10b7\u2d17\u0000\u0000\u10b8\u2d18\u0000\u0000\u10b9\u2d19\u0000\u0000\u10ba\u2d1a\u0000\u0000\u10bb\u2d1b\u0000\u0000\u10bc\u2d1c\u0000\u0000\u10bd\u2d1d\u0000\u0000\u10be\u2d1e\u0000\u0000\u10bf\u2d1f\u0000\u0000\u10c0\u2d20\u0000\u0000\u10c1\u2d21\u0000\u0000\u10c2\u2d22\u0000\u0000\u10c3\u2d23\u0000\u0000\u10c4\u2d24\u0000\u0000\u10c5\u2d25\u0000\u0000\u10c7\u2d27\u0000\u0000\u10cd\u2d2d\u0000\u0000\u1d79\ua77d\u0000\u0000\u1d7d\u2c63\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1efa\u1efb\u0000\u0000\u1efc\u1efd\u0000\u0000\u1efe\u1eff\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2132\u214e\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u2183\u2184\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\u2c00\u2c30\u0000\u0000\u2c01\u2c31\u0000\u0000\u2c02\u2c32\u0000\u0000\u2c03\u2c33\u0000\u0000\u2c04\u2c34\u0000\u0000\u2c05\u2c35\u0000\u0000\u2c06\u2c36\u0000\u0000\u2c07\u2c37\u0000\u0000\u2c08\u2c38\u0000\u0000\u2c09\u2c39\u0000\u0000\u2c0a\u2c3a\u0000\u0000\u2c0b\u2c3b\u0000\u0000\u2c0c\u2c3c\u0000\u0000\u2c0d\u2c3d\u0000\u0000\u2c0e\u2c3e\u0000\u0000\u2c0f\u2c3f\u0000\u0000\u2c10\u2c40\u0000\u0000\u2c11\u2c41\u0000\u0000\u2c12\u2c42\u0000\u0000\u2c13\u2c43\u0000\u0000\u2c14\u2c44\u0000\u0000\u2c15\u2c45\u0000\u0000\u2c16\u2c46\u0000\u0000\u2c17\u2c47\u0000\u0000\u2c18\u2c48\u0000\u0000\u2c19\u2c49\u0000\u0000\u2c1a\u2c4a\u0000\u0000\u2c1b\u2c4b\u0000\u0000\u2c1c\u2c4c\u0000\u0000\u2c1d\u2c4d\u0000\u0000\u2c1e\u2c4e\u0000\u0000\u2c1f\u2c4f\u0000\u0000\u2c20\u2c50\u0000\u0000\u2c21\u2c51\u0000\u0000\u2c22\u2c52\u0000\u0000\u2c23\u2c53\u0000\u0000\u2c24\u2c54\u0000\u0000\u2c25\u2c55\u0000\u0000\u2c26\u2c56\u0000\u0000\u2c27\u2c57\u0000\u0000\u2c28\u2c58\u0000\u0000\u2c29\u2c59\u0000\u0000\u2c2a\u2c5a\u0000\u0000\u2c2b\u2c5b\u0000\u0000\u2c2c\u2c5c\u0000\u0000\u2c2d\u2c5d\u0000\u0000\u2c2e\u2c5e\u0000\u0000\u2c60\u2c61\u0000\u0000\u2c67\u2c68\u0000\u0000\u2c69\u2c6a\u0000\u0000\u2c6b\u2c6c\u0000\u0000\u2c72\u2c73\u0000\u0000\u2c75\u2c76\u0000\u0000\u2c80\u2c81\u0000\u0000\u2c82\u2c83\u0000\u0000\u2c84\u2c85\u0000\u0000\u2c86\u2c87\u0000\u0000\u2c88\u2c89\u0000\u0000\u2c8a\u2c8b\u0000\u0000\u2c8c\u2c8d\u0000\u0000\u2c8e\u2c8f\u0000\u0000\u2c90\u2c91\u0000\u0000\u2c92\u2c93\u0000\u0000\u2c94\u2c95\u0000\u0000\u2c96\u2c97\u0000\u0000\u2c98\u2c99\u0000\u0000\u2c9a\u2c9b\u0000\u0000\u2c9c\u2c9d\u0000\u0000\u2c9e\u2c9f\u0000\u0000\u2ca0\u2ca1\u0000\u0000\u2ca2\u2ca3\u0000\u0000\u2ca4\u2ca5\u0000\u0000\u2ca6\u2ca7\u0000\u0000\u2ca8\u2ca9\u0000\u0000\u2caa\u2cab\u0000\u0000\u2cac\u2cad\u0000\u0000\u2cae\u2caf\u0000\u0000\u2cb0\u2cb1\u0000\u0000\u2cb2\u2cb3\u0000\u0000\u2cb4\u2cb5\u0000\u0000\u2cb6\u2cb7\u0000\u0000\u2cb8\u2cb9\u0000\u0000\u2cba\u2cbb\u0000\u0000\u2cbc\u2cbd\u0000\u0000\u2cbe\u2cbf\u0000\u0000\u2cc0\u2cc1\u0000\u0000\u2cc2\u2cc3\u0000\u0000\u2cc4\u2cc5\u0000\u0000\u2cc6\u2cc7\u0000\u0000\u2cc8\u2cc9\u0000\u0000\u2cca\u2ccb\u0000\u0000\u2ccc\u2ccd\u0000\u0000\u2cce\u2ccf\u0000\u0000\u2cd0\u2cd1\u0000\u0000\u2cd2\u2cd3\u0000\u0000\u2cd4\u2cd5\u0000\u0000\u2cd6\u2cd7\u0000\u0000\u2cd8\u2cd9\u0000\u0000\u2cda\u2cdb\u0000\u0000\u2cdc\u2cdd\u0000\u0000\u2cde\u2cdf\u0000\u0000\u2ce0\u2ce1\u0000\u0000\u2ce2\u2ce3\u0000\u0000\u2ceb\u2cec\u0000\u0000\u2ced\u2cee\u0000\u0000\u2cf2\u2cf3\u0000\u0000\ua640\ua641\u0000\u0000\ua642\ua643\u0000\u0000\ua644\ua645\u0000\u0000\ua646\ua647\u0000\u0000\ua648\ua649\u0000\u0000\ua64a\ua64b\u0000\u0000\ua64c\ua64d\u0000\u0000\ua64e\ua64f\u0000\u0000\ua650\ua651\u0000\u0000\ua652\ua653\u0000\u0000\ua654\ua655\u0000\u0000\ua656\ua657\u0000\u0000\ua658\ua659\u0000\u0000\ua65a\ua65b\u0000\u0000\ua65c\ua65d\u0000\u0000\ua65e\ua65f\u0000\u0000\ua660\ua661\u0000\u0000\ua662\ua663\u0000\u0000\ua664\ua665\u0000\u0000\ua666\ua667\u0000\u0000\ua668\ua669\u0000\u0000\ua66a\ua66b\u0000\u0000\ua66c\ua66d\u0000\u0000\ua680\ua681\u0000\u0000\ua682\ua683\u0000\u0000\ua684\ua685\u0000\u0000\ua686\ua687\u0000\u0000\ua688\ua689\u0000\u0000\ua68a\ua68b\u0000\u0000\ua68c\ua68d\u0000\u0000\ua68e\ua68f\u0000\u0000\ua690\ua691\u0000\u0000\ua692\ua693\u0000\u0000\ua694\ua695\u0000\u0000\ua696\ua697\u0000\u0000\ua722\ua723\u0000\u0000\ua724\ua725\u0000\u0000\ua726\ua727\u0000\u0000\ua728\ua729\u0000\u0000\ua72a\ua72b\u0000\u0000\ua72c\ua72d\u0000\u0000\ua72e\ua72f\u0000\u0000\ua732\ua733\u0000\u0000\ua734\ua735\u0000\u0000\ua736\ua737\u0000\u0000\ua738\ua739\u0000\u0000\ua73a\ua73b\u0000\u0000\ua73c\ua73d\u0000\u0000\ua73e\ua73f\u0000\u0000\ua740\ua741\u0000\u0000\ua742\ua743\u0000\u0000\ua744\ua745\u0000\u0000\ua746\ua747\u0000\u0000\ua748\ua749\u0000\u0000\ua74a\ua74b\u0000\u0000\ua74c\ua74d\u0000\u0000\ua74e\ua74f\u0000\u0000\ua750\ua751\u0000\u0000\ua752\ua753\u0000\u0000\ua754\ua755\u0000\u0000\ua756\ua757\u0000\u0000\ua758\ua759\u0000\u0000\ua75a\ua75b\u0000\u0000\ua75c\ua75d\u0000\u0000\ua75e\ua75f\u0000\u0000\ua760\ua761\u0000\u0000\ua762\ua763\u0000\u0000\ua764\ua765\u0000\u0000\ua766\ua767\u0000\u0000\ua768\ua769\u0000\u0000\ua76a\ua76b\u0000\u0000\ua76c\ua76d\u0000\u0000\ua76e\ua76f\u0000\u0000\ua779\ua77a\u0000\u0000\ua77b\ua77c\u0000\u0000\ua77e\ua77f\u0000\u0000\ua780\ua781\u0000\u0000\ua782\ua783\u0000\u0000\ua784\ua785\u0000\u0000\ua786\ua787\u0000\u0000\ua78b\ua78c\u0000\u0000\ua790\ua791\u0000\u0000\ua792\ua793\u0000\u0000\ua7a0\ua7a1\u0000\u0000\ua7a2\ua7a3\u0000\u0000\ua7a4\ua7a5\u0000\u0000\ua7a6\ua7a7\u0000\u0000\ua7a8\ua7a9\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000\ud801\udc00\ud801\udc28\u0000\u0000\ud801\udc01\ud801\udc29\u0000\u0000\ud801\udc02\ud801\udc2a\u0000\u0000\ud801\udc03\ud801\udc2b\u0000\u0000\ud801\udc04\ud801\udc2c\u0000\u0000\ud801\udc05\ud801\udc2d\u0000\u0000\ud801\udc06\ud801\udc2e\u0000\u0000\ud801\udc07\ud801\udc2f\u0000\u0000\ud801\udc08\ud801\udc30\u0000\u0000\ud801\udc09\ud801\udc31\u0000\u0000\ud801\udc0a\ud801\udc32\u0000\u0000\ud801\udc0b\ud801\udc33\u0000\u0000\ud801\udc0c\ud801\udc34\u0000\u0000\ud801\udc0d\ud801\udc35\u0000\u0000\ud801\udc0e\ud801\udc36\u0000\u0000\ud801\udc0f\ud801\udc37\u0000\u0000\ud801\udc10\ud801\udc38\u0000\u0000\ud801\udc11\ud801\udc39\u0000\u0000\ud801\udc12\ud801\udc3a\u0000\u0000\ud801\udc13\ud801\udc3b\u0000\u0000\ud801\udc14\ud801\udc3c\u0000\u0000\ud801\udc15\ud801\udc3d\u0000\u0000\ud801\udc16\ud801\udc3e\u0000\u0000\ud801\udc17\ud801\udc3f\u0000\u0000\ud801\udc18\ud801\udc40\u0000\u0000\ud801\udc19\ud801\udc41\u0000\u0000\ud801\udc1a\ud801\udc42\u0000\u0000\ud801\udc1b\ud801\udc43\u0000\u0000\ud801\udc1c\ud801\udc44\u0000\u0000\ud801\udc1d\ud801\udc45\u0000\u0000\ud801\udc1e\ud801\udc46\u0000\u0000\ud801\udc1f\ud801\udc47\u0000\u0000\ud801\udc20\ud801\udc48\u0000\u0000\ud801\udc21\ud801\udc49\u0000\u0000\ud801\udc22\ud801\udc4a\u0000\u0000\ud801\udc23\ud801\udc4b\u0000\u0000\ud801\udc24\ud801\udc4c\u0000\u0000\ud801\udc25\ud801\udc4d\u0000\u0000\ud801\udc26\ud801\udc4e\u0000\u0000\ud801\udc27\ud801\udc4f\u0000\u0000", 4);
        } else if (version.equals("6.3") || version.equals("6.3.0")) {
            this.bind(Unicode_6_3.propertyValues, Unicode_6_3.intervals, Unicode_6_3.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00df\u1e9e\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0180\u0243\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019a\u023d\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019e\u0220\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u023a\u2c65\u0000\u0000\u023b\u023c\u0000\u0000\u023e\u2c66\u0000\u0000\u023f\u2c7e\u0000\u0000\u0240\u2c7f\u0000\u0000\u0241\u0242\u0000\u0000\u0244\u0289\u0000\u0000\u0245\u028c\u0000\u0000\u0246\u0247\u0000\u0000\u0248\u0249\u0000\u0000\u024a\u024b\u0000\u0000\u024c\u024d\u0000\u0000\u024e\u024f\u0000\u0000\u0250\u2c6f\u0000\u0000\u0251\u2c6d\u0000\u0000\u0252\u2c70\u0000\u0000\u0265\ua78d\u0000\u0000\u0266\ua7aa\u0000\u0000\u026b\u2c62\u0000\u0000\u0271\u2c6e\u0000\u0000\u027d\u2c64\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0370\u0371\u0000\u0000\u0372\u0373\u0000\u0000\u0376\u0377\u0000\u0000\u037b\u03fd\u0000\u0000\u037c\u03fe\u0000\u0000\u037d\u03ff\u0000\u0000\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u03f5\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u03f4\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u0000\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03cf\u03d7\u0000\u0000\u03d8\u03d9\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u03f2\u03f9\u0000\u0000\u03f7\u03f8\u0000\u0000\u03fa\u03fb\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048a\u048b\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c0\u04cf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c5\u04c6\u0000\u0000\u04c7\u04c8\u0000\u0000\u04c9\u04ca\u0000\u0000\u04cb\u04cc\u0000\u0000\u04cd\u04ce\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f6\u04f7\u0000\u0000\u04f8\u04f9\u0000\u0000\u04fa\u04fb\u0000\u0000\u04fc\u04fd\u0000\u0000\u04fe\u04ff\u0000\u0000\u0500\u0501\u0000\u0000\u0502\u0503\u0000\u0000\u0504\u0505\u0000\u0000\u0506\u0507\u0000\u0000\u0508\u0509\u0000\u0000\u050a\u050b\u0000\u0000\u050c\u050d\u0000\u0000\u050e\u050f\u0000\u0000\u0510\u0511\u0000\u0000\u0512\u0513\u0000\u0000\u0514\u0515\u0000\u0000\u0516\u0517\u0000\u0000\u0518\u0519\u0000\u0000\u051a\u051b\u0000\u0000\u051c\u051d\u0000\u0000\u051e\u051f\u0000\u0000\u0520\u0521\u0000\u0000\u0522\u0523\u0000\u0000\u0524\u0525\u0000\u0000\u0526\u0527\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u10a0\u2d00\u0000\u0000\u10a1\u2d01\u0000\u0000\u10a2\u2d02\u0000\u0000\u10a3\u2d03\u0000\u0000\u10a4\u2d04\u0000\u0000\u10a5\u2d05\u0000\u0000\u10a6\u2d06\u0000\u0000\u10a7\u2d07\u0000\u0000\u10a8\u2d08\u0000\u0000\u10a9\u2d09\u0000\u0000\u10aa\u2d0a\u0000\u0000\u10ab\u2d0b\u0000\u0000\u10ac\u2d0c\u0000\u0000\u10ad\u2d0d\u0000\u0000\u10ae\u2d0e\u0000\u0000\u10af\u2d0f\u0000\u0000\u10b0\u2d10\u0000\u0000\u10b1\u2d11\u0000\u0000\u10b2\u2d12\u0000\u0000\u10b3\u2d13\u0000\u0000\u10b4\u2d14\u0000\u0000\u10b5\u2d15\u0000\u0000\u10b6\u2d16\u0000\u0000\u10b7\u2d17\u0000\u0000\u10b8\u2d18\u0000\u0000\u10b9\u2d19\u0000\u0000\u10ba\u2d1a\u0000\u0000\u10bb\u2d1b\u0000\u0000\u10bc\u2d1c\u0000\u0000\u10bd\u2d1d\u0000\u0000\u10be\u2d1e\u0000\u0000\u10bf\u2d1f\u0000\u0000\u10c0\u2d20\u0000\u0000\u10c1\u2d21\u0000\u0000\u10c2\u2d22\u0000\u0000\u10c3\u2d23\u0000\u0000\u10c4\u2d24\u0000\u0000\u10c5\u2d25\u0000\u0000\u10c7\u2d27\u0000\u0000\u10cd\u2d2d\u0000\u0000\u1d79\ua77d\u0000\u0000\u1d7d\u2c63\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1efa\u1efb\u0000\u0000\u1efc\u1efd\u0000\u0000\u1efe\u1eff\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2132\u214e\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u2183\u2184\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\u2c00\u2c30\u0000\u0000\u2c01\u2c31\u0000\u0000\u2c02\u2c32\u0000\u0000\u2c03\u2c33\u0000\u0000\u2c04\u2c34\u0000\u0000\u2c05\u2c35\u0000\u0000\u2c06\u2c36\u0000\u0000\u2c07\u2c37\u0000\u0000\u2c08\u2c38\u0000\u0000\u2c09\u2c39\u0000\u0000\u2c0a\u2c3a\u0000\u0000\u2c0b\u2c3b\u0000\u0000\u2c0c\u2c3c\u0000\u0000\u2c0d\u2c3d\u0000\u0000\u2c0e\u2c3e\u0000\u0000\u2c0f\u2c3f\u0000\u0000\u2c10\u2c40\u0000\u0000\u2c11\u2c41\u0000\u0000\u2c12\u2c42\u0000\u0000\u2c13\u2c43\u0000\u0000\u2c14\u2c44\u0000\u0000\u2c15\u2c45\u0000\u0000\u2c16\u2c46\u0000\u0000\u2c17\u2c47\u0000\u0000\u2c18\u2c48\u0000\u0000\u2c19\u2c49\u0000\u0000\u2c1a\u2c4a\u0000\u0000\u2c1b\u2c4b\u0000\u0000\u2c1c\u2c4c\u0000\u0000\u2c1d\u2c4d\u0000\u0000\u2c1e\u2c4e\u0000\u0000\u2c1f\u2c4f\u0000\u0000\u2c20\u2c50\u0000\u0000\u2c21\u2c51\u0000\u0000\u2c22\u2c52\u0000\u0000\u2c23\u2c53\u0000\u0000\u2c24\u2c54\u0000\u0000\u2c25\u2c55\u0000\u0000\u2c26\u2c56\u0000\u0000\u2c27\u2c57\u0000\u0000\u2c28\u2c58\u0000\u0000\u2c29\u2c59\u0000\u0000\u2c2a\u2c5a\u0000\u0000\u2c2b\u2c5b\u0000\u0000\u2c2c\u2c5c\u0000\u0000\u2c2d\u2c5d\u0000\u0000\u2c2e\u2c5e\u0000\u0000\u2c60\u2c61\u0000\u0000\u2c67\u2c68\u0000\u0000\u2c69\u2c6a\u0000\u0000\u2c6b\u2c6c\u0000\u0000\u2c72\u2c73\u0000\u0000\u2c75\u2c76\u0000\u0000\u2c80\u2c81\u0000\u0000\u2c82\u2c83\u0000\u0000\u2c84\u2c85\u0000\u0000\u2c86\u2c87\u0000\u0000\u2c88\u2c89\u0000\u0000\u2c8a\u2c8b\u0000\u0000\u2c8c\u2c8d\u0000\u0000\u2c8e\u2c8f\u0000\u0000\u2c90\u2c91\u0000\u0000\u2c92\u2c93\u0000\u0000\u2c94\u2c95\u0000\u0000\u2c96\u2c97\u0000\u0000\u2c98\u2c99\u0000\u0000\u2c9a\u2c9b\u0000\u0000\u2c9c\u2c9d\u0000\u0000\u2c9e\u2c9f\u0000\u0000\u2ca0\u2ca1\u0000\u0000\u2ca2\u2ca3\u0000\u0000\u2ca4\u2ca5\u0000\u0000\u2ca6\u2ca7\u0000\u0000\u2ca8\u2ca9\u0000\u0000\u2caa\u2cab\u0000\u0000\u2cac\u2cad\u0000\u0000\u2cae\u2caf\u0000\u0000\u2cb0\u2cb1\u0000\u0000\u2cb2\u2cb3\u0000\u0000\u2cb4\u2cb5\u0000\u0000\u2cb6\u2cb7\u0000\u0000\u2cb8\u2cb9\u0000\u0000\u2cba\u2cbb\u0000\u0000\u2cbc\u2cbd\u0000\u0000\u2cbe\u2cbf\u0000\u0000\u2cc0\u2cc1\u0000\u0000\u2cc2\u2cc3\u0000\u0000\u2cc4\u2cc5\u0000\u0000\u2cc6\u2cc7\u0000\u0000\u2cc8\u2cc9\u0000\u0000\u2cca\u2ccb\u0000\u0000\u2ccc\u2ccd\u0000\u0000\u2cce\u2ccf\u0000\u0000\u2cd0\u2cd1\u0000\u0000\u2cd2\u2cd3\u0000\u0000\u2cd4\u2cd5\u0000\u0000\u2cd6\u2cd7\u0000\u0000\u2cd8\u2cd9\u0000\u0000\u2cda\u2cdb\u0000\u0000\u2cdc\u2cdd\u0000\u0000\u2cde\u2cdf\u0000\u0000\u2ce0\u2ce1\u0000\u0000\u2ce2\u2ce3\u0000\u0000\u2ceb\u2cec\u0000\u0000\u2ced\u2cee\u0000\u0000\u2cf2\u2cf3\u0000\u0000\ua640\ua641\u0000\u0000\ua642\ua643\u0000\u0000\ua644\ua645\u0000\u0000\ua646\ua647\u0000\u0000\ua648\ua649\u0000\u0000\ua64a\ua64b\u0000\u0000\ua64c\ua64d\u0000\u0000\ua64e\ua64f\u0000\u0000\ua650\ua651\u0000\u0000\ua652\ua653\u0000\u0000\ua654\ua655\u0000\u0000\ua656\ua657\u0000\u0000\ua658\ua659\u0000\u0000\ua65a\ua65b\u0000\u0000\ua65c\ua65d\u0000\u0000\ua65e\ua65f\u0000\u0000\ua660\ua661\u0000\u0000\ua662\ua663\u0000\u0000\ua664\ua665\u0000\u0000\ua666\ua667\u0000\u0000\ua668\ua669\u0000\u0000\ua66a\ua66b\u0000\u0000\ua66c\ua66d\u0000\u0000\ua680\ua681\u0000\u0000\ua682\ua683\u0000\u0000\ua684\ua685\u0000\u0000\ua686\ua687\u0000\u0000\ua688\ua689\u0000\u0000\ua68a\ua68b\u0000\u0000\ua68c\ua68d\u0000\u0000\ua68e\ua68f\u0000\u0000\ua690\ua691\u0000\u0000\ua692\ua693\u0000\u0000\ua694\ua695\u0000\u0000\ua696\ua697\u0000\u0000\ua722\ua723\u0000\u0000\ua724\ua725\u0000\u0000\ua726\ua727\u0000\u0000\ua728\ua729\u0000\u0000\ua72a\ua72b\u0000\u0000\ua72c\ua72d\u0000\u0000\ua72e\ua72f\u0000\u0000\ua732\ua733\u0000\u0000\ua734\ua735\u0000\u0000\ua736\ua737\u0000\u0000\ua738\ua739\u0000\u0000\ua73a\ua73b\u0000\u0000\ua73c\ua73d\u0000\u0000\ua73e\ua73f\u0000\u0000\ua740\ua741\u0000\u0000\ua742\ua743\u0000\u0000\ua744\ua745\u0000\u0000\ua746\ua747\u0000\u0000\ua748\ua749\u0000\u0000\ua74a\ua74b\u0000\u0000\ua74c\ua74d\u0000\u0000\ua74e\ua74f\u0000\u0000\ua750\ua751\u0000\u0000\ua752\ua753\u0000\u0000\ua754\ua755\u0000\u0000\ua756\ua757\u0000\u0000\ua758\ua759\u0000\u0000\ua75a\ua75b\u0000\u0000\ua75c\ua75d\u0000\u0000\ua75e\ua75f\u0000\u0000\ua760\ua761\u0000\u0000\ua762\ua763\u0000\u0000\ua764\ua765\u0000\u0000\ua766\ua767\u0000\u0000\ua768\ua769\u0000\u0000\ua76a\ua76b\u0000\u0000\ua76c\ua76d\u0000\u0000\ua76e\ua76f\u0000\u0000\ua779\ua77a\u0000\u0000\ua77b\ua77c\u0000\u0000\ua77e\ua77f\u0000\u0000\ua780\ua781\u0000\u0000\ua782\ua783\u0000\u0000\ua784\ua785\u0000\u0000\ua786\ua787\u0000\u0000\ua78b\ua78c\u0000\u0000\ua790\ua791\u0000\u0000\ua792\ua793\u0000\u0000\ua7a0\ua7a1\u0000\u0000\ua7a2\ua7a3\u0000\u0000\ua7a4\ua7a5\u0000\u0000\ua7a6\ua7a7\u0000\u0000\ua7a8\ua7a9\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000\ud801\udc00\ud801\udc28\u0000\u0000\ud801\udc01\ud801\udc29\u0000\u0000\ud801\udc02\ud801\udc2a\u0000\u0000\ud801\udc03\ud801\udc2b\u0000\u0000\ud801\udc04\ud801\udc2c\u0000\u0000\ud801\udc05\ud801\udc2d\u0000\u0000\ud801\udc06\ud801\udc2e\u0000\u0000\ud801\udc07\ud801\udc2f\u0000\u0000\ud801\udc08\ud801\udc30\u0000\u0000\ud801\udc09\ud801\udc31\u0000\u0000\ud801\udc0a\ud801\udc32\u0000\u0000\ud801\udc0b\ud801\udc33\u0000\u0000\ud801\udc0c\ud801\udc34\u0000\u0000\ud801\udc0d\ud801\udc35\u0000\u0000\ud801\udc0e\ud801\udc36\u0000\u0000\ud801\udc0f\ud801\udc37\u0000\u0000\ud801\udc10\ud801\udc38\u0000\u0000\ud801\udc11\ud801\udc39\u0000\u0000\ud801\udc12\ud801\udc3a\u0000\u0000\ud801\udc13\ud801\udc3b\u0000\u0000\ud801\udc14\ud801\udc3c\u0000\u0000\ud801\udc15\ud801\udc3d\u0000\u0000\ud801\udc16\ud801\udc3e\u0000\u0000\ud801\udc17\ud801\udc3f\u0000\u0000\ud801\udc18\ud801\udc40\u0000\u0000\ud801\udc19\ud801\udc41\u0000\u0000\ud801\udc1a\ud801\udc42\u0000\u0000\ud801\udc1b\ud801\udc43\u0000\u0000\ud801\udc1c\ud801\udc44\u0000\u0000\ud801\udc1d\ud801\udc45\u0000\u0000\ud801\udc1e\ud801\udc46\u0000\u0000\ud801\udc1f\ud801\udc47\u0000\u0000\ud801\udc20\ud801\udc48\u0000\u0000\ud801\udc21\ud801\udc49\u0000\u0000\ud801\udc22\ud801\udc4a\u0000\u0000\ud801\udc23\ud801\udc4b\u0000\u0000\ud801\udc24\ud801\udc4c\u0000\u0000\ud801\udc25\ud801\udc4d\u0000\u0000\ud801\udc26\ud801\udc4e\u0000\u0000\ud801\udc27\ud801\udc4f\u0000\u0000", 4);
        } else if (version.equals("7") || version.equals(DEFAULT_UNICODE_VERSION) || version.equals("7.0.0")) {
            this.bind(Unicode_7_0.propertyValues, Unicode_7_0.intervals, Unicode_7_0.propertyValueAliases, 0x10FFFF, "Aa\u0000\u0000Bb\u0000\u0000Cc\u0000\u0000Dd\u0000\u0000Ee\u0000\u0000Ff\u0000\u0000Gg\u0000\u0000Hh\u0000\u0000Ii\u0130\u0131Jj\u0000\u0000Kk\u212a\u0000Ll\u0000\u0000Mm\u0000\u0000Nn\u0000\u0000Oo\u0000\u0000Pp\u0000\u0000Qq\u0000\u0000Rr\u0000\u0000Ss\u017f\u0000Tt\u0000\u0000Uu\u0000\u0000Vv\u0000\u0000Ww\u0000\u0000Xx\u0000\u0000Yy\u0000\u0000Zz\u0000\u0000\u00b5\u039c\u03bc\u0000\u00c0\u00e0\u0000\u0000\u00c1\u00e1\u0000\u0000\u00c2\u00e2\u0000\u0000\u00c3\u00e3\u0000\u0000\u00c4\u00e4\u0000\u0000\u00c5\u00e5\u212b\u0000\u00c6\u00e6\u0000\u0000\u00c7\u00e7\u0000\u0000\u00c8\u00e8\u0000\u0000\u00c9\u00e9\u0000\u0000\u00ca\u00ea\u0000\u0000\u00cb\u00eb\u0000\u0000\u00cc\u00ec\u0000\u0000\u00cd\u00ed\u0000\u0000\u00ce\u00ee\u0000\u0000\u00cf\u00ef\u0000\u0000\u00d0\u00f0\u0000\u0000\u00d1\u00f1\u0000\u0000\u00d2\u00f2\u0000\u0000\u00d3\u00f3\u0000\u0000\u00d4\u00f4\u0000\u0000\u00d5\u00f5\u0000\u0000\u00d6\u00f6\u0000\u0000\u00d8\u00f8\u0000\u0000\u00d9\u00f9\u0000\u0000\u00da\u00fa\u0000\u0000\u00db\u00fb\u0000\u0000\u00dc\u00fc\u0000\u0000\u00dd\u00fd\u0000\u0000\u00de\u00fe\u0000\u0000\u00df\u1e9e\u0000\u0000\u00ff\u0178\u0000\u0000\u0100\u0101\u0000\u0000\u0102\u0103\u0000\u0000\u0104\u0105\u0000\u0000\u0106\u0107\u0000\u0000\u0108\u0109\u0000\u0000\u010a\u010b\u0000\u0000\u010c\u010d\u0000\u0000\u010e\u010f\u0000\u0000\u0110\u0111\u0000\u0000\u0112\u0113\u0000\u0000\u0114\u0115\u0000\u0000\u0116\u0117\u0000\u0000\u0118\u0119\u0000\u0000\u011a\u011b\u0000\u0000\u011c\u011d\u0000\u0000\u011e\u011f\u0000\u0000\u0120\u0121\u0000\u0000\u0122\u0123\u0000\u0000\u0124\u0125\u0000\u0000\u0126\u0127\u0000\u0000\u0128\u0129\u0000\u0000\u012a\u012b\u0000\u0000\u012c\u012d\u0000\u0000\u012e\u012f\u0000\u0000\u0132\u0133\u0000\u0000\u0134\u0135\u0000\u0000\u0136\u0137\u0000\u0000\u0139\u013a\u0000\u0000\u013b\u013c\u0000\u0000\u013d\u013e\u0000\u0000\u013f\u0140\u0000\u0000\u0141\u0142\u0000\u0000\u0143\u0144\u0000\u0000\u0145\u0146\u0000\u0000\u0147\u0148\u0000\u0000\u014a\u014b\u0000\u0000\u014c\u014d\u0000\u0000\u014e\u014f\u0000\u0000\u0150\u0151\u0000\u0000\u0152\u0153\u0000\u0000\u0154\u0155\u0000\u0000\u0156\u0157\u0000\u0000\u0158\u0159\u0000\u0000\u015a\u015b\u0000\u0000\u015c\u015d\u0000\u0000\u015e\u015f\u0000\u0000\u0160\u0161\u0000\u0000\u0162\u0163\u0000\u0000\u0164\u0165\u0000\u0000\u0166\u0167\u0000\u0000\u0168\u0169\u0000\u0000\u016a\u016b\u0000\u0000\u016c\u016d\u0000\u0000\u016e\u016f\u0000\u0000\u0170\u0171\u0000\u0000\u0172\u0173\u0000\u0000\u0174\u0175\u0000\u0000\u0176\u0177\u0000\u0000\u0179\u017a\u0000\u0000\u017b\u017c\u0000\u0000\u017d\u017e\u0000\u0000\u0180\u0243\u0000\u0000\u0181\u0253\u0000\u0000\u0182\u0183\u0000\u0000\u0184\u0185\u0000\u0000\u0186\u0254\u0000\u0000\u0187\u0188\u0000\u0000\u0189\u0256\u0000\u0000\u018a\u0257\u0000\u0000\u018b\u018c\u0000\u0000\u018e\u01dd\u0000\u0000\u018f\u0259\u0000\u0000\u0190\u025b\u0000\u0000\u0191\u0192\u0000\u0000\u0193\u0260\u0000\u0000\u0194\u0263\u0000\u0000\u0195\u01f6\u0000\u0000\u0196\u0269\u0000\u0000\u0197\u0268\u0000\u0000\u0198\u0199\u0000\u0000\u019a\u023d\u0000\u0000\u019c\u026f\u0000\u0000\u019d\u0272\u0000\u0000\u019e\u0220\u0000\u0000\u019f\u0275\u0000\u0000\u01a0\u01a1\u0000\u0000\u01a2\u01a3\u0000\u0000\u01a4\u01a5\u0000\u0000\u01a6\u0280\u0000\u0000\u01a7\u01a8\u0000\u0000\u01a9\u0283\u0000\u0000\u01ac\u01ad\u0000\u0000\u01ae\u0288\u0000\u0000\u01af\u01b0\u0000\u0000\u01b1\u028a\u0000\u0000\u01b2\u028b\u0000\u0000\u01b3\u01b4\u0000\u0000\u01b5\u01b6\u0000\u0000\u01b7\u0292\u0000\u0000\u01b8\u01b9\u0000\u0000\u01bc\u01bd\u0000\u0000\u01bf\u01f7\u0000\u0000\u01c4\u01c5\u01c6\u0000\u01c7\u01c8\u01c9\u0000\u01ca\u01cb\u01cc\u0000\u01cd\u01ce\u0000\u0000\u01cf\u01d0\u0000\u0000\u01d1\u01d2\u0000\u0000\u01d3\u01d4\u0000\u0000\u01d5\u01d6\u0000\u0000\u01d7\u01d8\u0000\u0000\u01d9\u01da\u0000\u0000\u01db\u01dc\u0000\u0000\u01de\u01df\u0000\u0000\u01e0\u01e1\u0000\u0000\u01e2\u01e3\u0000\u0000\u01e4\u01e5\u0000\u0000\u01e6\u01e7\u0000\u0000\u01e8\u01e9\u0000\u0000\u01ea\u01eb\u0000\u0000\u01ec\u01ed\u0000\u0000\u01ee\u01ef\u0000\u0000\u01f1\u01f2\u01f3\u0000\u01f4\u01f5\u0000\u0000\u01f8\u01f9\u0000\u0000\u01fa\u01fb\u0000\u0000\u01fc\u01fd\u0000\u0000\u01fe\u01ff\u0000\u0000\u0200\u0201\u0000\u0000\u0202\u0203\u0000\u0000\u0204\u0205\u0000\u0000\u0206\u0207\u0000\u0000\u0208\u0209\u0000\u0000\u020a\u020b\u0000\u0000\u020c\u020d\u0000\u0000\u020e\u020f\u0000\u0000\u0210\u0211\u0000\u0000\u0212\u0213\u0000\u0000\u0214\u0215\u0000\u0000\u0216\u0217\u0000\u0000\u0218\u0219\u0000\u0000\u021a\u021b\u0000\u0000\u021c\u021d\u0000\u0000\u021e\u021f\u0000\u0000\u0222\u0223\u0000\u0000\u0224\u0225\u0000\u0000\u0226\u0227\u0000\u0000\u0228\u0229\u0000\u0000\u022a\u022b\u0000\u0000\u022c\u022d\u0000\u0000\u022e\u022f\u0000\u0000\u0230\u0231\u0000\u0000\u0232\u0233\u0000\u0000\u023a\u2c65\u0000\u0000\u023b\u023c\u0000\u0000\u023e\u2c66\u0000\u0000\u023f\u2c7e\u0000\u0000\u0240\u2c7f\u0000\u0000\u0241\u0242\u0000\u0000\u0244\u0289\u0000\u0000\u0245\u028c\u0000\u0000\u0246\u0247\u0000\u0000\u0248\u0249\u0000\u0000\u024a\u024b\u0000\u0000\u024c\u024d\u0000\u0000\u024e\u024f\u0000\u0000\u0250\u2c6f\u0000\u0000\u0251\u2c6d\u0000\u0000\u0252\u2c70\u0000\u0000\u025c\ua7ab\u0000\u0000\u0261\ua7ac\u0000\u0000\u0265\ua78d\u0000\u0000\u0266\ua7aa\u0000\u0000\u026b\u2c62\u0000\u0000\u026c\ua7ad\u0000\u0000\u0271\u2c6e\u0000\u0000\u027d\u2c64\u0000\u0000\u0287\ua7b1\u0000\u0000\u029e\ua7b0\u0000\u0000\u0345\u0399\u03b9\u1fbe\u0370\u0371\u0000\u0000\u0372\u0373\u0000\u0000\u0376\u0377\u0000\u0000\u037b\u03fd\u0000\u0000\u037c\u03fe\u0000\u0000\u037d\u03ff\u0000\u0000\u037f\u03f3\u0000\u0000\u0386\u03ac\u0000\u0000\u0388\u03ad\u0000\u0000\u0389\u03ae\u0000\u0000\u038a\u03af\u0000\u0000\u038c\u03cc\u0000\u0000\u038e\u03cd\u0000\u0000\u038f\u03ce\u0000\u0000\u0391\u03b1\u0000\u0000\u0392\u03b2\u03d0\u0000\u0393\u03b3\u0000\u0000\u0394\u03b4\u0000\u0000\u0395\u03b5\u03f5\u0000\u0396\u03b6\u0000\u0000\u0397\u03b7\u0000\u0000\u0398\u03b8\u03d1\u03f4\u039a\u03ba\u03f0\u0000\u039b\u03bb\u0000\u0000\u039d\u03bd\u0000\u0000\u039e\u03be\u0000\u0000\u039f\u03bf\u0000\u0000\u03a0\u03c0\u03d6\u0000\u03a1\u03c1\u03f1\u0000\u03a3\u03c2\u03c3\u0000\u03a4\u03c4\u0000\u0000\u03a5\u03c5\u0000\u0000\u03a6\u03c6\u03d5\u0000\u03a7\u03c7\u0000\u0000\u03a8\u03c8\u0000\u0000\u03a9\u03c9\u2126\u0000\u03aa\u03ca\u0000\u0000\u03ab\u03cb\u0000\u0000\u03cf\u03d7\u0000\u0000\u03d8\u03d9\u0000\u0000\u03da\u03db\u0000\u0000\u03dc\u03dd\u0000\u0000\u03de\u03df\u0000\u0000\u03e0\u03e1\u0000\u0000\u03e2\u03e3\u0000\u0000\u03e4\u03e5\u0000\u0000\u03e6\u03e7\u0000\u0000\u03e8\u03e9\u0000\u0000\u03ea\u03eb\u0000\u0000\u03ec\u03ed\u0000\u0000\u03ee\u03ef\u0000\u0000\u03f2\u03f9\u0000\u0000\u03f7\u03f8\u0000\u0000\u03fa\u03fb\u0000\u0000\u0400\u0450\u0000\u0000\u0401\u0451\u0000\u0000\u0402\u0452\u0000\u0000\u0403\u0453\u0000\u0000\u0404\u0454\u0000\u0000\u0405\u0455\u0000\u0000\u0406\u0456\u0000\u0000\u0407\u0457\u0000\u0000\u0408\u0458\u0000\u0000\u0409\u0459\u0000\u0000\u040a\u045a\u0000\u0000\u040b\u045b\u0000\u0000\u040c\u045c\u0000\u0000\u040d\u045d\u0000\u0000\u040e\u045e\u0000\u0000\u040f\u045f\u0000\u0000\u0410\u0430\u0000\u0000\u0411\u0431\u0000\u0000\u0412\u0432\u0000\u0000\u0413\u0433\u0000\u0000\u0414\u0434\u0000\u0000\u0415\u0435\u0000\u0000\u0416\u0436\u0000\u0000\u0417\u0437\u0000\u0000\u0418\u0438\u0000\u0000\u0419\u0439\u0000\u0000\u041a\u043a\u0000\u0000\u041b\u043b\u0000\u0000\u041c\u043c\u0000\u0000\u041d\u043d\u0000\u0000\u041e\u043e\u0000\u0000\u041f\u043f\u0000\u0000\u0420\u0440\u0000\u0000\u0421\u0441\u0000\u0000\u0422\u0442\u0000\u0000\u0423\u0443\u0000\u0000\u0424\u0444\u0000\u0000\u0425\u0445\u0000\u0000\u0426\u0446\u0000\u0000\u0427\u0447\u0000\u0000\u0428\u0448\u0000\u0000\u0429\u0449\u0000\u0000\u042a\u044a\u0000\u0000\u042b\u044b\u0000\u0000\u042c\u044c\u0000\u0000\u042d\u044d\u0000\u0000\u042e\u044e\u0000\u0000\u042f\u044f\u0000\u0000\u0460\u0461\u0000\u0000\u0462\u0463\u0000\u0000\u0464\u0465\u0000\u0000\u0466\u0467\u0000\u0000\u0468\u0469\u0000\u0000\u046a\u046b\u0000\u0000\u046c\u046d\u0000\u0000\u046e\u046f\u0000\u0000\u0470\u0471\u0000\u0000\u0472\u0473\u0000\u0000\u0474\u0475\u0000\u0000\u0476\u0477\u0000\u0000\u0478\u0479\u0000\u0000\u047a\u047b\u0000\u0000\u047c\u047d\u0000\u0000\u047e\u047f\u0000\u0000\u0480\u0481\u0000\u0000\u048a\u048b\u0000\u0000\u048c\u048d\u0000\u0000\u048e\u048f\u0000\u0000\u0490\u0491\u0000\u0000\u0492\u0493\u0000\u0000\u0494\u0495\u0000\u0000\u0496\u0497\u0000\u0000\u0498\u0499\u0000\u0000\u049a\u049b\u0000\u0000\u049c\u049d\u0000\u0000\u049e\u049f\u0000\u0000\u04a0\u04a1\u0000\u0000\u04a2\u04a3\u0000\u0000\u04a4\u04a5\u0000\u0000\u04a6\u04a7\u0000\u0000\u04a8\u04a9\u0000\u0000\u04aa\u04ab\u0000\u0000\u04ac\u04ad\u0000\u0000\u04ae\u04af\u0000\u0000\u04b0\u04b1\u0000\u0000\u04b2\u04b3\u0000\u0000\u04b4\u04b5\u0000\u0000\u04b6\u04b7\u0000\u0000\u04b8\u04b9\u0000\u0000\u04ba\u04bb\u0000\u0000\u04bc\u04bd\u0000\u0000\u04be\u04bf\u0000\u0000\u04c0\u04cf\u0000\u0000\u04c1\u04c2\u0000\u0000\u04c3\u04c4\u0000\u0000\u04c5\u04c6\u0000\u0000\u04c7\u04c8\u0000\u0000\u04c9\u04ca\u0000\u0000\u04cb\u04cc\u0000\u0000\u04cd\u04ce\u0000\u0000\u04d0\u04d1\u0000\u0000\u04d2\u04d3\u0000\u0000\u04d4\u04d5\u0000\u0000\u04d6\u04d7\u0000\u0000\u04d8\u04d9\u0000\u0000\u04da\u04db\u0000\u0000\u04dc\u04dd\u0000\u0000\u04de\u04df\u0000\u0000\u04e0\u04e1\u0000\u0000\u04e2\u04e3\u0000\u0000\u04e4\u04e5\u0000\u0000\u04e6\u04e7\u0000\u0000\u04e8\u04e9\u0000\u0000\u04ea\u04eb\u0000\u0000\u04ec\u04ed\u0000\u0000\u04ee\u04ef\u0000\u0000\u04f0\u04f1\u0000\u0000\u04f2\u04f3\u0000\u0000\u04f4\u04f5\u0000\u0000\u04f6\u04f7\u0000\u0000\u04f8\u04f9\u0000\u0000\u04fa\u04fb\u0000\u0000\u04fc\u04fd\u0000\u0000\u04fe\u04ff\u0000\u0000\u0500\u0501\u0000\u0000\u0502\u0503\u0000\u0000\u0504\u0505\u0000\u0000\u0506\u0507\u0000\u0000\u0508\u0509\u0000\u0000\u050a\u050b\u0000\u0000\u050c\u050d\u0000\u0000\u050e\u050f\u0000\u0000\u0510\u0511\u0000\u0000\u0512\u0513\u0000\u0000\u0514\u0515\u0000\u0000\u0516\u0517\u0000\u0000\u0518\u0519\u0000\u0000\u051a\u051b\u0000\u0000\u051c\u051d\u0000\u0000\u051e\u051f\u0000\u0000\u0520\u0521\u0000\u0000\u0522\u0523\u0000\u0000\u0524\u0525\u0000\u0000\u0526\u0527\u0000\u0000\u0528\u0529\u0000\u0000\u052a\u052b\u0000\u0000\u052c\u052d\u0000\u0000\u052e\u052f\u0000\u0000\u0531\u0561\u0000\u0000\u0532\u0562\u0000\u0000\u0533\u0563\u0000\u0000\u0534\u0564\u0000\u0000\u0535\u0565\u0000\u0000\u0536\u0566\u0000\u0000\u0537\u0567\u0000\u0000\u0538\u0568\u0000\u0000\u0539\u0569\u0000\u0000\u053a\u056a\u0000\u0000\u053b\u056b\u0000\u0000\u053c\u056c\u0000\u0000\u053d\u056d\u0000\u0000\u053e\u056e\u0000\u0000\u053f\u056f\u0000\u0000\u0540\u0570\u0000\u0000\u0541\u0571\u0000\u0000\u0542\u0572\u0000\u0000\u0543\u0573\u0000\u0000\u0544\u0574\u0000\u0000\u0545\u0575\u0000\u0000\u0546\u0576\u0000\u0000\u0547\u0577\u0000\u0000\u0548\u0578\u0000\u0000\u0549\u0579\u0000\u0000\u054a\u057a\u0000\u0000\u054b\u057b\u0000\u0000\u054c\u057c\u0000\u0000\u054d\u057d\u0000\u0000\u054e\u057e\u0000\u0000\u054f\u057f\u0000\u0000\u0550\u0580\u0000\u0000\u0551\u0581\u0000\u0000\u0552\u0582\u0000\u0000\u0553\u0583\u0000\u0000\u0554\u0584\u0000\u0000\u0555\u0585\u0000\u0000\u0556\u0586\u0000\u0000\u10a0\u2d00\u0000\u0000\u10a1\u2d01\u0000\u0000\u10a2\u2d02\u0000\u0000\u10a3\u2d03\u0000\u0000\u10a4\u2d04\u0000\u0000\u10a5\u2d05\u0000\u0000\u10a6\u2d06\u0000\u0000\u10a7\u2d07\u0000\u0000\u10a8\u2d08\u0000\u0000\u10a9\u2d09\u0000\u0000\u10aa\u2d0a\u0000\u0000\u10ab\u2d0b\u0000\u0000\u10ac\u2d0c\u0000\u0000\u10ad\u2d0d\u0000\u0000\u10ae\u2d0e\u0000\u0000\u10af\u2d0f\u0000\u0000\u10b0\u2d10\u0000\u0000\u10b1\u2d11\u0000\u0000\u10b2\u2d12\u0000\u0000\u10b3\u2d13\u0000\u0000\u10b4\u2d14\u0000\u0000\u10b5\u2d15\u0000\u0000\u10b6\u2d16\u0000\u0000\u10b7\u2d17\u0000\u0000\u10b8\u2d18\u0000\u0000\u10b9\u2d19\u0000\u0000\u10ba\u2d1a\u0000\u0000\u10bb\u2d1b\u0000\u0000\u10bc\u2d1c\u0000\u0000\u10bd\u2d1d\u0000\u0000\u10be\u2d1e\u0000\u0000\u10bf\u2d1f\u0000\u0000\u10c0\u2d20\u0000\u0000\u10c1\u2d21\u0000\u0000\u10c2\u2d22\u0000\u0000\u10c3\u2d23\u0000\u0000\u10c4\u2d24\u0000\u0000\u10c5\u2d25\u0000\u0000\u10c7\u2d27\u0000\u0000\u10cd\u2d2d\u0000\u0000\u1d79\ua77d\u0000\u0000\u1d7d\u2c63\u0000\u0000\u1e00\u1e01\u0000\u0000\u1e02\u1e03\u0000\u0000\u1e04\u1e05\u0000\u0000\u1e06\u1e07\u0000\u0000\u1e08\u1e09\u0000\u0000\u1e0a\u1e0b\u0000\u0000\u1e0c\u1e0d\u0000\u0000\u1e0e\u1e0f\u0000\u0000\u1e10\u1e11\u0000\u0000\u1e12\u1e13\u0000\u0000\u1e14\u1e15\u0000\u0000\u1e16\u1e17\u0000\u0000\u1e18\u1e19\u0000\u0000\u1e1a\u1e1b\u0000\u0000\u1e1c\u1e1d\u0000\u0000\u1e1e\u1e1f\u0000\u0000\u1e20\u1e21\u0000\u0000\u1e22\u1e23\u0000\u0000\u1e24\u1e25\u0000\u0000\u1e26\u1e27\u0000\u0000\u1e28\u1e29\u0000\u0000\u1e2a\u1e2b\u0000\u0000\u1e2c\u1e2d\u0000\u0000\u1e2e\u1e2f\u0000\u0000\u1e30\u1e31\u0000\u0000\u1e32\u1e33\u0000\u0000\u1e34\u1e35\u0000\u0000\u1e36\u1e37\u0000\u0000\u1e38\u1e39\u0000\u0000\u1e3a\u1e3b\u0000\u0000\u1e3c\u1e3d\u0000\u0000\u1e3e\u1e3f\u0000\u0000\u1e40\u1e41\u0000\u0000\u1e42\u1e43\u0000\u0000\u1e44\u1e45\u0000\u0000\u1e46\u1e47\u0000\u0000\u1e48\u1e49\u0000\u0000\u1e4a\u1e4b\u0000\u0000\u1e4c\u1e4d\u0000\u0000\u1e4e\u1e4f\u0000\u0000\u1e50\u1e51\u0000\u0000\u1e52\u1e53\u0000\u0000\u1e54\u1e55\u0000\u0000\u1e56\u1e57\u0000\u0000\u1e58\u1e59\u0000\u0000\u1e5a\u1e5b\u0000\u0000\u1e5c\u1e5d\u0000\u0000\u1e5e\u1e5f\u0000\u0000\u1e60\u1e61\u1e9b\u0000\u1e62\u1e63\u0000\u0000\u1e64\u1e65\u0000\u0000\u1e66\u1e67\u0000\u0000\u1e68\u1e69\u0000\u0000\u1e6a\u1e6b\u0000\u0000\u1e6c\u1e6d\u0000\u0000\u1e6e\u1e6f\u0000\u0000\u1e70\u1e71\u0000\u0000\u1e72\u1e73\u0000\u0000\u1e74\u1e75\u0000\u0000\u1e76\u1e77\u0000\u0000\u1e78\u1e79\u0000\u0000\u1e7a\u1e7b\u0000\u0000\u1e7c\u1e7d\u0000\u0000\u1e7e\u1e7f\u0000\u0000\u1e80\u1e81\u0000\u0000\u1e82\u1e83\u0000\u0000\u1e84\u1e85\u0000\u0000\u1e86\u1e87\u0000\u0000\u1e88\u1e89\u0000\u0000\u1e8a\u1e8b\u0000\u0000\u1e8c\u1e8d\u0000\u0000\u1e8e\u1e8f\u0000\u0000\u1e90\u1e91\u0000\u0000\u1e92\u1e93\u0000\u0000\u1e94\u1e95\u0000\u0000\u1ea0\u1ea1\u0000\u0000\u1ea2\u1ea3\u0000\u0000\u1ea4\u1ea5\u0000\u0000\u1ea6\u1ea7\u0000\u0000\u1ea8\u1ea9\u0000\u0000\u1eaa\u1eab\u0000\u0000\u1eac\u1ead\u0000\u0000\u1eae\u1eaf\u0000\u0000\u1eb0\u1eb1\u0000\u0000\u1eb2\u1eb3\u0000\u0000\u1eb4\u1eb5\u0000\u0000\u1eb6\u1eb7\u0000\u0000\u1eb8\u1eb9\u0000\u0000\u1eba\u1ebb\u0000\u0000\u1ebc\u1ebd\u0000\u0000\u1ebe\u1ebf\u0000\u0000\u1ec0\u1ec1\u0000\u0000\u1ec2\u1ec3\u0000\u0000\u1ec4\u1ec5\u0000\u0000\u1ec6\u1ec7\u0000\u0000\u1ec8\u1ec9\u0000\u0000\u1eca\u1ecb\u0000\u0000\u1ecc\u1ecd\u0000\u0000\u1ece\u1ecf\u0000\u0000\u1ed0\u1ed1\u0000\u0000\u1ed2\u1ed3\u0000\u0000\u1ed4\u1ed5\u0000\u0000\u1ed6\u1ed7\u0000\u0000\u1ed8\u1ed9\u0000\u0000\u1eda\u1edb\u0000\u0000\u1edc\u1edd\u0000\u0000\u1ede\u1edf\u0000\u0000\u1ee0\u1ee1\u0000\u0000\u1ee2\u1ee3\u0000\u0000\u1ee4\u1ee5\u0000\u0000\u1ee6\u1ee7\u0000\u0000\u1ee8\u1ee9\u0000\u0000\u1eea\u1eeb\u0000\u0000\u1eec\u1eed\u0000\u0000\u1eee\u1eef\u0000\u0000\u1ef0\u1ef1\u0000\u0000\u1ef2\u1ef3\u0000\u0000\u1ef4\u1ef5\u0000\u0000\u1ef6\u1ef7\u0000\u0000\u1ef8\u1ef9\u0000\u0000\u1efa\u1efb\u0000\u0000\u1efc\u1efd\u0000\u0000\u1efe\u1eff\u0000\u0000\u1f00\u1f08\u0000\u0000\u1f01\u1f09\u0000\u0000\u1f02\u1f0a\u0000\u0000\u1f03\u1f0b\u0000\u0000\u1f04\u1f0c\u0000\u0000\u1f05\u1f0d\u0000\u0000\u1f06\u1f0e\u0000\u0000\u1f07\u1f0f\u0000\u0000\u1f10\u1f18\u0000\u0000\u1f11\u1f19\u0000\u0000\u1f12\u1f1a\u0000\u0000\u1f13\u1f1b\u0000\u0000\u1f14\u1f1c\u0000\u0000\u1f15\u1f1d\u0000\u0000\u1f20\u1f28\u0000\u0000\u1f21\u1f29\u0000\u0000\u1f22\u1f2a\u0000\u0000\u1f23\u1f2b\u0000\u0000\u1f24\u1f2c\u0000\u0000\u1f25\u1f2d\u0000\u0000\u1f26\u1f2e\u0000\u0000\u1f27\u1f2f\u0000\u0000\u1f30\u1f38\u0000\u0000\u1f31\u1f39\u0000\u0000\u1f32\u1f3a\u0000\u0000\u1f33\u1f3b\u0000\u0000\u1f34\u1f3c\u0000\u0000\u1f35\u1f3d\u0000\u0000\u1f36\u1f3e\u0000\u0000\u1f37\u1f3f\u0000\u0000\u1f40\u1f48\u0000\u0000\u1f41\u1f49\u0000\u0000\u1f42\u1f4a\u0000\u0000\u1f43\u1f4b\u0000\u0000\u1f44\u1f4c\u0000\u0000\u1f45\u1f4d\u0000\u0000\u1f51\u1f59\u0000\u0000\u1f53\u1f5b\u0000\u0000\u1f55\u1f5d\u0000\u0000\u1f57\u1f5f\u0000\u0000\u1f60\u1f68\u0000\u0000\u1f61\u1f69\u0000\u0000\u1f62\u1f6a\u0000\u0000\u1f63\u1f6b\u0000\u0000\u1f64\u1f6c\u0000\u0000\u1f65\u1f6d\u0000\u0000\u1f66\u1f6e\u0000\u0000\u1f67\u1f6f\u0000\u0000\u1f70\u1fba\u0000\u0000\u1f71\u1fbb\u0000\u0000\u1f72\u1fc8\u0000\u0000\u1f73\u1fc9\u0000\u0000\u1f74\u1fca\u0000\u0000\u1f75\u1fcb\u0000\u0000\u1f76\u1fda\u0000\u0000\u1f77\u1fdb\u0000\u0000\u1f78\u1ff8\u0000\u0000\u1f79\u1ff9\u0000\u0000\u1f7a\u1fea\u0000\u0000\u1f7b\u1feb\u0000\u0000\u1f7c\u1ffa\u0000\u0000\u1f7d\u1ffb\u0000\u0000\u1f80\u1f88\u0000\u0000\u1f81\u1f89\u0000\u0000\u1f82\u1f8a\u0000\u0000\u1f83\u1f8b\u0000\u0000\u1f84\u1f8c\u0000\u0000\u1f85\u1f8d\u0000\u0000\u1f86\u1f8e\u0000\u0000\u1f87\u1f8f\u0000\u0000\u1f90\u1f98\u0000\u0000\u1f91\u1f99\u0000\u0000\u1f92\u1f9a\u0000\u0000\u1f93\u1f9b\u0000\u0000\u1f94\u1f9c\u0000\u0000\u1f95\u1f9d\u0000\u0000\u1f96\u1f9e\u0000\u0000\u1f97\u1f9f\u0000\u0000\u1fa0\u1fa8\u0000\u0000\u1fa1\u1fa9\u0000\u0000\u1fa2\u1faa\u0000\u0000\u1fa3\u1fab\u0000\u0000\u1fa4\u1fac\u0000\u0000\u1fa5\u1fad\u0000\u0000\u1fa6\u1fae\u0000\u0000\u1fa7\u1faf\u0000\u0000\u1fb0\u1fb8\u0000\u0000\u1fb1\u1fb9\u0000\u0000\u1fb3\u1fbc\u0000\u0000\u1fc3\u1fcc\u0000\u0000\u1fd0\u1fd8\u0000\u0000\u1fd1\u1fd9\u0000\u0000\u1fe0\u1fe8\u0000\u0000\u1fe1\u1fe9\u0000\u0000\u1fe5\u1fec\u0000\u0000\u1ff3\u1ffc\u0000\u0000\u2132\u214e\u0000\u0000\u2160\u2170\u0000\u0000\u2161\u2171\u0000\u0000\u2162\u2172\u0000\u0000\u2163\u2173\u0000\u0000\u2164\u2174\u0000\u0000\u2165\u2175\u0000\u0000\u2166\u2176\u0000\u0000\u2167\u2177\u0000\u0000\u2168\u2178\u0000\u0000\u2169\u2179\u0000\u0000\u216a\u217a\u0000\u0000\u216b\u217b\u0000\u0000\u216c\u217c\u0000\u0000\u216d\u217d\u0000\u0000\u216e\u217e\u0000\u0000\u216f\u217f\u0000\u0000\u2183\u2184\u0000\u0000\u24b6\u24d0\u0000\u0000\u24b7\u24d1\u0000\u0000\u24b8\u24d2\u0000\u0000\u24b9\u24d3\u0000\u0000\u24ba\u24d4\u0000\u0000\u24bb\u24d5\u0000\u0000\u24bc\u24d6\u0000\u0000\u24bd\u24d7\u0000\u0000\u24be\u24d8\u0000\u0000\u24bf\u24d9\u0000\u0000\u24c0\u24da\u0000\u0000\u24c1\u24db\u0000\u0000\u24c2\u24dc\u0000\u0000\u24c3\u24dd\u0000\u0000\u24c4\u24de\u0000\u0000\u24c5\u24df\u0000\u0000\u24c6\u24e0\u0000\u0000\u24c7\u24e1\u0000\u0000\u24c8\u24e2\u0000\u0000\u24c9\u24e3\u0000\u0000\u24ca\u24e4\u0000\u0000\u24cb\u24e5\u0000\u0000\u24cc\u24e6\u0000\u0000\u24cd\u24e7\u0000\u0000\u24ce\u24e8\u0000\u0000\u24cf\u24e9\u0000\u0000\u2c00\u2c30\u0000\u0000\u2c01\u2c31\u0000\u0000\u2c02\u2c32\u0000\u0000\u2c03\u2c33\u0000\u0000\u2c04\u2c34\u0000\u0000\u2c05\u2c35\u0000\u0000\u2c06\u2c36\u0000\u0000\u2c07\u2c37\u0000\u0000\u2c08\u2c38\u0000\u0000\u2c09\u2c39\u0000\u0000\u2c0a\u2c3a\u0000\u0000\u2c0b\u2c3b\u0000\u0000\u2c0c\u2c3c\u0000\u0000\u2c0d\u2c3d\u0000\u0000\u2c0e\u2c3e\u0000\u0000\u2c0f\u2c3f\u0000\u0000\u2c10\u2c40\u0000\u0000\u2c11\u2c41\u0000\u0000\u2c12\u2c42\u0000\u0000\u2c13\u2c43\u0000\u0000\u2c14\u2c44\u0000\u0000\u2c15\u2c45\u0000\u0000\u2c16\u2c46\u0000\u0000\u2c17\u2c47\u0000\u0000\u2c18\u2c48\u0000\u0000\u2c19\u2c49\u0000\u0000\u2c1a\u2c4a\u0000\u0000\u2c1b\u2c4b\u0000\u0000\u2c1c\u2c4c\u0000\u0000\u2c1d\u2c4d\u0000\u0000\u2c1e\u2c4e\u0000\u0000\u2c1f\u2c4f\u0000\u0000\u2c20\u2c50\u0000\u0000\u2c21\u2c51\u0000\u0000\u2c22\u2c52\u0000\u0000\u2c23\u2c53\u0000\u0000\u2c24\u2c54\u0000\u0000\u2c25\u2c55\u0000\u0000\u2c26\u2c56\u0000\u0000\u2c27\u2c57\u0000\u0000\u2c28\u2c58\u0000\u0000\u2c29\u2c59\u0000\u0000\u2c2a\u2c5a\u0000\u0000\u2c2b\u2c5b\u0000\u0000\u2c2c\u2c5c\u0000\u0000\u2c2d\u2c5d\u0000\u0000\u2c2e\u2c5e\u0000\u0000\u2c60\u2c61\u0000\u0000\u2c67\u2c68\u0000\u0000\u2c69\u2c6a\u0000\u0000\u2c6b\u2c6c\u0000\u0000\u2c72\u2c73\u0000\u0000\u2c75\u2c76\u0000\u0000\u2c80\u2c81\u0000\u0000\u2c82\u2c83\u0000\u0000\u2c84\u2c85\u0000\u0000\u2c86\u2c87\u0000\u0000\u2c88\u2c89\u0000\u0000\u2c8a\u2c8b\u0000\u0000\u2c8c\u2c8d\u0000\u0000\u2c8e\u2c8f\u0000\u0000\u2c90\u2c91\u0000\u0000\u2c92\u2c93\u0000\u0000\u2c94\u2c95\u0000\u0000\u2c96\u2c97\u0000\u0000\u2c98\u2c99\u0000\u0000\u2c9a\u2c9b\u0000\u0000\u2c9c\u2c9d\u0000\u0000\u2c9e\u2c9f\u0000\u0000\u2ca0\u2ca1\u0000\u0000\u2ca2\u2ca3\u0000\u0000\u2ca4\u2ca5\u0000\u0000\u2ca6\u2ca7\u0000\u0000\u2ca8\u2ca9\u0000\u0000\u2caa\u2cab\u0000\u0000\u2cac\u2cad\u0000\u0000\u2cae\u2caf\u0000\u0000\u2cb0\u2cb1\u0000\u0000\u2cb2\u2cb3\u0000\u0000\u2cb4\u2cb5\u0000\u0000\u2cb6\u2cb7\u0000\u0000\u2cb8\u2cb9\u0000\u0000\u2cba\u2cbb\u0000\u0000\u2cbc\u2cbd\u0000\u0000\u2cbe\u2cbf\u0000\u0000\u2cc0\u2cc1\u0000\u0000\u2cc2\u2cc3\u0000\u0000\u2cc4\u2cc5\u0000\u0000\u2cc6\u2cc7\u0000\u0000\u2cc8\u2cc9\u0000\u0000\u2cca\u2ccb\u0000\u0000\u2ccc\u2ccd\u0000\u0000\u2cce\u2ccf\u0000\u0000\u2cd0\u2cd1\u0000\u0000\u2cd2\u2cd3\u0000\u0000\u2cd4\u2cd5\u0000\u0000\u2cd6\u2cd7\u0000\u0000\u2cd8\u2cd9\u0000\u0000\u2cda\u2cdb\u0000\u0000\u2cdc\u2cdd\u0000\u0000\u2cde\u2cdf\u0000\u0000\u2ce0\u2ce1\u0000\u0000\u2ce2\u2ce3\u0000\u0000\u2ceb\u2cec\u0000\u0000\u2ced\u2cee\u0000\u0000\u2cf2\u2cf3\u0000\u0000\ua640\ua641\u0000\u0000\ua642\ua643\u0000\u0000\ua644\ua645\u0000\u0000\ua646\ua647\u0000\u0000\ua648\ua649\u0000\u0000\ua64a\ua64b\u0000\u0000\ua64c\ua64d\u0000\u0000\ua64e\ua64f\u0000\u0000\ua650\ua651\u0000\u0000\ua652\ua653\u0000\u0000\ua654\ua655\u0000\u0000\ua656\ua657\u0000\u0000\ua658\ua659\u0000\u0000\ua65a\ua65b\u0000\u0000\ua65c\ua65d\u0000\u0000\ua65e\ua65f\u0000\u0000\ua660\ua661\u0000\u0000\ua662\ua663\u0000\u0000\ua664\ua665\u0000\u0000\ua666\ua667\u0000\u0000\ua668\ua669\u0000\u0000\ua66a\ua66b\u0000\u0000\ua66c\ua66d\u0000\u0000\ua680\ua681\u0000\u0000\ua682\ua683\u0000\u0000\ua684\ua685\u0000\u0000\ua686\ua687\u0000\u0000\ua688\ua689\u0000\u0000\ua68a\ua68b\u0000\u0000\ua68c\ua68d\u0000\u0000\ua68e\ua68f\u0000\u0000\ua690\ua691\u0000\u0000\ua692\ua693\u0000\u0000\ua694\ua695\u0000\u0000\ua696\ua697\u0000\u0000\ua698\ua699\u0000\u0000\ua69a\ua69b\u0000\u0000\ua722\ua723\u0000\u0000\ua724\ua725\u0000\u0000\ua726\ua727\u0000\u0000\ua728\ua729\u0000\u0000\ua72a\ua72b\u0000\u0000\ua72c\ua72d\u0000\u0000\ua72e\ua72f\u0000\u0000\ua732\ua733\u0000\u0000\ua734\ua735\u0000\u0000\ua736\ua737\u0000\u0000\ua738\ua739\u0000\u0000\ua73a\ua73b\u0000\u0000\ua73c\ua73d\u0000\u0000\ua73e\ua73f\u0000\u0000\ua740\ua741\u0000\u0000\ua742\ua743\u0000\u0000\ua744\ua745\u0000\u0000\ua746\ua747\u0000\u0000\ua748\ua749\u0000\u0000\ua74a\ua74b\u0000\u0000\ua74c\ua74d\u0000\u0000\ua74e\ua74f\u0000\u0000\ua750\ua751\u0000\u0000\ua752\ua753\u0000\u0000\ua754\ua755\u0000\u0000\ua756\ua757\u0000\u0000\ua758\ua759\u0000\u0000\ua75a\ua75b\u0000\u0000\ua75c\ua75d\u0000\u0000\ua75e\ua75f\u0000\u0000\ua760\ua761\u0000\u0000\ua762\ua763\u0000\u0000\ua764\ua765\u0000\u0000\ua766\ua767\u0000\u0000\ua768\ua769\u0000\u0000\ua76a\ua76b\u0000\u0000\ua76c\ua76d\u0000\u0000\ua76e\ua76f\u0000\u0000\ua779\ua77a\u0000\u0000\ua77b\ua77c\u0000\u0000\ua77e\ua77f\u0000\u0000\ua780\ua781\u0000\u0000\ua782\ua783\u0000\u0000\ua784\ua785\u0000\u0000\ua786\ua787\u0000\u0000\ua78b\ua78c\u0000\u0000\ua790\ua791\u0000\u0000\ua792\ua793\u0000\u0000\ua796\ua797\u0000\u0000\ua798\ua799\u0000\u0000\ua79a\ua79b\u0000\u0000\ua79c\ua79d\u0000\u0000\ua79e\ua79f\u0000\u0000\ua7a0\ua7a1\u0000\u0000\ua7a2\ua7a3\u0000\u0000\ua7a4\ua7a5\u0000\u0000\ua7a6\ua7a7\u0000\u0000\ua7a8\ua7a9\u0000\u0000\uff21\uff41\u0000\u0000\uff22\uff42\u0000\u0000\uff23\uff43\u0000\u0000\uff24\uff44\u0000\u0000\uff25\uff45\u0000\u0000\uff26\uff46\u0000\u0000\uff27\uff47\u0000\u0000\uff28\uff48\u0000\u0000\uff29\uff49\u0000\u0000\uff2a\uff4a\u0000\u0000\uff2b\uff4b\u0000\u0000\uff2c\uff4c\u0000\u0000\uff2d\uff4d\u0000\u0000\uff2e\uff4e\u0000\u0000\uff2f\uff4f\u0000\u0000\uff30\uff50\u0000\u0000\uff31\uff51\u0000\u0000\uff32\uff52\u0000\u0000\uff33\uff53\u0000\u0000\uff34\uff54\u0000\u0000\uff35\uff55\u0000\u0000\uff36\uff56\u0000\u0000\uff37\uff57\u0000\u0000\uff38\uff58\u0000\u0000\uff39\uff59\u0000\u0000\uff3a\uff5a\u0000\u0000\ud801\udc00\ud801\udc28\u0000\u0000\ud801\udc01\ud801\udc29\u0000\u0000\ud801\udc02\ud801\udc2a\u0000\u0000\ud801\udc03\ud801\udc2b\u0000\u0000\ud801\udc04\ud801\udc2c\u0000\u0000\ud801\udc05\ud801\udc2d\u0000\u0000\ud801\udc06\ud801\udc2e\u0000\u0000\ud801\udc07\ud801\udc2f\u0000\u0000\ud801\udc08\ud801\udc30\u0000\u0000\ud801\udc09\ud801\udc31\u0000\u0000\ud801\udc0a\ud801\udc32\u0000\u0000\ud801\udc0b\ud801\udc33\u0000\u0000\ud801\udc0c\ud801\udc34\u0000\u0000\ud801\udc0d\ud801\udc35\u0000\u0000\ud801\udc0e\ud801\udc36\u0000\u0000\ud801\udc0f\ud801\udc37\u0000\u0000\ud801\udc10\ud801\udc38\u0000\u0000\ud801\udc11\ud801\udc39\u0000\u0000\ud801\udc12\ud801\udc3a\u0000\u0000\ud801\udc13\ud801\udc3b\u0000\u0000\ud801\udc14\ud801\udc3c\u0000\u0000\ud801\udc15\ud801\udc3d\u0000\u0000\ud801\udc16\ud801\udc3e\u0000\u0000\ud801\udc17\ud801\udc3f\u0000\u0000\ud801\udc18\ud801\udc40\u0000\u0000\ud801\udc19\ud801\udc41\u0000\u0000\ud801\udc1a\ud801\udc42\u0000\u0000\ud801\udc1b\ud801\udc43\u0000\u0000\ud801\udc1c\ud801\udc44\u0000\u0000\ud801\udc1d\ud801\udc45\u0000\u0000\ud801\udc1e\ud801\udc46\u0000\u0000\ud801\udc1f\ud801\udc47\u0000\u0000\ud801\udc20\ud801\udc48\u0000\u0000\ud801\udc21\ud801\udc49\u0000\u0000\ud801\udc22\ud801\udc4a\u0000\u0000\ud801\udc23\ud801\udc4b\u0000\u0000\ud801\udc24\ud801\udc4c\u0000\u0000\ud801\udc25\ud801\udc4d\u0000\u0000\ud801\udc26\ud801\udc4e\u0000\u0000\ud801\udc27\ud801\udc4f\u0000\u0000\ud806\udca0\ud806\udcc0\u0000\u0000\ud806\udca1\ud806\udcc1\u0000\u0000\ud806\udca2\ud806\udcc2\u0000\u0000\ud806\udca3\ud806\udcc3\u0000\u0000\ud806\udca4\ud806\udcc4\u0000\u0000\ud806\udca5\ud806\udcc5\u0000\u0000\ud806\udca6\ud806\udcc6\u0000\u0000\ud806\udca7\ud806\udcc7\u0000\u0000\ud806\udca8\ud806\udcc8\u0000\u0000\ud806\udca9\ud806\udcc9\u0000\u0000\ud806\udcaa\ud806\udcca\u0000\u0000\ud806\udcab\ud806\udccb\u0000\u0000\ud806\udcac\ud806\udccc\u0000\u0000\ud806\udcad\ud806\udccd\u0000\u0000\ud806\udcae\ud806\udcce\u0000\u0000\ud806\udcaf\ud806\udccf\u0000\u0000\ud806\udcb0\ud806\udcd0\u0000\u0000\ud806\udcb1\ud806\udcd1\u0000\u0000\ud806\udcb2\ud806\udcd2\u0000\u0000\ud806\udcb3\ud806\udcd3\u0000\u0000\ud806\udcb4\ud806\udcd4\u0000\u0000\ud806\udcb5\ud806\udcd5\u0000\u0000\ud806\udcb6\ud806\udcd6\u0000\u0000\ud806\udcb7\ud806\udcd7\u0000\u0000\ud806\udcb8\ud806\udcd8\u0000\u0000\ud806\udcb9\ud806\udcd9\u0000\u0000\ud806\udcba\ud806\udcda\u0000\u0000\ud806\udcbb\ud806\udcdb\u0000\u0000\ud806\udcbc\ud806\udcdc\u0000\u0000\ud806\udcbd\ud806\udcdd\u0000\u0000\ud806\udcbe\ud806\udcde\u0000\u0000\ud806\udcbf\ud806\udcdf\u0000\u0000", 4);
        } else {
            throw new UnsupportedUnicodeVersionException();
        }
    }

    private void bind(String[] propertyValues, String[] intervals, String[] propertyValueAliases, int maximumCodePoint, String caselessMatchPartitions, int caselessMatchPartitionSize) {
        int n;
        this.caselessMatchPartitions = caselessMatchPartitions;
        this.caselessMatchPartitionSize = caselessMatchPartitionSize;
        this.maximumCodePoint = maximumCodePoint;
        for (n = 0; n < propertyValues.length; ++n) {
            int end;
            String propertyValue = propertyValues[n];
            String propertyIntervals = intervals[n];
            IntCharSet set = new IntCharSet();
            for (int index = 0; index < propertyIntervals.length(); index += Character.charCount(end)) {
                int start = propertyIntervals.codePointAt(index);
                end = propertyIntervals.codePointAt(index += Character.charCount(start));
                set.add(new Interval(start, end));
            }
            this.propertyValueIntervals.put(propertyValue, set);
            if (2 != propertyValue.length()) continue;
            String singleLetter = propertyValue.substring(0, 1);
            IntCharSet singleLetterPropValueSet = this.propertyValueIntervals.get(singleLetter);
            if (null == singleLetterPropValueSet) {
                singleLetterPropValueSet = new IntCharSet();
                this.propertyValueIntervals.put(singleLetter, singleLetterPropValueSet);
            }
            singleLetterPropValueSet.add(set);
        }
        for (n = 0; n < propertyValueAliases.length; n += 2) {
            String alias = propertyValueAliases[n];
            String propertyValue = propertyValueAliases[n + 1];
            IntCharSet targetSet = this.propertyValueIntervals.get(propertyValue);
            if (null == targetSet) continue;
            this.propertyValueIntervals.put(alias, targetSet);
        }
        this.bindInvariantIntervals();
    }

    private void bindInvariantIntervals() {
        IntCharSet asciiSet = new IntCharSet(new Interval(0, 127));
        this.propertyValueIntervals.put(this.normalize("ASCII"), asciiSet);
        IntCharSet anySet = new IntCharSet(new Interval(0, this.maximumCodePoint));
        this.propertyValueIntervals.put(this.normalize("Any"), anySet);
    }

    private String normalize(String identifier) {
        if (null == identifier) {
            return identifier;
        }
        Matcher matcher = WORD_SEP_PATTERN.matcher(identifier.toLowerCase(Locale.ENGLISH));
        return matcher.replaceAll("").replace(':', '=');
    }

    public static class UnsupportedUnicodeVersionException
    extends Exception {
        private static final long serialVersionUID = -1718158223161422981L;

        public UnsupportedUnicodeVersionException() {
            super("Supported versions: 1.1, 1.1.5, 2, 2.0, 2.0.14, 2.1, 2.1.9, 3, 3.0, 3.0.1, 3.1, 3.1.0, 3.2, 3.2.0, 4, 4.0, 4.0.1, 4.1, 4.1.0, 5, 5.0, 5.0.0, 5.1, 5.1.0, 5.2, 5.2.0, 6, 6.0, 6.0.0, 6.1, 6.1.0, 6.2, 6.2.0, 6.3, 6.3.0, 7, 7.0, 7.0.0");
        }
    }
}

