/**
 * @file libcomprex/types.h Type definitions.
 * 
 * $Id: types.h,v 1.10 2003/01/01 06:22:36 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LIBCOMPREX_TYPES_H_
#define _LIBCOMPREX_TYPES_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * A status result.
 */
typedef enum
{
	CX_SUCCESS,          /**< Operation completed successfully.            */
	CX_NOT_SUPPORTED,    /**< The feature is not supported in that module. */
	CX_INVALID_FORMAT,   /**< Invalid file format.                         */
	CX_ERROR,            /**< Fatal error.                                 */
	CX_FILE_NOT_FOUND,   /**< File not found.                              */
	CX_READ_ONLY,        /**< The file is read-only.                       */
	CX_INVALID_VERSION,  /**< Invalid or unsupported archive version.      */
	CX_EOF,              /**< End of file.                                 */
	CX_CORRUPT           /**< Corruption.                                  */

} CxStatus;

/**
 * The access mode used when opening a file or archive.
 */
typedef enum
{
	/** Don't handle compression/decompression with the file. */
	CX_MODE_RAW        = 0x01,
	
	/** Allows reading and writing to files. */
	CX_MODE_READ_WRITE = 0x02,

	/** Allows reading, but not writing, of files. */
	CX_MODE_READ_ONLY  = 0x04,

	/** An error has occurred. Most likely, the specified file is NULL. */
	CX_MODE_ERROR      = 0xFF

} CxAccessMode;

/**
 * An archive type.
 */
typedef enum
{
	CX_ARCHIVE_SINGLE,  /**< Single-file archives.                    */
	CX_ARCHIVE_MULTI,   /**< Multi-file archives.                     */
	CX_ARCHIVE_UNKNOWN  /**< Unknown archive type (usually an error). */

} CxArchiveType;

/**
 * @name Access mode macros
 */
/*@{*/
#define CX_IS_MODE_RAW(mode) \
	(((mode) & CX_MODE_RAW) == CX_MODE_RAW)

#define CX_IS_MODE_READ_WRITE(mode) \
	(((mode) & CX_MODE_READ_WRITE) == CX_MODE_READ_WRITE)

#define CX_IS_MODE_READ_ONLY(mode) \
	(((mode) & CX_MODE_READ_ONLY) == CX_MODE_READ_ONLY)

/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* _LIBCOMPREX_TYPES_H_ */

