/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.core.scanner.AbstractAppParamPlugin;
import org.parosproxy.paros.network.HttpMessage;

public class TestInjectionCRLF
extends AbstractAppParamPlugin {
    private static Random staticRandomGenerator = new Random();
    private String randomString = "Tamper=" + Long.toString(Math.abs(staticRandomGenerator.nextLong()));
    private String cookieTamper1 = "Set-cookie: " + this.randomString;
    private String cookieTamper2a = "any\r\nSet-cookie: " + this.randomString;
    private String cookieTamper2b = "any?\r\nSet-cookie: " + this.randomString;
    private String cookieTamper3a = "any\nSet-cookie: " + this.randomString;
    private String cookieTamper3b = "any?\nSet-cookie: " + this.randomString;
    private String cookieTamper4a = "any\r\nSet-cookie: " + this.randomString + "\r\n";
    private String cookieTamper4b = "any?\r\nSet-cookie: " + this.randomString + "\r\n";
    private String[] PARAM_LIST = new String[]{this.cookieTamper1, this.cookieTamper2a, this.cookieTamper2b, this.cookieTamper3a, this.cookieTamper3b, this.cookieTamper4a, this.cookieTamper4b};
    private Pattern patternCookieTamper = Pattern.compile("\\nSet-cookie: " + this.randomString, 10);

    public int getId() {
        return 40001;
    }

    public String getName() {
        return "CRLF injection";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        String string = "Cookie can be set via CRLF injection.  It may also be possible to set arbitrary HTTP response header.\r\nIn addition, by carefully crafting the injected response using cross-site script, cache poisiong vulnerability may also exist.";
        return string;
    }

    public int getCategory() {
        return 4;
    }

    public String getSolution() {
        return "Type check the submitted parameter carefully.  Do not allow CRLF to be injected by filtering CRLF.";
    }

    public String getReference() {
        String string = "<ul><li>http://www.watchfire.com/resources/HTTPResponseSplitting.pdf</li><li>http://webappfirewall.com/lib/crlf-injection.txtnull</li><li>http://www.securityfocus.com/bid/9804</li></ul>";
        return string;
    }

    public void init() {
    }

    public void scan(HttpMessage httpMessage, String string, String string2) {
        String string3 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        for (int i = 0; i < this.PARAM_LIST.length; ++i) {
            httpMessage = this.getNewMsg();
            string3 = this.setParameter(httpMessage, string, this.PARAM_LIST[i]);
            try {
                this.sendAndReceive(httpMessage, false);
                if (!this.checkResult(httpMessage, string3)) continue;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean checkResult(HttpMessage httpMessage, String string) {
        Matcher matcher = this.patternCookieTamper.matcher(httpMessage.getResponseHeader().toString());
        if (matcher.find()) {
            this.bingo(2, 1, null, string, "", httpMessage);
            return true;
        }
        return false;
    }
}

