/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.bean;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wiztools.restclient.bean.AuthorizationHeaderAuthBean;
import org.wiztools.restclient.bean.OAuth2BearerAuth;

public class OAuth2BearerAuthBean
extends AuthorizationHeaderAuthBean
implements OAuth2BearerAuth {
    private static final Pattern p = Pattern.compile("Bearer\\s(.*)");

    public void setOAuth2BearerToken(String token) {
        this.setAuthorizationHeaderValue("Bearer " + token);
    }

    @Override
    public String getOAuth2BearerToken() {
        String fullHeader = this.getAuthorizationHeaderValue();
        Matcher m3 = p.matcher(fullHeader);
        if (m3.matches()) {
            return m3.group(1);
        }
        throw new IllegalStateException("OAuth2 Header does not match pattern: " + p);
    }
}

