/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import java.util.Enumeration;
import org.w3c.dom.Element;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.ListStyleConverter;
import writer2latex.latex.style.StyleConverter;
import writer2latex.office.MasterPage;
import writer2latex.office.PageMaster;
import writer2latex.office.ParStyle;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class PageStyleConverter
extends StyleConverter {
    private String sMainMasterPage = null;
    private String sChapterField1 = null;
    private String sChapterField2 = null;

    public PageStyleConverter(WriterStyleCollection wsc, Config config, ConverterPalette palette) {
        super(wsc, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        MasterPage mpStyle;
        if (this.config.pageFormatting() == 4) {
            pack.append("\\usepackage{calc}").nl();
        }
        if (this.sMainMasterPage == null) {
            this.sMainMasterPage = this.wsc.getFirstMasterPageName();
            if (this.sMainMasterPage != null) {
                this.styleNames.addName(this.sMainMasterPage);
            }
        }
        String sMainPageMaster = null;
        if (this.sMainMasterPage != null && (mpStyle = this.wsc.getMasterPage(this.sMainMasterPage)) != null) {
            sMainPageMaster = mpStyle.getProperty("style:page-master-name");
        }
        this.convertMasterPages(decl);
        BeforeAfter ba = new BeforeAfter();
        this.applyMasterPage(this.sMainMasterPage, ba);
        decl.append(ba.getBefore());
    }

    public void setChapterField1(String s) {
        this.sChapterField1 = s;
    }

    public void setChapterField2(String s) {
        this.sChapterField2 = s;
    }

    public void applyMasterPage(String sName, BeforeAfter ba) {
        if (this.config.pageFormatting() == 0) {
            return;
        }
        MasterPage style = this.wsc.getMasterPage(sName);
        if (style == null) {
            return;
        }
        String sNextName = style.getProperty("style:next-style-name");
        MasterPage nextStyle = this.wsc.getMasterPage(sNextName);
        if (style == nextStyle || nextStyle == null) {
            ba.add("\\pagestyle{" + this.styleNames.getExportName(sName) + "}\n", "");
        } else {
            ba.add("\\pagestyle{" + this.styleNames.getExportName(sNextName) + "}\n" + "\\thispagestyle{" + this.styleNames.getExportName(sName) + "}\n", "");
        }
    }

    public void collectMasterPage(ParStyle style) {
        if (style == null || this.sMainMasterPage != null) {
            return;
        }
        String s = style.getMasterPageName();
        if (s != null && s.length() != 0) {
            this.sMainMasterPage = s;
        }
    }

    private void convertMasterPages(LaTeXDocumentPortion ldp) {
        if (this.config.pageFormatting() == 0) {
            return;
        }
        Context context = new Context();
        context.resetFormattingFromStyle(this.wsc.getDefaultParStyle());
        context.setInHeaderFooter(true);
        Enumeration styles = this.wsc.getMasterPages().getStylesEnumeration();
        ldp.append("% Pages styles (master pages)").nl().append("\\makeatletter").nl();
        while (styles.hasMoreElements()) {
            MasterPage style = (MasterPage)styles.nextElement();
            String sName = style.getName();
            if (!this.styleNames.containsName(sName)) continue;
            ldp.append("\\newcommand\\ps@").append(this.styleNames.getExportName(sName)).append("{%").nl();
            this.sChapterField1 = null;
            this.sChapterField2 = null;
            ldp.append("\\renewcommand\\@oddhead{");
            if (style.getHeader() != null) {
                this.traverseHeaderFooter((Element)style.getHeader(), ldp, context);
            }
            ldp.append("}%").nl();
            ldp.append("\\renewcommand\\@evenhead{");
            if (style.getHeaderLeft() != null) {
                this.traverseHeaderFooter((Element)style.getHeaderLeft(), ldp, context);
            } else if (style.getHeader() != null) {
                ldp.append("\\@oddhead");
            }
            ldp.append("}%").nl();
            ldp.append("\\renewcommand\\@oddfoot{");
            if (style.getFooter() != null) {
                this.traverseHeaderFooter((Element)style.getFooter(), ldp, context);
            }
            ldp.append("}%").nl();
            ldp.append("\\renewcommand\\@evenfoot{");
            if (style.getFooterLeft() != null) {
                this.traverseHeaderFooter((Element)style.getFooterLeft(), ldp, context);
            } else if (style.getFooter() != null) {
                ldp.append("\\@oddfoot");
            }
            ldp.append("}%").nl();
            if (this.sChapterField1 != null) {
                ldp.append("\\def\\sectionmark##1{\\markboth{");
                if ("name".equals(this.sChapterField1)) {
                    ldp.append("##1");
                } else if ("number".equals(this.sChapterField1) || "plain-number".equals(this.sChapterField1)) {
                    ldp.append("\\thesection");
                } else {
                    ldp.append("\\thesection ##1");
                }
                ldp.append("}{}}").nl();
            }
            if (this.sChapterField2 != null) {
                if (this.sChapterField1 == null) {
                    ldp.append("\\def\\sectionmark##1{\\markboth{}{}}").nl();
                }
                ldp.append("\\def\\subsectionmark##1{\\markright{");
                if ("name".equals(this.sChapterField2)) {
                    ldp.append("##1");
                } else if ("number".equals(this.sChapterField2) || "plain-number".equals(this.sChapterField1)) {
                    ldp.append("\\thesubsection");
                } else {
                    ldp.append("\\thesubsection ##1");
                }
                ldp.append("}{}}").nl();
            }
            String sPageMaster = style.getProperty("style:page-master-name");
            this.convertPageMaster(sPageMaster, ldp);
            ldp.append("}").nl();
        }
        ldp.append("\\makeatother").nl();
    }

    private void traverseHeaderFooter(Element node, LaTeXDocumentPortion ldp, Context context) {
        Element par = Misc.getChildByTagName(node, "text:p");
        if (par == null) {
            return;
        }
        String sStyleName = par.getAttribute("text:style-name");
        BeforeAfter ba = new BeforeAfter();
        if (par.hasChildNodes()) {
            ldp.append(ba.getBefore());
            this.palette.getInlineCv().traverseInlineText(par, ldp, context, false);
            ldp.append(ba.getAfter());
        }
    }

    private void convertPageMaster(String sName, LaTeXDocumentPortion ldp) {
        String sWidth;
        String sHeight;
        String sAfter;
        String sBefore;
        String sPageNumber;
        if (this.config.pageFormatting() != 4) {
            return;
        }
        PageMaster style = this.wsc.getPageMaster(sName);
        if (style == null) {
            return;
        }
        String sHeadHeight = "0cm";
        String sHeadSep = "0cm";
        if (style.hasHeaderStyle()) {
            sHeadHeight = "12pt";
            sHeadSep = style.getHeaderProperty("fo:margin-bottom");
            if (sHeadSep == null) {
                sHeadSep = "0cm";
            }
        }
        String sFootHeight = "0cm";
        String sFootSep = "0cm";
        if (style.hasFooterStyle()) {
            sFootHeight = "12pt";
            sFootSep = style.getFooterProperty("fo:margin-top");
            if (sFootSep == null) {
                sFootSep = "0cm";
            }
        }
        ldp.append("\\setlength\\paperwidth{").append(style.getAbsoluteProperty("fo:page-width")).append("}").append("\\setlength\\paperheight{").append(style.getAbsoluteProperty("fo:page-height")).append("}");
        if (this.config.getBackend() == 2 && !this.config.useHyperref()) {
            ldp.append("\\setlength\\pdfpagewidth{").append(style.getAbsoluteProperty("fo:page-width")).append("}").append("\\setlength\\pdfpageheight{").append(style.getAbsoluteProperty("fo:page-height")).append("}");
        }
        ldp.append("\\setlength\\voffset{-1in}");
        ldp.append("\\setlength\\hoffset{-1in}");
        ldp.append("\\setlength\\topmargin{").append(style.getProperty("fo:margin-top")).append("}");
        ldp.append("\\setlength\\headheight{").append(sHeadHeight).append("}");
        ldp.append("\\setlength\\headsep{").append(sHeadSep).append("}");
        ldp.append("\\setlength\\footskip{").append(sFootHeight).append("+").append(sFootSep).append("}");
        ldp.append("\\setlength\\textheight{").append(style.getProperty("fo:page-height")).append("-").append(style.getProperty("fo:margin-top")).append("-").append(style.getProperty("fo:margin-bottom")).append("-").append(sHeadSep).append("-").append(sHeadHeight).append("-").append(sFootSep).append("-").append(sFootHeight).append("}");
        ldp.append("\\setlength\\oddsidemargin{").append(style.getProperty("fo:margin-left")).append("}");
        if ("mirrored".equals(style.getPageUsage())) {
            ldp.append("\\setlength\\evensidemargin{").append(style.getProperty("fo:margin-right")).append("}");
        }
        ldp.append("\\setlength\\textwidth{").append(style.getProperty("fo:page-width")).append("-").append(style.getProperty("fo:margin-left")).append("-").append(style.getProperty("fo:margin-right")).append("}").nl();
        String sNumFormat = style.getProperty("style:num-format");
        if (sNumFormat != null) {
            ldp.append("\\renewcommand\\thepage{").append(ListStyleConverter.numFormat(sNumFormat)).append("{page}}").nl();
        }
        if ((sPageNumber = style.getProperty("style:first-page-number")) != null && !sPageNumber.equals("continue")) {
            ldp.append("\\setcounter{page}{").append(Integer.toString(Misc.getPosInteger(sPageNumber, 0))).append("}").nl();
        }
        if ((sBefore = style.getFootnoteProperty("style:distance-before-sep")) == null) {
            sBefore = "1mm";
        }
        if ((sAfter = style.getFootnoteProperty("style:distance-after-sep")) == null) {
            sAfter = "1mm";
        }
        if ((sHeight = style.getFootnoteProperty("style:width")) == null) {
            sHeight = "0.2mm";
        }
        if ((sWidth = style.getFootnoteProperty("style:rel-width")) == null) {
            sWidth = "25%";
        }
        sWidth = Float.toString(Misc.getFloat(sWidth.substring(0, sWidth.length() - 1), 1.0f) / 100.0f);
        BeforeAfter baColor = new BeforeAfter();
        this.palette.getCharSc().applyThisColor(style.getFootnoteProperty("style:color"), false, baColor);
        ldp.append("\\setlength{\\skip\\footins}{").append(sBefore).append("}");
        ldp.append("\\renewcommand\\footnoterule{\\vspace*{-").append(sHeight).append("}\\noindent").append(baColor.getBefore()).append("\\rule{").append(sWidth).append("\\columnwidth}{").append(sHeight).append("}").append(baColor.getAfter()).append("\\vspace*{").append(sAfter).append("}}").nl();
    }
}

