/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.properties;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Properties;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.RandomUtils;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.properties.EncryptablePropertiesEncryptorRegistry;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.jasypt.util.text.TextEncryptor;

public class EncryptableProperties
extends Properties {
    private static final long serialVersionUID = 6479795856725500639L;
    private Integer ident = new Integer(RandomUtils.nextInt());
    private boolean beenSerialized = false;

    public EncryptableProperties(StringEncryptor stringEncryptor) {
        this(null, stringEncryptor);
    }

    public EncryptableProperties(TextEncryptor textEncryptor) {
        this(null, textEncryptor);
    }

    public EncryptableProperties(Properties defaults, StringEncryptor stringEncryptor) {
        super(defaults);
        Validate.notNull((Object)stringEncryptor, (String)"Encryptor cannot be null");
        EncryptablePropertiesEncryptorRegistry registry = EncryptablePropertiesEncryptorRegistry.getInstance();
        registry.setStringEncryptor(this, stringEncryptor);
    }

    public EncryptableProperties(Properties defaults, TextEncryptor textEncryptor) {
        super(defaults);
        Validate.notNull((Object)textEncryptor, (String)"Encryptor cannot be null");
        EncryptablePropertiesEncryptorRegistry registry = EncryptablePropertiesEncryptorRegistry.getInstance();
        registry.setTextEncryptor(this, textEncryptor);
    }

    public String getProperty(String key) {
        return this.decode(super.getProperty(key));
    }

    public String getProperty(String key, String defaultValue) {
        return this.decode(super.getProperty(key, defaultValue));
    }

    Integer getIdent() {
        return this.ident;
    }

    private synchronized String decode(String encodedValue) {
        if (!PropertyValueEncryptionUtils.isEncryptedValue(encodedValue)) {
            return encodedValue;
        }
        EncryptablePropertiesEncryptorRegistry registry = EncryptablePropertiesEncryptorRegistry.getInstance();
        StringEncryptor stringEncryptor = registry.getStringEncryptor(this);
        if (stringEncryptor != null) {
            return PropertyValueEncryptionUtils.decrypt(encodedValue, stringEncryptor);
        }
        TextEncryptor textEncryptor = registry.getTextEncryptor(this);
        if (textEncryptor != null) {
            return PropertyValueEncryptionUtils.decrypt(encodedValue, textEncryptor);
        }
        throw new EncryptionOperationNotPossibleException("Neither a string encryptor nor a text encryptor exist for this instance of EncryptableProperties. This is usually caused by the instance having been serialized and then de-serialized in a different classloader or virtual machine, which is an unsupported behaviour (as encryptors cannot be serialized themselves)");
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        this.beenSerialized = true;
        outputStream.defaultWriteObject();
    }

    protected void finalize() throws Throwable {
        if (!this.beenSerialized) {
            EncryptablePropertiesEncryptorRegistry registry = EncryptablePropertiesEncryptorRegistry.getInstance();
            registry.removeEntries(this);
        }
    }
}

