/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import org.apache.activemq.apollo.util.IOExceptionSupport;
import org.apache.activemq.apollo.util.os.CLibrary;
import org.apache.activemq.apollo.util.os.Kernel32Library;
import org.fusesource.hawtbuf.ByteArrayOutputStream;
import org.fusesource.hawtbuf.HexSupport;

public final class IOHelper {
    protected static final int MAX_DIR_NAME_LENGTH = Integer.valueOf(System.getProperty("MaximumDirNameLength", "200"));
    protected static final int MAX_FILE_NAME_LENGTH = Integer.valueOf(System.getProperty("MaximumFileNameLength", "64"));
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    static final SyncStrategy SYNC_STRATEGY = IOHelper.createSyncStrategy();
    static final HardLinkStrategy HARD_LINK_STRATEGY = IOHelper.createHardLinkStrategy();

    private IOHelper() {
    }

    public static String getDefaultDataDirectory() {
        return IOHelper.getDefaultDirectoryPrefix() + "activemq-data";
    }

    public static String getDefaultStoreDirectory() {
        return IOHelper.getDefaultDirectoryPrefix() + "amqstore";
    }

    public static String getDefaultDirectoryPrefix() {
        try {
            return System.getProperty("org.apache.activemq.default.directory.prefix", "");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String toFileSystemDirectorySafeName(String name) {
        return IOHelper.toFileSystemSafeName(name, true, MAX_DIR_NAME_LENGTH);
    }

    public static String toFileSystemSafeName(String name) {
        return IOHelper.toFileSystemSafeName(name, false, MAX_FILE_NAME_LENGTH);
    }

    public static String toFileSystemSafeName(String name, boolean dirSeparators, int maxFileLength) {
        int size = name.length();
        StringBuffer rc = new StringBuffer(size * 2);
        for (int i = 0; i < size; ++i) {
            char c = name.charAt(i);
            boolean valid = c >= 'a' && c <= 'z';
            valid = valid || c >= 'A' && c <= 'Z';
            valid = valid || c >= '0' && c <= '9';
            boolean bl = valid = valid || c == '_' || c == '-' || c == '.' || c == '#' || dirSeparators && (c == '/' || c == '\\');
            if (valid) {
                rc.append(c);
                continue;
            }
            rc.append('#');
            rc.append(HexSupport.toHexFromInt((int)c, (boolean)true));
        }
        String result = rc.toString();
        if (result.length() > maxFileLength) {
            result = result.substring(result.length() - maxFileLength, result.length());
        }
        return result;
    }

    public static boolean deleteFile(File fileToDelete) {
        if (fileToDelete == null || !fileToDelete.exists()) {
            return true;
        }
        boolean result = IOHelper.deleteChildren(fileToDelete);
        return result &= fileToDelete.delete();
    }

    public static boolean deleteChildren(File parent) {
        if (parent == null || !parent.exists()) {
            return false;
        }
        boolean result = true;
        if (parent.isDirectory()) {
            File[] files = parent.listFiles();
            if (files == null) {
                result = false;
            } else {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    if (file.isDirectory()) {
                        result &= IOHelper.deleteFile(file);
                        continue;
                    }
                    result &= file.delete();
                }
            }
        }
        return result;
    }

    public static void moveFile(File src, File targetDirectory) throws IOException {
        if (!src.renameTo(new File(targetDirectory, src.getName()))) {
            throw new IOException("Failed to move " + src + " to " + targetDirectory);
        }
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream fileSrc = new FileInputStream(src);
        FileOutputStream fileDest = new FileOutputStream(dest);
        IOHelper.copyInputStream(fileSrc, fileDest);
    }

    public static String readText(File path) throws IOException {
        return IOHelper.readText(path, "UTF-8");
    }

    public static String readText(File path, String encoding) throws IOException {
        return IOHelper.readText(new FileInputStream(path), encoding);
    }

    public static String readText(InputStream in) throws IOException {
        return IOHelper.readText(in, "UTF-8");
    }

    public static String readText(InputStream in, String encoding) throws IOException {
        return new String(IOHelper.readBytes(in), encoding);
    }

    public static byte[] readBytes(File path) throws IOException {
        return IOHelper.readBytes(new FileInputStream(path));
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOHelper.copyInputStream(in, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static void writeText(File path, String text) throws IOException {
        IOHelper.writeText(path, text, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeText(File path, String text, String encoding) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(path), encoding);
        try {
            out.write(text);
        }
        finally {
            IOHelper.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBinaryFile(File path, byte[] contents) throws IOException {
        FileOutputStream out = new FileOutputStream(path);
        try {
            out.write(contents);
        }
        finally {
            IOHelper.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        try {
            byte[] buffer = new byte[4096];
            int len = in.read(buffer);
            while (len >= 0) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
        }
        finally {
            IOHelper.close(in);
            IOHelper.close(out);
        }
    }

    public static void close(Writer out) {
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void mkdirs(File dir) throws IOException {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException("Failed to create directory '" + dir + "', regular file already existed with that name");
            }
        } else if (!dir.mkdirs()) {
            throw new IOException("Failed to create directory '" + dir + "'");
        }
    }

    public static void sync(FileDescriptor fd) throws IOException {
        SYNC_STRATEGY.sync(fd);
    }

    private static SyncStrategy createSyncStrategy() {
        String os = System.getProperty("os.name");
        if ("Mac OS X".equals(os)) {
            try {
                final Field field = FileDescriptor.class.getDeclaredField("fd");
                field.setAccessible(true);
                final CLibrary lib = IOHelper.getCLibrary();
                return new SyncStrategy(){
                    static final int F_FULLFSYNC = 51;

                    public void sync(FileDescriptor fd) throws IOException {
                        try {
                            int id = field.getInt(fd);
                            lib.fcntl(id, 51, new Object[0]);
                        }
                        catch (Exception e) {
                            throw IOExceptionSupport.create(e);
                        }
                    }

                    public void hardlink(File source, File target) throws IOException {
                        int rc = lib.link(source.getCanonicalPath(), target.getCanonicalPath());
                        if (rc != 0) {
                            throw new IOException("Hard link failed with result code=" + rc);
                        }
                    }
                };
            }
            catch (Throwable ignore) {}
        } else if (os.toLowerCase().startsWith("windows")) {
            try {
                final Kernel32Library lib = IOHelper.getKernel32Library();
                return new SyncStrategy(){

                    public void sync(FileDescriptor fd) throws IOException {
                        fd.sync();
                    }

                    public void hardlink(File source, File target) throws IOException {
                        int rc = lib.CreateHardLink(target.getCanonicalPath(), source.getCanonicalPath(), 0L);
                        if (rc == 0) {
                            throw new IOException("Hard link failed with result code=" + lib.GetLastError());
                        }
                    }
                };
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        try {
            final CLibrary lib = IOHelper.getCLibrary();
            return new SyncStrategy(){

                public void sync(FileDescriptor fd) throws IOException {
                    fd.sync();
                }

                public void hardlink(File source, File target) throws IOException {
                    int rc = lib.link(source.getCanonicalPath(), target.getCanonicalPath());
                    if (rc != 0) {
                        throw new IOException("Hard link failed with result code=" + rc);
                    }
                }
            };
        }
        catch (Throwable throwable) {
            return new SyncStrategy(){

                public void sync(FileDescriptor fd) throws IOException {
                    fd.sync();
                }

                public void hardlink(File source, File target) throws IOException {
                }
            };
        }
    }

    public static void hardlink(File source, File target) throws IOException {
        if (HARD_LINK_STRATEGY == null) {
            throw new UnsupportedOperationException();
        }
        HARD_LINK_STRATEGY.hardlink(source, target);
    }

    private static HardLinkStrategy createHardLinkStrategy() {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().startsWith("windows")) {
            try {
                final Kernel32Library lib = IOHelper.getKernel32Library();
                return new HardLinkStrategy(){

                    public void hardlink(File source, File target) throws IOException {
                        int rc = lib.CreateHardLink(target.getCanonicalPath(), source.getCanonicalPath(), 0L);
                        if (rc == 0) {
                            throw new IOException("Hard link failed with result code=" + lib.GetLastError());
                        }
                    }
                };
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        try {
            final CLibrary lib = IOHelper.getCLibrary();
            return new HardLinkStrategy(){

                public void hardlink(File source, File target) throws IOException {
                    int rc = lib.link(source.getCanonicalPath(), target.getCanonicalPath());
                    if (rc != 0) {
                        throw new IOException("Hard link failed with result code=" + rc);
                    }
                }
            };
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static CLibrary getCLibrary() throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
        Class<?> clazz = IOHelper.class.getClassLoader().loadClass("org.apache.activemq.apollo..util.os.JnaCLibrary");
        CLibrary lib = (CLibrary)clazz.getField("INSTANCE").get(null);
        return lib;
    }

    public static Kernel32Library getKernel32Library() throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
        Class<?> clazz = IOHelper.class.getClassLoader().loadClass("org.apache.activemq.apollo.util.os.Kernel32JnaLibrary");
        Kernel32Library lib = (Kernel32Library)clazz.getField("INSTANCE").get(null);
        return lib;
    }

    public static interface HardLinkStrategy {
        public void hardlink(File var1, File var2) throws IOException;
    }

    public static interface SyncStrategy {
        public void sync(FileDescriptor var1) throws IOException;
    }
}

