/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockableFactory;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.DockingStrategy;
import org.flexdock.docking.DockingStub;
import org.flexdock.docking.activation.ActiveDockableListener;
import org.flexdock.docking.adapter.AdapterFactory;
import org.flexdock.docking.adapter.DockingAdapter;
import org.flexdock.docking.defaults.DefaultDockingStrategy;
import org.flexdock.docking.defaults.DockableComponentWrapper;
import org.flexdock.docking.drag.DragManager;
import org.flexdock.docking.drag.effects.DragPreview;
import org.flexdock.docking.drag.effects.EffectsManager;
import org.flexdock.docking.drag.effects.RubberBand;
import org.flexdock.docking.event.DockingEventHandler;
import org.flexdock.docking.event.hierarchy.DockingPortTracker;
import org.flexdock.docking.event.hierarchy.RootDockingPortInfo;
import org.flexdock.docking.floating.policy.FloatPolicyManager;
import org.flexdock.docking.props.DockablePropertySet;
import org.flexdock.docking.props.PropertyManager;
import org.flexdock.docking.state.DockingState;
import org.flexdock.docking.state.FloatManager;
import org.flexdock.docking.state.LayoutManager;
import org.flexdock.docking.state.MinimizationManager;
import org.flexdock.docking.state.PersistenceException;
import org.flexdock.event.EventManager;
import org.flexdock.event.RegistrationEvent;
import org.flexdock.util.ClassMapping;
import org.flexdock.util.DockingUtility;
import org.flexdock.util.ResourceManager;
import org.flexdock.util.RootWindow;
import org.flexdock.util.SwingUtility;
import org.flexdock.util.Utilities;

public class DockingManager
implements DockingConstants {
    private static Log log = LogFactory.getLog((Class)DockingManager.class);
    public static final String MINIMIZE_MANAGER = "minimize.manager";
    public static final String LAYOUT_MANAGER = "layout.manager";
    private static final String DEV_PROPS = "org/flexdock/util/dev-props.properties";
    private static final String CONFIG_PROPS = "org/flexdock/docking/flexdock-core.properties";
    private static final DockingManager SINGLETON = new DockingManager();
    private static final HashMap DOCKABLES_BY_ID = new HashMap();
    private static final WeakHashMap DOCKABLES_BY_COMPONENT = new WeakHashMap();
    private static final ClassMapping DOCKING_STRATEGIES = new ClassMapping(DefaultDockingStrategy.class, new DefaultDockingStrategy());
    private static final Map maximizedStatesByRootPort = new HashMap();
    private static Object persistentIdLock = new Object();
    private String defaultLayoutManagerClass;
    private String defaultMinimizeManagerClass;
    private DockingStrategy defaultDocker = new DefaultDockingStrategy();
    private LayoutManager layoutManager;
    private MinimizationManager minimizeManager;
    private DockableFactory dockableFactory;
    private AutoPersist autoPersister = new AutoPersist();
    private float defaultSiblingSize;

    private static void init() {
        Properties p = ResourceManager.getProperties(DEV_PROPS, true);
        if (p != null) {
            System.getProperties().putAll((Map<?, ?>)p);
        }
        DragManager.prime();
        AdapterFactory.prime();
        EventManager.addHandler(new DockingEventHandler());
        EventManager.addListener(FloatPolicyManager.getInstance());
        Properties config = ResourceManager.getProperties(CONFIG_PROPS, true);
        DockingManager mgr = DockingManager.getDockingManager();
        mgr.defaultMinimizeManagerClass = config.getProperty(MINIMIZE_MANAGER);
        DockingManager.setMinimizeManager(mgr.defaultMinimizeManagerClass);
        mgr.defaultLayoutManagerClass = config.getProperty(LAYOUT_MANAGER);
        DockingManager.setLayoutManager(mgr.defaultLayoutManagerClass);
        ActiveDockableListener.prime();
        float siblingSize = Utilities.getFloat(System.getProperty("default.sibling.size"), 0.5f);
        DockingManager.setDefaultSiblingSize(siblingSize);
        Runtime.getRuntime().addShutdownHook(DockingManager.getDockingManager().autoPersister);
    }

    private DockingManager() {
    }

    private static DockingManager getDockingManager() {
        return SINGLETON;
    }

    public static void addDragSource(Dockable dockable, Component dragSrc) {
        List sources;
        List list = sources = dockable == null ? null : dockable.getDragSources();
        if (sources == null || dragSrc == null) {
            return;
        }
        if (!sources.contains(dragSrc)) {
            DockingManager.updateDragListeners(dockable);
        }
    }

    public static void close(Dockable dockable) {
        if (dockable == null) {
            return;
        }
        if (DockingManager.isMaximized(dockable)) {
            DockingManager.toggleMaximized(dockable);
        }
        if (DockingManager.isDocked(dockable)) {
            DockingManager.undock(dockable);
        } else if (DockingUtility.isMinimized(dockable)) {
            DockingManager.getMinimizeManager().close(dockable);
        }
    }

    public static boolean dock(Component dockable, DockingPort port) {
        return DockingManager.dock(dockable, port, "CENTER");
    }

    public static boolean dock(Component dockable, DockingPort port, String region) {
        Dockable d = DockingManager.resolveDockable(dockable);
        return DockingManager.dock(d, port, region);
    }

    public static boolean dock(Dockable dockable, DockingPort port, String region) {
        if (dockable == null) {
            return false;
        }
        DockingStrategy strategy = DockingManager.getDockingStrategy(port);
        if (strategy != null) {
            return strategy.dock(dockable, port, region);
        }
        return false;
    }

    private static Dockable resolveDockable(Component comp) {
        if (comp == null) {
            return null;
        }
        Dockable d = DockingManager.getDockable(comp);
        if (d == null) {
            d = DockingManager.registerDockable(comp);
        }
        return d;
    }

    public static boolean dock(Component dockable, Component parent) {
        return DockingManager.dock(DockingManager.resolveDockable(dockable), DockingManager.resolveDockable(parent));
    }

    public static boolean dock(Dockable dockable, Dockable parent) {
        return DockingManager.dock(dockable, parent, "CENTER");
    }

    public static boolean dock(Component dockable, Component parent, String region) {
        return DockingManager.dock(dockable, parent, region, 0.5f);
    }

    public static boolean dock(Dockable dockable, Dockable parent, String region) {
        return DockingManager.dock(dockable, parent, region, 0.5f);
    }

    public static boolean dock(Component dockable, Component parent, String region, float proportion) {
        Dockable newDockable = DockingManager.resolveDockable(dockable);
        Dockable parentDockable = DockingManager.resolveDockable(parent);
        return DockingManager.dock(newDockable, parentDockable, region, proportion);
    }

    public static boolean dock(Dockable dockable, Dockable parent, String region, float proportion) {
        return DockingUtility.dockRelative(dockable, parent, region, proportion);
    }

    private static DockingStrategy findDockingStrategy(Dockable dockable) {
        DockingStrategy strategy;
        DockingPort port = dockable.getDockingPort();
        DockingStrategy dockingStrategy = strategy = port == null ? null : port.getDockingStrategy();
        if (strategy == null) {
            DockingManager mgr = DockingManager.getDockingManager();
            strategy = mgr == null ? null : mgr.defaultDocker;
        }
        return strategy;
    }

    public static boolean isDocked(Component component) {
        return DockingManager.getDockingPort(component) != null;
    }

    public static boolean isDocked(Dockable dockable) {
        return DockingManager.getDockingPort(dockable) != null;
    }

    public static boolean isDocked(DockingPort dockingPort, Dockable dockable) {
        return dockingPort == null || dockable == null ? false : dockingPort.isParentDockingPort(dockable.getComponent());
    }

    public static boolean isFloatingEnabled() {
        return FloatPolicyManager.isGlobalFloatingEnabled();
    }

    public static boolean isSingleTabsAllowed() {
        return PropertyManager.getDockingPortRoot().isSingleTabsAllowed();
    }

    public static boolean isValidDockingRegion(String region) {
        return "CENTER".equals(region) || "NORTH".equals(region) || "SOUTH".equals(region) || "EAST".equals(region) || "WEST".equals(region);
    }

    private static void updateDragListeners(Component dragSrc, DragManager listener) {
        MouseMotionListener motionListener = null;
        EventListener[] listeners = dragSrc.getMouseMotionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof DragManager)) continue;
            motionListener = listeners[i];
            break;
        }
        if (motionListener != listener) {
            if (motionListener != null) {
                dragSrc.removeMouseMotionListener(motionListener);
            }
            dragSrc.addMouseMotionListener(listener);
        }
        MouseListener mouseListener = null;
        listeners = dragSrc.getMouseListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof DragManager)) continue;
            mouseListener = (MouseListener)listeners[i];
            break;
        }
        if (mouseListener != listener) {
            if (mouseListener != null) {
                dragSrc.removeMouseListener(mouseListener);
            }
            dragSrc.addMouseListener(listener);
        }
    }

    public static Dockable registerDockable(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof Dockable) {
            return DockingManager.registerDockable((Dockable)((Object)comp));
        }
        return DockingManager.registerDockable(comp, null, null);
    }

    private static String determineTabText(Component comp, String persistId) {
        String tabText = null;
        if (comp instanceof DockingStub) {
            tabText = ((DockingStub)((Object)comp)).getTabText();
        } else {
            DockingAdapter adapter = AdapterFactory.getAdapter(comp);
            if (adapter != null) {
                tabText = adapter.getTabText();
            }
        }
        if (tabText == null) {
            tabText = comp.getName();
        }
        if (tabText == null) {
            tabText = persistId;
        }
        String string = tabText = tabText == null ? "null" : tabText.trim();
        if (tabText.length() == 0) {
            tabText = "null";
        }
        return tabText;
    }

    public static Dockable registerDockable(Component comp, String tabText) {
        return DockingManager.registerDockable(comp, tabText, null);
    }

    private static Dockable registerDockable(Component comp, String tabText, String dockingId) {
        if (comp == null) {
            return null;
        }
        if (tabText == null) {
            tabText = DockingManager.determineTabText(comp, dockingId);
        }
        Dockable dockable = DockingManager.getDockableForComponent(comp, tabText, dockingId);
        return DockingManager.registerDockable(dockable);
    }

    public static Dockable registerDockable(Dockable dockable) {
        if (dockable == null || dockable.getComponent() == null || dockable.getDragSources() == null) {
            return null;
        }
        if (dockable.getPersistentId() == null) {
            throw new IllegalArgumentException("Dockable must have a non-null persistent ID.");
        }
        DOCKABLES_BY_COMPONENT.put(dockable.getComponent(), dockable);
        Component c = dockable.getComponent();
        SwingUtility.putClientProperty(c, "Dockable.DOCKABLE_INDICATOR", Boolean.TRUE);
        DockingManager.updateDragListeners(dockable);
        dockable.addDockingListener(dockable);
        DOCKABLES_BY_ID.put(dockable.getPersistentId(), dockable);
        DockablePropertySet props = PropertyManager.getDockablePropertySet(dockable);
        EventManager.dispatch(new RegistrationEvent((Object)dockable, (Object)SINGLETON, true));
        return dockable;
    }

    public static void unregisterDockable(Component comp) {
        Dockable dockable = DockingManager.getDockable(comp);
        DockingManager.unregisterDockable(dockable);
    }

    public static void unregisterDockable(String dockingId) {
        Dockable dockable = DockingManager.getDockableImpl(dockingId);
        DockingManager.unregisterDockable(dockable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterDockable(Dockable dockable) {
        if (dockable == null) {
            return;
        }
        WeakHashMap weakHashMap = DOCKABLES_BY_COMPONENT;
        synchronized (weakHashMap) {
            DOCKABLES_BY_COMPONENT.remove(dockable.getComponent());
        }
        Component c = dockable.getComponent();
        SwingUtility.removeClientProperty(c, "Dockable.DOCKABLE_INDICATOR");
        DockingManager.removeDragListeners(dockable);
        dockable.removeDockingListener(dockable);
        PropertyManager.removePropertySet(dockable);
        HashMap hashMap = DOCKABLES_BY_ID;
        synchronized (hashMap) {
            DOCKABLES_BY_ID.remove(dockable.getPersistentId());
        }
        EventManager.dispatch(new RegistrationEvent((Object)dockable, (Object)SINGLETON, false));
    }

    public static void removeDragListeners(Component comp) {
        if (comp == null) {
            return;
        }
        MouseMotionListener motionListener = null;
        EventListener[] listeners = comp.getMouseMotionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof DragManager)) continue;
            motionListener = listeners[i];
            break;
        }
        if (motionListener != null) {
            comp.removeMouseMotionListener(motionListener);
        }
        MouseListener mouseListener = null;
        listeners = comp.getMouseListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof DragManager)) continue;
            mouseListener = (MouseListener)listeners[i];
            break;
        }
        if (mouseListener != null) {
            comp.removeMouseListener(mouseListener);
        }
    }

    public static boolean display(Dockable dockable) {
        return DockingManager.getLayoutManager().display(dockable);
    }

    public static boolean display(String dockable) {
        return DockingManager.getLayoutManager().display(DockingManager.getDockable(dockable));
    }

    private static String generatePersistentId(Object obj) {
        return DockingManager.generatePersistentId(obj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generatePersistentId(Object obj, String desiredId) {
        if (obj == null) {
            return null;
        }
        Object object = persistentIdLock;
        synchronized (object) {
            String pId = desiredId == null ? obj.getClass().getName() : desiredId;
            StringBuffer baseId = new StringBuffer(pId);
            int i = 1;
            while (DockingManager.hasRegisteredDockableId(pId)) {
                baseId.append("_").append(i);
                pId = baseId.toString();
                ++i;
            }
            return pId;
        }
    }

    private static boolean hasRegisteredDockableId(String id) {
        return DOCKABLES_BY_ID.containsKey(id);
    }

    public static DockingStrategy getDockingStrategy(Object obj) {
        Class<?> key = obj == null ? null : obj.getClass();
        return DockingManager.getDockingStrategy(key);
    }

    public static DockingStrategy getDockingStrategy(Class classKey) {
        DockingStrategy strategy = (DockingStrategy)DOCKING_STRATEGIES.getClassInstance(classKey);
        return strategy;
    }

    public static RootWindow[] getDockingWindows() {
        Set windowSet = DockingPortTracker.getDockingWindows();
        return windowSet == null ? new RootWindow[]{} : windowSet.toArray(new RootWindow[0]);
    }

    public static DockingPort getDockingPort(String portId) {
        return DockingPortTracker.findById(portId);
    }

    public static DockingPort getMainDockingPort(Component comp) {
        RootDockingPortInfo info = DockingManager.getRootDockingPortInfo(comp);
        return info == null ? null : info.getMainPort();
    }

    public static DockingPort getRootDockingPort(Component comp) {
        return DockingPortTracker.findByWindow(comp);
    }

    public static RootDockingPortInfo getRootDockingPortInfo(Component comp) {
        return DockingPortTracker.getRootDockingPortInfo(comp);
    }

    public static boolean storeLayoutModel() throws IOException, PersistenceException {
        LayoutManager mgr = DockingManager.getLayoutManager();
        return mgr == null ? false : mgr.store();
    }

    public static boolean loadLayoutModel() throws IOException, PersistenceException {
        return DockingManager.loadLayoutModel(false);
    }

    public static boolean loadLayoutModel(boolean restore) throws IOException, PersistenceException {
        LayoutManager mgr = DockingManager.getLayoutManager();
        if (mgr == null) {
            return false;
        }
        return restore ? DockingManager.restoreLayout(true) : mgr.load();
    }

    public static boolean restoreLayout() {
        try {
            return DockingManager.restoreLayout(false);
        }
        catch (IOException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (PersistenceException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean restoreLayout(boolean loadFromStorage) throws IOException, PersistenceException {
        LayoutManager mgr = DockingManager.getLayoutManager();
        return mgr == null ? false : mgr.restore(loadFromStorage);
    }

    private static Dockable loadAndRegister(String id) {
        DockableFactory factory;
        DockableFactory dockableFactory = factory = id == null ? null : DockingManager.getDockingManager().dockableFactory;
        if (factory == null) {
            return null;
        }
        Dockable dockable = factory.getDockable(id);
        if (dockable != null) {
            Dockable tmp = DockingManager.getDockableImpl(dockable.getPersistentId());
            if (tmp == null) {
                DockingManager.registerDockable(dockable);
            }
        } else {
            Component comp = factory.getDockableComponent(id);
            if (comp == null) {
                return null;
            }
            dockable = DockingManager.getDockable(comp);
            if (dockable == null) {
                dockable = DockingManager.registerDockable(comp, null, id);
            }
        }
        return dockable;
    }

    private static Dockable getDragInitiator(Component c) {
        return DockingManager.getDockableForComponent(c, null, null);
    }

    private static Dockable getDockableForComponent(Component c, String desc, String dockingId) {
        if (c == null) {
            return null;
        }
        Dockable dockable = DockingManager.getDockable(c);
        if (dockable != null) {
            return dockable;
        }
        DockingAdapter adapter = AdapterFactory.getAdapter(c);
        if (adapter != null) {
            dockable = DockableComponentWrapper.create(adapter);
        }
        if (dockable == null) {
            if (c instanceof DockingStub) {
                dockable = DockableComponentWrapper.create((DockingStub)((Object)c));
            } else {
                String persistentId = dockingId == null ? DockingManager.generatePersistentId(c) : dockingId;
                dockable = DockableComponentWrapper.create(c, persistentId, desc);
            }
        }
        if (desc != null) {
            dockable.getDockingProperties().setDockableDesc(desc);
        }
        DOCKABLES_BY_COMPONENT.put(c, dockable);
        return dockable;
    }

    public static DockingPort getDockingPort(Component dockable) {
        return DockingUtility.getParentDockingPort(dockable);
    }

    public static DockingPort getDockingPort(Dockable dockable) {
        return DockingUtility.getParentDockingPort(dockable);
    }

    public static Dockable getDockable(Component comp) {
        return comp == null ? null : (Dockable)DOCKABLES_BY_COMPONENT.get(comp);
    }

    public static Dockable getDockable(String id) {
        if (id == null) {
            return null;
        }
        Dockable dockable = DockingManager.getDockableImpl(id);
        if (dockable == null) {
            dockable = DockingManager.loadAndRegister(id);
        }
        return dockable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dockable getDockableImpl(String id) {
        HashMap hashMap = DOCKABLES_BY_ID;
        synchronized (hashMap) {
            return id == null ? null : (Dockable)DOCKABLES_BY_ID.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getDockableIds() {
        HashMap hashMap = DOCKABLES_BY_ID;
        synchronized (hashMap) {
            return new HashSet(DOCKABLES_BY_ID.keySet());
        }
    }

    public static DragManager getDragListener(Dockable dockable) {
        if (dockable == null || dockable.getDragSources() == null) {
            return null;
        }
        Iterator it = dockable.getDragSources().iterator();
        while (it.hasNext()) {
            DragManager listener;
            Object obj = it.next();
            if (!(obj instanceof Component) || (listener = DockingManager.getDragListener((Component)obj)) == null) continue;
            return listener;
        }
        return null;
    }

    private static DragManager getDragListener(Component c) {
        MouseMotionListener[] listeners = c.getMouseMotionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof DragManager)) continue;
            return (DragManager)listeners[i];
        }
        return null;
    }

    public static LayoutManager getLayoutManager() {
        return DockingManager.getDockingManager().layoutManager;
    }

    public static MinimizationManager getMinimizeManager() {
        MinimizationManager mgr = DockingManager.getDockingManager().minimizeManager;
        return mgr == null ? MinimizationManager.DEFAULT_STUB : mgr;
    }

    public static FloatManager getFloatManager() {
        return DockingManager.getLayoutManager().getFloatManager();
    }

    public static DockingState getDockingState(String dockableId) {
        return DockingManager.getLayoutManager().getDockingState(dockableId);
    }

    public static DockingState getDockingState(Dockable dockable) {
        return DockingManager.getLayoutManager().getDockingState(dockable);
    }

    public static DockableFactory getDockableFactory() {
        return DockingManager.getDockingManager().dockableFactory;
    }

    public static void setAutoPersist(boolean enabled) {
        DockingManager.getDockingManager().autoPersister.setEnabled(enabled);
    }

    public static void setSplitProportion(Component dockable, float proportion) {
        DockingManager.setSplitProportion(DockingManager.getDockable(dockable), proportion);
    }

    public static void setSplitProportion(Dockable dockable, float proportion) {
        DockingUtility.setSplitProportion(dockable, proportion);
    }

    public static void setSplitProportion(DockingPort port, float proportion) {
        DockingUtility.setSplitProportion(port, proportion);
    }

    public static void setDockableFactory(DockableFactory factory) {
        DockingManager.getDockingManager().dockableFactory = factory;
    }

    public static void setMinimized(Dockable dockable, boolean minimized) {
        Component cmp = dockable == null ? null : dockable.getComponent();
        Window window = cmp == null ? null : SwingUtilities.getWindowAncestor(cmp);
        DockingManager.setMinimized(dockable, minimized, window);
    }

    public static void setMinimized(Dockable dockable, boolean minimized, Component window) {
        DockingManager.setMinimized(dockable, minimized, window, -1);
    }

    public static void setMinimized(Dockable dockable, boolean minimizing, int constraint) {
        DockingManager.setMinimized(dockable, minimizing, null, constraint);
    }

    public static void setMinimized(Dockable dockable, boolean minimizing, Component window, int constraint) {
        if (dockable == null) {
            return;
        }
        if (window == null) {
            window = SwingUtility.getActiveWindow();
        }
        if (window == null) {
            return;
        }
        DockingManager.getMinimizeManager().setMinimized(dockable, minimizing, window, constraint);
    }

    public static void setMainDockingPort(Component window, String portId) {
        RootDockingPortInfo info = DockingManager.getRootDockingPortInfo(window);
        if (info != null) {
            info.setMainPort(portId);
        }
    }

    public static void setMinimizeManager(MinimizationManager mgr) {
        DockingManager dockingManager = DockingManager.getDockingManager();
        if (mgr == null) {
            DockingManager.setMinimizeManager(dockingManager.defaultMinimizeManagerClass);
        } else {
            dockingManager.minimizeManager = mgr;
        }
    }

    public static void setMinimizeManager(String mgrClass) {
        Object instance = Utilities.getInstance(mgrClass);
        DockingManager.setMinimizeManager((MinimizationManager)instance);
    }

    public static void setFloatingEnabled(boolean enabled) {
        FloatPolicyManager.setGlobalFloatingEnabled(enabled);
    }

    public static void setDefaultPersistenceKey(String key) {
        DockingManager.getLayoutManager().setDefaultPersistenceKey(key);
    }

    public static String getDefaultPersistenceKey() {
        return DockingManager.getLayoutManager().getDefaultPersistenceKey();
    }

    public static void setSingleTabsAllowed(boolean allowed) {
        PropertyManager.getDockingPortRoot().setSingleTabsAllowed(allowed);
    }

    public static void setLayoutManager(LayoutManager mgr) {
        DockingManager dockingManager = DockingManager.getDockingManager();
        if (mgr == null) {
            DockingManager.setLayoutManager(dockingManager.defaultLayoutManagerClass);
        } else {
            DockingManager.getDockingManager().layoutManager = mgr;
        }
    }

    public static void setLayoutManager(String mgrClass) {
        Object instance = Utilities.getInstance(mgrClass);
        DockingManager.setLayoutManager((LayoutManager)instance);
    }

    public static void setDockingStrategy(Class classKey, DockingStrategy strategy) {
        if (classKey == null) {
            return;
        }
        if (strategy == null) {
            DOCKING_STRATEGIES.removeClassMapping(classKey);
        } else {
            DOCKING_STRATEGIES.addClassMapping(classKey, strategy.getClass(), strategy);
        }
    }

    public static boolean undock(Dockable dockable) {
        if (dockable == null) {
            return false;
        }
        DockingStrategy strategy = DockingManager.findDockingStrategy(dockable);
        if (strategy != null) {
            return strategy.undock(dockable);
        }
        return false;
    }

    public static boolean undock(Component dockable) {
        return DockingManager.undock(DockingManager.resolveDockable(dockable));
    }

    public static void updateDragListeners(Dockable dockable) {
        if (dockable == null) {
            return;
        }
        DragManager dragListener = DockingManager.getDragListener(dockable);
        if (dragListener == null) {
            dragListener = new DragManager(dockable);
        }
        Iterator it = dockable.getDragSources().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Component)) continue;
            DockingManager.updateDragListeners((Component)obj, dragListener);
        }
    }

    private static void removeDragListeners(Dockable dockable) {
        if (dockable == null) {
            return;
        }
        Iterator it = dockable.getDragSources().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Component)) continue;
            DockingManager.removeDragListeners((Component)obj);
        }
    }

    public static float getDefaultSiblingSize() {
        return DockingManager.getDockingManager().defaultSiblingSize;
    }

    public static void setDefaultSiblingSize(float size) {
        size = Math.max(size, 0.0f);
        DockingManager.getDockingManager().defaultSiblingSize = size = Math.min(size, 1.0f);
    }

    public static void setRubberBand(RubberBand rubberBand) {
        EffectsManager.setRubberBand(rubberBand);
    }

    public static void setDragPreview(DragPreview dragPreview) {
        EffectsManager.setPreview(dragPreview);
    }

    public static void toggleMaximized(Component comp) {
        Dockable dockable = DockingManager.getDockable(comp);
        if (dockable == null) {
            return;
        }
        DockingManager.toggleMaximized(dockable);
    }

    public static void toggleMaximized(Dockable dockable) {
        DockingPort rootPort = DockingManager.getRootDockingPort(dockable.getComponent());
        MaximizedState state = DockingManager.getMaximizedState(rootPort);
        if (state != null) {
            if (state.getDockable() != dockable) {
                throw new IllegalStateException("Can't maximize while different dockable is maximized");
            }
            DockingManager.restoreFromMaximized(dockable, rootPort, state);
        } else {
            DockingManager.maximize(dockable, rootPort);
        }
    }

    public static boolean isMaximized(Dockable dockable) {
        DockingPort rootPort = DockingManager.getRootDockingPort(dockable.getComponent());
        MaximizedState state = DockingManager.getMaximizedState(rootPort);
        return state != null && state.getDockable().equals(dockable);
    }

    private static void maximize(Dockable dockable, DockingPort rootPort) {
        DockingPort originalPort = dockable.getDockingPort();
        MaximizedState state = new MaximizedState(dockable, originalPort);
        originalPort.releaseForMaximization(dockable);
        rootPort.installMaximizedDockable(dockable);
        maximizedStatesByRootPort.put(rootPort, state);
    }

    private static void restoreFromMaximized(Dockable dockable, DockingPort rootPort, MaximizedState state) {
        rootPort.uninstallMaximizedDockable();
        state.getOriginalPort().returnFromMaximization();
        maximizedStatesByRootPort.remove(rootPort);
    }

    private static MaximizedState getMaximizedState(DockingPort rootPort) {
        return (MaximizedState)maximizedStatesByRootPort.get(rootPort);
    }

    static {
        DockingManager.init();
    }

    private static class MaximizedState {
        private final Dockable dockable;
        private final DockingPort originalPort;

        public MaximizedState(Dockable dockable, DockingPort originalDockingPort) {
            this.dockable = dockable;
            this.originalPort = originalDockingPort;
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        public DockingPort getOriginalPort() {
            return this.originalPort;
        }
    }

    private static class AutoPersist
    extends Thread {
        private boolean enabled;

        private AutoPersist() {
        }

        public void run() {
            this.store();
        }

        private synchronized void store() {
            try {
                if (this.isEnabled()) {
                    DockingManager.storeLayoutModel();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (PersistenceException e) {
                e.printStackTrace();
            }
        }

        public synchronized boolean isEnabled() {
            return this.enabled;
        }

        public synchronized void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

